/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.managed.ManagedConnection;
import org.apache.commons.dbcp2.managed.SynchronizationAdapter;
import org.apache.commons.dbcp2.managed.TestManagedDataSource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestManagedDataSourceInTx
extends TestManagedDataSource {
    @Override
    protected void assertBackPointers(Connection conn, Statement statement) throws SQLException {
        Assertions.assertFalse((boolean)conn.isClosed());
        Assertions.assertFalse((boolean)this.isClosed(statement));
        Assertions.assertSame((Object)conn, (Object)statement.getConnection(), (String)"statement.getConnection() should return the exact same connection instance that was used to create the statement");
        try (ResultSet resultSet = statement.getResultSet();){
            Assertions.assertFalse((boolean)this.isClosed(resultSet));
            Assertions.assertSame((Object)statement, (Object)resultSet.getStatement(), (String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set");
            try (ResultSet executeResultSet = statement.executeQuery("select * from dual");){
                Assertions.assertFalse((boolean)this.isClosed(executeResultSet));
                Assertions.assertSame((Object)statement, (Object)executeResultSet.getStatement(), (String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set");
            }
            try (ResultSet keysResultSet = statement.getGeneratedKeys();){
                Assertions.assertFalse((boolean)this.isClosed(keysResultSet));
                Assertions.assertSame((Object)statement, (Object)keysResultSet.getStatement(), (String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set");
            }
            if (statement instanceof PreparedStatement) {
                PreparedStatement preparedStatement = (PreparedStatement)statement;
                try (ResultSet preparedResultSet = preparedStatement.executeQuery();){
                    Assertions.assertFalse((boolean)this.isClosed(preparedResultSet));
                    Assertions.assertSame((Object)statement, (Object)preparedResultSet.getStatement(), (String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set");
                }
            }
            resultSet.getStatement().getConnection().close();
        }
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.transactionManager.begin();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        if (this.transactionManager.getTransaction() != null) {
            this.transactionManager.commit();
        }
        super.tearDown();
    }

    @Override
    @Test
    public void testAutoCommitBehavior() throws Exception {
        Connection connection = this.newConnection();
        Assertions.assertFalse((boolean)connection.getAutoCommit(), (String)"Auto-commit should be disabled");
        try {
            connection.setAutoCommit(true);
            Assertions.fail((String)"setAutoCommit method should be disabled while enlisted in a transaction");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)connection.getAutoCommit(), (String)"Auto-commit should be disabled");
        connection.close();
    }

    @Override
    @Test
    public void testClearWarnings() throws Exception {
        Connection connection = this.newConnection();
        Assertions.assertNotNull((Object)connection);
        CallableStatement statement = connection.prepareCall("warning");
        Assertions.assertNotNull((Object)connection.getWarnings());
        Connection sharedConnection = this.newConnection();
        Assertions.assertNotNull((Object)sharedConnection.getWarnings());
        connection.close();
        connection = this.newConnection();
        Assertions.assertNotNull((Object)connection.getWarnings());
        Assertions.assertNotNull((Object)sharedConnection.getWarnings());
        statement.close();
        sharedConnection.close();
        connection.close();
    }

    @Test
    public void testCloseInTransaction() throws Exception {
        try (DelegatingConnection connectionA = (DelegatingConnection)this.newConnection();
             DelegatingConnection connectionB = (DelegatingConnection)this.newConnection();){
            Assertions.assertNotEquals((Object)connectionA, (Object)connectionB);
            Assertions.assertNotEquals((Object)connectionB, (Object)connectionA);
            Assertions.assertTrue((boolean)connectionA.innermostDelegateEquals(connectionB.getInnermostDelegate()));
            Assertions.assertTrue((boolean)connectionB.innermostDelegateEquals(connectionA.getInnermostDelegate()));
        }
        Connection connection = this.newConnection();
        Assertions.assertFalse((boolean)connection.isClosed(), (String)"Connection should be open");
        connection.close();
        Assertions.assertTrue((boolean)connection.isClosed(), (String)"Connection should be closed");
    }

    @Test
    public void testCommit() throws Exception {
        try (Connection connection = this.newConnection();){
            Assertions.assertFalse((boolean)connection.isClosed(), (String)"Connection should be open");
            try {
                connection.commit();
                Assertions.fail((String)"commit method should be disabled while enlisted in a transaction");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Assertions.assertFalse((boolean)connection.isClosed(), (String)"Connection should be open");
        }
    }

    @Override
    @Test
    public void testConnectionReturnOnCommit() throws Exception {
    }

    @Override
    @Test
    public void testConnectionsAreDistinct() throws Exception {
        Connection[] conn = new Connection[this.getMaxTotal()];
        for (int i = 0; i < conn.length; ++i) {
            conn[i] = this.newConnection();
            for (int j = 0; j < i; ++j) {
                Assertions.assertNotSame((Object)conn[j], (Object)conn[i]);
                Assertions.assertNotEquals((Object)conn[j], (Object)conn[i]);
                Assertions.assertEquals((Object)((DelegatingConnection)conn[j]).getInnermostDelegateInternal(), (Object)((DelegatingConnection)conn[i]).getInnermostDelegateInternal());
            }
        }
        for (Connection element : conn) {
            element.close();
        }
    }

    @Test
    public void testDoubleReturn() throws Exception {
        this.transactionManager.getTransaction().registerSynchronization(new Synchronization(){
            private ManagedConnection<?> conn;

            public void afterCompletion(int i) {
                int numActive = TestManagedDataSourceInTx.this.pool.getNumActive();
                try {
                    this.conn.checkOpen();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Assertions.assertEquals((int)numActive, (int)TestManagedDataSourceInTx.this.pool.getNumActive());
                try {
                    this.conn.close();
                }
                catch (Exception e) {
                    Assertions.fail((String)"Should have been able to close the connection");
                }
            }

            public void beforeCompletion() {
                try {
                    this.conn = (ManagedConnection)TestManagedDataSourceInTx.this.ds.getConnection();
                    Assertions.assertNotNull(this.conn);
                }
                catch (SQLException e) {
                    Assertions.fail((String)"Could not get connection");
                }
            }
        });
        this.transactionManager.commit();
    }

    @Test
    public void testGetConnectionInAfterCompletion() throws Exception {
        try (DelegatingConnection connection = (DelegatingConnection)this.newConnection();){
            this.transactionManager.getTransaction().registerSynchronization((Synchronization)new SynchronizationAdapter(){

                public void afterCompletion(int i) {
                    try {
                        Connection connection1 = TestManagedDataSourceInTx.this.ds.getConnection();
                        try {
                            connection1.getWarnings();
                            Assertions.fail((String)"Could operate on closed connection");
                        }
                        catch (SQLException sQLException) {}
                    }
                    catch (SQLException e) {
                        Assertions.fail((String)"Should have been able to get connection");
                    }
                }
            });
        }
        this.transactionManager.commit();
    }

    @Override
    @Test
    public void testHashCode() throws Exception {
        try (Connection conn1 = this.newConnection();){
            Assertions.assertNotNull((Object)conn1);
            try (Connection conn2 = this.newConnection();){
                Assertions.assertNotNull((Object)conn2);
                Assertions.assertNotEquals((int)conn1.hashCode(), (int)conn2.hashCode());
            }
        }
    }

    @Override
    @Test
    public void testManagedConnectionEqualsFail() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void testMaxTotal() throws Exception {
        int i;
        Transaction[] transactions = new Transaction[this.getMaxTotal()];
        Connection[] c = new Connection[this.getMaxTotal()];
        for (i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
            Assertions.assertNotNull((Object)c[i]);
            transactions[i] = this.transactionManager.suspend();
            Assertions.assertNotNull((Object)transactions[i]);
            this.transactionManager.begin();
        }
        try {
            this.newConnection();
            Assertions.fail((String)"Allowed to open more than DefaultMaxTotal connections.");
        }
        catch (SQLException i2) {
            this.transactionManager.commit();
            for (int i3 = 0; i3 < c.length; ++i3) {
                this.transactionManager.resume(transactions[i3]);
                c[i3].close();
                this.transactionManager.commit();
            }
        }
        finally {
            this.transactionManager.commit();
            for (i = 0; i < c.length; ++i) {
                this.transactionManager.resume(transactions[i]);
                c[i].close();
                this.transactionManager.commit();
            }
        }
    }

    @Override
    @Test
    public void testNestedConnections() {
    }

    @Test
    public void testReadOnly() throws Exception {
        try (Connection connection = this.newConnection();){
            Assertions.assertTrue((boolean)connection.isReadOnly(), (String)"Connection be read-only");
            try {
                connection.setReadOnly(true);
                Assertions.fail((String)"setReadOnly method should be disabled while enlisted in a transaction");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Assertions.assertTrue((boolean)connection.isReadOnly(), (String)"Connection be read-only");
            try {
                connection.setReadOnly(false);
                Assertions.fail((String)"setReadOnly method should be disabled while enlisted in a transaction");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Assertions.assertTrue((boolean)connection.isReadOnly(), (String)"Connection be read-only");
        }
    }

    @Override
    @Test
    public void testSharedConnection() throws Exception {
        try (DelegatingConnection connectionA = (DelegatingConnection)this.newConnection();
             DelegatingConnection connectionB = (DelegatingConnection)this.newConnection();){
            Assertions.assertNotEquals((Object)connectionA, (Object)connectionB);
            Assertions.assertNotEquals((Object)connectionB, (Object)connectionA);
            Assertions.assertTrue((boolean)connectionA.innermostDelegateEquals(connectionB.getInnermostDelegate()));
            Assertions.assertTrue((boolean)connectionB.innermostDelegateEquals(connectionA.getInnermostDelegate()));
        }
    }

    @Test
    public void testSharedTransactionConversion() throws Exception {
        try (DelegatingConnection connectionA = (DelegatingConnection)this.newConnection();
             DelegatingConnection connectionB = (DelegatingConnection)this.newConnection();){
            Assertions.assertNotEquals((Object)connectionA, (Object)connectionB);
            Assertions.assertNotEquals((Object)connectionB, (Object)connectionA);
            Assertions.assertTrue((boolean)connectionA.innermostDelegateEquals(connectionB.getInnermostDelegate()));
            Assertions.assertTrue((boolean)connectionB.innermostDelegateEquals(connectionA.getInnermostDelegate()));
            this.transactionManager.commit();
            connectionA.getAutoCommit();
            connectionB.getAutoCommit();
            Assertions.assertNotEquals((Object)connectionA, (Object)connectionB);
            Assertions.assertNotEquals((Object)connectionB, (Object)connectionA);
            Assertions.assertFalse((boolean)connectionA.innermostDelegateEquals(connectionB.getInnermostDelegate()));
            Assertions.assertFalse((boolean)connectionB.innermostDelegateEquals(connectionA.getInnermostDelegate()));
            this.transactionManager.begin();
            connectionA.getAutoCommit();
            connectionB.getAutoCommit();
            Assertions.assertNotEquals((Object)connectionA, (Object)connectionB);
            Assertions.assertNotEquals((Object)connectionB, (Object)connectionA);
            Assertions.assertTrue((boolean)connectionA.innermostDelegateEquals(connectionB.getInnermostDelegate()));
            Assertions.assertTrue((boolean)connectionB.innermostDelegateEquals(connectionA.getInnermostDelegate()));
        }
    }
}

