/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.generic;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.apache.cayenne.modeler.generic.GenericButtonUI;
import org.apache.cayenne.modeler.init.platform.PlatformInitializer;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPlatformInitializer
implements PlatformInitializer {
    private static Logger logger = LoggerFactory.getLogger(GenericPlatformInitializer.class);
    static final String DEFAULT_LAF_NAME = PlasticXPLookAndFeel.class.getName();
    static final String DEFAULT_THEME_NAME = "Sky Bluer";

    @Override
    public void setupMenus(JFrame frame) {
    }

    @Override
    public void initLookAndFeel() {
        PlasticTheme theme = this.findTheme();
        if (theme != null) {
            PlasticLookAndFeel.setCurrentTheme(theme);
        }
        try {
            UIManager.setLookAndFeel(DEFAULT_LAF_NAME);
            this.overrideUIDefaults();
        }
        catch (Exception e) {
            logger.warn("Error installing L&F: " + DEFAULT_LAF_NAME, e);
        }
    }

    private void overrideUIDefaults() {
        Color greyHighlight = new Color(0xCBCBCB);
        UIManager.put("ButtonUI", GenericButtonUI.class.getName());
        UIManager.put("HiResGrayFilterEnabled", Boolean.TRUE);
        UIManager.put("Tree.expandedIcon", ModelerUtil.buildIcon("icon-arrow-open.png"));
        UIManager.put("Tree.collapsedIcon", ModelerUtil.buildIcon("icon-arrow-closed.png"));
        UIManager.put("Tree.paintLines", Boolean.FALSE);
        UIManager.put("Tree.selectionForeground", Color.BLACK);
        UIManager.put("Tree.selectionBackground", greyHighlight);
        UIManager.put("Tree.selectionBorderColor", UIManager.get("Tree.selectionBackground"));
        UIManager.put("ScrollPane.border", BorderFactory.createEmptyBorder());
        UIManager.put("Table.scrollPaneBorder", BorderFactory.createEmptyBorder());
        UIManager.put("SplitPane.border", BorderFactory.createEmptyBorder());
        UIManager.put("ToolBar.border", BorderFactory.createEmptyBorder(1, 1, 1, 1));
        UIManager.put("MenuItem.selectionBackground", greyHighlight);
        UIManager.put("MenuItem.selectionForeground", Color.BLACK);
        UIManager.put("MainToolBar.border", BorderFactory.createLineBorder(Color.GRAY));
    }

    protected PlasticTheme findTheme() {
        for (Object object : PlasticLookAndFeel.getInstalledThemes()) {
            PlasticTheme theme = (PlasticTheme)object;
            if (!DEFAULT_THEME_NAME.equals(theme.getName())) continue;
            return theme;
        }
        return null;
    }
}

