/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1alpha1.kameletbindingspec.integration.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.Jvm;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.jvm.Configuration;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.jvm.ConfigurationBuilder;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.jvm.ConfigurationFluent;

public class JvmFluent<A extends JvmFluent<A>>
extends BaseFluent<A> {
    private String classpath;
    private ConfigurationBuilder configuration;
    private Boolean debug;
    private String debugAddress;
    private Boolean debugSuspend;
    private Boolean enabled;
    private String jar;
    private List<String> options;
    private Boolean printCommand;

    public JvmFluent() {
    }

    public JvmFluent(Jvm instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Jvm instance) {
        Jvm jvm = instance = instance != null ? instance : new Jvm();
        if (instance != null) {
            this.withClasspath(instance.getClasspath());
            this.withConfiguration(instance.getConfiguration());
            this.withDebug(instance.getDebug());
            this.withDebugAddress(instance.getDebugAddress());
            this.withDebugSuspend(instance.getDebugSuspend());
            this.withEnabled(instance.getEnabled());
            this.withJar(instance.getJar());
            this.withOptions(instance.getOptions());
            this.withPrintCommand(instance.getPrintCommand());
        }
    }

    public String getClasspath() {
        return this.classpath;
    }

    public A withClasspath(String classpath) {
        this.classpath = classpath;
        return (A)((Object)this);
    }

    public boolean hasClasspath() {
        return this.classpath != null;
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public A withDebug(Boolean debug) {
        this.debug = debug;
        return (A)((Object)this);
    }

    public boolean hasDebug() {
        return this.debug != null;
    }

    public String getDebugAddress() {
        return this.debugAddress;
    }

    public A withDebugAddress(String debugAddress) {
        this.debugAddress = debugAddress;
        return (A)((Object)this);
    }

    public boolean hasDebugAddress() {
        return this.debugAddress != null;
    }

    public Boolean getDebugSuspend() {
        return this.debugSuspend;
    }

    public A withDebugSuspend(Boolean debugSuspend) {
        this.debugSuspend = debugSuspend;
        return (A)((Object)this);
    }

    public boolean hasDebugSuspend() {
        return this.debugSuspend != null;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public String getJar() {
        return this.jar;
    }

    public A withJar(String jar) {
        this.jar = jar;
        return (A)((Object)this);
    }

    public boolean hasJar() {
        return this.jar != null;
    }

    public A addToOptions(int index, String item) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        this.options.add(index, item);
        return (A)((Object)this);
    }

    public A setToOptions(int index, String item) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        this.options.set(index, item);
        return (A)((Object)this);
    }

    public A addToOptions(String ... items) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        for (String item : items) {
            this.options.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToOptions(Collection<String> items) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        for (String item : items) {
            this.options.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromOptions(String ... items) {
        if (this.options == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.options.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOptions(Collection<String> items) {
        if (this.options == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.options.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getOptions() {
        return this.options;
    }

    public String getOption(int index) {
        return this.options.get(index);
    }

    public String getFirstOption() {
        return this.options.get(0);
    }

    public String getLastOption() {
        return this.options.get(this.options.size() - 1);
    }

    public String getMatchingOption(Predicate<String> predicate) {
        for (String item : this.options) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingOption(Predicate<String> predicate) {
        for (String item : this.options) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOptions(List<String> options) {
        if (options != null) {
            this.options = new ArrayList<String>();
            for (String item : options) {
                this.addToOptions(item);
            }
        } else {
            this.options = null;
        }
        return (A)((Object)this);
    }

    public A withOptions(String ... options) {
        if (this.options != null) {
            this.options.clear();
            this._visitables.remove((Object)"options");
        }
        if (options != null) {
            for (String item : options) {
                this.addToOptions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOptions() {
        return this.options != null && !this.options.isEmpty();
    }

    public Boolean getPrintCommand() {
        return this.printCommand;
    }

    public A withPrintCommand(Boolean printCommand) {
        this.printCommand = printCommand;
        return (A)((Object)this);
    }

    public boolean hasPrintCommand() {
        return this.printCommand != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JvmFluent that = (JvmFluent)((Object)o);
        if (!Objects.equals(this.classpath, that.classpath)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.debug, that.debug)) {
            return false;
        }
        if (!Objects.equals(this.debugAddress, that.debugAddress)) {
            return false;
        }
        if (!Objects.equals(this.debugSuspend, that.debugSuspend)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.jar, that.jar)) {
            return false;
        }
        if (!Objects.equals(this.options, that.options)) {
            return false;
        }
        return Objects.equals(this.printCommand, that.printCommand);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.classpath, this.configuration, this.debug, this.debugAddress, this.debugSuspend, this.enabled, this.jar, this.options, this.printCommand, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.classpath != null) {
            sb.append("classpath:");
            sb.append(this.classpath + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.debug != null) {
            sb.append("debug:");
            sb.append(this.debug + ",");
        }
        if (this.debugAddress != null) {
            sb.append("debugAddress:");
            sb.append(this.debugAddress + ",");
        }
        if (this.debugSuspend != null) {
            sb.append("debugSuspend:");
            sb.append(this.debugSuspend + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.jar != null) {
            sb.append("jar:");
            sb.append(this.jar + ",");
        }
        if (this.options != null && !this.options.isEmpty()) {
            sb.append("options:");
            sb.append(this.options + ",");
        }
        if (this.printCommand != null) {
            sb.append("printCommand:");
            sb.append(this.printCommand);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDebug() {
        return this.withDebug(true);
    }

    public A withDebugSuspend() {
        return this.withDebugSuspend(true);
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withPrintCommand() {
        return this.withPrintCommand(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)JvmFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

