/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.ContainerStatusBuilder;
import io.fabric8.kubernetes.api.model.ContainerStatusFluent;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodConditionBuilder;
import io.fabric8.kubernetes.api.model.PodConditionFluent;
import io.fabric8.kubernetes.api.model.PodIP;
import io.fabric8.kubernetes.api.model.PodIPBuilder;
import io.fabric8.kubernetes.api.model.PodIPFluent;
import io.fabric8.kubernetes.api.model.PodStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodStatusFluent<A extends PodStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<PodConditionBuilder> conditions = new ArrayList();
    private ArrayList<ContainerStatusBuilder> containerStatuses = new ArrayList();
    private ArrayList<ContainerStatusBuilder> ephemeralContainerStatuses = new ArrayList();
    private String hostIP;
    private ArrayList<ContainerStatusBuilder> initContainerStatuses = new ArrayList();
    private String message;
    private String nominatedNodeName;
    private String phase;
    private String podIP;
    private ArrayList<PodIPBuilder> podIPs = new ArrayList();
    private String qosClass;
    private String reason;
    private String resize;
    private String startTime;
    private Map<String, Object> additionalProperties;

    public PodStatusFluent() {
    }

    public PodStatusFluent(PodStatus instance) {
        PodStatus podStatus = instance = instance != null ? instance : new PodStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withContainerStatuses(instance.getContainerStatuses());
            this.withEphemeralContainerStatuses(instance.getEphemeralContainerStatuses());
            this.withHostIP(instance.getHostIP());
            this.withInitContainerStatuses(instance.getInitContainerStatuses());
            this.withMessage(instance.getMessage());
            this.withNominatedNodeName(instance.getNominatedNodeName());
            this.withPhase(instance.getPhase());
            this.withPodIP(instance.getPodIP());
            this.withPodIPs(instance.getPodIPs());
            this.withQosClass(instance.getQosClass());
            this.withReason(instance.getReason());
            this.withResize(instance.getResize());
            this.withStartTime(instance.getStartTime());
            this.withConditions(instance.getConditions());
            this.withContainerStatuses(instance.getContainerStatuses());
            this.withEphemeralContainerStatuses(instance.getEphemeralContainerStatuses());
            this.withHostIP(instance.getHostIP());
            this.withInitContainerStatuses(instance.getInitContainerStatuses());
            this.withMessage(instance.getMessage());
            this.withNominatedNodeName(instance.getNominatedNodeName());
            this.withPhase(instance.getPhase());
            this.withPodIP(instance.getPodIP());
            this.withPodIPs(instance.getPodIPs());
            this.withQosClass(instance.getQosClass());
            this.withReason(instance.getReason());
            this.withResize(instance.getResize());
            this.withStartTime(instance.getStartTime());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, PodCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        PodConditionBuilder builder = new PodConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, PodCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        PodConditionBuilder builder = new PodConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(PodCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<PodCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(PodCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<PodCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<PodConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<PodConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            PodConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<PodCondition> buildConditions() {
        return this.conditions != null ? PodStatusFluent.build(this.conditions) : null;
    }

    public PodCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public PodCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public PodCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public PodCondition buildMatchingCondition(Predicate<PodConditionBuilder> predicate) {
        for (PodConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<PodConditionBuilder> predicate) {
        for (PodConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<PodCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (PodCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(PodCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (PodCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(PodCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, PodCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<PodConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public A addToContainerStatuses(int index, ContainerStatus item) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.containerStatuses.size()) {
            this._visitables.get("containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        } else {
            this._visitables.get("containerStatuses").add(index, builder);
            this.containerStatuses.add(index, builder);
        }
        return (A)this;
    }

    public A setToContainerStatuses(int index, ContainerStatus item) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.containerStatuses.size()) {
            this._visitables.get("containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        } else {
            this._visitables.get("containerStatuses").set(index, builder);
            this.containerStatuses.set(index, builder);
        }
        return (A)this;
    }

    public A addToContainerStatuses(ContainerStatus ... items) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    public A addAllToContainerStatuses(Collection<ContainerStatus> items) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    public A removeFromContainerStatuses(ContainerStatus ... items) {
        if (this.containerStatuses == null) {
            return (A)this;
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").remove(builder);
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromContainerStatuses(Collection<ContainerStatus> items) {
        if (this.containerStatuses == null) {
            return (A)this;
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").remove(builder);
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
        if (this.containerStatuses == null) {
            return (A)this;
        }
        Iterator<ContainerStatusBuilder> each = this.containerStatuses.iterator();
        Object visitables = this._visitables.get("containerStatuses");
        while (each.hasNext()) {
            ContainerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ContainerStatus> buildContainerStatuses() {
        return this.containerStatuses != null ? PodStatusFluent.build(this.containerStatuses) : null;
    }

    public ContainerStatus buildContainerStatus(int index) {
        return this.containerStatuses.get(index).build();
    }

    public ContainerStatus buildFirstContainerStatus() {
        return this.containerStatuses.get(0).build();
    }

    public ContainerStatus buildLastContainerStatus() {
        return this.containerStatuses.get(this.containerStatuses.size() - 1).build();
    }

    public ContainerStatus buildMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContainerStatuses(List<ContainerStatus> containerStatuses) {
        if (this.containerStatuses != null) {
            this._visitables.get("containerStatuses").clear();
        }
        if (containerStatuses != null) {
            this.containerStatuses = new ArrayList();
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        } else {
            this.containerStatuses = null;
        }
        return (A)this;
    }

    public A withContainerStatuses(ContainerStatus ... containerStatuses) {
        if (this.containerStatuses != null) {
            this.containerStatuses.clear();
            this._visitables.remove("containerStatuses");
        }
        if (containerStatuses != null) {
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        }
        return (A)this;
    }

    public boolean hasContainerStatuses() {
        return this.containerStatuses != null && !this.containerStatuses.isEmpty();
    }

    public ContainerStatusesNested<A> addNewContainerStatus() {
        return new ContainerStatusesNested(-1, null);
    }

    public ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatus item) {
        return new ContainerStatusesNested(-1, item);
    }

    public ContainerStatusesNested<A> setNewContainerStatusLike(int index, ContainerStatus item) {
        return new ContainerStatusesNested(index, item);
    }

    public ContainerStatusesNested<A> editContainerStatus(int index) {
        if (this.containerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit containerStatuses. Index exceeds size.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    public ContainerStatusesNested<A> editFirstContainerStatus() {
        if (this.containerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(0, this.buildContainerStatus(0));
    }

    public ContainerStatusesNested<A> editLastContainerStatus() {
        int index = this.containerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    public ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containerStatuses.size(); ++i) {
            if (!predicate.test(this.containerStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containerStatuses. No match found.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    public A addToEphemeralContainerStatuses(int index, ContainerStatus item) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.ephemeralContainerStatuses.size()) {
            this._visitables.get("ephemeralContainerStatuses").add(builder);
            this.ephemeralContainerStatuses.add(builder);
        } else {
            this._visitables.get("ephemeralContainerStatuses").add(index, builder);
            this.ephemeralContainerStatuses.add(index, builder);
        }
        return (A)this;
    }

    public A setToEphemeralContainerStatuses(int index, ContainerStatus item) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.ephemeralContainerStatuses.size()) {
            this._visitables.get("ephemeralContainerStatuses").add(builder);
            this.ephemeralContainerStatuses.add(builder);
        } else {
            this._visitables.get("ephemeralContainerStatuses").set(index, builder);
            this.ephemeralContainerStatuses.set(index, builder);
        }
        return (A)this;
    }

    public A addToEphemeralContainerStatuses(ContainerStatus ... items) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").add(builder);
            this.ephemeralContainerStatuses.add(builder);
        }
        return (A)this;
    }

    public A addAllToEphemeralContainerStatuses(Collection<ContainerStatus> items) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").add(builder);
            this.ephemeralContainerStatuses.add(builder);
        }
        return (A)this;
    }

    public A removeFromEphemeralContainerStatuses(ContainerStatus ... items) {
        if (this.ephemeralContainerStatuses == null) {
            return (A)this;
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").remove(builder);
            this.ephemeralContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromEphemeralContainerStatuses(Collection<ContainerStatus> items) {
        if (this.ephemeralContainerStatuses == null) {
            return (A)this;
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").remove(builder);
            this.ephemeralContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromEphemeralContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
        if (this.ephemeralContainerStatuses == null) {
            return (A)this;
        }
        Iterator<ContainerStatusBuilder> each = this.ephemeralContainerStatuses.iterator();
        Object visitables = this._visitables.get("ephemeralContainerStatuses");
        while (each.hasNext()) {
            ContainerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ContainerStatus> buildEphemeralContainerStatuses() {
        return this.ephemeralContainerStatuses != null ? PodStatusFluent.build(this.ephemeralContainerStatuses) : null;
    }

    public ContainerStatus buildEphemeralContainerStatus(int index) {
        return this.ephemeralContainerStatuses.get(index).build();
    }

    public ContainerStatus buildFirstEphemeralContainerStatus() {
        return this.ephemeralContainerStatuses.get(0).build();
    }

    public ContainerStatus buildLastEphemeralContainerStatus() {
        return this.ephemeralContainerStatuses.get(this.ephemeralContainerStatuses.size() - 1).build();
    }

    public ContainerStatus buildMatchingEphemeralContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.ephemeralContainerStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEphemeralContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.ephemeralContainerStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEphemeralContainerStatuses(List<ContainerStatus> ephemeralContainerStatuses) {
        if (this.ephemeralContainerStatuses != null) {
            this._visitables.get("ephemeralContainerStatuses").clear();
        }
        if (ephemeralContainerStatuses != null) {
            this.ephemeralContainerStatuses = new ArrayList();
            for (ContainerStatus item : ephemeralContainerStatuses) {
                this.addToEphemeralContainerStatuses(item);
            }
        } else {
            this.ephemeralContainerStatuses = null;
        }
        return (A)this;
    }

    public A withEphemeralContainerStatuses(ContainerStatus ... ephemeralContainerStatuses) {
        if (this.ephemeralContainerStatuses != null) {
            this.ephemeralContainerStatuses.clear();
            this._visitables.remove("ephemeralContainerStatuses");
        }
        if (ephemeralContainerStatuses != null) {
            for (ContainerStatus item : ephemeralContainerStatuses) {
                this.addToEphemeralContainerStatuses(item);
            }
        }
        return (A)this;
    }

    public boolean hasEphemeralContainerStatuses() {
        return this.ephemeralContainerStatuses != null && !this.ephemeralContainerStatuses.isEmpty();
    }

    public EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatus() {
        return new EphemeralContainerStatusesNested(-1, null);
    }

    public EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatusLike(ContainerStatus item) {
        return new EphemeralContainerStatusesNested(-1, item);
    }

    public EphemeralContainerStatusesNested<A> setNewEphemeralContainerStatusLike(int index, ContainerStatus item) {
        return new EphemeralContainerStatusesNested(index, item);
    }

    public EphemeralContainerStatusesNested<A> editEphemeralContainerStatus(int index) {
        if (this.ephemeralContainerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit ephemeralContainerStatuses. Index exceeds size.");
        }
        return this.setNewEphemeralContainerStatusLike(index, this.buildEphemeralContainerStatus(index));
    }

    public EphemeralContainerStatusesNested<A> editFirstEphemeralContainerStatus() {
        if (this.ephemeralContainerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first ephemeralContainerStatuses. The list is empty.");
        }
        return this.setNewEphemeralContainerStatusLike(0, this.buildEphemeralContainerStatus(0));
    }

    public EphemeralContainerStatusesNested<A> editLastEphemeralContainerStatus() {
        int index = this.ephemeralContainerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ephemeralContainerStatuses. The list is empty.");
        }
        return this.setNewEphemeralContainerStatusLike(index, this.buildEphemeralContainerStatus(index));
    }

    public EphemeralContainerStatusesNested<A> editMatchingEphemeralContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ephemeralContainerStatuses.size(); ++i) {
            if (!predicate.test(this.ephemeralContainerStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ephemeralContainerStatuses. No match found.");
        }
        return this.setNewEphemeralContainerStatusLike(index, this.buildEphemeralContainerStatus(index));
    }

    public String getHostIP() {
        return this.hostIP;
    }

    public A withHostIP(String hostIP) {
        this.hostIP = hostIP;
        return (A)this;
    }

    public boolean hasHostIP() {
        return this.hostIP != null;
    }

    public A addToInitContainerStatuses(int index, ContainerStatus item) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.initContainerStatuses.size()) {
            this._visitables.get("initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        } else {
            this._visitables.get("initContainerStatuses").add(index, builder);
            this.initContainerStatuses.add(index, builder);
        }
        return (A)this;
    }

    public A setToInitContainerStatuses(int index, ContainerStatus item) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.initContainerStatuses.size()) {
            this._visitables.get("initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        } else {
            this._visitables.get("initContainerStatuses").set(index, builder);
            this.initContainerStatuses.set(index, builder);
        }
        return (A)this;
    }

    public A addToInitContainerStatuses(ContainerStatus ... items) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)this;
    }

    public A addAllToInitContainerStatuses(Collection<ContainerStatus> items) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)this;
    }

    public A removeFromInitContainerStatuses(ContainerStatus ... items) {
        if (this.initContainerStatuses == null) {
            return (A)this;
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").remove(builder);
            this.initContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromInitContainerStatuses(Collection<ContainerStatus> items) {
        if (this.initContainerStatuses == null) {
            return (A)this;
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").remove(builder);
            this.initContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromInitContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
        if (this.initContainerStatuses == null) {
            return (A)this;
        }
        Iterator<ContainerStatusBuilder> each = this.initContainerStatuses.iterator();
        Object visitables = this._visitables.get("initContainerStatuses");
        while (each.hasNext()) {
            ContainerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ContainerStatus> buildInitContainerStatuses() {
        return this.initContainerStatuses != null ? PodStatusFluent.build(this.initContainerStatuses) : null;
    }

    public ContainerStatus buildInitContainerStatus(int index) {
        return this.initContainerStatuses.get(index).build();
    }

    public ContainerStatus buildFirstInitContainerStatus() {
        return this.initContainerStatuses.get(0).build();
    }

    public ContainerStatus buildLastInitContainerStatus() {
        return this.initContainerStatuses.get(this.initContainerStatuses.size() - 1).build();
    }

    public ContainerStatus buildMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.initContainerStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.initContainerStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInitContainerStatuses(List<ContainerStatus> initContainerStatuses) {
        if (this.initContainerStatuses != null) {
            this._visitables.get("initContainerStatuses").clear();
        }
        if (initContainerStatuses != null) {
            this.initContainerStatuses = new ArrayList();
            for (ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        } else {
            this.initContainerStatuses = null;
        }
        return (A)this;
    }

    public A withInitContainerStatuses(ContainerStatus ... initContainerStatuses) {
        if (this.initContainerStatuses != null) {
            this.initContainerStatuses.clear();
            this._visitables.remove("initContainerStatuses");
        }
        if (initContainerStatuses != null) {
            for (ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        }
        return (A)this;
    }

    public boolean hasInitContainerStatuses() {
        return this.initContainerStatuses != null && !this.initContainerStatuses.isEmpty();
    }

    public InitContainerStatusesNested<A> addNewInitContainerStatus() {
        return new InitContainerStatusesNested(-1, null);
    }

    public InitContainerStatusesNested<A> addNewInitContainerStatusLike(ContainerStatus item) {
        return new InitContainerStatusesNested(-1, item);
    }

    public InitContainerStatusesNested<A> setNewInitContainerStatusLike(int index, ContainerStatus item) {
        return new InitContainerStatusesNested(index, item);
    }

    public InitContainerStatusesNested<A> editInitContainerStatus(int index) {
        if (this.initContainerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit initContainerStatuses. Index exceeds size.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    public InitContainerStatusesNested<A> editFirstInitContainerStatus() {
        if (this.initContainerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first initContainerStatuses. The list is empty.");
        }
        return this.setNewInitContainerStatusLike(0, this.buildInitContainerStatus(0));
    }

    public InitContainerStatusesNested<A> editLastInitContainerStatus() {
        int index = this.initContainerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainerStatuses. The list is empty.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    public InitContainerStatusesNested<A> editMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainerStatuses.size(); ++i) {
            if (!predicate.test(this.initContainerStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainerStatuses. No match found.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public String getNominatedNodeName() {
        return this.nominatedNodeName;
    }

    public A withNominatedNodeName(String nominatedNodeName) {
        this.nominatedNodeName = nominatedNodeName;
        return (A)this;
    }

    public boolean hasNominatedNodeName() {
        return this.nominatedNodeName != null;
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public String getPodIP() {
        return this.podIP;
    }

    public A withPodIP(String podIP) {
        this.podIP = podIP;
        return (A)this;
    }

    public boolean hasPodIP() {
        return this.podIP != null;
    }

    public A addToPodIPs(int index, PodIP item) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList();
        }
        PodIPBuilder builder = new PodIPBuilder(item);
        if (index < 0 || index >= this.podIPs.size()) {
            this._visitables.get("podIPs").add(builder);
            this.podIPs.add(builder);
        } else {
            this._visitables.get("podIPs").add(index, builder);
            this.podIPs.add(index, builder);
        }
        return (A)this;
    }

    public A setToPodIPs(int index, PodIP item) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList();
        }
        PodIPBuilder builder = new PodIPBuilder(item);
        if (index < 0 || index >= this.podIPs.size()) {
            this._visitables.get("podIPs").add(builder);
            this.podIPs.add(builder);
        } else {
            this._visitables.get("podIPs").set(index, builder);
            this.podIPs.set(index, builder);
        }
        return (A)this;
    }

    public A addToPodIPs(PodIP ... items) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList();
        }
        for (PodIP item : items) {
            PodIPBuilder builder = new PodIPBuilder(item);
            this._visitables.get("podIPs").add(builder);
            this.podIPs.add(builder);
        }
        return (A)this;
    }

    public A addAllToPodIPs(Collection<PodIP> items) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList();
        }
        for (PodIP item : items) {
            PodIPBuilder builder = new PodIPBuilder(item);
            this._visitables.get("podIPs").add(builder);
            this.podIPs.add(builder);
        }
        return (A)this;
    }

    public A removeFromPodIPs(PodIP ... items) {
        if (this.podIPs == null) {
            return (A)this;
        }
        for (PodIP item : items) {
            PodIPBuilder builder = new PodIPBuilder(item);
            this._visitables.get("podIPs").remove(builder);
            this.podIPs.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPodIPs(Collection<PodIP> items) {
        if (this.podIPs == null) {
            return (A)this;
        }
        for (PodIP item : items) {
            PodIPBuilder builder = new PodIPBuilder(item);
            this._visitables.get("podIPs").remove(builder);
            this.podIPs.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPodIPs(Predicate<PodIPBuilder> predicate) {
        if (this.podIPs == null) {
            return (A)this;
        }
        Iterator<PodIPBuilder> each = this.podIPs.iterator();
        Object visitables = this._visitables.get("podIPs");
        while (each.hasNext()) {
            PodIPBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<PodIP> buildPodIPs() {
        return this.podIPs != null ? PodStatusFluent.build(this.podIPs) : null;
    }

    public PodIP buildPodIP(int index) {
        return this.podIPs.get(index).build();
    }

    public PodIP buildFirstPodIP() {
        return this.podIPs.get(0).build();
    }

    public PodIP buildLastPodIP() {
        return this.podIPs.get(this.podIPs.size() - 1).build();
    }

    public PodIP buildMatchingPodIP(Predicate<PodIPBuilder> predicate) {
        for (PodIPBuilder item : this.podIPs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPodIP(Predicate<PodIPBuilder> predicate) {
        for (PodIPBuilder item : this.podIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPodIPs(List<PodIP> podIPs) {
        if (this.podIPs != null) {
            this._visitables.get("podIPs").clear();
        }
        if (podIPs != null) {
            this.podIPs = new ArrayList();
            for (PodIP item : podIPs) {
                this.addToPodIPs(item);
            }
        } else {
            this.podIPs = null;
        }
        return (A)this;
    }

    public A withPodIPs(PodIP ... podIPs) {
        if (this.podIPs != null) {
            this.podIPs.clear();
            this._visitables.remove("podIPs");
        }
        if (podIPs != null) {
            for (PodIP item : podIPs) {
                this.addToPodIPs(item);
            }
        }
        return (A)this;
    }

    public boolean hasPodIPs() {
        return this.podIPs != null && !this.podIPs.isEmpty();
    }

    public A addNewPodIP(String ip) {
        return this.addToPodIPs(new PodIP(ip));
    }

    public PodIPsNested<A> addNewPodIP() {
        return new PodIPsNested(-1, null);
    }

    public PodIPsNested<A> addNewPodIPLike(PodIP item) {
        return new PodIPsNested(-1, item);
    }

    public PodIPsNested<A> setNewPodIPLike(int index, PodIP item) {
        return new PodIPsNested(index, item);
    }

    public PodIPsNested<A> editPodIP(int index) {
        if (this.podIPs.size() <= index) {
            throw new RuntimeException("Can't edit podIPs. Index exceeds size.");
        }
        return this.setNewPodIPLike(index, this.buildPodIP(index));
    }

    public PodIPsNested<A> editFirstPodIP() {
        if (this.podIPs.size() == 0) {
            throw new RuntimeException("Can't edit first podIPs. The list is empty.");
        }
        return this.setNewPodIPLike(0, this.buildPodIP(0));
    }

    public PodIPsNested<A> editLastPodIP() {
        int index = this.podIPs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last podIPs. The list is empty.");
        }
        return this.setNewPodIPLike(index, this.buildPodIP(index));
    }

    public PodIPsNested<A> editMatchingPodIP(Predicate<PodIPBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.podIPs.size(); ++i) {
            if (!predicate.test(this.podIPs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching podIPs. No match found.");
        }
        return this.setNewPodIPLike(index, this.buildPodIP(index));
    }

    public String getQosClass() {
        return this.qosClass;
    }

    public A withQosClass(String qosClass) {
        this.qosClass = qosClass;
        return (A)this;
    }

    public boolean hasQosClass() {
        return this.qosClass != null;
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public String getResize() {
        return this.resize;
    }

    public A withResize(String resize) {
        this.resize = resize;
        return (A)this;
    }

    public boolean hasResize() {
        return this.resize != null;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public A withStartTime(String startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    public boolean hasStartTime() {
        return this.startTime != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodStatusFluent that = (PodStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.containerStatuses, that.containerStatuses)) {
            return false;
        }
        if (!Objects.equals(this.ephemeralContainerStatuses, that.ephemeralContainerStatuses)) {
            return false;
        }
        if (!Objects.equals(this.hostIP, that.hostIP)) {
            return false;
        }
        if (!Objects.equals(this.initContainerStatuses, that.initContainerStatuses)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.nominatedNodeName, that.nominatedNodeName)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        if (!Objects.equals(this.podIP, that.podIP)) {
            return false;
        }
        if (!Objects.equals(this.podIPs, that.podIPs)) {
            return false;
        }
        if (!Objects.equals(this.qosClass, that.qosClass)) {
            return false;
        }
        if (!Objects.equals(this.reason, that.reason)) {
            return false;
        }
        if (!Objects.equals(this.resize, that.resize)) {
            return false;
        }
        if (!Objects.equals(this.startTime, that.startTime)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.containerStatuses, this.ephemeralContainerStatuses, this.hostIP, this.initContainerStatuses, this.message, this.nominatedNodeName, this.phase, this.podIP, this.podIPs, this.qosClass, this.reason, this.resize, this.startTime, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.containerStatuses != null && !this.containerStatuses.isEmpty()) {
            sb.append("containerStatuses:");
            sb.append(this.containerStatuses + ",");
        }
        if (this.ephemeralContainerStatuses != null && !this.ephemeralContainerStatuses.isEmpty()) {
            sb.append("ephemeralContainerStatuses:");
            sb.append(this.ephemeralContainerStatuses + ",");
        }
        if (this.hostIP != null) {
            sb.append("hostIP:");
            sb.append(this.hostIP + ",");
        }
        if (this.initContainerStatuses != null && !this.initContainerStatuses.isEmpty()) {
            sb.append("initContainerStatuses:");
            sb.append(this.initContainerStatuses + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.nominatedNodeName != null) {
            sb.append("nominatedNodeName:");
            sb.append(this.nominatedNodeName + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.podIP != null) {
            sb.append("podIP:");
            sb.append(this.podIP + ",");
        }
        if (this.podIPs != null && !this.podIPs.isEmpty()) {
            sb.append("podIPs:");
            sb.append(this.podIPs + ",");
        }
        if (this.qosClass != null) {
            sb.append("qosClass:");
            sb.append(this.qosClass + ",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason + ",");
        }
        if (this.resize != null) {
            sb.append("resize:");
            sb.append(this.resize + ",");
        }
        if (this.startTime != null) {
            sb.append("startTime:");
            sb.append(this.startTime + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PodIPsNested<N>
    extends PodIPFluent<PodIPsNested<N>>
    implements Nested<N> {
        PodIPBuilder builder;
        int index;

        PodIPsNested(int index, PodIP item) {
            this.index = index;
            this.builder = new PodIPBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodStatusFluent.this.setToPodIPs(this.index, this.builder.build());
        }

        public N endPodIP() {
            return this.and();
        }
    }

    public class InitContainerStatusesNested<N>
    extends ContainerStatusFluent<InitContainerStatusesNested<N>>
    implements Nested<N> {
        ContainerStatusBuilder builder;
        int index;

        InitContainerStatusesNested(int index, ContainerStatus item) {
            this.index = index;
            this.builder = new ContainerStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodStatusFluent.this.setToInitContainerStatuses(this.index, this.builder.build());
        }

        public N endInitContainerStatus() {
            return this.and();
        }
    }

    public class EphemeralContainerStatusesNested<N>
    extends ContainerStatusFluent<EphemeralContainerStatusesNested<N>>
    implements Nested<N> {
        ContainerStatusBuilder builder;
        int index;

        EphemeralContainerStatusesNested(int index, ContainerStatus item) {
            this.index = index;
            this.builder = new ContainerStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodStatusFluent.this.setToEphemeralContainerStatuses(this.index, this.builder.build());
        }

        public N endEphemeralContainerStatus() {
            return this.and();
        }
    }

    public class ContainerStatusesNested<N>
    extends ContainerStatusFluent<ContainerStatusesNested<N>>
    implements Nested<N> {
        ContainerStatusBuilder builder;
        int index;

        ContainerStatusesNested(int index, ContainerStatus item) {
            this.index = index;
            this.builder = new ContainerStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodStatusFluent.this.setToContainerStatuses(this.index, this.builder.build());
        }

        public N endContainerStatus() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends PodConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        PodConditionBuilder builder;
        int index;

        ConditionsNested(int index, PodCondition item) {
            this.index = index;
            this.builder = new PodConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

