/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.KeySpec;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import org.jclouds.cloudstack.domain.EncryptedPasswordAndPrivateKey;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Pems;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

@Singleton
public class WindowsLoginCredentialsFromEncryptedData
implements Function<EncryptedPasswordAndPrivateKey, LoginCredentials> {
    private final Crypto crypto;
    private static final Pattern whitespace = Pattern.compile("\\s");

    @Inject
    public WindowsLoginCredentialsFromEncryptedData(Crypto crypto) {
        this.crypto = crypto;
    }

    public LoginCredentials apply(@Nullable EncryptedPasswordAndPrivateKey dataAndKey) {
        if (dataAndKey == null) {
            return null;
        }
        try {
            KeySpec keySpec = Pems.privateKeySpec((String)dataAndKey.getPrivateKey());
            KeyFactory kf = this.crypto.rsaKeyFactory();
            PrivateKey privKey = kf.generatePrivate(keySpec);
            Cipher cipher = this.crypto.cipher("RSA");
            cipher.init(2, privKey);
            byte[] cipherText = BaseEncoding.base64().decode((CharSequence)whitespace.matcher(dataAndKey.getEncryptedPassword()).replaceAll(""));
            byte[] plainText = cipher.doFinal(cipherText);
            String password = new String(plainText, Charsets.UTF_8);
            return LoginCredentials.builder().user("Administrator").password(password).noPrivateKey().build();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

