/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.filter;

import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.rest.security.provider.DelegatingSecurityProvider;
import org.apache.brooklyn.rest.security.provider.SecurityProvider;
import org.apache.brooklyn.rest.util.MultiSessionAttributeAdapter;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.jetty.http.HttpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynSecurityProviderFilterHelper {
    public static final String AUTHENTICATED_USER_SESSION_ATTRIBUTE = "brooklyn.user";
    private static final Logger log = LoggerFactory.getLogger(BrooklynSecurityProviderFilterHelper.class);
    public static final String BASIC_REALM_NAME = "brooklyn";
    public static final String BASIC_REALM_HEADER_VALUE = "BASIC realm=" + StringEscapes.JavaStringEscapes.wrapJavaString((String)"brooklyn");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(HttpServletRequest webRequest, ManagementContext mgmt) throws SecurityProvider.SecurityProviderDeniedAuthentication {
        HttpSession preferredSession1;
        SecurityProvider provider = this.getProvider(mgmt);
        MultiSessionAttributeAdapter preferredSessionWrapper = null;
        try {
            preferredSessionWrapper = MultiSessionAttributeAdapter.of(webRequest, false);
        }
        catch (WebApplicationException e) {
            this.abort(e.getResponse());
        }
        HttpSession httpSession = preferredSession1 = preferredSessionWrapper == null ? null : preferredSessionWrapper.getPreferredSession();
        if (log.isTraceEnabled()) {
            log.trace(this + " checking " + MultiSessionAttributeAdapter.info(webRequest));
        }
        if (provider.isAuthenticated(preferredSession1)) {
            log.trace("{} already authenticated - {}", (Object)this, (Object)preferredSession1);
            return;
        }
        String user = null;
        String pass = null;
        if (provider.requiresUserPass()) {
            String userpass;
            String authorization = webRequest.getHeader("Authorization");
            if (authorization == null) throw this.abort("Authorization required", provider.requiresUserPass());
            if (authorization.length() < 6) {
                throw this.abort("Invalid authorization string (too short)", provider.requiresUserPass());
            }
            try {
                userpass = new String(Base64.decodeBase64((String)authorization.substring(6)));
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                throw this.abort("Invalid authorization string (not Base64)", provider.requiresUserPass());
            }
            int idxColon = userpass.indexOf(":");
            if (idxColon < 0) throw this.abort("Invalid authorization string (no colon after decoding)", provider.requiresUserPass());
            user = userpass.substring(0, idxColon);
            pass = userpass.substring(idxColon + 1);
        }
        Supplier<HttpSession> sessionSupplier = () -> preferredSession1 != null ? preferredSession1 : MultiSessionAttributeAdapter.of(webRequest, true).getPreferredSession();
        try {
            if (!provider.authenticate(webRequest, sessionSupplier, user, pass)) throw this.abort("Authentication failed", provider.requiresUserPass());
            HttpSession preferredSession2 = sessionSupplier.get();
            log.trace("{} authentication successful - {}", (Object)this, (Object)preferredSession2);
            preferredSession2.setAttribute("request.remoteAddress", (Object)webRequest.getRemoteAddr());
            if (user == null) return;
            preferredSession2.setAttribute(AUTHENTICATED_USER_SESSION_ATTRIBUTE, (Object)user);
            return;
        }
        catch (WebApplicationException e) {
            this.abort(e.getResponse());
        }
        throw this.abort("Authentication failed", provider.requiresUserPass());
    }

    SecurityProvider.SecurityProviderDeniedAuthentication abort(String msg, boolean requiresUserPass) throws SecurityProvider.SecurityProviderDeniedAuthentication {
        Response.ResponseBuilder response = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
        if (requiresUserPass) {
            response.header(HttpHeader.WWW_AUTHENTICATE.asString(), (Object)BASIC_REALM_HEADER_VALUE);
        }
        response.header(HttpHeader.CONTENT_TYPE.asString(), (Object)"text/plain");
        response.entity((Object)msg);
        throw new SecurityProvider.SecurityProviderDeniedAuthentication(response.build());
    }

    void abort(Response response) throws SecurityProvider.SecurityProviderDeniedAuthentication {
        throw new SecurityProvider.SecurityProviderDeniedAuthentication(response);
    }

    SecurityProvider.SecurityProviderDeniedAuthentication redirect(String path, String msg) throws SecurityProvider.SecurityProviderDeniedAuthentication {
        Response.ResponseBuilder response = Response.status((Response.Status)Response.Status.FOUND);
        response.header(HttpHeader.LOCATION.asString(), (Object)path);
        response.entity((Object)msg);
        throw new SecurityProvider.SecurityProviderDeniedAuthentication(response.build());
    }

    protected SecurityProvider getProvider(ManagementContext mgmt) {
        return new DelegatingSecurityProvider(mgmt);
    }

    public static interface Responder {
        public void error(String var1, boolean var2) throws SecurityProvider.SecurityProviderDeniedAuthentication;
    }
}

