/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.inventory.impl.helper;

import java.io.Writer;
import java.util.StringTokenizer;
import org.apache.felix.inventory.impl.helper.ConfigurationWriter;

public class JSONConfigurationWriter
extends ConfigurationWriter {
    private boolean wrapJSON = false;
    private boolean startLine;
    private boolean needComma;
    private final char[] oneChar = new char[1];

    public JSONConfigurationWriter(Writer delegatee) {
        super(delegatee);
    }

    public void startJSONWrapper() {
        this.println("[");
        this.wrapJSON = true;
        this.startLine = true;
        this.needComma = false;
    }

    public void endJSONWrapper() {
        if (this.wrapJSON) {
            this.println();
            this.wrapJSON = false;
            this.startLine = false;
            super.println("]");
        }
    }

    public void println() {
        if (this.wrapJSON) {
            if (!this.startLine) {
                super.write(34);
                this.startLine = true;
                this.needComma = true;
            }
        } else {
            super.println();
        }
    }

    public void print(String str) {
        char[] chars = str.toCharArray();
        this.write(chars, 0, chars.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int character) {
        char[] cArray = this.oneChar;
        synchronized (this.oneChar) {
            this.oneChar[0] = (char)character;
            this.write(this.oneChar, 0, 1);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void write(char[] chars, int off, int len) {
        if (this.wrapJSON) {
            if (this.startLine) {
                this.startLine();
                this.startLine = false;
            }
            String v = new String(chars, off, len);
            StringTokenizer st = new StringTokenizer(v, "\r\n\"", true);
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (t.length() == 1) {
                    char c = t.charAt(0);
                    if (c == '\r') continue;
                    if (c == '\n') {
                        this.println();
                        this.startLine();
                        continue;
                    }
                    if (c == '\"') {
                        super.write(92);
                        super.write(c);
                        continue;
                    }
                    super.write(c);
                    continue;
                }
                super.write(t.toCharArray(), 0, t.length());
            }
        } else {
            super.write(chars, off, len);
        }
    }

    public void write(String string, int off, int len) {
        this.write(string.toCharArray(), off, len);
    }

    private void startLine() {
        if (this.needComma) {
            super.write(44);
            super.println();
            this.needComma = false;
        }
        super.write("    \"".toCharArray(), 0, 5);
        this.startLine = false;
    }
}

