/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.network.bind;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import org.apache.brooklyn.entity.group.DynamicGroup;
import org.apache.brooklyn.entity.network.bind.BindDnsServer;
import org.apache.brooklyn.entity.network.bind.BindDnsServerDriver;
import org.apache.brooklyn.entity.network.bind.BindDnsServerSshDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindDnsServerImpl
extends SoftwareProcessImpl
implements BindDnsServer {
    private static final Logger LOG = LoggerFactory.getLogger(BindDnsServerImpl.class);
    private final Object serialMutex = new Object();
    private static final CharMatcher DOMAIN_NAME_FIRST_CHAR_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9'));
    private static final CharMatcher DOMAIN_NAME_MATCHER = DOMAIN_NAME_FIRST_CHAR_MATCHER.or(CharMatcher.is((char)'-'));
    private transient boolean hasLoggedDeprecationAboutAddressSensor = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        super.init();
        Preconditions.checkNotNull((Object)this.getConfig(HOSTNAME_SENSOR), (String)"%s requires value for %s", (Object[])new Object[]{this.getClass().getName(), HOSTNAME_SENSOR});
        Preconditions.checkNotNull((Object)this.getConfig(ADDRESS_SENSOR), (String)"%s requires value for %s", (Object[])new Object[]{this.getClass().getName(), ADDRESS_SENSOR});
        DynamicGroup entities = (DynamicGroup)this.addChild((EntitySpec)((EntitySpec)EntitySpec.create(DynamicGroup.class).displayName("BIND-managed entities")).configure(DynamicGroup.ENTITY_FILTER, this.getEntityFilter()));
        this.sensors().set(ENTITIES, (Object)entities);
        this.sensors().set(A_RECORDS, (Object)ImmutableMap.of());
        this.sensors().set(CNAME_RECORDS, (Object)ImmutableMultimap.of());
        this.sensors().set(PTR_RECORDS, (Object)ImmutableMap.of());
        this.sensors().set(ADDRESS_MAPPINGS, (Object)ImmutableMultimap.of());
        Object object = this.serialMutex;
        synchronized (object) {
            this.sensors().set(SERIAL, (Object)(System.currentTimeMillis() / 1000L));
        }
    }

    public void postRebind() {
        this.update();
    }

    public Class<?> getDriverInterface() {
        return BindDnsServerDriver.class;
    }

    @Override
    public Multimap<String, String> getAddressMappings() {
        return (Multimap)this.getAttribute(ADDRESS_MAPPINGS);
    }

    @Override
    public Map<String, String> getReverseMappings() {
        return (Map)this.getAttribute(PTR_RECORDS);
    }

    public BindDnsServerDriver getDriver() {
        return (BindDnsServerDriver)super.getDriver();
    }

    public void connectSensors() {
        this.connectServiceUpIsRunning();
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        this.disconnectServiceUpIsRunning();
    }

    protected void preStart() {
        String reverse = (String)this.getConfig(REVERSE_LOOKUP_NETWORK);
        if (Strings.isBlank((CharSequence)reverse)) {
            reverse = (String)this.getAttribute(ADDRESS);
        }
        this.sensors().set(REVERSE_LOOKUP_CIDR, (Object)new Cidr(reverse + "/24"));
        String reverseLookupDomain = Joiner.on((char)'.').join(Iterables.skip((Iterable)Lists.reverse((List)Lists.newArrayList((Iterable)Splitter.on((char)'.').split((CharSequence)reverse))), (int)1)) + ".in-addr.arpa";
        this.sensors().set(REVERSE_LOOKUP_DOMAIN, (Object)reverseLookupDomain);
        this.policies().add((PolicySpec)((PolicySpec)((PolicySpec)PolicySpec.create(MemberTrackingPolicy.class).displayName("Address tracker")).configure(AbstractMembershipTrackingPolicy.SENSORS_TO_TRACK, (Object)ImmutableSet.of((Object)this.getConfig(HOSTNAME_SENSOR), (Object)this.getConfig(ADDRESS_SENSOR)))).configure(AbstractMembershipTrackingPolicy.GROUP, (Object)this.getEntities()));
    }

    public void postStart() {
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Lifecycle serverState = (Lifecycle)this.getAttribute(Attributes.SERVICE_STATE_ACTUAL);
        if (Lifecycle.STOPPED.equals((Object)serverState) || Lifecycle.STOPPING.equals((Object)serverState) || Lifecycle.DESTROYED.equals((Object)serverState) || !((Boolean)this.getAttribute(Attributes.SERVICE_UP)).booleanValue()) {
            LOG.debug("Skipped update of {} when service state is {} and running is {}", new Object[]{this, this.getAttribute(Attributes.SERVICE_STATE_ACTUAL), this.getAttribute(SERVICE_UP)});
            return;
        }
        BindDnsServerImpl bindDnsServerImpl = this;
        synchronized (bindDnsServerImpl) {
            FluentIterable availableEntities = FluentIterable.from((Iterable)this.getEntities().getMembers()).filter((Predicate)new HasHostnameAndValidLifecycle());
            LOG.debug("{} updating with entities: {}", (Object)this, (Object)Iterables.toString((Iterable)availableEntities));
            ImmutableListMultimap hostnameToEntity = Multimaps.index((Iterable)availableEntities, (Function)new HostnameTransformer());
            HashMap octetToName = Maps.newHashMap();
            HashBiMap ipToARecord = HashBiMap.create();
            SetMultimap aRecordToCnames = MultimapBuilder.hashKeys().hashSetValues().build();
            SetMultimap ipToAllNames = MultimapBuilder.hashKeys().hashSetValues().build();
            for (Map.Entry entry : hostnameToEntity.entries()) {
                String domainName = (String)entry.getKey();
                Entity entity = (Entity)entry.getValue();
                String address = null;
                AttributeSensor addressSensor = (AttributeSensor)this.getConfig(ADDRESS_SENSOR);
                if (addressSensor != null) {
                    address = (String)entity.getAttribute(addressSensor);
                } else {
                    Maybe location;
                    if (!this.hasLoggedDeprecationAboutAddressSensor) {
                        LOG.warn("BIND entity " + this + " is using legacy machine inspection to determine IP address; set the " + ADDRESS_SENSOR.getName() + " config to ensure compatibility with future versions");
                        this.hasLoggedDeprecationAboutAddressSensor = true;
                    }
                    if (!(location = Machines.findUniqueMachineLocation((Iterable)entity.getLocations(), SshMachineLocation.class)).isPresent()) {
                        LOG.debug("Member {} of {} does not have an hostname so will not be configured", (Object)entity, (Object)this);
                    } else if (!ipToARecord.inverse().containsKey((Object)domainName)) {
                        address = ((SshMachineLocation)location.get()).getAddress().getHostAddress();
                    }
                }
                if (Strings.isBlank((CharSequence)address)) continue;
                ipToAllNames.put((Object)address, (Object)domainName);
                if (!ipToARecord.containsKey((Object)address)) {
                    String octet;
                    ipToARecord.put((Object)address, (Object)domainName);
                    if (!this.getReverseLookupNetwork().contains(new Cidr(address + "/32")) || octetToName.containsKey(octet = (String)Iterables.get((Iterable)Splitter.on((char)'.').split((CharSequence)address), (int)3))) continue;
                    octetToName.put(octet, domainName);
                    continue;
                }
                aRecordToCnames.put(ipToARecord.get((Object)address), (Object)domainName);
            }
            this.sensors().set(A_RECORDS, (Object)ImmutableMap.copyOf((Map)ipToARecord.inverse()));
            this.sensors().set(PTR_RECORDS, (Object)ImmutableMap.copyOf((Map)octetToName));
            this.sensors().set(CNAME_RECORDS, (Object)Multimaps.unmodifiableMultimap((Multimap)aRecordToCnames));
            this.sensors().set(ADDRESS_MAPPINGS, (Object)Multimaps.unmodifiableMultimap((Multimap)ipToAllNames));
            this.getDriver().updateBindConfiguration();
        }
    }

    protected void configureResolver(Entity entity) {
        Maybe machine = Machines.findUniqueMachineLocation((Iterable)entity.getLocations(), SshMachineLocation.class);
        if (machine.isPresent()) {
            if (((Boolean)this.getConfig(REPLACE_RESOLV_CONF)).booleanValue()) {
                ((SshMachineLocation)machine.get()).copyTo((Reader)new StringReader((String)this.getConfig(RESOLV_CONF_TEMPLATE)), "/etc/resolv.conf");
            } else {
                this.appendTemplate((String)this.getConfig(INTERFACE_CONFIG_TEMPLATE), "/etc/sysconfig/network-scripts/ifcfg-eth0", (SshMachineLocation)machine.get());
                ((SshMachineLocation)machine.get()).execScript("reload network", (List)ImmutableList.of((Object)BashCommands.sudo((String)"service network reload")));
            }
            LOG.info("configured resolver on {}", (Object)machine);
        } else {
            LOG.debug("{} can't configure resolver at {}: no SshMachineLocation", (Object)this, (Object)entity);
        }
    }

    protected void appendTemplate(String template, String destination, SshMachineLocation machine) {
        String content = ((BindDnsServerSshDriver)this.getDriver()).processTemplate(template);
        String temp = "/tmp/template-" + Strings.makeRandomId((int)6);
        machine.copyTo((InputStream)new ByteArrayInputStream(content.getBytes()), temp);
        machine.execScript("updating file", (List)ImmutableList.of((Object)BashCommands.sudo((String)String.format("tee -a %s < %s", destination, temp)), (Object)String.format("rm -f %s", temp)));
    }

    @Override
    public Predicate<? super Entity> getEntityFilter() {
        return (Predicate)this.getConfig(ENTITY_FILTER);
    }

    public String getManagementCidr() {
        return (String)this.getConfig(MANAGEMENT_CIDR);
    }

    public Integer getDnsPort() {
        return (Integer)this.getAttribute((AttributeSensor)DNS_PORT);
    }

    public String getDomainName() {
        return (String)this.getConfig(DOMAIN_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSerial() {
        Object object = this.serialMutex;
        synchronized (object) {
            long next = (Long)this.getAttribute(SERIAL) + 1L;
            this.sensors().set(SERIAL, (Object)next);
            return next;
        }
    }

    public Cidr getReverseLookupNetwork() {
        return (Cidr)this.getAttribute(REVERSE_LOOKUP_CIDR);
    }

    public String getReverseLookupDomain() {
        return (String)this.getAttribute(REVERSE_LOOKUP_DOMAIN);
    }

    public DynamicGroup getEntities() {
        return (DynamicGroup)this.getAttribute(ENTITIES);
    }

    public Map<String, String> getAddressRecords() {
        return (Map)this.getAttribute(A_RECORDS);
    }

    public Multimap<String, String> getCanonicalNameRecords() {
        return (Multimap)this.getAttribute(CNAME_RECORDS);
    }

    public Map<String, Collection<String>> getCnamesForTemplates() {
        return ((Multimap)this.getAttribute(CNAME_RECORDS)).asMap();
    }

    public Map<String, String> getPointerRecords() {
        return (Map)this.getAttribute(PTR_RECORDS);
    }

    private class HasHostnameAndValidLifecycle
    implements Predicate<Entity> {
        private HasHostnameAndValidLifecycle() {
        }

        public boolean apply(Entity input) {
            switch ((Lifecycle)input.getAttribute(Attributes.SERVICE_STATE_ACTUAL)) {
                case STOPPED: 
                case STOPPING: 
                case DESTROYED: {
                    return false;
                }
            }
            return input.getAttribute((AttributeSensor)BindDnsServerImpl.this.getConfig(BindDnsServer.HOSTNAME_SENSOR)) != null;
        }
    }

    public static class MemberTrackingPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityChange(Entity member) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("State of {} on change: {}", (Object)member, (Object)((Lifecycle)member.getAttribute(Attributes.SERVICE_STATE_ACTUAL)).name());
            }
            ((BindDnsServerImpl)this.entity).update();
        }

        protected void onEntityAdded(Entity member) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("State of {} on added: {}", (Object)member, (Object)((Lifecycle)member.getAttribute(Attributes.SERVICE_STATE_ACTUAL)).name());
            }
            ((BindDnsServerImpl)this.entity).configureResolver(member);
        }
    }

    private class HostnameTransformer
    implements Function<Entity, String> {
        private HostnameTransformer() {
        }

        public String apply(Entity input) {
            String hostname = (String)input.getAttribute((AttributeSensor)BindDnsServerImpl.this.getConfig(BindDnsServer.HOSTNAME_SENSOR));
            hostname = DOMAIN_NAME_FIRST_CHAR_MATCHER.negate().trimFrom((CharSequence)hostname);
            hostname = DOMAIN_NAME_MATCHER.negate().trimAndCollapseFrom((CharSequence)hostname, '-');
            if (hostname.length() > 63) {
                hostname = hostname.substring(0, 63);
            }
            return hostname;
        }
    }
}

