/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.strategy.EatWhatYouKill;

public class ManagedSelector
extends ContainerLifeCycle
implements Dumpable {
    private static final Logger LOG = Log.getLogger(ManagedSelector.class);
    private static final boolean FORCE_SELECT_NOW;
    private final AtomicBoolean _started = new AtomicBoolean(false);
    private boolean _selecting = false;
    private final SelectorManager _selectorManager;
    private final int _id;
    private final ExecutionStrategy _strategy;
    private Selector _selector;
    private Deque<SelectorUpdate> _updates = new ArrayDeque<SelectorUpdate>();
    private Deque<SelectorUpdate> _updateable = new ArrayDeque<SelectorUpdate>();

    public ManagedSelector(SelectorManager selectorManager, int id) {
        this._selectorManager = selectorManager;
        this._id = id;
        SelectorProducer producer = new SelectorProducer();
        Executor executor = selectorManager.getExecutor();
        this._strategy = new EatWhatYouKill((ExecutionStrategy.Producer)producer, executor);
        this.addBean(this._strategy, true);
        this.setStopTimeout(5000L);
    }

    public Selector getSelector() {
        return this._selector;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this._selector = this._selectorManager.newSelector();
        this._selectorManager.execute(() -> ((ExecutionStrategy)this._strategy).produce());
        Start start = new Start();
        this.submit(start);
        start._started.await();
    }

    public int size() {
        Selector s = this._selector;
        if (s == null) {
            return 0;
        }
        return s.keys().size();
    }

    protected void doStop() throws Exception {
        if (this._started.compareAndSet(true, false)) {
            CloseConnections closeConnections = new CloseConnections();
            this.submit(closeConnections);
            closeConnections._complete.await();
            StopSelector stopSelector = new StopSelector();
            this.submit(stopSelector);
            stopSelector._stopped.await();
        }
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(SelectorUpdate update) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queued change {} on {}", new Object[]{update, this});
        }
        Selector selector = null;
        ManagedSelector managedSelector = this;
        synchronized (managedSelector) {
            this._updates.offer(update);
            if (this._selecting) {
                selector = this._selector;
                this._selecting = false;
            }
        }
        if (selector != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Wakeup on submit {}", new Object[]{this});
            }
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeup() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Wakeup {}", new Object[]{this});
        }
        Selector selector = null;
        ManagedSelector managedSelector = this;
        synchronized (managedSelector) {
            if (this._selecting) {
                selector = this._selector;
                this._selecting = false;
            }
        }
        if (selector != null) {
            selector.wakeup();
        }
    }

    private void execute(Runnable task) {
        block2: {
            try {
                this._selectorManager.execute(task);
            }
            catch (RejectedExecutionException x) {
                if (!(task instanceof Closeable)) break block2;
                ManagedSelector.closeNoExceptions((Closeable)((Object)task));
            }
        }
    }

    private void processConnect(SelectionKey key, Connect connect) {
        SelectableChannel channel = key.channel();
        try {
            key.attach(connect.attachment);
            boolean connected = this._selectorManager.doFinishConnect(channel);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connected {} {}", new Object[]{connected, channel});
            }
            if (connected) {
                if (!connect.timeout.cancel()) {
                    throw new SocketTimeoutException("Concurrent Connect Timeout");
                }
            } else {
                throw new ConnectException();
            }
            key.interestOps(0);
            this.execute(new CreateEndPoint(connect, key));
        }
        catch (Throwable x) {
            connect.failed(x);
        }
    }

    private static void closeNoExceptions(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable x) {
            LOG.ignore(x);
        }
    }

    private void createEndPoint(SelectableChannel channel, SelectionKey selectionKey) throws IOException {
        EndPoint endPoint = this._selectorManager.newEndPoint(channel, this, selectionKey);
        Connection connection = this._selectorManager.newConnection(channel, endPoint, selectionKey.attachment());
        endPoint.setConnection(connection);
        selectionKey.attach(endPoint);
        endPoint.onOpen();
        this._selectorManager.endPointOpened(endPoint);
        this._selectorManager.connectionOpened(connection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", new Object[]{endPoint});
        }
    }

    public void destroyEndPoint(EndPoint endPoint) {
        this.wakeup();
        this.execute(new DestroyEndPoint(endPoint));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getActionSize() {
        ManagedSelector managedSelector = this;
        synchronized (managedSelector) {
            return this._updates.size();
        }
    }

    static int safeReadyOps(SelectionKey selectionKey) {
        try {
            return selectionKey.readyOps();
        }
        catch (Throwable x) {
            LOG.ignore(x);
            return -1;
        }
    }

    static int safeInterestOps(SelectionKey selectionKey) {
        try {
            return selectionKey.interestOps();
        }
        catch (Throwable x) {
            LOG.ignore(x);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Appendable out, String indent) throws IOException {
        Selector selector = this._selector;
        if (selector != null && selector.isOpen()) {
            ArrayList<SelectorUpdate> updates;
            DumpKeys dump = new DumpKeys();
            String updatesAt = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.now());
            ManagedSelector managedSelector = this;
            synchronized (managedSelector) {
                updates = new ArrayList<SelectorUpdate>(this._updates);
                this._updates.addFirst(dump);
                this._selecting = false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("wakeup on dump {}", new Object[]{this});
            }
            selector.wakeup();
            List<String> keys = dump.get(5L, TimeUnit.SECONDS);
            String keysAt = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.now());
            if (keys == null) {
                keys = Collections.singletonList("No dump keys retrieved");
            }
            this.dumpObjects(out, indent, new Object[]{new DumpableCollection("updates @ " + updatesAt, updates), new DumpableCollection("keys @ " + keysAt, keys)});
        } else {
            this.dumpObjects(out, indent, new Object[0]);
        }
    }

    public String toString() {
        Selector selector = this._selector;
        return String.format("%s id=%s keys=%d selected=%d updates=%d", super.toString(), this._id, selector != null && selector.isOpen() ? selector.keys().size() : -1, selector != null && selector.isOpen() ? selector.selectedKeys().size() : -1, this.getActionSize());
    }

    static {
        String property = System.getProperty("org.eclipse.jetty.io.forceSelectNow");
        FORCE_SELECT_NOW = property != null ? Boolean.parseBoolean(property) : (property = System.getProperty("os.name")) != null && property.toLowerCase(Locale.ENGLISH).contains("windows");
    }

    private class DestroyEndPoint
    implements Runnable,
    Closeable {
        private final EndPoint endPoint;

        public DestroyEndPoint(EndPoint endPoint) {
            this.endPoint = endPoint;
        }

        @Override
        public void run() {
            Connection connection;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Destroyed {}", new Object[]{this.endPoint});
            }
            if ((connection = this.endPoint.getConnection()) != null) {
                ManagedSelector.this._selectorManager.connectionClosed(connection);
            }
            ManagedSelector.this._selectorManager.endPointClosed(this.endPoint);
        }

        @Override
        public void close() {
            this.run();
        }
    }

    private final class CreateEndPoint
    implements Runnable {
        private final Connect _connect;
        private final SelectionKey _key;

        private CreateEndPoint(Connect connect, SelectionKey key) {
            this._connect = connect;
            this._key = key;
        }

        @Override
        public void run() {
            try {
                ManagedSelector.this.createEndPoint(this._connect.channel, this._key);
            }
            catch (Throwable failure) {
                ManagedSelector.closeNoExceptions(this._connect.channel);
                LOG.warn(String.valueOf(failure), new Object[0]);
                LOG.debug(failure);
                this._connect.failed(failure);
            }
        }

        public String toString() {
            return String.format("CreateEndPoint@%x{%s,%s}", this.hashCode(), this._connect, this._key);
        }
    }

    private class StopSelector
    implements SelectorUpdate {
        CountDownLatch _stopped = new CountDownLatch(1);

        private StopSelector() {
        }

        @Override
        public void update(Selector selector) {
            for (SelectionKey key : selector.keys()) {
                Object attachment;
                if (key == null || !key.isValid() || !((attachment = key.attachment()) instanceof EndPoint)) continue;
                ManagedSelector.closeNoExceptions((EndPoint)attachment);
            }
            ManagedSelector.this._selector = null;
            ManagedSelector.closeNoExceptions(selector);
            this._stopped.countDown();
        }
    }

    private class CloseConnections
    implements SelectorUpdate {
        final Set<Closeable> _closed;
        final CountDownLatch _noEndPoints = new CountDownLatch(1);
        final CountDownLatch _complete = new CountDownLatch(1);

        public CloseConnections() {
            this(null);
        }

        public CloseConnections(Set<Closeable> closed) {
            this._closed = closed;
        }

        @Override
        public void update(Selector selector) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing {} connections on {}", new Object[]{selector.keys().size(), ManagedSelector.this});
            }
            boolean zero = true;
            for (SelectionKey key : selector.keys()) {
                if (key == null || !key.isValid()) continue;
                Closeable closeable = null;
                Object attachment = key.attachment();
                if (attachment instanceof EndPoint) {
                    Connection connection;
                    EndPoint endp = (EndPoint)attachment;
                    if (!endp.isOutputShutdown()) {
                        zero = false;
                    }
                    closeable = (connection = endp.getConnection()) != null ? connection : endp;
                }
                if (closeable == null) continue;
                if (this._closed == null) {
                    ManagedSelector.closeNoExceptions(closeable);
                    continue;
                }
                if (this._closed.contains(closeable)) continue;
                this._closed.add(closeable);
                ManagedSelector.closeNoExceptions(closeable);
            }
            if (zero) {
                this._noEndPoints.countDown();
            }
            this._complete.countDown();
        }
    }

    class Connect
    implements SelectorUpdate,
    Runnable {
        private final AtomicBoolean failed = new AtomicBoolean();
        private final SelectableChannel channel;
        private final Object attachment;
        private final Scheduler.Task timeout;

        Connect(SelectableChannel channel, Object attachment) {
            this.channel = channel;
            this.attachment = attachment;
            this.timeout = ManagedSelector.this._selectorManager.getScheduler().schedule((Runnable)this, ManagedSelector.this._selectorManager.getConnectTimeout(), TimeUnit.MILLISECONDS);
        }

        @Override
        public void update(Selector selector) {
            try {
                this.channel.register(selector, 8, this);
            }
            catch (Throwable x) {
                this.failed(x);
            }
        }

        @Override
        public void run() {
            if (ManagedSelector.this._selectorManager.isConnectionPending(this.channel)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Channel {} timed out while connecting, closing it", new Object[]{this.channel});
                }
                this.failed(new SocketTimeoutException("Connect Timeout"));
            }
        }

        public void failed(Throwable failure) {
            if (this.failed.compareAndSet(false, true)) {
                this.timeout.cancel();
                ManagedSelector.closeNoExceptions(this.channel);
                ManagedSelector.this._selectorManager.connectionFailed(this.channel, failure, this.attachment);
            }
        }

        public String toString() {
            return String.format("Connect@%x{%s,%s}", this.hashCode(), this.channel, this.attachment);
        }
    }

    class Accept
    implements SelectorUpdate,
    Runnable,
    Closeable {
        private final SelectableChannel channel;
        private final Object attachment;
        private SelectionKey key;

        Accept(SelectableChannel channel, Object attachment) {
            this.channel = channel;
            this.attachment = attachment;
            ManagedSelector.this._selectorManager.onAccepting(channel);
        }

        @Override
        public void close() {
            LOG.debug("closed accept of {}", new Object[]{this.channel});
            ManagedSelector.closeNoExceptions(this.channel);
        }

        @Override
        public void update(Selector selector) {
            try {
                this.key = this.channel.register(selector, 0, this.attachment);
                ManagedSelector.this.execute(this);
            }
            catch (Throwable x) {
                ManagedSelector.closeNoExceptions(this.channel);
                ManagedSelector.this._selectorManager.onAcceptFailed(this.channel, x);
                LOG.debug(x);
            }
        }

        @Override
        public void run() {
            try {
                ManagedSelector.this.createEndPoint(this.channel, this.key);
                ManagedSelector.this._selectorManager.onAccepted(this.channel);
            }
            catch (Throwable x) {
                LOG.debug(x);
                this.failed(x);
            }
        }

        protected void failed(Throwable failure) {
            ManagedSelector.closeNoExceptions(this.channel);
            LOG.warn(String.valueOf(failure), new Object[0]);
            LOG.debug(failure);
            ManagedSelector.this._selectorManager.onAcceptFailed(this.channel, failure);
        }
    }

    class Acceptor
    implements SelectorUpdate,
    Selectable,
    Closeable {
        private final SelectableChannel _channel;
        private SelectionKey _key;

        public Acceptor(SelectableChannel channel) {
            this._channel = channel;
        }

        @Override
        public void update(Selector selector) {
            try {
                if (this._key == null) {
                    this._key = this._channel.register(selector, 16, this);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} acceptor={}", new Object[]{this, this._key});
                }
            }
            catch (Throwable x) {
                ManagedSelector.closeNoExceptions(this._channel);
                LOG.warn(x);
            }
        }

        @Override
        public Runnable onSelected() {
            SelectableChannel server = this._key.channel();
            SelectableChannel channel = null;
            try {
                while ((channel = ManagedSelector.this._selectorManager.doAccept(server)) != null) {
                    ManagedSelector.this._selectorManager.accepted(channel);
                }
            }
            catch (Throwable x) {
                ManagedSelector.closeNoExceptions(channel);
                LOG.warn("Accept failed for channel " + channel, x);
            }
            return null;
        }

        @Override
        public void updateKey() {
        }

        @Override
        public void close() throws IOException {
            SelectionKey key = this._key;
            this._key = null;
            if (key != null && key.isValid()) {
                key.cancel();
            }
        }
    }

    private static class DumpKeys
    implements SelectorUpdate {
        private CountDownLatch latch = new CountDownLatch(1);
        private List<String> keys;

        private DumpKeys() {
        }

        @Override
        public void update(Selector selector) {
            Set<SelectionKey> selectionKeys = selector.keys();
            ArrayList<String> list = new ArrayList<String>(selectionKeys.size());
            for (SelectionKey key : selectionKeys) {
                if (key == null) continue;
                list.add(String.format("SelectionKey@%x{i=%d}->%s", key.hashCode(), ManagedSelector.safeInterestOps(key), key.attachment()));
            }
            this.keys = list;
            this.latch.countDown();
        }

        public List<String> get(long timeout, TimeUnit unit) {
            try {
                this.latch.await(timeout, unit);
            }
            catch (InterruptedException x) {
                LOG.ignore((Throwable)x);
            }
            return this.keys;
        }
    }

    private class Start
    implements SelectorUpdate {
        private final CountDownLatch _started = new CountDownLatch(1);

        private Start() {
        }

        @Override
        public void update(Selector selector) {
            ManagedSelector.this._started.set(true);
            this._started.countDown();
        }
    }

    public static interface SelectorUpdate {
        public void update(Selector var1);
    }

    private class SelectorProducer
    implements ExecutionStrategy.Producer {
        private Set<SelectionKey> _keys = Collections.emptySet();
        private Iterator<SelectionKey> _cursor = Collections.emptyIterator();

        private SelectorProducer() {
        }

        public Runnable produce() {
            do {
                Runnable task;
                if ((task = this.processSelected()) != null) {
                    return task;
                }
                this.processUpdates();
                this.updateKeys();
            } while (this.select());
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processUpdates() {
            Selector selector;
            int updates;
            ManagedSelector managedSelector = ManagedSelector.this;
            synchronized (managedSelector) {
                Deque updates2 = ManagedSelector.this._updates;
                ManagedSelector.this._updates = ManagedSelector.this._updateable;
                ManagedSelector.this._updateable = updates2;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("updateable {}", (long)ManagedSelector.this._updateable.size());
            }
            for (SelectorUpdate update : ManagedSelector.this._updateable) {
                if (ManagedSelector.this._selector == null) break;
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("update {}", new Object[]{update});
                    }
                    update.update(ManagedSelector.this._selector);
                }
                catch (Throwable ex) {
                    LOG.warn(ex);
                }
            }
            ManagedSelector.this._updateable.clear();
            ManagedSelector managedSelector2 = ManagedSelector.this;
            synchronized (managedSelector2) {
                updates = ManagedSelector.this._updates.size();
                ManagedSelector.this._selecting = updates == 0;
                selector = ManagedSelector.this._selecting ? null : ManagedSelector.this._selector;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("updates {}", (long)updates);
            }
            if (selector != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("wakeup on updates {}", new Object[]{this});
                }
                selector.wakeup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean select() {
            block14: {
                try {
                    int updates;
                    int selected;
                    Selector selector = ManagedSelector.this._selector;
                    if (selector == null || !selector.isOpen()) break block14;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Selector {} waiting with {} keys", new Object[]{selector, selector.keys().size()});
                    }
                    if ((selected = selector.select()) == 0) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Selector {} woken with none selected", new Object[]{selector});
                        }
                        if (Thread.interrupted() && !ManagedSelector.this.isRunning()) {
                            throw new ClosedSelectorException();
                        }
                        if (FORCE_SELECT_NOW) {
                            selected = selector.selectNow();
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Selector {} woken up from select, {}/{}/{} selected", new Object[]{selector, selected, selector.selectedKeys().size(), selector.keys().size()});
                    }
                    ManagedSelector managedSelector = ManagedSelector.this;
                    synchronized (managedSelector) {
                        ManagedSelector.this._selecting = false;
                        updates = ManagedSelector.this._updates.size();
                    }
                    this._keys = selector.selectedKeys();
                    Iterator<Object> iterator = this._cursor = this._keys.isEmpty() ? Collections.emptyIterator() : this._keys.iterator();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Selector {} processing {} keys, {} updates", new Object[]{selector, this._keys.size(), updates});
                    }
                    return true;
                }
                catch (Throwable x) {
                    ManagedSelector.this._selector = null;
                    if (ManagedSelector.this.isRunning()) {
                        LOG.warn(x);
                    } else {
                        LOG.warn(x.toString(), new Object[0]);
                        LOG.debug(x);
                    }
                    ManagedSelector.closeNoExceptions(ManagedSelector.this._selector);
                }
            }
            return false;
        }

        private Runnable processSelected() {
            while (this._cursor.hasNext()) {
                Object attachment;
                SelectionKey key = this._cursor.next();
                if (key.isValid()) {
                    attachment = key.attachment();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("selected {} {} {} ", new Object[]{ManagedSelector.safeReadyOps(key), key, attachment});
                    }
                    try {
                        if (attachment instanceof Selectable) {
                            Runnable task = ((Selectable)attachment).onSelected();
                            if (task == null) continue;
                            return task;
                        }
                        if (key.isConnectable()) {
                            ManagedSelector.this.processConnect(key, (Connect)attachment);
                            continue;
                        }
                        throw new IllegalStateException("key=" + key + ", att=" + attachment + ", iOps=" + ManagedSelector.safeInterestOps(key) + ", rOps=" + ManagedSelector.safeReadyOps(key));
                    }
                    catch (CancelledKeyException x) {
                        LOG.debug("Ignoring cancelled key for channel {}", new Object[]{key.channel()});
                        if (!(attachment instanceof EndPoint)) continue;
                        ManagedSelector.closeNoExceptions((EndPoint)attachment);
                        continue;
                    }
                    catch (Throwable x) {
                        LOG.warn("Could not process key for channel " + key.channel(), x);
                        if (!(attachment instanceof EndPoint)) continue;
                        ManagedSelector.closeNoExceptions((EndPoint)attachment);
                        continue;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Selector loop ignoring invalid key for channel {}", new Object[]{key.channel()});
                }
                if (!((attachment = key.attachment()) instanceof EndPoint)) continue;
                ManagedSelector.closeNoExceptions((EndPoint)attachment);
            }
            return null;
        }

        private void updateKeys() {
            for (SelectionKey key : this._keys) {
                Object attachment = key.attachment();
                if (!(attachment instanceof Selectable)) continue;
                ((Selectable)attachment).updateKey();
            }
            this._keys.clear();
        }

        public String toString() {
            return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
        }
    }

    public static interface Selectable {
        public Runnable onSelected();

        public void updateKey();
    }
}

