/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.client.ReadOnlyLedgerHandle;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.OrderedSafeExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerOpenOp
implements BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata> {
    static final Logger LOG = LoggerFactory.getLogger(LedgerOpenOp.class);
    final BookKeeper bk;
    final long ledgerId;
    final AsyncCallback.OpenCallback cb;
    final Object ctx;
    LedgerHandle lh;
    final byte[] passwd;
    boolean doRecovery = true;
    boolean administrativeOpen = false;
    long startTime;
    OpStatsLogger openOpLogger;
    final BookKeeper.DigestType suggestedDigestType;
    final boolean enableDigestAutodetection;

    public LedgerOpenOp(BookKeeper bk, long ledgerId, BookKeeper.DigestType digestType, byte[] passwd, AsyncCallback.OpenCallback cb, Object ctx) {
        this.bk = bk;
        this.ledgerId = ledgerId;
        this.passwd = passwd;
        this.cb = cb;
        this.ctx = ctx;
        this.enableDigestAutodetection = bk.conf.getEnableDigestTypeAutodetection();
        this.suggestedDigestType = digestType;
    }

    public LedgerOpenOp(BookKeeper bk, long ledgerId, AsyncCallback.OpenCallback cb, Object ctx) {
        this.bk = bk;
        this.ledgerId = ledgerId;
        this.cb = cb;
        this.ctx = ctx;
        this.passwd = bk.getConf().getBookieRecoveryPasswd();
        this.administrativeOpen = true;
        this.enableDigestAutodetection = false;
        this.suggestedDigestType = bk.conf.getBookieRecoveryDigestType();
    }

    public void initiate() {
        this.startTime = MathUtils.nowInNano();
        this.openOpLogger = this.bk.getOpenOpLogger();
        this.bk.getLedgerManager().readLedgerMetadata(this.ledgerId, this);
    }

    public void initiateWithoutRecovery() {
        this.doRecovery = false;
        this.initiate();
    }

    @Override
    public void operationComplete(int rc, LedgerMetadata metadata) {
        byte[] passwd;
        BookKeeper.DigestType digestType;
        if (0 != rc) {
            this.openComplete(rc, null);
            return;
        }
        BookKeeper.DigestType digestType2 = digestType = this.enableDigestAutodetection ? metadata.getDigestType() : this.suggestedDigestType;
        if (this.administrativeOpen && metadata.hasPassword()) {
            passwd = metadata.getPassword();
            digestType = metadata.getDigestType();
        } else {
            passwd = this.passwd;
            if (metadata.hasPassword()) {
                if (!Arrays.equals(passwd, metadata.getPassword())) {
                    LOG.error("Provided passwd does not match that in metadata");
                    this.openComplete(-102, null);
                    return;
                }
                if (digestType != metadata.getDigestType()) {
                    LOG.error("Provided digest does not match that in metadata");
                    this.openComplete(-5, null);
                    return;
                }
            }
        }
        try {
            this.lh = new ReadOnlyLedgerHandle(this.bk, this.ledgerId, metadata, digestType, passwd, !this.doRecovery);
        }
        catch (GeneralSecurityException e) {
            LOG.error("Security exception while opening ledger: " + this.ledgerId, (Throwable)e);
            this.openComplete(-4, null);
            return;
        }
        catch (NumberFormatException e) {
            LOG.error("Incorrectly entered parameter throttle: " + this.bk.getConf().getThrottleValue(), (Throwable)e);
            this.openComplete(-14, null);
            return;
        }
        if (metadata.isClosed()) {
            this.openComplete(0, this.lh);
            return;
        }
        if (this.doRecovery) {
            this.lh.recover((BookkeeperInternalCallbacks.GenericCallback<Void>)new OrderedSafeExecutor.OrderedSafeGenericCallback<Void>(this.bk.mainWorkerPool, this.ledgerId){

                @Override
                public void safeOperationComplete(int rc, Void result) {
                    if (rc == 0) {
                        LedgerOpenOp.this.openComplete(0, LedgerOpenOp.this.lh);
                    } else if (rc == -102) {
                        LedgerOpenOp.this.openComplete(-102, null);
                    } else {
                        LedgerOpenOp.this.openComplete(LedgerOpenOp.this.bk.getReturnRc(-10), null);
                    }
                }

                public String toString() {
                    return String.format("Recover(%d)", LedgerOpenOp.this.ledgerId);
                }
            });
        } else {
            this.lh.asyncReadLastConfirmed(new AsyncCallback.ReadLastConfirmedCallback(){

                @Override
                public void readLastConfirmedComplete(int rc, long lastConfirmed, Object ctx) {
                    if (rc != 0) {
                        LedgerOpenOp.this.openComplete(LedgerOpenOp.this.bk.getReturnRc(-1), null);
                    } else {
                        LedgerOpenOp.this.lh.lastAddConfirmed = LedgerOpenOp.this.lh.lastAddPushed = lastConfirmed;
                        LedgerOpenOp.this.openComplete(0, LedgerOpenOp.this.lh);
                    }
                }
            }, null);
        }
    }

    void openComplete(int rc, LedgerHandle lh) {
        if (0 != rc) {
            this.openOpLogger.registerFailedEvent(MathUtils.elapsedNanos(this.startTime), TimeUnit.NANOSECONDS);
        } else {
            this.openOpLogger.registerSuccessfulEvent(MathUtils.elapsedNanos(this.startTime), TimeUnit.NANOSECONDS);
        }
        this.cb.openComplete(rc, lh, this.ctx);
    }
}

