/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.List;

public final class TypeUtil {
    private static final Function<Type, Type> GET_TYPE = new Function<Type, Type>(){

        public Type apply(Type type) {
            if (type instanceof WildcardType) {
                return this.apply(((WildcardType)type).getUpperBounds()[0]);
            }
            return type;
        }
    };

    private TypeUtil() {
    }

    public static List<Type> getTypeParams(Type type) {
        if (type instanceof WildcardType) {
            return TypeUtil.getTypeParams((Type)GET_TYPE.apply((Object)type));
        }
        return Lists.transform(Arrays.asList(((ParameterizedType)type).getActualTypeArguments()), GET_TYPE);
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof ParameterizedType) {
            return TypeUtil.getRawType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            return TypeUtil.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        return (Class)type;
    }

    public static TypeToken<?> getTypeParamTypeToken(Field field) {
        List<Type> typeParams = TypeUtil.getTypeParams(field.getGenericType());
        Preconditions.checkArgument((typeParams.size() == 1 ? 1 : 0) != 0, (Object)("Expected exactly one type parameter for field " + field));
        return TypeToken.of((Type)typeParams.get(0));
    }

    public static Type getTypeParam(Field field) {
        return TypeUtil.extractTypeToken(field.getGenericType());
    }

    public static Type extractTypeToken(Type type) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkArgument((boolean)(type instanceof ParameterizedType), (Object)"Missing type parameter.");
        Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
        Preconditions.checkArgument((typeArguments.length == 1 ? 1 : 0) != 0, (Object)"Expected a type with exactly 1 type argument");
        return typeArguments[0];
    }
}

