/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConstructorWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.FieldWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.MethodWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.NestedClassWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.PackageUseWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.SubWriterHolderWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.ContentBuilder;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.StringContent;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.ClassTree;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.ClassUseMapper;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPath;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocPaths;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletAbortException;

public class ClassUseWriter
extends SubWriterHolderWriter {
    final TypeElement typeElement;
    Set<PackageElement> pkgToPackageAnnotations = null;
    final Map<PackageElement, List<Element>> pkgToClassTypeParameter;
    final Map<PackageElement, List<Element>> pkgToClassAnnotations;
    final Map<PackageElement, List<Element>> pkgToMethodTypeParameter;
    final Map<PackageElement, List<Element>> pkgToMethodArgTypeParameter;
    final Map<PackageElement, List<Element>> pkgToMethodReturnTypeParameter;
    final Map<PackageElement, List<Element>> pkgToMethodAnnotations;
    final Map<PackageElement, List<Element>> pkgToMethodParameterAnnotations;
    final Map<PackageElement, List<Element>> pkgToFieldTypeParameter;
    final Map<PackageElement, List<Element>> pkgToFieldAnnotations;
    final Map<PackageElement, List<Element>> pkgToSubclass;
    final Map<PackageElement, List<Element>> pkgToSubinterface;
    final Map<PackageElement, List<Element>> pkgToImplementingClass;
    final Map<PackageElement, List<Element>> pkgToField;
    final Map<PackageElement, List<Element>> pkgToMethodReturn;
    final Map<PackageElement, List<Element>> pkgToMethodArgs;
    final Map<PackageElement, List<Element>> pkgToMethodThrows;
    final Map<PackageElement, List<Element>> pkgToConstructorAnnotations;
    final Map<PackageElement, List<Element>> pkgToConstructorParameterAnnotations;
    final Map<PackageElement, List<Element>> pkgToConstructorArgs;
    final Map<PackageElement, List<Element>> pkgToConstructorArgTypeParameter;
    final Map<PackageElement, List<Element>> pkgToConstructorThrows;
    final SortedSet<PackageElement> pkgSet;
    final MethodWriterImpl methodSubWriter;
    final ConstructorWriterImpl constrSubWriter;
    final FieldWriterImpl fieldSubWriter;
    final NestedClassWriterImpl classSubWriter;
    final String classUseTableSummary;
    final String subclassUseTableSummary;
    final String subinterfaceUseTableSummary;
    final String fieldUseTableSummary;
    final String methodUseTableSummary;
    final String constructorUseTableSummary;
    protected HtmlTree mainTree = HtmlTree.MAIN();

    public ClassUseWriter(ConfigurationImpl configuration, ClassUseMapper mapper, DocPath filename, TypeElement typeElement) throws IOException {
        super(configuration, filename);
        this.typeElement = typeElement;
        if (mapper.classToPackageAnnotations.containsKey(typeElement)) {
            this.pkgToPackageAnnotations = new TreeSet<Element>(this.utils.makeClassUseComparator());
            this.pkgToPackageAnnotations.addAll((Collection<PackageElement>)mapper.classToPackageAnnotations.get(typeElement));
        }
        configuration.currentTypeElement = typeElement;
        this.pkgSet = new TreeSet<Element>(this.utils.makePackageComparator());
        this.pkgToClassTypeParameter = this.pkgDivide(mapper.classToClassTypeParam);
        this.pkgToClassAnnotations = this.pkgDivide(mapper.classToClassAnnotations);
        this.pkgToMethodTypeParameter = this.pkgDivide(mapper.classToMethodTypeParam);
        this.pkgToMethodArgTypeParameter = this.pkgDivide(mapper.classToMethodArgTypeParam);
        this.pkgToFieldTypeParameter = this.pkgDivide(mapper.classToFieldTypeParam);
        this.pkgToFieldAnnotations = this.pkgDivide(mapper.annotationToField);
        this.pkgToMethodReturnTypeParameter = this.pkgDivide(mapper.classToMethodReturnTypeParam);
        this.pkgToMethodAnnotations = this.pkgDivide(mapper.classToMethodAnnotations);
        this.pkgToMethodParameterAnnotations = this.pkgDivide(mapper.classToMethodParamAnnotation);
        this.pkgToSubclass = this.pkgDivide(mapper.classToSubclass);
        this.pkgToSubinterface = this.pkgDivide(mapper.classToSubinterface);
        this.pkgToImplementingClass = this.pkgDivide(mapper.classToImplementingClass);
        this.pkgToField = this.pkgDivide(mapper.classToField);
        this.pkgToMethodReturn = this.pkgDivide(mapper.classToMethodReturn);
        this.pkgToMethodArgs = this.pkgDivide(mapper.classToMethodArgs);
        this.pkgToMethodThrows = this.pkgDivide(mapper.classToMethodThrows);
        this.pkgToConstructorAnnotations = this.pkgDivide(mapper.classToConstructorAnnotations);
        this.pkgToConstructorParameterAnnotations = this.pkgDivide(mapper.classToConstructorParamAnnotation);
        this.pkgToConstructorArgs = this.pkgDivide(mapper.classToConstructorArgs);
        this.pkgToConstructorArgTypeParameter = this.pkgDivide(mapper.classToConstructorArgTypeParam);
        this.pkgToConstructorThrows = this.pkgDivide(mapper.classToConstructorThrows);
        if (this.pkgSet.size() > 0 && mapper.classToPackage.containsKey(this.typeElement) && !this.pkgSet.equals(mapper.classToPackage.get(this.typeElement))) {
            configuration.reporter.print(Diagnostic.Kind.WARNING, "Internal error: package sets don't match: " + this.pkgSet + " with: " + mapper.classToPackage.get(this.typeElement));
        }
        this.methodSubWriter = new MethodWriterImpl(this);
        this.constrSubWriter = new ConstructorWriterImpl(this);
        this.fieldSubWriter = new FieldWriterImpl(this);
        this.classSubWriter = new NestedClassWriterImpl(this);
        this.classUseTableSummary = configuration.getText("doclet.Use_Table_Summary", configuration.getText("doclet.classes"));
        this.subclassUseTableSummary = configuration.getText("doclet.Use_Table_Summary", configuration.getText("doclet.subclasses"));
        this.subinterfaceUseTableSummary = configuration.getText("doclet.Use_Table_Summary", configuration.getText("doclet.subinterfaces"));
        this.fieldUseTableSummary = configuration.getText("doclet.Use_Table_Summary", configuration.getText("doclet.fields"));
        this.methodUseTableSummary = configuration.getText("doclet.Use_Table_Summary", configuration.getText("doclet.methods"));
        this.constructorUseTableSummary = configuration.getText("doclet.Use_Table_Summary", configuration.getText("doclet.constructors"));
    }

    public static void generate(ConfigurationImpl configuration, ClassTree classtree) {
        ClassUseMapper mapper = new ClassUseMapper(configuration, classtree);
        for (TypeElement aClass : configuration.root.getIncludedClasses()) {
            if (configuration.nodeprecated && configuration.utils.isDeprecated(configuration.utils.containingPackage(aClass))) continue;
            ClassUseWriter.generate(configuration, mapper, aClass);
        }
        for (PackageElement pkg : configuration.packages) {
            if (configuration.nodeprecated && configuration.utils.isDeprecated(pkg)) continue;
            PackageUseWriter.generate(configuration, mapper, pkg);
        }
    }

    private Map<PackageElement, List<Element>> pkgDivide(Map<TypeElement, ? extends List<? extends Element>> classMap) {
        HashMap<PackageElement, List<Element>> map = new HashMap<PackageElement, List<Element>>();
        List<? extends Element> elements = classMap.get(this.typeElement);
        if (elements != null) {
            Collections.sort(elements, this.utils.makeClassUseComparator());
            for (Element element : elements) {
                PackageElement pkg = this.utils.containingPackage(element);
                this.pkgSet.add(pkg);
                ArrayList<Element> inPkg = (ArrayList<Element>)map.get(pkg);
                if (inPkg == null) {
                    inPkg = new ArrayList<Element>();
                    map.put(pkg, inPkg);
                }
                inPkg.add(element);
            }
        }
        return map;
    }

    public static void generate(ConfigurationImpl configuration, ClassUseMapper mapper, TypeElement typeElement) {
        DocPath path = DocPath.forPackage(configuration.utils, typeElement).resolve(DocPaths.CLASS_USE).resolve(DocPath.forName(configuration.utils, typeElement));
        try {
            ClassUseWriter clsgen = new ClassUseWriter(configuration, mapper, path, typeElement);
            clsgen.generateClassUseFile();
            clsgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), path.getPath());
            throw new DocletAbortException(exc);
        }
    }

    protected void generateClassUseFile() throws IOException {
        HtmlTree body = this.getClassUseHeader();
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.classUseContainer);
        if (this.pkgSet.size() > 0) {
            this.addClassUse(div);
        } else {
            div.addContent(this.getResource("doclet.ClassUse_No.usage.of.0", this.utils.getFullyQualifiedName(this.typeElement)));
        }
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            this.mainTree.addContent(div);
            body.addContent(this.mainTree);
        } else {
            body.addContent(div);
        }
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.FOOTER) ? HtmlTree.FOOTER() : body;
        this.addNavLinks(false, htmlTree);
        this.addBottom(htmlTree);
        if (this.configuration.allowTag(HtmlTag.FOOTER)) {
            body.addContent(htmlTree);
        }
        this.printHtmlDocument(null, true, body);
    }

    protected void addClassUse(Content contentTree) throws IOException {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        if (this.configuration.packages.size() > 1) {
            this.addPackageList(ul);
            this.addPackageAnnotationList(ul);
        }
        this.addClassList(ul);
        contentTree.addContent(ul);
    }

    protected void addPackageList(Content contentTree) throws IOException {
        Content caption = this.getTableCaption(this.configuration.getResource("doclet.ClassUse_Packages.that.use.0", this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_USE_HEADER, this.typeElement))));
        HtmlTree table = this.configuration.isOutputHtml5() ? HtmlTree.TABLE(HtmlStyle.useSummary, caption) : HtmlTree.TABLE(HtmlStyle.useSummary, this.useTableSummary, caption);
        ((Content)table).addContent(this.getSummaryTableHeader(this.packageTableHeader, "col"));
        HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
        boolean altColor = true;
        for (PackageElement pkg : this.pkgSet) {
            HtmlTree tr = new HtmlTree(HtmlTag.TR);
            tr.addStyle(altColor ? HtmlStyle.altColor : HtmlStyle.rowColor);
            altColor = !altColor;
            this.addPackageUse(pkg, tr);
            ((Content)tbody).addContent(tr);
        }
        ((Content)table).addContent(tbody);
        HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, table);
        contentTree.addContent(li);
    }

    protected void addPackageAnnotationList(Content contentTree) throws IOException {
        if (!this.utils.isAnnotationType(this.typeElement) || this.pkgToPackageAnnotations == null || this.pkgToPackageAnnotations.isEmpty()) {
            return;
        }
        Content caption = this.getTableCaption(this.configuration.getResource("doclet.ClassUse_PackageAnnotation", this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_USE_HEADER, this.typeElement))));
        HtmlTree table = this.configuration.isOutputHtml5() ? HtmlTree.TABLE(HtmlStyle.useSummary, caption) : HtmlTree.TABLE(HtmlStyle.useSummary, this.useTableSummary, caption);
        ((Content)table).addContent(this.getSummaryTableHeader(this.packageTableHeader, "col"));
        HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
        boolean altColor = true;
        for (PackageElement pkg : this.pkgToPackageAnnotations) {
            HtmlTree tr = new HtmlTree(HtmlTag.TR);
            tr.addStyle(altColor ? HtmlStyle.altColor : HtmlStyle.rowColor);
            altColor = !altColor;
            HtmlTree tdFirst = HtmlTree.TD(HtmlStyle.colFirst, this.getPackageLink(pkg));
            tr.addContent(tdFirst);
            HtmlTree tdLast = new HtmlTree(HtmlTag.TD);
            tdLast.addStyle(HtmlStyle.colLast);
            this.addSummaryComment(pkg, tdLast);
            tr.addContent(tdLast);
            ((Content)tbody).addContent(tr);
        }
        ((Content)table).addContent(tbody);
        HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, table);
        contentTree.addContent(li);
    }

    protected void addClassList(Content contentTree) throws IOException {
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        for (PackageElement pkg : this.pkgSet) {
            Content markerAnchor = this.getMarkerAnchor(this.getPackageAnchorName(pkg));
            HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.SECTION) ? HtmlTree.SECTION(markerAnchor) : HtmlTree.LI(HtmlStyle.blockList, markerAnchor);
            Content link = this.getResource("doclet.ClassUse_Uses.of.0.in.1", this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_USE_HEADER, this.typeElement)), this.getPackageLink(pkg, this.utils.getPackageName(pkg)));
            HtmlTree heading = HtmlTree.HEADING(HtmlConstants.SUMMARY_HEADING, link);
            htmlTree.addContent(heading);
            this.addClassUse(pkg, htmlTree);
            if (this.configuration.allowTag(HtmlTag.SECTION)) {
                ul.addContent(HtmlTree.LI(HtmlStyle.blockList, htmlTree));
                continue;
            }
            ul.addContent(htmlTree);
        }
        HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, ul);
        contentTree.addContent(li);
    }

    protected void addPackageUse(PackageElement pkg, Content contentTree) throws IOException {
        HtmlTree tdFirst = HtmlTree.TD(HtmlStyle.colFirst, this.getHyperLink(this.getPackageAnchorName(pkg), (Content)new StringContent(this.utils.getPackageName(pkg))));
        contentTree.addContent(tdFirst);
        HtmlTree tdLast = new HtmlTree(HtmlTag.TD);
        tdLast.addStyle(HtmlStyle.colLast);
        this.addSummaryComment(pkg, tdLast);
        contentTree.addContent(tdLast);
    }

    protected void addClassUse(PackageElement pkg, Content contentTree) throws IOException {
        Content classLink = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_USE_HEADER, this.typeElement));
        Content pkgLink = this.getPackageLink(pkg, this.utils.getPackageName(pkg));
        this.classSubWriter.addUseInfo(this.pkgToClassAnnotations.get(pkg), this.configuration.getResource("doclet.ClassUse_Annotation", classLink, pkgLink), this.classUseTableSummary, contentTree);
        this.classSubWriter.addUseInfo(this.pkgToClassTypeParameter.get(pkg), this.configuration.getResource("doclet.ClassUse_TypeParameter", classLink, pkgLink), this.classUseTableSummary, contentTree);
        this.classSubWriter.addUseInfo(this.pkgToSubclass.get(pkg), this.configuration.getResource("doclet.ClassUse_Subclass", classLink, pkgLink), this.subclassUseTableSummary, contentTree);
        this.classSubWriter.addUseInfo(this.pkgToSubinterface.get(pkg), this.configuration.getResource("doclet.ClassUse_Subinterface", classLink, pkgLink), this.subinterfaceUseTableSummary, contentTree);
        this.classSubWriter.addUseInfo(this.pkgToImplementingClass.get(pkg), this.configuration.getResource("doclet.ClassUse_ImplementingClass", classLink, pkgLink), this.classUseTableSummary, contentTree);
        this.fieldSubWriter.addUseInfo(this.pkgToField.get(pkg), this.configuration.getResource("doclet.ClassUse_Field", classLink, pkgLink), this.fieldUseTableSummary, contentTree);
        this.fieldSubWriter.addUseInfo(this.pkgToFieldAnnotations.get(pkg), this.configuration.getResource("doclet.ClassUse_FieldAnnotations", classLink, pkgLink), this.fieldUseTableSummary, contentTree);
        this.fieldSubWriter.addUseInfo(this.pkgToFieldTypeParameter.get(pkg), this.configuration.getResource("doclet.ClassUse_FieldTypeParameter", classLink, pkgLink), this.fieldUseTableSummary, contentTree);
        this.methodSubWriter.addUseInfo(this.pkgToMethodAnnotations.get(pkg), this.configuration.getResource("doclet.ClassUse_MethodAnnotations", classLink, pkgLink), this.methodUseTableSummary, contentTree);
        this.methodSubWriter.addUseInfo(this.pkgToMethodParameterAnnotations.get(pkg), this.configuration.getResource("doclet.ClassUse_MethodParameterAnnotations", classLink, pkgLink), this.methodUseTableSummary, contentTree);
        this.methodSubWriter.addUseInfo(this.pkgToMethodTypeParameter.get(pkg), this.configuration.getResource("doclet.ClassUse_MethodTypeParameter", classLink, pkgLink), this.methodUseTableSummary, contentTree);
        this.methodSubWriter.addUseInfo(this.pkgToMethodReturn.get(pkg), this.configuration.getResource("doclet.ClassUse_MethodReturn", classLink, pkgLink), this.methodUseTableSummary, contentTree);
        this.methodSubWriter.addUseInfo(this.pkgToMethodReturnTypeParameter.get(pkg), this.configuration.getResource("doclet.ClassUse_MethodReturnTypeParameter", classLink, pkgLink), this.methodUseTableSummary, contentTree);
        this.methodSubWriter.addUseInfo(this.pkgToMethodArgs.get(pkg), this.configuration.getResource("doclet.ClassUse_MethodArgs", classLink, pkgLink), this.methodUseTableSummary, contentTree);
        this.methodSubWriter.addUseInfo(this.pkgToMethodArgTypeParameter.get(pkg), this.configuration.getResource("doclet.ClassUse_MethodArgsTypeParameters", classLink, pkgLink), this.methodUseTableSummary, contentTree);
        this.methodSubWriter.addUseInfo(this.pkgToMethodThrows.get(pkg), this.configuration.getResource("doclet.ClassUse_MethodThrows", classLink, pkgLink), this.methodUseTableSummary, contentTree);
        this.constrSubWriter.addUseInfo(this.pkgToConstructorAnnotations.get(pkg), this.configuration.getResource("doclet.ClassUse_ConstructorAnnotations", classLink, pkgLink), this.constructorUseTableSummary, contentTree);
        this.constrSubWriter.addUseInfo(this.pkgToConstructorParameterAnnotations.get(pkg), this.configuration.getResource("doclet.ClassUse_ConstructorParameterAnnotations", classLink, pkgLink), this.constructorUseTableSummary, contentTree);
        this.constrSubWriter.addUseInfo(this.pkgToConstructorArgs.get(pkg), this.configuration.getResource("doclet.ClassUse_ConstructorArgs", classLink, pkgLink), this.constructorUseTableSummary, contentTree);
        this.constrSubWriter.addUseInfo(this.pkgToConstructorArgTypeParameter.get(pkg), this.configuration.getResource("doclet.ClassUse_ConstructorArgsTypeParameters", classLink, pkgLink), this.constructorUseTableSummary, contentTree);
        this.constrSubWriter.addUseInfo(this.pkgToConstructorThrows.get(pkg), this.configuration.getResource("doclet.ClassUse_ConstructorThrows", classLink, pkgLink), this.constructorUseTableSummary, contentTree);
    }

    protected HtmlTree getClassUseHeader() {
        String cltype = this.configuration.getText(this.utils.isInterface(this.typeElement) ? "doclet.Interface" : "doclet.Class");
        String clname = this.utils.getFullyQualifiedName(this.typeElement);
        String title = this.configuration.getText("doclet.Window_ClassUse_Header", cltype, clname);
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(title));
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.HEADER) ? HtmlTree.HEADER() : bodyTree;
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        if (this.configuration.allowTag(HtmlTag.HEADER)) {
            bodyTree.addContent(htmlTree);
        }
        ContentBuilder headContent = new ContentBuilder();
        headContent.addContent(this.getResource("doclet.ClassUse_Title", cltype));
        headContent.addContent(new HtmlTree(HtmlTag.BR));
        headContent.addContent(clname);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.CLASS_PAGE_HEADING, true, HtmlStyle.title, headContent);
        HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            this.mainTree.addContent(div);
        } else {
            bodyTree.addContent(div);
        }
        return bodyTree;
    }

    @Override
    protected Content getNavLinkPackage() {
        Content linkContent = this.getHyperLink(DocPath.parent.resolve(DocPaths.PACKAGE_SUMMARY), this.packageLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    @Override
    protected Content getNavLinkClass() {
        Content linkContent = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_USE_HEADER, this.typeElement).label(this.configuration.getText("doclet.Class")));
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    @Override
    protected Content getNavLinkClassUse() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.useLabel);
        return li;
    }

    @Override
    protected Content getNavLinkTree() {
        Content linkContent = this.utils.isEnclosingPackageIncluded(this.typeElement) ? this.getHyperLink(DocPath.parent.resolve(DocPaths.PACKAGE_TREE), this.treeLabel) : this.getHyperLink(this.pathToRoot.resolve(DocPaths.OVERVIEW_TREE), this.treeLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }
}

