/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.metadata.bootstrap.SynonymEntity;
import org.apache.asterix.metadata.entities.Synonym;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public final class SynonymTupleTranslator
extends AbstractTupleTranslator<Synonym> {
    private final SynonymEntity synonymEntity;

    protected SynonymTupleTranslator(boolean getTuple, SynonymEntity synonymEntity) {
        super(getTuple, synonymEntity.getIndex(), synonymEntity.payloadPosition());
        this.synonymEntity = synonymEntity;
    }

    @Override
    protected Synonym createMetadataEntityFromARecord(ARecord synonymRecord) throws AlgebricksException {
        String dataverseCanonicalName = ((AString)synonymRecord.getValueByPos(this.synonymEntity.dataverseNameIndex())).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        int databaseNameIndex = this.synonymEntity.databaseNameIndex();
        String databaseName = databaseNameIndex >= 0 ? ((AString)synonymRecord.getValueByPos(databaseNameIndex)).getStringValue() : MetadataUtil.databaseFor((DataverseName)dataverseName);
        String synonymName = ((AString)synonymRecord.getValueByPos(this.synonymEntity.synonymNameIndex())).getStringValue();
        String objectDataverseCanonicalName = ((AString)synonymRecord.getValueByPos(this.synonymEntity.objectDataverseNameIndex())).getStringValue();
        DataverseName objectDataverseName = DataverseName.createFromCanonicalForm((String)objectDataverseCanonicalName);
        int objectDatabaseIdx = synonymRecord.getType().getFieldIndex("ObjectDatabaseName");
        String objectDatabaseName = objectDatabaseIdx >= 0 ? ((AString)synonymRecord.getValueByPos(objectDatabaseIdx)).getStringValue() : MetadataUtil.databaseFor((DataverseName)objectDataverseName);
        String objectName = ((AString)synonymRecord.getValueByPos(this.synonymEntity.objectNameIndex())).getStringValue();
        return new Synonym(databaseName, dataverseName, synonymName, objectDatabaseName, objectDataverseName, objectName);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(Synonym synonym) throws HyracksDataException {
        String dataverseCanonicalName = synonym.getDataverseName().getCanonicalForm();
        this.tupleBuilder.reset();
        if (this.synonymEntity.databaseNameIndex() >= 0) {
            this.aString.setValue(synonym.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
            this.tupleBuilder.addFieldEndOffset();
        }
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(synonym.getSynonymName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(this.synonymEntity.getRecordType());
        if (this.synonymEntity.databaseNameIndex() >= 0) {
            this.fieldValue.reset();
            this.aString.setValue(synonym.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField(this.synonymEntity.databaseNameIndex(), (IValueReference)this.fieldValue);
        }
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.synonymEntity.dataverseNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(synonym.getSynonymName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.synonymEntity.synonymNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(synonym.getObjectDataverseName().getCanonicalForm());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.synonymEntity.objectDataverseNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(synonym.getObjectName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.synonymEntity.objectNameIndex(), (IValueReference)this.fieldValue);
        this.writeOpenFields(synonym);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    private void writeOpenFields(Synonym synonym) throws HyracksDataException {
        if (this.synonymEntity.databaseNameIndex() >= 0) {
            this.fieldName.reset();
            this.aString.setValue("ObjectDatabaseName");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            this.fieldValue.reset();
            this.aString.setValue(synonym.getObjectDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
        }
    }
}

