/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.impls;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.List;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.IBTreeInteriorFrame;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeSplitKey;
import org.apache.hyracks.storage.am.common.api.ISplitKey;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.impls.AbstractTreeIndexBulkLoader;
import org.apache.hyracks.storage.am.common.impls.NodeFrontier;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;
import org.apache.hyracks.util.JSONUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BTreeNSMBulkLoader
extends AbstractTreeIndexBulkLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final ISplitKey splitKey;
    protected final boolean verifyInput;
    private final int maxTupleSize;

    public BTreeNSMBulkLoader(float fillFactor, boolean verifyInput, IPageWriteCallback callback, ITreeIndex index) throws HyracksDataException {
        this(fillFactor, verifyInput, callback, index, index.getLeafFrameFactory().createFrame());
    }

    protected BTreeNSMBulkLoader(float fillFactor, boolean verifyInput, IPageWriteCallback callback, ITreeIndex index, ITreeIndexFrame leafFrame) throws HyracksDataException {
        super(fillFactor, callback, index, leafFrame);
        this.verifyInput = verifyInput;
        this.splitKey = new BTreeSplitKey(this.tupleWriter.createTupleReference());
        this.splitKey.getTuple().setFieldCount(this.cmp.getKeyFieldCount());
        this.maxTupleSize = ((BTree)index).maxTupleSize;
    }

    public void add(ITupleReference tuple) throws HyracksDataException {
        try {
            int tupleSize = Math.max(this.leafFrame.getBytesRequiredToWriteTuple(tuple), this.interiorFrame.getBytesRequiredToWriteTuple(tuple));
            NodeFrontier leafFrontier = (NodeFrontier)this.nodeFrontiers.get(0);
            int spaceNeeded = this.tupleWriter.bytesRequired(tuple) + this.slotSize;
            int spaceUsed = this.leafFrame.getBuffer().capacity() - this.leafFrame.getTotalFreeSpace();
            if (spaceUsed + spaceNeeded > this.leafMaxBytes) {
                this.leafFrame.compress();
                spaceUsed = this.leafFrame.getBuffer().capacity() - this.leafFrame.getTotalFreeSpace();
            }
            if (spaceUsed + spaceNeeded > this.leafMaxBytes) {
                if (this.leafFrame.getTupleCount() == 0) {
                    this.bufferCache.returnPage(leafFrontier.page, false);
                } else {
                    leafFrontier.lastTuple.resetByTupleIndex(this.leafFrame, this.leafFrame.getTupleCount() - 1);
                    if (this.verifyInput) {
                        this.verifyInputTuple(tuple, (ITupleReference)leafFrontier.lastTuple);
                    }
                    this.writeFullLeafPage();
                }
                if (tupleSize > this.maxTupleSize) {
                    long dpid = BufferedFileHandle.getDiskPageId((int)this.fileId, (int)leafFrontier.pageId);
                    int headerSize = Math.max(this.leafFrame.getPageHeaderSize(), this.interiorFrame.getPageHeaderSize());
                    int multiplier = (int)Math.ceil((double)tupleSize / (double)(this.bufferCache.getPageSize() - headerSize));
                    leafFrontier.page = multiplier > 1 ? this.bufferCache.confiscateLargePage(dpid, multiplier, this.freePageManager.takeBlock(this.metaFrame, multiplier - 1)) : this.bufferCache.confiscatePage(dpid);
                    this.leafFrame.setPage(leafFrontier.page);
                    this.leafFrame.initBuffer((byte)0);
                    ((IBTreeLeafFrame)this.leafFrame).setLargeFlag(true);
                } else {
                    this.confiscateNewLeafPage();
                }
            } else if (this.verifyInput && this.leafFrame.getTupleCount() > 0) {
                leafFrontier.lastTuple.resetByTupleIndex(this.leafFrame, this.leafFrame.getTupleCount() - 1);
                this.verifyInputTuple(tuple, (ITupleReference)leafFrontier.lastTuple);
            }
            ((IBTreeLeafFrame)this.leafFrame).insertSorted(tuple);
        }
        catch (RuntimeException | HyracksDataException e) {
            this.logState(tuple, (Exception)e);
            this.handleException();
            throw e;
        }
    }

    protected void verifyInputTuple(ITupleReference tuple, ITupleReference prevTuple) throws HyracksDataException {
        int cmpResult = this.cmp.compare(tuple, prevTuple);
        if (cmpResult < 0) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.UNSORTED_LOAD_INPUT, (Serializable[])new Serializable[0]);
        }
        if (cmpResult == 0) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.DUPLICATE_LOAD_INPUT, (Serializable[])new Serializable[0]);
        }
    }

    protected void propagateBulk(int level, List<ICachedPage> pagesToWrite) throws HyracksDataException {
        if (this.splitKey.getBuffer() == null) {
            return;
        }
        if (level >= this.nodeFrontiers.size()) {
            this.addLevel();
        }
        NodeFrontier frontier = (NodeFrontier)this.nodeFrontiers.get(level);
        this.interiorFrame.setPage(frontier.page);
        ITreeIndexTupleReference tuple = this.splitKey.getTuple();
        int tupleBytes = this.tupleWriter.bytesRequired((ITupleReference)tuple, 0, this.cmp.getKeyFieldCount());
        int spaceNeeded = tupleBytes + this.slotSize + 4;
        if (tupleBytes > this.interiorFrame.getMaxTupleSize(this.bufferCache.getPageSize())) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.RECORD_IS_TOO_LARGE, (Serializable[])new Serializable[]{Integer.valueOf(tupleBytes), Integer.valueOf(this.interiorFrame.getMaxTupleSize(this.bufferCache.getPageSize()))});
        }
        int spaceUsed = this.interiorFrame.getBuffer().capacity() - this.interiorFrame.getTotalFreeSpace();
        if (spaceUsed + spaceNeeded > this.interiorMaxBytes) {
            ISplitKey copyKey = this.splitKey.duplicate(this.tupleWriter.createTupleReference());
            tuple = copyKey.getTuple();
            frontier.lastTuple.resetByTupleIndex(this.interiorFrame, this.interiorFrame.getTupleCount() - 1);
            int splitKeySize = this.tupleWriter.bytesRequired((ITupleReference)frontier.lastTuple, 0, this.cmp.getKeyFieldCount());
            this.splitKey.initData(splitKeySize);
            this.tupleWriter.writeTupleFields((ITupleReference)frontier.lastTuple, 0, this.cmp.getKeyFieldCount(), this.splitKey.getBuffer().array(), 0);
            this.splitKey.getTuple().resetByTupleOffset(this.splitKey.getBuffer().array(), 0);
            ((IBTreeInteriorFrame)this.interiorFrame).deleteGreatest();
            int finalPageId = this.freePageManager.takePage(this.metaFrame);
            frontier.page.setDiskPageId(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)finalPageId));
            pagesToWrite.add(frontier.page);
            this.splitKey.setLeftPage(finalPageId);
            this.propagateBulk(level + 1, pagesToWrite);
            frontier.page = this.bufferCache.confiscatePage(-1L);
            this.interiorFrame.setPage(frontier.page);
            this.interiorFrame.initBuffer((byte)level);
        }
        ((IBTreeInteriorFrame)this.interiorFrame).insertSorted((ITupleReference)tuple);
    }

    private void persistFrontiers(int level, int rightPage) throws HyracksDataException {
        if (level >= this.nodeFrontiers.size()) {
            this.setRootPageId(((NodeFrontier)this.nodeFrontiers.get((int)(level - 1))).pageId);
            this.releasedLatches = true;
            return;
        }
        if (level < 1) {
            ICachedPage lastLeaf = ((NodeFrontier)this.nodeFrontiers.get((int)level)).page;
            int lastLeafPage = ((NodeFrontier)this.nodeFrontiers.get((int)level)).pageId;
            lastLeaf.setDiskPageId(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)((NodeFrontier)this.nodeFrontiers.get((int)level)).pageId));
            this.writeLastLeaf(lastLeaf);
            ((NodeFrontier)this.nodeFrontiers.get((int)level)).page = null;
            this.persistFrontiers(level + 1, lastLeafPage);
            return;
        }
        NodeFrontier frontier = (NodeFrontier)this.nodeFrontiers.get(level);
        this.interiorFrame.setPage(frontier.page);
        if (rightPage < 0) {
            throw new HyracksDataException("Error in index creation. Internal node appears to have no rightmost guide");
        }
        ((IBTreeInteriorFrame)this.interiorFrame).setRightmostChildPageId(rightPage);
        int finalPageId = this.freePageManager.takePage(this.metaFrame);
        frontier.page.setDiskPageId(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)finalPageId));
        this.write(frontier.page);
        frontier.pageId = finalPageId;
        this.persistFrontiers(level + 1, finalPageId);
    }

    public void end() throws HyracksDataException {
        try {
            this.persistFrontiers(0, -1);
            super.end();
        }
        catch (RuntimeException | HyracksDataException e) {
            this.handleException();
            throw e;
        }
    }

    public void abort() throws HyracksDataException {
        super.handleException();
    }

    protected void writeFullLeafPage() throws HyracksDataException {
        NodeFrontier leafFrontier = (NodeFrontier)this.nodeFrontiers.get(0);
        leafFrontier.lastTuple.resetByTupleIndex(this.leafFrame, this.leafFrame.getTupleCount() - 1);
        int splitKeySize = this.tupleWriter.bytesRequired((ITupleReference)leafFrontier.lastTuple, 0, this.cmp.getKeyFieldCount());
        this.splitKey.initData(splitKeySize);
        this.tupleWriter.writeTupleFields((ITupleReference)leafFrontier.lastTuple, 0, this.cmp.getKeyFieldCount(), this.splitKey.getBuffer().array(), 0);
        this.splitKey.getTuple().resetByTupleOffset(this.splitKey.getBuffer().array(), 0);
        this.splitKey.setLeftPage(leafFrontier.pageId);
        this.propagateBulk(1, this.pagesToWrite);
        leafFrontier.pageId = this.freePageManager.takePage(this.metaFrame);
        ((IBTreeLeafFrame)this.leafFrame).setNextLeaf(leafFrontier.pageId);
        this.write(leafFrontier.page);
        for (ICachedPage c : this.pagesToWrite) {
            this.write(c);
        }
        this.pagesToWrite.clear();
        this.splitKey.setRightPage(leafFrontier.pageId);
    }

    protected void writeLastLeaf(ICachedPage page) throws HyracksDataException {
        this.write(page);
    }

    protected final void confiscateNewLeafPage() throws HyracksDataException {
        NodeFrontier leafFrontier = (NodeFrontier)this.nodeFrontiers.get(0);
        long dpid = BufferedFileHandle.getDiskPageId((int)this.fileId, (int)leafFrontier.pageId);
        leafFrontier.page = this.bufferCache.confiscatePage(dpid);
        this.leafFrame.setPage(leafFrontier.page);
        this.leafFrame.initBuffer((byte)0);
    }

    private void logState(ITupleReference tuple, Exception e) {
        try {
            ObjectNode state = JSONUtil.createObject();
            state.set("leafFrame", (JsonNode)this.leafFrame.getState());
            state.set("interiorFrame", (JsonNode)this.interiorFrame.getState());
            int tupleSize = Math.max(this.leafFrame.getBytesRequiredToWriteTuple(tuple), this.interiorFrame.getBytesRequiredToWriteTuple(tuple));
            state.put("tupleSize", tupleSize);
            state.put("spaceNeeded", this.tupleWriter.bytesRequired(tuple) + this.slotSize);
            state.put("spaceUsed", this.leafFrame.getBuffer().capacity() - this.leafFrame.getTotalFreeSpace());
            state.put("leafMaxBytes", this.leafMaxBytes);
            state.put("maxTupleSize", this.maxTupleSize);
            LOGGER.error("failed to add tuple {}", (Object)state, (Object)e);
        }
        catch (Throwable t) {
            e.addSuppressed(t);
        }
    }
}

