/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.credential;

import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;
import java.util.function.Function;

public final class AzureSasCredential {
    private final ClientLogger logger = new ClientLogger(AzureSasCredential.class);
    private final Function<String, String> signatureEncoder;
    private volatile String signature;

    public AzureSasCredential(String signature) {
        this(signature, null);
    }

    public AzureSasCredential(String signature, Function<String, String> signatureEncoder) {
        Objects.requireNonNull(signature, "'signature' cannot be null.");
        if (signature.isEmpty()) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("'signature' cannot be empty."));
        }
        this.signatureEncoder = signatureEncoder;
        this.signature = signatureEncoder == null ? signature : signatureEncoder.apply(signature);
    }

    public String getSignature() {
        return this.signature;
    }

    public AzureSasCredential update(String signature) {
        Objects.requireNonNull(signature, "'signature' cannot be null.");
        if (signature.isEmpty()) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("'signature' cannot be empty."));
        }
        this.signature = this.signatureEncoder == null ? signature : this.signatureEncoder.apply(signature);
        return this;
    }
}

