/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.ServerBootstrap;
import java.util.Objects;
import java.util.function.Consumer;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.tcp.TcpServer;
import reactor.netty.tcp.TcpServerOperator;

final class TcpServerDoOnConnection
extends TcpServerOperator
implements ConnectionObserver {
    final Consumer<? super Connection> onConnection;

    TcpServerDoOnConnection(TcpServer server, Consumer<? super Connection> onConnection) {
        super(server);
        this.onConnection = Objects.requireNonNull(onConnection, "onConnection");
    }

    @Override
    public void onStateChange(Connection connection, ConnectionObserver.State newState) {
        if (newState == ConnectionObserver.State.CONFIGURED) {
            try {
                this.onConnection.accept(connection);
            }
            catch (Throwable t) {
                log.error(ReactorNetty.format(connection.channel(), ""), t);
                connection.channel().close();
            }
        }
    }

    @Override
    public ServerBootstrap configure() {
        ServerBootstrap b = this.source.configure();
        ConnectionObserver observer = BootstrapHandlers.childConnectionObserver(b);
        BootstrapHandlers.childConnectionObserver(b, observer.then(this));
        return b;
    }
}

