/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

Em.I18n.translations = {

  'app.name':'Ambari',
  'app.name.subtitle':'Ambari - {0}',
  'app.name.subtitle.experimental':'Ambari Experimental',
  'app.name.subtitle.installer':'Cluster Install Wizard',
  'app.reloadPopup.link': 'Reload Page',
  'app.reloadPopup.text': 'Trying to connect to server...',
  'app.reloadPopup.noClusterName.text': 'Failed to retrieve cluster name, trying to reload...',
  'app.reloadPopup.header': 'Reload Page',
  'app.redirectIssuePopup.header': 'Login Redirect Issue',
  'app.redirectIssuePopup.body': 'For single sign-on, make sure that Knox Gateway and Ambari Server are located on the same host or subdomain.' +
    '<br/>Alternatively login as an Ambari local user using the local login page.<br />' +
    '<a rel="noopener noreferrer" href="{0}" target="_blank">{0}</a>',

  'app.loadingPlaceholder': 'Loading...',
  'app.versionMismatchAlert.title': 'Ambari Server / Web Client Version Mismatch',
  'app.versionMismatchAlert.body': 'Ambari Server and Web Client versions do not match:<br> ' +
    '<br>Ambari Server: <strong>{0}</strong>' +
    '<br>Ambari Web Client: <strong>{1}</strong><br>' +
    '<br>This typically happens after upgrading Ambari due to Ambari Web Client code cached in the browser.' +
    '<br>Perform a hard browser cache refresh, typically \'Ctrl+Shift+R\' (\'Cmd+Shift+R\' on OS X), to see if this message disappears.' +
    '<br>If you keep seeing this message, clear the browser cache completely and hit this URL again.' +
    '<br>You must resolve this error in order to continue.',
  'app.signout':'Sign out',
  'app.settings':'Settings',
  'app.manageAmbari': 'Manage Ambari',
  'app.aboutAmbari':'About',
  'app.settings.selectTimezone': 'Timezone',
  'app.settings.notshowBgOperationsPopup': 'Do not show the Background Operations dialog when starting an operation',
  'app.settings.notShowBgOperations': 'Do not show this dialog again when starting a background operation',
  'app.settings.categories.general': 'General',
  'app.settings.categories.locale': 'Locale',
  'app.settings.noData': 'Unable to retrieve settings data',
  'app.settings.no.view.privileges': 'No view privileges',
  'app.settings.no.cluster.privileges': 'No cluster privileges',
  'app.settings.admin.all.privileges': 'This user is an Ambari Admin and has all privileges.',
  'app.settings.no.privileges': 'This user does not have any privileges.',
  'app.settings.clusterRole': 'Cluster Role',
  'app.settings.viewPermissions': 'View Permissions',
  'app.goToView': 'Go To View',
  'app.debugHiveQuery': 'Debug Hive Query',

  'app.aboutAmbari.getInvolved': 'Get involved!',
  'app.aboutAmbari.version': 'Version',
  'app.aboutAmbari.licensed': 'Licensed under the Apache License, Version 2.0',

  'apply':'apply',
  'and':'and',
  'none':'none',
  'all':'all',
  'minimum':'minimum',
  'from':'From',
  'to':'To',
  'ok':'OK',
  'as':'as',
  'on':'on',
  'in':'in',
  'any': 'Any',
  'more':'more',
  'yes':'Yes',
  'no':'No',
  'add': 'Add',
  'op': 'op',
  'ops': 'ops',
  'or': 'or',
  'then': 'then',
  'it': 'it',


  'common.access':'Access',
  'common.learnMore':'Learn more',
  'common.showDetails':'Show Details',
  'common.back':'Back',
  'common.prev':'Prev',
  'common.next':'Next',
  'common.host':'Host',
  'common.hosts':'Hosts',
  'common.services':'Services',
  'common.group':'Group',
  'common.groups':'Groups',
  'common.progress':'Progress',
  'common.status':'Status',
  'common.action':'Action',
  'common.refresh':'Refresh',
  'common.remove':'Remove',
  'common.retry':'Retry',
  'common.skip':'Skip',
  'common.filter': 'Filter',
  'common.rollBack':'Rollback',
  'common.show':'Show',
  'common.hide':'Hide',
  'common.cancel':'Cancel',
  'common.apply':'Apply',
  'common.done':'Done',
  'common.failed':'Failed',
  'common.service': 'Service',
  'common.version':'Version',
  'common.downgrade':'Downgrade',
  'common.description':'Description',
  'common.default':'Default',
  'common.client':'Client',
  'common.master':'Master',
  'common.slave':'Slave',
  'common.zookeeper':'ZooKeeper',
  'common.hbase':'HBase',
  'common.regionServer':'RegionServer',
  'common.taskTracker':'TaskTracker',
  'common.dataNode':'DataNode',
  'common.more': 'More...',
  'common.print':'Print',
  'common.deploy':'Deploy',
  'common.generate.blueprint':'Generate Blueprint',
  'common.message':'Message',
  'common.tasks':'Tasks',
  'common.taskLog':'Task Log',
  'common.open':'Open',
  'common.copy':'Copy',
  'common.complete':'Complete',
  'common.completed':'Completed',
  'common.metrics':'Metrics',
  'common.timeRange':'Time Range',
  'common.name':'Name',
  'common.key':'Key',
  'common.value':'Value',
  'common.ipAddress':'IP Address',
  'common.rack':'Rack',
  'common.cpu':'CPU',
  'common.cores': 'Cores',
  'common.cores.cpu': 'Cores (CPU)',
  'common.ram':'RAM',
  'common.disabled':'Disabled',
  'common.enabled':'Enabled',
  'common.enableAll':'Enable All',
  'common.disableAll':'Disable All',
  'common.disk':'Disk',
  'common.diskUsage':'Disk Usage',
  'common.last':'Last',
  'common.loadAvg':'Load Avg',
  'common.components':'Components',
  'common.component':'Component',
  'common.quickLinks':'Quick Links',
  'common.save':'Save',
  'common.saveAnyway':'Save Anyway',
  'common.servers':'Servers',
  'common.clients':'Clients',
  'common.all.clients':'All Clients',
  'common.user': 'User',
  'common.users': 'Users',
  'common.issues': 'Issues',
  'common.os':'OS',
  'common.oss':'OSs',
  'common.memory':'Memory',
  'common.maximum':'Maximum',
  'common.started':'Started',
  'common.start':'Start',
  'common.stop':'Stop',
  'common.pause':'Pause',
  'common.end':'End',
  'common.decommission':'Decommission',
  'common.recommission':'Recommission',
  'common.failure': 'Failure',
  'common.type': 'Type',
  'common.direction': 'Direction',
  'common.close': 'Close',
  'common.warning': 'Warning',
  'common.critical': 'Critical',
  'common.information': 'Information',
  'common.all':'All',
  'common.success': 'Success',
  'common.fail':'Fail',
  'common.error': 'Error',
  'common.loading': 'Loading',
  'common.search': 'Search',
  'common.confirm': 'Confirm',
  'common.upgrade': 'Upgrade',
  'common.reUpgrade': 'Retry Upgrade',
  'common.reDowngrade': 'Retry Downgrade',
  'common.security':'Security',
  'common.kerberos':'Kerberos',
  'common.cluster':'Cluster',
  'common.repositories':'Repositories',
  'common.stack.versions':'Stack Versions',
  'common.versions':'Versions',
  'common.upgrade.history':'Upgrade History',
  'common.serviceAccounts': 'Service Accounts',
  'common.add': 'Add',
  'common.edit': 'Edit',
  'common.delete': 'Delete',
  'common.duplicate': 'Duplicate',
  'common.disable': 'Disable',
  'common.enable': 'Enable',
  'common.empty': 'Empty',
  'common.override':'Override',
  'common.undo':'Undo',
  'common.details':'Details',
  'common.stats':'Stats',
  'common.abort': 'Abort',
  'common.aborted': 'Aborted',
  'common.misc': 'Misc',
  'common.userSettings': 'User Settings',
  'common.aboutAmbari': 'About',
  'common.notAvailable': 'Not Available',
  'common.na': 'n/a',
  'common.operations': 'Operations',
  'common.backgroundOperations': 'Background Operations',
  'common.startTime': 'Start Time',
  'common.duration': 'Duration',
  'common.reinstall': 'Re-Install',
  'common.revert': 'Revert',
  'common.errorPopup.header': 'An error has been encountered',
  'common.use': 'Use',
  'common.stacks': 'Stacks',
  'common.stack': 'Stack',
  'common.reset': 'Reset',
  'common.reset.default': 'Reset to default',
  'common.resume': 'Resume',
  'common.path': 'Path',
  'common.patch': 'Patch',
  'common.maint': 'Maint',
  'common.package': 'Package',
  'common.proceed': 'Proceed',
  'common.proceedAnyway': 'Proceed Anyway',
  'common.exitAnyway': 'Exit Anyway',
  'common.process': 'Process',
  'common.property': 'Property',
  'common.installed': 'Installed',
  'common.persist.error' : 'Error in persisting web client state at ambari server. Server respond with following error message:',
  'common.update.error' : 'Error in retrieving web client state from ambari server',
  'common.tags': 'Tags',
  'common.important': 'Important',
  'common.important.strong': '<strong>Important:</strong>',
  'common.allServices':'All Services',
  'common.move':'Move',
  'common.change': 'Change',
  'common.overrides': 'Overrides',
  'common.properties': 'properties',
  'common.conf.group': 'Configuration Group',
  'common.ignore': 'Ignore',
  'common.restart': 'Restart',
  'common.discard': 'Discard',
  'common.actions': 'Actions',
  'common.maintenance': 'Maintenance',
  'common.passive_state': 'Maintenance Mode',
  'common.select': 'Select',
  'common.selected': 'Selected',
  'common.password': 'Password',
  'common.confirm.password': 'Confirm Password',
  'common.username': 'Username',
  'common.url': 'URL',
  'common.advanced': 'Advanced',
  'common.download': 'Download',
  'common.current': 'Current',
  'common.additional': 'Additional',
  'common.time.start': 'Start Time',
  'common.time.end': 'End Time',
  'common.hostLog.popup.logDir.path':'/var/lib/ambari-agent/data/',   // TODO, this hardcoded path needs to be removed.
  'common.hostLog.popup.outputLog.value': 'output-{0}.txt',
  'common.hostLog.popup.errorLog.value': 'errors-{0}.txt',
  'common.maintenance.task': ' Toggle Maintenance Mode',
  'common.installRepo.task': ' Install Packages',
  'common.used': 'used',
  'common.free': 'free',
  'common.type.string': 'string',
  'common.type.number': 'number',
  'common.author': 'Author',
  'common.notes': 'Notes',
  'common.view': 'View',
  'common.compare': 'Compare',
  'common.latest': 'Latest',
  'common.custom': 'Custom',
  'common.continue': 'Continue',
  'common.continueAnyway': 'Continue Anyway',
  'common.property.undefined': "Undefined",
  'common.summary': "Summary",
  'common.configs': "Configs",
  'common.configuration': "Configuration",
  'common.unknown': "Unknown",
  'common.install': "Install",
  'common.alertDefinition': "Alert Definition",
  'common.prerequisites': 'Prerequisites',
  'common.finalize': "Finalize",
  'common.severity': "Severity",
  'common.dismiss': "Dismiss",
  'common.stdout': "stdout",
  'common.stderr': "stderr",
  'common.structuredOut': "structured_out",
  'common.fileName': 'File Name',
  'common.file': 'File',
  'common.days': "Days",
  'common.hours': "Hours",
  'common.minutes': "Minutes",
  'common.seconds': "Seconds",
  'common.milliseconds': "Milliseconds",
  'common.configGroup': 'Config Group',
  'common.expression': 'Expression',
  'common.dataSet': 'Data Set',
  'common.label': 'Label',
  'common.preview': 'Preview',
  'common.options': 'Options',
  'common.scope': 'Scope',
  'common.clone': 'Clone',
  'common.removed': 'Removed',
  'common.testing': 'Testing',
  'common.noData': 'No Data',
  'common.export': 'Export',
  'common.csv': 'Save as CSV',
  'common.json': 'Save as JSON',
  'common.timestamp': 'Timestamp',
  'common.timezone': 'Timezone',
  'common.loading.eclipses': 'Loading...',
  'common.optional': 'Optional',
  'common.propertyType': 'Property Type',
  'common.running': 'Running',
  'common.stopped': 'Stopped',
  'common.enter': 'Enter',
  'common.timeout.warning.popup.header': 'Automatic Logout',
  'common.timeout.warning.popup.body.before': 'You will be automatically logged out in ',
  'common.timeout.warning.popup.body.after': ' seconds due to inactivity',
  'common.timeout.warning.popup.primary': 'Remain Logged In',
  'common.timeout.warning.popup.secondary': 'Log Out Now',
  'common.openNewWindow': 'Open in New Window',
  'common.fullLogPopup.clickToCopy': 'Click to Copy',
  'common.nothingToDelete': 'Nothing to delete',
  'common.exclude': 'Exclude',
  'common.include': 'Include',
  'common.exclude.short': 'Excl',
  'common.include.short': 'Incl',
  'common.filters': 'Filters',
  'common.keywords': 'Keywods',
  'common.levels': 'Levels',
  'common.extension': 'Extension',
  'common.logs': 'Logs',
  'common.warn.message': '<div class="alert alert-warning">{0}</div>',
  'common.link': 'Link',
  'common.noLink': 'No Links',
  'common.live': 'Live',
  'common.from.version': 'From Version',
  'common.to.version': 'To Version',
  'common.start.time': 'Start Time',
  'common.end.time': 'End Time',
  'common.rolling': 'Rolling',
  'common.express': 'Express',
  'common.hostOrdered': 'Host Ordered',
  'common.repository': 'Repository',
  'common.repositoryType': 'Repository Type',
  'common.rolling.downgrade': 'Rolling Downgrade',
  'common.express.downgrade': 'Express Downgrade',
  'common.minute.ago': 'less than a minute ago',
  'common.views': 'Views',
  'common.review': 'Review',
  'common.critical.error': 'Critical',
  'common.with': 'with',
  'common.propertyName': 'Property Name',

  'models.alert_instance.tiggered.verbose': "Occurred on {0} <br> Checked on {1}",
  'models.alert_definition.triggered.verbose': "Occurred on {0}",
  'models.alert_definition.triggered.checked': "Status Changed: {0}\nLast Checked: {1}",
  'models.alert_definition.check.retry': "Alert Check {0} out of {1}",

  'passiveState.turnOn':'Turn On Maintenance Mode',
  'passiveState.turnOff':'Turn Off Maintenance Mode',
  'passiveState.turnOnFor':'Turn On Maintenance Mode for {0}',
  'passiveState.turnOffFor':'Turn Off Maintenance Mode for {0}',
  'passiveState.disabled.impliedFromHighLevel':'{0} is already in Maintenance Mode because {1} is in Maintenance Mode.',
  'passiveState.disabled.impliedFromServiceAndHost':'{0} is already in Maintenance Mode because {1} and {2} are in Maintenance Mode.',

  'requestInfo.installComponents':'Install Components',
  'requestInfo.installKerbeorosComponents':'Install Kerberos Components',
  'requestInfo.installServices':'Install Services',
  'requestInfo.kerberosService': 'Install Kerberos Service',
  'requestInfo.startServices':'Start Services',
  'requestInfo.startAddedServices':'Start Added Services',
  'requestInfo.stopAllServices':'Stop All Services',
  'requestInfo.startAllServices':'Start All Services',
  'requestInfo.startHostComponent':'Start',
  'requestInfo.startHostComponent.datanode':'Start DataNode',
  'requestInfo.startHostComponent.nodemanager':'Start NodeManager',
  'requestInfo.startHostComponent.hbase_regionserver':'Start RegionServer',
  'requestInfo.startHostComponents':'Start Components',
  'requestInfo.upgradeHostComponent':'Upgrade',
  'requestInfo.stopHostComponent':'Stop',
  'requestInfo.installHostComponent':'Install',
  'requestInfo.installNewHostComponent':'Install',
  'requestInfo.refreshComponentConfigs':'Refresh {0} configs',
  'requestInfo.stop':'Stop {0}',
  'requestInfo.start':'Start {0}',
  'requestInfo.unspecified':'Request name not specified',
  'requestInfo.kerberizeCluster': 'Kerberize Cluster',

  'hostPopup.noServicesToShow':'No services to show',
  'hostPopup.noHostsToShow':'No hosts to show',
  'hostPopup.noTasksToShow':'No tasks to show',
  'hostPopup.status.category.all':'All ({0})',
  'hostPopup.status.category.pending':'Pending ({0})',
  'hostPopup.status.category.inProgress':'In Progress ({0})',
  'hostPopup.status.category.failed':'Failed ({0})',
  'hostPopup.status.category.success':'Success ({0})',
  'hostPopup.status.category.aborted':'Aborted ({0})',
  'hostPopup.status.category.timedout':'Timedout ({0})',
  'hostPopup.header.postFix':' Background Operation{0} Running',
  'hostPopup.serviceInfo.showMore':'Show more...',
  'hostPopup.bgop.abortRequest.title': 'Abort operation',
  'hostPopup.bgop.abortRequest.confirmation.body': 'Are you sure you want to abort \'{0}\' operation?',
  'hostPopup.bgop.abortRequest.reason': 'Aborted by user',
  'hostPopup.bgop.abortRequest.modal.header': 'Abort request sent',
  'hostPopup.bgop.abortRequest.modal.body': 'The abort request for <strong>{0}</strong> has been sent to the server. Note: some tasks that are already running may have time to complete or fail before the abort request is applied.',
  'hostPopup.bgop.sourceRequestSchedule.running': 'Future operations of this batch request can be aborted',
  'hostPopup.bgop.sourceRequestSchedule.aborted': 'Future operations of this batch request have been aborted',
  'hostPopup.bgop.abort.rollingRestart': 'Abort Rolling Restart',
  'hostPopup.warning.alertsTimeOut': 'Maintenance Mode has been turned {0}. It may take a few minutes for the alerts to be {1}.',
  'hostPopup.reccomendation.beforeDecommission': '{0} Maintenance Mode is pre required for decommissioning.',
  'hostPopup.setRackId.success': 'Updating rack id to \"{0}\". It may take a few moments for it to get refreshed.',
  'hostPopup.setRackId.error': 'Updating the rack id failed.',
  'hostPopup.setRackId.invalid': 'Should start with a forward slash it may include alphanumeric chars, dots, dashes and forward slashes. Should be less than 255 symbols.',
  'hostPopup.RackId': 'Rack',
  'hostPopup.recommendation.beforeDecommission': '{0} Maintenance Mode is pre required for decommissioning.',
  'hostPopup.default.userName': 'none',

  'question.sure':'Are you sure?',
  'question.sure.restart':'Are you sure you want to restart {0}?',
  'question.sure.start':'Are you sure you want to start {0}?',
  'question.sure.stop':'Are you sure you want to stop {0}?',
  'question.sure.move':'Are you sure you want to move {0}?',
  'question.sure.refresh':'Are you sure you want to restart {0} on {1}?',
  'question.sure.maintenance':'Are you sure you want to turn {0} maintenance mode for {1}?',
  'question.sure.upgrade':'Are you sure you want to upgrade {0}?',
  'question.sure.decommission':'Are you sure you want to decommission {0}?',
  'question.sure.recommission':'Are you sure you want to recommission {0}?',
  'question.sure.startAll':'Are you sure you want to start all the components?',
  'question.sure.stopAll':'Are you sure you want to stop all the components?',
  'question.sure.restartAll':'Are you sure you want to restart all the components?',
  'question.sure.regenerateKeytab.service': 'Are you sure you want to regenerate keytab file operations for a {0} service?',
  'question.sure.regenerateKeytab.host': 'Are you sure you want to regenerate keytab file operations for a {0} host?',

  'popup.highlight':'click to highlight',
  'popup.confirmation.commonHeader':'Confirmation',
  'popup.confirmation.refreshYarnQueues.body':'It is strongly recommended to <strong>Refresh Yarn Queues</strong> after making a change to the capacity scheduler configuration. Would you like to proceed?',
  'popup.warning.refreshYarnQueues.body': '<div class="alert alert-warning"><strong>Warning: </strong>The queue configuration change may have affected the queue used by Hive LLAP. A Hive LLAP reconfiguration or restart may be required.</div>',
  'popup.confirmation.refreshYarnQueues.buttonText':'Refresh Yarn Queues',
  'popup.confirmation.hsiRestart.body':'It is strongly recommended to <strong>Restart HiveServer2 Interactive</strong> after making a change to the Hive LLAP sizing configuration. Would you like to proceed?',
  'popup.confirmation.hsiRestart.buttonText':'Restart HiveServer2 Interactive',
  'popup.prompt.commonHeader':'Prompt',
  'popup.confirmationFeedBack.sending':'Sending...',
  'popup.confirmationFeedBack.query.fail':'Request failed',

  'popup.clusterCheck.failedOn': 'Failed on: ',
  'popup.clusterCheck.reason': 'Reason: ',
  'popup.clusterCheck.Upgrade.header': 'Upgrade to {0}',
  'popup.clusterCheck.Upgrade.fail.title': 'Requirements',
  'popup.clusterCheck.Upgrade.fail.alert': 'You <strong>must</strong> meet these requirements before you can proceed.',
  'popup.clusterCheck.Upgrade.bypassed-failures.title': 'Errors that can be bypassed',
  'popup.clusterCheck.Upgrade.bypassed-failures.alert': 'Errors are allowed to be bypassed since config stack.upgrade.bypass.prechecks is set to true. It is strongly encouraged to look into these failures.',
  'popup.clusterCheck.Upgrade.warning.title': 'Warnings',
  'popup.clusterCheck.Upgrade.warning.alert': 'Correcting the warnings is not required but is <strong>recommended</strong>.',
  'popup.clusterCheck.Upgrade.configsMerge.title': 'Configuration Changes',
  'popup.clusterCheck.Upgrade.configsMerge.alert': 'During upgrade, the following configuration changes will be applied.',
  'popup.clusterCheck.Upgrade.configsMerge.configType': 'Config Type',
  'popup.clusterCheck.Upgrade.configsMerge.propertyName': 'Property Name',
  'popup.clusterCheck.Upgrade.configsMerge.currentValue': 'Current Value',
  'popup.clusterCheck.Upgrade.configsMerge.recommendedValue': 'Recommended Value',
  'popup.clusterCheck.Upgrade.configsMerge.resultingValue': 'Resulting Value',
  'popup.clusterCheck.Upgrade.configsMerge.deprecated': 'Property is deprecated',
  'popup.clusterCheck.Upgrade.configsMerge.willBeRemoved': 'Will be removed',
  'popup.clusterCheck.Upgrade.configsRecommend.alert': 'We\'ve detected the need to update the following properties,' +
  ' but cannot do so automatically since they have been customized.  Please review these properties manually,' +
  ' and update the properties manually where necessary.',
  'popup.clusterCheck.Upgrade.configsRecommend.title': 'Recommended Configuration Changes: Manual Review',
  'popup.clusterCheck.Security.header': 'Enable Security',
  'popup.clusterCheck.Security.title': 'Security Requirements Not Met',
  'popup.clusterCheck.Security.alert': 'You must meet the following requirements before you can enable security.',

  'popup.invalid.KDC.header': 'Admin session expiration error',
  'popup.invalid.KDC.msg': ' Please enter admin principal and password.',
  'popup.invalid.KDC.admin.principal': 'Admin principal',
  'popup.invalid.KDC.admin.password': 'Admin password',

  'popup.dependent.configs.header': 'Dependent Configurations',
  'popup.dependent.configs.title.recommendation': 'Based on your configuration changes, Ambari is recommending the following dependent configuration changes.',
  'popup.dependent.configs.title.values': 'Ambari will update all checked configuration changes to the <b>Recommended Value</b>. Uncheck any configuration to retain the <b>Current Value</b>.',
  'popup.dependent.configs.title.required': 'The following configuration changes are required and will be applied automatically.',
  'popup.dependent.configs.table.recommended': 'Recommended Changes',
  'popup.dependent.configs.table.required': 'Required Changes',
  'popup.dependent.configs.table.saveProperty': 'Save property',
  'popup.dependent.configs.table.initValue': 'Initial value',
  'popup.dependent.configs.table.currentValue': 'Current Value',
  'popup.dependent.configs.table.originalValue': 'Original Value',
  'popup.dependent.configs.table.recommendedValue': 'Recommended Value',
  'popup.dependent.configs.table.newValue': 'New Value',
  'popup.dependent.configs.table.undefined': 'Property undefined',
  'popup.dependent.configs.table.removed': 'Property removed',


  'popup.dependent.configs.select.config.group.header': 'Select Config Group',
  'popup.dependent.configs.select.config.group.no.groups': 'No config groups for current service',
  'popup.dependent.configs.select.config.group': 'Please select to which config group would you like to save dependent properties',

  'popup.dependent.configs.dependencies.config.singular': 'There is {0} configuration change ',
  'popup.dependent.configs.dependencies.config.plural': 'There are {0} configuration changes ',
  'popup.dependent.configs.dependencies.service.singular': 'in {0} service',
  'popup.dependent.configs.dependencies.service.plural': 'in {0} services',

  'popup.dependent.configs.dependencies.for.groups': 'You are changing not default group, please select config group to which you want to save dependent configs from other services',

  'popup.jdkValidation.header': 'Unsupported JDK',
  'popup.jdkValidation.body': 'The {0} Stack requires JDK {1} but Ambari is configured for JDK {2}. This could result in error or problems with running your cluster.',
  'popup.logTail.header': 'File Name',
  'popup.logTail.openInLogSearch': 'Open In Log Search',

  'login.header':'Sign in',
  'login.message.title':'Login Message',
  'login.username':'Username',
  'login.loginButton':'Sign in',
  'login.error.bad.credentials':'Unable to sign in. Invalid username/password combination.',
  'login.error.disabled':'Unable to sign in. Invalid username/password combination.',
  'login.error.bad.connection':'Unable to connect to Ambari Server. Confirm Ambari Server is running and you can reach Ambari Server from this machine.',

  'titlebar.alerts.noAlerts': 'No Alerts',

  'graphs.noData.title': 'No Data',
  'graphs.noData.message': 'No Data Available',
  'graphs.noData.tooltip.title': 'No Data Available. The Ambari Metrics service may be not installed or inaccessible',
  'graphs.noDataAtTime.message': 'No available data for the time period.',
  'graphs.error.title': 'Error',
  'graphs.error.message': 'There was a problem getting data for the chart ({0}: {1})',
  'graphs.timeRange.hour': 'Last 1 hour',
  'graphs.timeRange.twoHours': 'Last 2 hours',
  'graphs.timeRange.fourHours': 'Last 4 hours',
  'graphs.timeRange.twelveHours': 'Last 12 hours',
  'graphs.timeRange.day': 'Last 24 hours',
  'graphs.timeRange.week': 'Last 1 week',
  'graphs.timeRange.month': 'Last 1 month',
  'graphs.timeRange.year': 'Last 1 year',
  'graphs.tooltip.title': 'Click to zoom',

  'users.userName.validationFail': 'Only lowercase letters and numbers are recommended; must start with a letter',
  'host.spacesValidation': 'Cannot contain whitespace',

  'services.hdfs.rebalance.title' : 'HDFS Rebalance',
  'services.ganglia.description':'Ganglia Metrics Collection system',
  'services.hdfs.description':'Apache Hadoop Distributed File System',
  'services.glusterfs.description':'Apache Hadoop Compatible File System (must be installed manually)',
  'services.sqoop.description':'Tool for transferring bulk data between Apache Hadoop and structured data stores such as relational databases',
  'services.pig.description':'Scripting platform for analyzing large datasets',
  'services.hive.description':'Data warehouse system for ad-hoc queries & analysis of large datasets and table & storage management service',
  'services.oozie.description':'System for workflow coordination and execution of Apache Hadoop jobs',
  'services.zookeeper.description':'Centralized service which provides highly reliable distributed coordination',
  'services.hbase.description':'Non-relational distributed database and centralized service for configuration management & synchronization',
  'services.hive.databaseComponent':'Database Server',
  'services.mapreduce2.description':'Apache Hadoop NextGen MapReduce (client libraries)',
  'services.yarn.description':'Apache Hadoop NextGen MapReduce (YARN)',
  'services.tez.description':'Tez is the next generation Hadoop Query Processing framework written on top of YARN',
  'services.falcon.description': 'Falcon mirroring engine',
  'services.storm.description': 'Apache Hadoop Stream processing framework',
  'services.storm.configs.range-plugin-enable.dialog.title': 'Enable Ranger for STORM',
  'services.storm.configs.range-plugin-enable.dialog.message': 'Enabling Ranger plugin for STORM is effective only on a secured cluster.',


  'services.alerts.head':'You have {0} critical alert notification(s).',
  'services.alerts.OK.timePrefixShort': 'OK',
  'services.alerts.WARN.timePrefixShort': 'WARN',
  'services.alerts.CRIT.timePrefixShort': 'CRIT',
  'services.alerts.MAINT.timePrefixShort': 'MAINT',
  'services.alerts.UNKNOWN.timePrefixShort': 'UNKNOWN',
  'services.alerts.OK.timePrefix': 'OK for {0}',
  'services.alerts.WARN.timePrefix': 'WARN for {0}',
  'services.alerts.CRIT.timePrefix': 'CRIT for {0}',
  'services.alerts.MAINT.timePrefix': 'MAINT for {0}',
  'services.alerts.UNKNOWN.timePrefix': 'UNKNOWN for {0}',
  'services.alerts.lastCheck': 'Last Checked {0}',
  'services.alerts.brLastCheck': '<br>Last Checked {0}',
  'services.alerts.occurredOn': 'Occurred on {0}, {1}',
  'services.alerts.goToService': 'Go to Service',
  'services.alerts.goTo': 'Go to {0}',

  'services.summary.selectHostForComponent': 'Select the host to add {0} component',
  'services.summary.allHostsAlreadyRunComponent': 'All hosts already running {0} component',

  'topnav.help.href':'https://cwiki.apache.org/confluence/display/AMBARI/Ambari',

  'installer.header':'Cluster Install Wizard',
  'installer.navigation.warning.header':'Navigation Warning',

  'installer.noHostsAssigned':'No host assigned',
  'installer.slaveComponentHosts.selectHosts':'select hosts for this group',
  'installer.slaveComponentHostsPopup.header':'Select which hosts should belong to which {0} group',

  'installer.controls.slaveComponentGroups':' Groups',
  'installer.controls.serviceConfigPopover.title':'{0}<br><small>{1}</small>',
  'installer.controls.checkConnection.popover':'This action will check accessibility of {0} host and port from Ambari Server host',
  'installer.controls.serviceConfigMultipleHosts.other':'1 other',
  'installer.controls.serviceConfigMultipleHosts.others':'{0} others',
  'installer.controls.serviceConfigMasterHosts.header':'{0} Hosts',
  'installer.controls.slaveComponentChangeGroupName.error':'group with this name already exist',

  'installer.step0.header':'Get Started',
  'installer.step0.body.header':'Get Started',
  'installer.step0.body':'This wizard will walk you through the cluster installation process.  First, start by naming your new cluster.',
  'installer.step0.clusterName':'Name your cluster',
  'installer.step0.clusterName.tooltip.title':'Cluster Name',
  'installer.step0.clusterName.tooltip.content':'Enter a unique cluster name.',
  'installer.step0.clusterName.error.required':'Cluster Name is required',
  'installer.step0.clusterName.error.tooLong':'Cluster Name is too long',
  'installer.step0.clusterName.error.whitespace':'Cluster Name cannot contain whitespace',
  'installer.step0.clusterName.error.specialChar':'Cluster Name cannot contain special characters',

  'installer.step1.header':'Select Version',
  'installer.step1.body':'Select the software version and method of delivery for your cluster.',
  'installer.step1.repo.body':'Using a Public Repository requires Internet connectivity. Using a Local Repository requires you have configured the software in a repository available in your network.',
  'installer.step1.addVersion.title':'Add Version',
  'installer.step1.changeVersion.defaultVersion':'Default Version Definition',
  'installer.step1.selectUseRepoOptions.public':'Use Public Repository',
  'installer.step1.selectUseRepoOptions.public.networkLost.button':'Not Available',
  'installer.step1.selectUseRepoOptions.public.networkLost':'Why is this not selected?',
  'installer.step1.selectUseRepoOptions.public.networkLost.popup.title': 'Public Repository Option Not Selected',
  'installer.step1.selectUseRepoOptions.public.networkLost.popup.msg': 'Ambari is unable to confirm access to the Public Repositories, which means you might not have Internet access and will not be able to use the Public Repository option for installing the software. Your choices:',
  'installer.step1.selectUseRepoOptions.public.networkLost.popup.msg1': 'Configure your hosts for access to the Internet.',
  'installer.step1.selectUseRepoOptions.public.networkLost.popup.msg2': 'If you are using an Internet Proxy, refer to the Ambari Documentation on how to configure Ambari to use the Internet Proxy.',
  'installer.step1.selectUseRepoOptions.public.networkLost.popup.msg3': 'Use the Local Repositoy option.',
  'installer.step1.selectUseRepoOptions.public.networkLost.popup.msg4': 'If you do not have internet access and select this option, you will fail the Repository Base URL validation.',
  'installer.step1.selectUseRepoOptions.public.select':'Select Version',
  'installer.step1.selectUseRepoOptions.local':'Use Local Repository',
  'installer.step1.usePublicRepo.ReposList.empty':'No other versions',
  'installer.step1.usePublicRepo.viewRepos':'View Repositories',
  'installer.step1.useLocalRepo.uploadFile': 'Upload Version Definition File',
  'installer.step1.useLocalRepo.uploadFile.error.title': 'Upload Version Definition File Error',
  'installer.step1.useLocalRepo.getSurpottedOs.error.title': 'Cannot get supported OS types',
  'installer.step1.useLocalRepo.addRepo.button': 'Add Repository',
  'installer.step1.addVersion': 'Add Version',
  'installer.step1.addVersion.stackChanged.popup.body': 'Stack is changed from {0} to {1}.',
  'installer.step1.useLocalRepo.enterUrl': 'Version Definition File URL',
  'installer.step1.useLocalRepo.enterUrl.placeholder': 'Enter URL to Version Definition File',
  'installer.step1.useLocalRepo.readButton': 'Read Version Info',
  'installer.step1.useLocalRepo.infoForm.details.title': 'Details',
  'installer.step1.useLocalRepo.infoForm.details.stackName': 'Stack Name',
  'installer.step1.useLocalRepo.infoForm.details.displayName': 'Display Name',
  'installer.step1.useLocalRepo.infoForm.details.version': 'Version',
  'installer.step1.useLocalRepo.infoForm.details.actualVersion': 'Actual Version',
  'installer.step1.useLocalRepo.infoForm.details.releaseNotes': 'Release Notes',
  'installer.step1.useLocalRepo.infoForm.content.title': 'Contents',
  'installer.step1.useLocalRepo.infoForm.content.empty': 'No contents to display',
  'installer.step1.useLocalRepo.infoForm.alert.baseUrl': 'Provide Base URLs for the Operating Systems you are configuring.',
  'installer.step1.useLocalRepo.infoForm.alert.warning': 'Some of the repositories failed validation. Make changes to the base url or skip validation if you are sure that urls are correct',
  'installer.step1.advancedRepo.title':'Advanced Repository Options',
  'installer.step1.advancedRepo.message':'Customize the repository Base URLs for downloading the Stack software packages. If your hosts do not have access to the internet, you will have to create a local mirror of the Stack repository that is accessible by all hosts and use those Base URLs here.',
  'installer.step1.advancedRepo.importantMassage':'<b>Important:</b> When using local mirror repositories, you only need to provide Base URLs for the Operating System you are installing for your Stack. Uncheck all other repositories.',
  'installer.step1.advancedRepo.localRepo.error.modifyUrl':'Local repository URL must be modified',
  'installer.step1.advancedRepo.localRepo.error.noUrl':'Base URL required for a local repository',
  'installer.step1.advancedRepo.localRepo.column.baseUrl':'Base URL',
  'installer.step1.advancedRepo.localRepo.label.os':'Operating System',
  'installer.step1.advancedRepo.localRepo.label.baseUrl':'Repository Base URL',
  'installer.step1.advancedRepo.localRepo.label.stack':'Stack',
  'installer.step1.advancedRepo.localRepo.placeholder': 'Enter Base URL or remove this OS',
  'installer.step1.advancedRepo.skipValidation.tooltip':'Warning: This is for advanced users only. Use this option if you want to skip validation for Repository Base URLs.',
  'installer.step1.advancedRepo.useRedhatSatellite.tooltip':'Disable distributed repositories and use RedHat Satellite/Spacewalk channels instead',
  'installer.step1.advancedRepo.useRedhatSatellite.disabled.tooltip':'Use of RedHat Satellite/Spacewalk is not available when is using Public Repositories',
  'installer.step1.advancedRepo.skipValidation.message':'Skip Repository Base URL validation (Advanced)',
  'installer.step1.advancedRepo.useRedhatSatellite.message': 'Use RedHat Satellite/Spacewalk',
  'installer.step1.advancedRepo.useRedhatSatellite.warning': "In order for Ambari to install packages from the right" +
  " repositories, it is recommended that you edit the names of the repo's for each operating system so they match " +
  "the channel names in your RedHat Satellite/Spacewalk instance.",
  'installer.step1.addOs.disabled.tooltip':'All Operating Systems have been added',
  'installer.step1.attentionNeeded':'<b>Attention:</b> Repository Base URLs of at least one OS are REQUIRED before you can proceed. Please make sure they are in correct format with its protocol.',
  'installer.step1.invalidURLAttention': '<b>Attention:</b> Please make sure all repository URLs are valid before proceeding.',
  'installer.step1.checkAtLeastOneAttention': '<b>Attention:</b> Please check at least one repository.',
  'installer.step1.retryRepoUrls': 'Click <b>here</b> to retry.',

  'installer.step2.header':'Install Options',
  'installer.step2.body':'Enter the list of hosts to be included in the cluster and provide your SSH key.',
  'installer.step2.targetHosts':'Target Hosts',
  'installer.step2.targetHosts.info':'Enter a list of hosts using the Fully Qualified Domain Name (FQDN), one per line',
  'installer.step2.hostPattern.tooltip.title':'Pattern Expressions',
  'installer.step2.hostPattern.tooltip.content':'You can use pattern expressions to specify a number of target hosts. For example, to specify host01.domain thru host10.domain, enter host[01-10].domain in the target hosts textarea.',
  'installer.step2.hostName.error.required':'You must specify at least one host name',
  'installer.step2.hostName.error.already_installed':'All these hosts are already part of the cluster',
  'installer.step2.hostName.error.notRequired':'Host Names will be ignored if not using SSH to automatically configure hosts',
  'installer.step2.hostName.error.invalid':'Invalid Host Name(s)',
  'installer.step2.hostName.pattern.header':'Host name pattern expressions',
  'installer.step2.sshKey':'Host Registration Information',
  'installer.step2.sshKey.error.required':'SSH Private Key is required',
  'installer.step2.passphrase.error.match':'Passphrases do not match',
  'installer.step2.manualInstall.label':'Do not use SSH to automatically configure hosts ',
  'installer.step2.manualInstall.info':'By not using SSH to connect to the target hosts, you must manually install and' +
    ' start the Ambari Agent on each host in order for the wizard to perform the necessary configurations and' +
    ' software installs.',
  'installer.step2.advancedOption':'Advanced Options',
  'installer.step2.repoConf':'Software Repository Configuration File Path',
  'installer.step2.advancedOptions.header':'Advanced Options',
  'installer.step2.localRepo.label_use':'Use a',
  'installer.step2.localRepo.label_instead':'instead of downloading software packages from the Internet',
  'installer.step2.localRepo.error.required':'Local repository file path is required',
  'installer.step2.localRepo.tooltip.title':'Local Software Repository',
  'installer.step2.localRepo.tooltip.content': 'The cluster install requires access to the Internet to fetch software ' +
    'from a remote repository. In some cases, adequate bandwidth is not available and you want to prevent downloading ' +
    'packages from the remote repository over and over again. Other times, Internet access is not available from the ' +
    'hosts in your cluster. In these situations, you must set up a version of the repository that your machines can ' +
    'access locally and this is called a <b>Local Software Repository</b>',
  'installer.step2.javaHome.label' : 'Path to 64-bit JDK',
  'installer.step2.javaHome.tooltip.title' : 'JAVA_HOME',
  'installer.step2.javaHome.tooltip.content' : 'Path to 64-bit JAVA_HOME. /usr/jdk/jdk1.6.0_31 is the default used by Ambari. You can override this to a specific path that contains the JDK. <br/> Note: the path must be valid on <b>ALL</b> hosts in your cluster.',
  'installer.step2.javaHome.tooltip.placeholder' : '/usr/jdk/jdk1.6.0_31',
  'installer.step2.automaticInstall.tooltip.title':'automatic registration',
  'installer.step2.automaticInstall.tooltip.content':'Ambari will automatically install and register the Ambari Agent on each host prior to the cluster installation.',
  'installer.step2.useSsh.provide' : 'Provide your',
  'installer.step2.useSsh.provide_id_rsa' : ' to automatically register hosts',
  'installer.step2.useSsh.tooltip.title':'SSH Private Key',
  'installer.step2.useSsh.tooltip.content':'The <b>SSH Private Key File</b> is used to connect to the target hosts in your cluster to install the Ambari Agent.',
  'installer.step2.install.perform':'Perform',
  'installer.step2.install.perform_on_hosts':'on hosts',
  'installer.step2.install.without_ssh':' and do not use SSH',
  'installer.step2.manualInstall.tooltip.title':'manual registration',
  'installer.step2.manualInstall.tooltip.content':'Manually registering the Ambari Agent on each host eliminates the need for SSH and should be performed prior to continuing cluster installation.',
  'installer.step2.manualInstall.tooltip.content_no_ssh':'Manually registering the Ambari Agent on each host should be performed prior to continuing cluster installation.',
  'installer.step2.manualInstall.popup.header':'Before You Proceed',
  'installer.step2.manualInstall.popup.body':'You must install Ambari Agents on each host you want to manage before you proceed.',
  'installer.step2.warning.popup.body':'<p>The following hostnames are not valid FQDNs:</p><p> {0} </p><p>This may cause problems during installation. Do you want to continue?</p>',
  'installer.step2.orUse':'Or use',
  'installer.step2.registerAndConfirm':'Register and Confirm',
  'installer.step2.evaluateStep.installedHosts':'These hosts are already installed on the cluster and will be ignored:',
  'installer.step2.evaluateStep.continueConfirm':'Do you want to continue?',
  'installer.step2.evaluateStep.hostRegInProgress':'Host Registration is currently in progress.  Please try again later.',
  'installer.step2.sshUser':'SSH User Account',
  'installer.step2.sshUser.toolTip':'The user account used to install the Ambari Agent on the target host(s) via SSH. This user must be set up with passwordless SSH and sudo access on all the target host(s)',
  'installer.step2.sshUser.placeholder':'Enter user name',
  'installer.step2.sshUser.required':'User name is required',
  'installer.step2.sshPort':'SSH Port Number',
  'installer.step2.sshPort.toolTip':'SSH Port Number',
  'installer.step2.sshPort.required':'SSH Port Number is required.',
  'installer.step2.agentUser':'Ambari Agent User Account',
  'installer.step2.agentUser.toolTip':'The user account used to run the Ambari Agent daemon on the target host(s). This user must be set up with passwordless sudo access on all the target host(s)',
  'installer.step2.bootStrap.error':'Errors were encountered while setting up Ambari Agents on the hosts.',
  'installer.step2.bootStrap.inProgress':'Please wait while Ambari Agents are being set up on the hosts. This can take several minutes depending on the number of hosts.',
  'installer.step2.bootStrap.header':'Setting Up Ambari Agents',
  'installer.step2.skipHostChecks.label': 'Skip host checks',
  'installer.step2.skipHostChecks.popup.header': 'Warning',
  'installer.step2.skipHostChecks.popup.body': 'By skipping host checks, Ambari will not check and warn if any issues with the host are identified and the host will be added to the cluster as is.',

  'installer.step3.header':'Confirm Hosts',
  'installer.step3.body':'Registering your hosts.<br>' +
    'Please confirm the host list and remove any hosts that you do not want to include in the cluster.',
  'installer.step3.hostLog.popup.header':'Registration log for {0}',
  'installer.step3.hosts.remove.popup.header':'Remove Hosts',
  'installer.step3.hosts.remove.popup.body':'Are you sure you want to remove the selected host(s)?',
  'installer.step3.hostInformation.popup.header':'Error in retrieving host Information',
  'installer.step3.hostInformation.popup.body' : 'All bootstrapped hosts registered but unable to retrieve cpu and memory related information',
  'installer.step3.hostOsTypeCheck.popup.body' : 'Host registered successfully, but the host operating system type NOT match the selected group in "Select Stack" step: Advanced Repository Option. You can go back to "Select Stack" step OR remove this host.' +
    'The host type is {0}, but you selected group {1} in step 1.',
  'installer.step3.hostWarningsPopup.report':'Show Report',
  'installer.step3.hostWarningsPopup.report.header': '<p style="font-family: monospace">######################################<br># Host Checks Report<br>#<br># Generated: ',
  'installer.step3.hostWarningsPopup.report.hosts': '<br>######################################<br><br>######################################<br># Hosts<br>#<br># A space delimited list of hosts which have issues.<br># Provided so that administrators can easily copy hostnames into scripts, email etc.<br>######################################<br>HOSTS<br>',
  'installer.step3.hostWarningsPopup.report.jdk': '<br><br>######################################<br># JDK Check <br>#<br># A newline delimited list of JDK issues.<br>######################################<br>JDK ISSUES<br>',
  'installer.step3.hostWarningsPopup.report.disk': '<br><br>######################################<br># Disk <br>#<br># A newline delimited list of disk issues.<br>######################################<br>DISK ISSUES<br>',
  'installer.step3.hostWarningsPopup.report.repositories': '<br><br>######################################<br># Repositories <br>#<br># A newline delimited list of repositories issues.<br>######################################<br>REPOSITORIES ISSUES<br>',
  'installer.step3.hostWarningsPopup.report.hostNameResolution': '<br><br>######################################<br># Hostname Resolution<br>#<br># A newline delimited list of hostname resolution issues.<br>######################################<br>HOSTNAME RESOLUTION ISSUES<br>',
  'installer.step3.hostWarningsPopup.report.thp': '<br><br>######################################<br># Transparent Huge Pages(THP) <br>#<br># A space delimited list of hostnames on which Transparent Huge Pages are enabled.<br>######################################<br>THP ISSUES HOSTS<br>',
  'installer.step3.hostWarningsPopup.report.firewall': '<br><br>######################################<br># Firewall<br>#<br># A newline delimited list of firewall issues.<br>######################################<br>FIREWALL<br>',
  'installer.step3.hostWarningsPopup.report.fileFolders': '<br><br>######################################<br># Files and Folders<br>#<br># A space delimited list of files and folders which should not exist.<br># Provided so that administrators can easily copy paths into scripts, email etc.<br># Example: rm -r /etc/hadoop /etc/hbase<br>######################################<br>FILES AND FOLDERS<br>',
  'installer.step3.hostWarningsPopup.report.reverseLookup': '<br><br>######################################<br># Reverse Lookup<br># <br># The hostname was not found in the reverse DNS lookup. This may result in incorrect behavior. <br># Please check the DNS setup and fix the issue.<br>######################################<br>REVERSE LOOKUP<br>',
  'installer.step3.hostWarningsPopup.report.process': '<br><br>######################################<br># Processes<br>#<br># A comma separated list of process tuples which should not be running.<br># Provided so that administrators can easily copy paths into scripts, email etc.<br>######################################<br>PROCESSES<br>',
  'installer.step3.hostWarningsPopup.report.package': '<br><br>######################################<br># Packages<br>#<br># A space delimited list of software packages which should be uninstalled.<br># Provided so that administrators can easily copy paths into scripts, email etc.<br># Example: yum remove hadoop-hdfs yarn<br>######################################<br>PACKAGES<br>',
  'installer.step3.hostWarningsPopup.report.service': '<br><br>######################################<br># Services<br>#<br># A space delimited list of services which should be up and running.<br># Provided so that administrators can easily copy paths into scripts, email etc.<br># Example: services start ntpd httpd<br>######################################<br>SERVICES<br>',
  'installer.step3.hostWarningsPopup.report.user': '<br><br>######################################<br># Users<br>#<br># A space delimited list of users who should not exist.<br># Provided so that administrators can easily copy paths into scripts, email etc.<br># Example: userdel hdfs<br>######################################<br>USERS<br>',
  'installer.step3.hostWarningsPopup.report.folder': '\\ /folder',
  'installer.step3.hostWarningsPopup.checks': 'Host Checks found',
  'installer.step3.hostWarningsPopup.notice.beginning': 'After manually resolving the issues, click <b>Rerun Checks</b>.',
  'installer.step3.hostWarningsPopup.summary':'{0} on {1}',
  'installer.step3.hostWarningsPopup.jdk':'JDK Issues',
  'installer.step3.hostWarningsPopup.jdk.name':'JDK not found at <i>{0}</i>',
  'installer.step3.hostWarningsPopup.jdk.context':'{0}',
  'installer.step3.hostWarningsPopup.jdk.message':'The following registered hosts have issues related to JDK',
  'installer.step3.hostWarningsPopup.repositories':'Repository Issues',
  'installer.step3.hostWarningsPopup.repositories.name':'Repository for OS not available',
  'installer.step3.hostWarningsPopup.repositories.context':'Host ({0}) is {1} OS type, but the repositories chosen in "Select Stack" step was {2}. Selected repositories do not support this host OS type.',
  'installer.step3.hostWarningsPopup.repositories.message': 'The following registered hosts have different Operating System types from the available Repositories chosen in "Select Stack" step. You can go back to "Select Stack" step to select another OS repository <b>or</b> remove the host.',
  'installer.step3.hostWarningsPopup.disk':'Disk Issues',
  'installer.step3.hostWarningsPopup.disk.name':'Not enough disk space ',
  'installer.step3.hostWarningsPopup.disk.context1':'Not enough disk space on host ({0}).',
  'installer.step3.hostWarningsPopup.disk.context2':'A minimum of {0} is required for "{1}" mount.',
  'installer.step3.hostWarningsPopup.disk.message':'The following registered hosts have issues related to disk space',
  'installer.step3.hostWarningsPopup.thp':'Transparent Huge Pages Issues',
  'installer.step3.hostWarningsPopup.thp.name':'Transparent Huge Pages',
  'installer.step3.hostWarningsPopup.thp.context':'{0}',
  'installer.step3.hostWarningsPopup.thp.message':'The following hosts have Transparent Huge Pages (THP) enabled. THP should be disabled to avoid potential Hadoop performance issues.',
  'installer.step3.hostWarningsPopup.firewall':'Firewall Issues',
  'installer.step3.hostWarningsPopup.firewall.message':'Firewall is running on the following hosts. Please configure the firewall to allow communications on the ports documented in the <i>Configuring Ports</i> section of  the <a target=\"_blank\" href=\"http://ambari.apache.org/current/installing-hadoop-using-ambari/content/\">Ambari documentation</a>',
  'installer.step3.hostWarningsPopup.process':'Process Issues',
  'installer.step3.hostWarningsPopup.processes.message':'The following processes should not be running',
  'installer.step3.hostWarningsPopup.fileAndFolder':'File and Folder Issues',
  'installer.step3.hostWarningsPopup.fileFolders.message':'The following files and folders should not exist',
  'installer.step3.hostWarningsPopup.package':'Package Issues',
  'installer.step3.hostWarningsPopup.packages.message':'The following packages should be uninstalled',
  'installer.step3.hostWarningsPopup.user':'User Issues',
  'installer.step3.hostWarningsPopup.users.message':'The following users should be removed',
  'installer.step3.hostWarningsPopup.service':'Service Issues',
  'installer.step3.hostWarningsPopup.services.message':'The following services should be up',
  'installer.step3.hostWarningsPopup.misc':'Misc Issues',
  'installer.step3.hostWarningsPopup.misc.message':'The following umasks should be changed',
  'installer.step3.hostWarningsPopup.misc.umask':'Umask',
  'installer.step3.hostWarningsPopup.alternatives':'Alternatives Issues',
  'installer.step3.hostWarningsPopup.alternatives.umask' : 'Alternatives',
  'installer.step3.hostWarningsPopup.alternatives.message':'The following alternatives should be removed',
  'installer.step3.hostWarningsPopup.alternatives.noIssues':'There was no alternative issue following alternatives should be removed',
  'installer.step3.hostWarningsPopup.alternatives.empty': 'alternative issues',
  'installer.step3.hostWarningsPopup.issue':'issue',
  'installer.step3.hostWarningsPopup.issues':'issues',
  'installer.step3.hostWarningsPopup.emptyMessage':'There were no {0}',
  'installer.step3.hostWarningsPopup.empty.filesAndFolders':'unwanted files and folders',
  'installer.step3.hostWarningsPopup.empty.processes':'unwanted processes',
  'installer.step3.hostWarningsPopup.empty.packages':'unwanted packages',
  'installer.step3.hostWarningsPopup.empty.users':'unwanted users',
  'installer.step3.hostWarningsPopup.empty.services':'unwanted services',
  'installer.step3.hostWarningsPopup.empty.misc':'issues',
  'installer.step3.hostWarningsPopup.empty.firewall':'firewalls running',
  'installer.step3.hostWarningsPopup.empty.repositories':'repositories OS type mis-match with registered hosts',
  'installer.step3.hostWarningsPopup.empty.disk':'disk space issues',
  'installer.step3.hostWarningsPopup.empty.jdk':'JDK issues',
  'installer.step3.hostWarningsPopup.empty.thp':'THP issues',
  'installer.step3.hostWarningsPopup.reverseLookup.name': 'Reverse Lookup validation failed on',
  'installer.step3.hostWarningsPopup.reverseLookup': 'Reverse Lookup Issues',
  'installer.step3.hostWarningsPopup.reverseLookup.message': 'The hostname was not found in the reverse DNS lookup. This may result in incorrect behavior. Please check the DNS setup and fix the issue.',
  'installer.step3.hostWarningsPopup.reverseLookup.empty': 'reverse DNS lookup issues.',
  'installer.step3.hostWarningsPopup.resolution.validation.name': 'Hostname Resolution Issues',
  'installer.step3.hostWarningsPopup.resolution.validation.error': 'Hostname resolution',
  'installer.step3.hostWarningsPopup.resolution.validation': 'Hostname resolution validation',
  'installer.step3.hostWarningsPopup.resolution.validation.message': 'Not all hosts could resolve hostnames of other hosts. Make sure that host resolution works properly on all hosts before continuing.',
  'installer.step3.hostWarningsPopup.resolution.validation.empty': 'hostname resolution issues',
  'installer.step3.hostWarningsPopup.resolution.validation.context': '{0} could not resolve: {1}.',
  'installer.step3.hostWarningsPopup.action.exists':'Exists on',
  'installer.step3.hostWarningsPopup.action.notRunning':'Not running on',
  'installer.step3.hostWarningsPopup.action.installed':'Installed on',
  'installer.step3.hostWarningsPopup.action.running':'Running on',
  'installer.step3.hostWarningsPopup.action.invalid':'Invalid on',
  'installer.step3.hostWarningsPopup.action.failed':'Failed on',
  'installer.step3.hostWarningsPopup.action.enabled':'Enabled on',
  'installer.step3.hostWarningsPopup.host':'host',
  'installer.step3.hostWarningsPopup.hosts':'hosts',
  'installer.step3.hostWarningsPopup.moreHosts':'{0} more hosts...<br>Click on link to view all hosts.',
  'installer.step3.hostWarningsPopup.allHosts':'List of hosts',
  'installer.step3.hostWarningsPopup.rerunChecks':'Rerun Checks',
  'installer.step3.hostWarningsPopup.hostHasWarnings':'Host checks failed on some of your hosts. It is highly recommended that you fix these problems first before proceeding to prevent potentially major problems with cluster installation. Are you sure you want to ignore these warnings and proceed?',
  'installer.step3.hostWarningsPopup.hostHasWarnings.header':'Host Check Warning',
  'installer.step3.warningsWindow.allHosts':'Warnings across all hosts',
  'installer.step3.warningsWindow.warningsOn':'Warnings on ',
  'installer.step3.warningsWindow.directoriesAndFiles':'DIRECTORIES AND FILES',
  'installer.step3.warningsWindow.noWarnings':'No warnings',
  'installer.step3.hosts.noHosts':'No hosts to display',
  'installer.step3.warnings.popup.header':'Host Checks',
  'installer.step3.warnings.description':'Some warnings were encountered while performing checks against the above hosts.',
  'installer.step3.warnings.linkText':'Click here to see the warnings.',
  'installer.step3.noWarnings.linkText':'Click here to see the check results.',
  'installer.step3.warnings.noWarnings':'All host checks passed on {0} registered hosts.',
  'installer.step3.warnings.fails':'Some warnings were encountered while performing checks against the {0} registered hosts above',
  'installer.step3.warnings.someWarnings':'All host checks passed on {0} registered hosts. Note: Host checks were skipped on {1} hosts that failed to register.',
  'installer.step3.warnings.allFailed':'Host checks were skipped on {0} hosts that failed to register.',
  'installer.step3.warnings.updateChecks.success':'Host Checks successfully updated',
  'installer.step3.warnings.updateChecks.failed':'Host Checks update failed',
  'installer.step3.warnings.missingHosts':'There is no registered host',
  'installer.step3.warning.registeredHosts': '{0} Other Registered Hosts',
  'installer.step3.warning.loading':'Please wait while the hosts are being checked for potential problems...',
  'installer.step3.registeredHostsPopup': 'These are the hosts that have registered with the server, but do not appear in the list of hosts that you are adding.',
  'installer.step3.removeSelected':'Remove Selected',
  'installer.step3.retryFailed':'Retry Failed',
  'installer.step3.hosts.status.registering':'Registering',
  'installer.step3.hosts.status.installing':'Installing',
  'installer.step3.hosts.bootLog.failed':'\nRegistration with the server failed.',
  'installer.step3.hosts.bootLog.registering':'\nRegistering with the server...',
  'installer.step3.hostLogPopup.highlight':'click to highlight',
  'installer.step3.hostLogPopup.copy':'press CTRL+C',
  'installer.step3.hostsTable.selectAll':'Select All Hosts',
  'installer.step3.selectedHosts.popup.header':'Selected Hosts',

  'installer.step4.header':'Choose Services',
  'installer.step4.body':'Choose which services you want to install on your cluster.',
  'installer.step4.headerFS':'Choose File System',
  'installer.step4.bodyFS':'Choose which file system you want to install on your cluster.',
  'installer.step4.fsCheck.popup.header':'File System Required',
  'installer.step4.fsCheck.popup.body':'You did not select a File System but one is required. We will automatically add {0}. Is this OK?',
  'installer.step4.multipleDFS.popup.header':'Multiple File Systems Selected',
  'installer.step4.multipleDFS.popup.body':'You selected more than one file system. We will automatically select only {0}. Is this OK?',
  'installer.step4.serviceCheck.popup.header':'{0} Needed',
  'installer.step4.serviceCheck.popup.body':'You did not select {0}, but it is needed by other services you selected. We will automatically add {1}. Is this OK?',
  'installer.step4.serviceCheck.popup.body.multiOptions':'You did not select {0}, but it is needed by other services you selected. Select a compatible service from the following list: {1}',
  'installer.step4.hcfs.displayName':'a Hadoop Compatible File System',
  'installer.step4.limitedFunctionality.popup.header':'Limited Functionality Warning',
  'installer.step4.ambariMetricsCheck.popup.header': 'Ambari Metrics',
  'installer.step4.ambariMetricsCheck.popup.body':'Ambari Metrics collects metrics from the cluster and makes them available to Ambari.  If you do not install Ambari Metrics service, metrics will not be accessible from Ambari.  Are you sure you want to proceed without Ambari Metrics?',
  'installer.step4.ambariRangerInfraCheck.popup.header': 'Infra Solr',
  'installer.step4.ambariRangerInfraCheck.popup.body':'In order for Ranger to work, Solr is required. Either select Infra Solr to be added to the cluster, or ensure you configure your own during the Customize Services step.',
  'installer.step4.ambariAtlasInfraCheck.popup.header': 'Infra Solr',
  'installer.step4.ambariAtlasInfraCheck.popup.body':'In order for Atlas to work, Solr is required. Either select Infra Solr to be added to the cluster, or ensure you configure your own during the Customize Services step.',
  'installer.step4.ambariAtlasHbaseCheck.popup.header': 'HBase',
  'installer.step4.ambariAtlasHbaseCheck.popup.body':'In order for Atlas to work, HBase is required. Either select HBase to be added to the cluster, or ensure you configure your own during the Customize Services step.',
  'installer.step4.ambariLogsearchCheck.popup.header': 'Ambari Logsearch',
  'installer.step4.ambariLogsearchCheck.popup.body':'Since Ambari Infra is not selected, you must supply your own Solr to make Log Search work. Are you sure you want to proceed?',
  'installer.step4.smartSenseCheck.popup.header': 'Apache SmartSense',
  'installer.step4.smartSenseCheck.popup.body':'SmartSense securely collects cluster diagnostics in order to send you recommendations and automate analysis for ' +
  'troubleshooting support cases. If you choose not to install SmartSense, you will not receive any recommendations, and you ' +
  'will need to collect configuration and logs manually for troubleshooting support cases. ' +
  'Are you sure you want to proceed without SmartSense?',
  'installer.step4.rangerCheck.popup.header': 'Apache Ranger',
  'installer.step4.rangerCheck.popup.body':'Apache Ranger provides fine grained authorization and audit of access attempts for many Hadoop ecosystem services. If you do not install the Apache Ranger Service and enable Kerberos, the security of your cluster will be diminished. Are you sure you want to proceed without it? ',
  'installer.step4.atlasCheck.popup.header': 'Apache Atlas',
  'installer.step4.atlasCheck.popup.body':'Apache Atlas provides strong data governance, lineage and metadata management for many hadoop ecosystem services. If you do not install Apache Atlas service, the data governance capabilities of you cluster will be diminished. Are you sure you want to proceed without it? ',

  'installer.step4.rangerRequirements.popup.header': 'Ranger Requirements',
  'installer.step4.rangerRequirements.popup.body.requirements': '<ol><li>You must have an <strong>MySQL/Oracle/Postgres/MSSQL/SQL Anywhere Server</strong> database instance running to be used by Ranger.</li>' +
    '<li>In Assign Masters step of this wizard, you will be prompted to specify which host for the Ranger Admin. On that host, you <strong>must have DB Client installed</strong> for Ranger to access to the database. (Note: This is applicable for only Ranger 0.4.0)</li>' +
    '<li>Ensure that the access for the DB Admin user is enabled in DB server from any host.</li>' +
    '<li>Execute the following command on the Ambari Server host. Replace <code>database-type</code> with <strong>mysql|oracle|postgres|mssql|sqlanywhere</strong> and <code>/jdbc/driver/path</code> based on the location of corresponding JDBC driver:' +
    '<pre>ambari-server setup --jdbc-db={database-type} --jdbc-driver={/jdbc/driver/path}</pre></li></ol>',
  'installer.step4.rangerRequirements.popup.body.confirmation': 'I have met all the requirements above.',
  'installer.step4.sparkWarning.popup.body': 'Spark requires HDP 2.2.2 or later. Attempting to install Spark to a HDP 2.2.0 cluster will fail. Confirm you are using HDP 2.2.2 or later packages. Are you sure you want to proceed?',

  'installer.step5.header':'Assign Masters',
  'installer.step5.reassign.header':'Select Target Host',
  'installer.step5.attention':' hosts not running master services',
  'installer.step5.body':'Assign master components to hosts you want to run them on.',
  'installer.step5.body.coHostedComponents':'<i class="glyphicon glyphicon-asterisks">&#10037;</i> {0} will be hosted on the same host.',
  'installer.step5.hostInfo':'%@ (%@, %@ cores)',
  'installer.step5.hiveGroup':'HiveServer2, WebHCat Server, MySQL Server',
  'installer.step5.validationIssuesAttention.header': 'Validation Issues',
  'installer.step5.validationIssuesAttention': 'Master component assignments have issues that need attention.',
  'installer.step5.error.host.invalid': 'The host you choose could (1) have an invalid host name; (2) be conflicting with another selection; or (3) be in maintenance mode',

  'installer.step6.header':'Assign Slaves and Clients',
  'installer.step6.body':'Assign slave and client components to hosts you want to run them on.<br/>Hosts that are assigned master components are shown with <i class="glyphicon glyphicon-asterisks">&#10037;</i>.',
  'installer.step6.body.clientText': ' <br/>&quot;Client&quot; will install ',
  'installer.step6.error.mustSelectOne':'You must assign at least one host to each component.',
  'installer.step6.error.mustSelectOneForHost':'You must assign at least one slave/client component to each.',
  'installer.step6.error.mustSelectComponents': 'You must assign at least: {0}',
  'installer.step6.wizardStep6Host.title':'master components hosted on {0}',
  'installer.step6.addHostWizard.body':'Assign HBase master and ZooKeeper server.',
  'installer.step6.error.mustSelectOneForSlaveHost': 'You must assign at least one slave/client component to each host with no master component',
  'installer.step6.validationSlavesAndClients.click': 'Click',
  'installer.step6.validationSlavesAndClients.popup.body': 'Assignment of slave and client components has the following issues',
  'installer.step6.validationIssuesAttention.header': 'Validation Issues',
  'installer.step6.validationIssuesAttention': 'Slave and Client component assignments have issues that need attention.',

  'installer.step7.header':'Customize Services',
  'installer.step7.body':'We have come up with recommended configurations for the services you selected. Customize them as you see fit.',
  'installer.step7.credentialsTab.body':'Please provide credentials for these services',
  'installer.step7.databasesTab.body':'Please choose and configure the appropriate databases for these services',
  'installer.step7.databasesTab.radioButton.default':'Use Ambari Database',
  'installer.step7.databasesTab.radioButton.custom':'Use Custom Database',
  'installer.step7.credentialsTab.usersGroups':'Users/Groups',
  'installer.step7.credentialsTab.usernames':'Usernames',
  'installer.step7.accountsTab.body': 'Please review these settings for Service Accounts',
  'installer.step7.attentionNeeded':'<b>Attention:</b> Some configurations need your attention before you can proceed.',
  'installer.step7.noIssues':'All configurations have been addressed.',
  'installer.step7.showPropertiesWithIssues':'Show me properties with issues',
  'installer.step7.showingPropertiesWithIssues':'Showing properties with issues.',
  'installer.step7.showAllProperties':'Show all properties',
  'installer.step7.config.addProperty':'Add Property',
  'installer.step7.ConfigErrMsg.header':'Custom configuration error: ',
  'installer.step7.ConfigErrMsg.message':'Error in custom configuration. Some properties entered in the box are already exposed on this page',
  'installer.step7.popup.currentValue':'Current Value',
  'installer.step7.popup.adjustedValue':'Adjusted Value',
  'installer.step7.popup.rddWarning.header':'Warning: disk space low on {0}',
  'installer.step7.popup.rddWarning.body':'A minimum of 16GB is recommended for the Ganglia Server logs but the disk mount "{0}" on {1} does not have enough space ({2} free). Go to the Misc tab and change Ganglia rrdcached base directory with more than 16GB of disk space. If you proceed without changing it, {1} will likely run out of disk space and become inoperable.',
  'installer.step7.popup.mySQLWarning.header':'Error: New MySQL Database for Hive Conflict',
  'installer.step7.popup.mySQLWarning.body':'You cannot install a \"New MySQL Database\" for Hive on the same host as the Ambari Server MySQL Server. Please go back to <b>Assign Masters</b> and reassign Hive to another host <b>OR</b> choose \"Existing MySQL Database\" option to specify the Database Credentials and URL for the Ambari Server MySQL Server instance. If you choose \"Existing MySQL Database\" option, you need to perform the Hive prerequisite steps to prepare the MySQL Server instance for Hive.',
  'installer.step7.popup.mySQLWarning.button.gotostep5': 'Go to Assign Masters',
  'installer.step7.popup.mySQLWarning.button.dismiss': 'Dismiss',
  'installer.step7.popup.mySQLWarning.confirmation.header': 'Confirmation: Go to Assign Masters',
  'installer.step7.popup.mySQLWarning.confirmation.body': 'You will be brought back to the \"Assign Masters\" step and will lose all your current customizations. Are you sure?',
  'installer.step7.popup.database.connection.header': 'Database Connectivity Warning',
  'installer.step7.popup.database.connection.body': 'You have not run or passed the database connection test for: {0}. It is highly recommended that you pass the connection test before proceeding to prevent failures during deployment.',
  'installer.step7.popup.validation.failed.header': 'Consistency Check Failed',
  'installer.step7.popup.validation.failed.body': 'Some services are not properly configured. You have to change the highlighted configs according to the recommended values.',
  'installer.step7.popup.validation.request.failed.body': 'The configuration changes could not be validated for consistency due to an unknown error.  Your changes have not been saved yet.  Would you like to proceed and save the changes?',
  'installer.step7.popup.validation.warning.header': 'Configurations',
  'installer.step7.popup.validation.issues.title': 'Highly Recommended Configurations',
  'installer.step7.popup.validation.issues.body': 'Please review the folowing recommended changes, and click on the property name to change its value.',
  'installer.step7.popup.validation.criticalIssues.body': 'You must correct the following critical issues before proceeding:',
  'installer.step7.popup.oozie.derby.warning': 'Derby is not recommended for production use. With Derby, Oozie Server HA and concurrent connection support will not be available.',
  'installer.step7.oozie.database.new': 'New Derby Database',
  'installer.step7.hive.database.new.mysql': 'New MySQL Database',
  'installer.step7.hive.database.new.postgres': 'New PostgreSQL Database',
  'installer.step7.addWizard.notEditable': 'This configuration cannot be edited on Add Service wizard',
  'installer.step7.misc.notification.configure':'Configure email notifications',
  'installer.step7.misc.notification.configure.later':'Configure email notifications later',
  'installer.step7.misc.notification.use_tls':'Use TLS',
  'installer.step7.misc.notification.use_ssl':'Use SSL',

  'installer.step7.preInstallChecks':'Pre Install Checks',
  'installer.step7.preInstallChecks.notRunChecksWarnPopup.header':'Skipping Pre Install Checks',
  'installer.step7.preInstallChecks.notRunChecksWarnPopup.body':'Skipping Pre Install Checks is not recommended.',
  'installer.step7.preInstallChecks.notRunChecksWarnPopup.primary':'Ignore and Proceed',
  'installer.step7.preInstallChecks.notRunChecksWarnPopup.secondary':'Run Pre Install Checks',
  'installer.step7.preInstallChecks.checksPopup.header':'Pre Install Checks',


  'installer.step7.assign.master.body':'Assign <strong>{0}</strong> to {1} you want to run {2} on.',
  'installer.step7.assign.master.dependent.component.body':'If not present {0} will also be installed on the selected host. ',
  'installer.step7.missing.service.header':'Missing Service',
  'installer.step7.missing.service.body': '{0} service should be added to the cluster to {1}.',
  'assign.master.popup.header':'Select {0} host',
  'assign.master.popup.cancel.body':'Not selecting {0} host will disable interactive query.',
  'installer.step7.recommendations.popover.header': 'Review Recommendations',
  'installer.step7.recommendations.popover.message': '<p>Based on your configuration changes, Ambari is recommending the following dependent configuration changes. Ambari has updated all checked configuration changes to the <strong>Recommended Value</strong>. Uncheck any configuration to retain the <strong>Original Value</strong>.</p>',
  'installer.step7.requirements.popover.header': 'Required Configurations',
  'installer.step7.requirements.popover.message': '<p>The following properties must be set to proceed with the install.</p>',

  'installer.step8.header': 'Review',
  'installer.step8.body': 'Please review the configuration before installation',
  'installer.step8.kerberors.warning': '<strong>Because Kerberos has been manually installed on the cluster, you will have to create/distribute principals and keytabs when this operation is finished.</strong>',
  'installer.step8.generateBlueprint.popup.msg': 'You will be <b>downloading</b> blueprint.json and clustertemplate.json to your local machine. <br/><br/> You can use them to deploy a cluster via AMBARI REST API. <br/> Update clustertemplate.json with a custom cluster name if you do not want to use name <b>{0}</b>. <br/><br/>If you want to use custom repo URLs, make sure to update them via Ambari REST API before deploying the cluster.',
  'installer.step8.deployPopup.message':'Preparing to Deploy: {0} of {1} tasks completed.',
  'installer.step8.deployPopup.header':'Initializing Tasks',
  'installer.step8.hosts':' hosts',
  'installer.step8.host':' host',
  'installer.step8.other':'and {0} other hosts',
  'installer.step8.repoInfo.osType.redhat6':'RHEL 6/CentOS 6/Oracle Linux 6',
  'installer.step8.repoInfo.osType.redhat5':'RHEL 5/CentOS 5/Oracle Linux 5',
  'installer.step8.repoInfo.osType.sles11':'SLES 11/SUSE 11',
  'installer.step8.repoInfo.displayName':'Repositories',
  'installer.step8.services.restart.required': '{0} {1} will be restarted during installation.',
  'installer.step9.header':'Install, Start and Test',
  'installer.step9.body':'Please wait while the selected services are installed and started.',
  'installer.step9.status.success':'Successfully installed and started the services.',
  'installer.step9.status.skipStartSuccess':'Successfully installed the services.',
  'installer.step9.status.warning':'Installed and started the services with some warnings.',
  'installer.step9.status.failed':'Failed to install/start the services.',
  'installer.step9.status.start.services.failed':'Start all services API call failed.',
  'installer.step9.status.install.components.failed': 'Some service components are still not known to have installed successfully. Please Retry',
  'installer.step9.status.hosts.heartbeat_lost': 'Ambari agent is not running on {0} hosts.',
  'installer.step9.host.heartbeat_lost': 'Heartbeat lost for the host',
  'installer.step9.host.heartbeat_lost_popup': 'Ambari agent process is not heartbeating on the host',
  'installer.step9.host.heartbeat_lost.header' : 'Hosts with heartbeat lost',
  'installer.step9.host.status.success':'Success',
  'installer.step9.host.status.startAborted':'Install completed. Start aborted',
  'installer.step9.host.status.warning':'Warnings encountered',
  'installer.step9.host.status.failed':'Failures encountered',
  'installer.step9.host.status.nothingToInstall':'Install complete (Waiting to start)',
  'installer.step9.hosts.status.label.inProgress':'In Progress',
  'installer.step9.hosts.status.label.warning':'Warning',
  'installer.step9.hosts.filteredHostsInfo': '{0} of {1} hosts showing',
  'installer.step9.hostLog.popup.header':'Tasks. executed on ',
  'installer.step9.hostLog.popup.categories.all':'All',
  'installer.step9.hostLog.popup.categories.pending':'Queued / Pending',
  'installer.step9.hostLog.popup.categories.in_progress':'In Progress',
  'installer.step9.hostLog.popup.categories.failed':'Failed',
  'installer.step9.hostLog.popup.categories.completed':'Success',
  'installer.step9.hostLog.popup.categories.aborted':'Aborted',
  'installer.step9.hostLog.popup.categories.timedout':'Timed Out',
  'installer.step9.hostLog.popup.noTasksToShow':'No tasks to show',
  'installer.step9.host.status.noTasks': 'Ambari server did not schedule any tasks on the host. Either the service component on the host is already in installed state <b>OR</b> the pre-check of host reachability failed.',
  'installer.step9.overallProgress':'{0} % overall',
  'installer.step9.serviceStatus.install.pending':'Preparing to install ',
  'installer.step9.serviceStatus.install.queued':'Waiting to install ',
  'installer.step9.serviceStatus.install.inProgress':'Installing ',
  'installer.step9.serviceStatus.install.completed':'Successfully installed ',
  'installer.step9.serviceStatus.install.failed':'Failed to install ',
  'installer.step9.serviceStatus.uninstall.pending':'Preparing to uninstall ',
  'installer.step9.serviceStatus.uninstall.queued':'Waiting to uninstall ',
  'installer.step9.serviceStatus.uninstall.inProgress':'Uninstalling ',
  'installer.step9.serviceStatus.uninstall.completed':'Successfully uninstalled ',
  'installer.step9.serviceStatus.uninstall.failed':'Failed to uninstall ',
  'installer.step9.serviceStatus.start.pending':'Preparing to start ',
  'installer.step9.serviceStatus.start.queued':'Waiting to start ',
  'installer.step9.serviceStatus.start.inProgress':'Starting ',
  'installer.step9.serviceStatus.start.completed':' started successfully',
  'installer.step9.serviceStatus.start.failed':' failed to start',
  'installer.step9.serviceStatus.stop.pending':'Preparing to stop ',
  'installer.step9.serviceStatus.stop.queued':'Waiting to stop ',
  'installer.step9.serviceStatus.stop.inProgress':'Stopping ',
  'installer.step9.serviceStatus.stop.completed':' stopped successfully',
  'installer.step9.serviceStatus.stop.failed':' failed to stop',
  'installer.step9.serviceStatus.execute.pending':'Preparing to execute ',
  'installer.step9.serviceStatus.execute.queued':'Waiting to execute ',
  'installer.step9.serviceStatus.execute.inProgress':'Executing ',
  'installer.step9.serviceStatus.execute.completed':' executed successfully',
  'installer.step9.serviceStatus.execute.failed':' failed to execute',
  'installer.step9.serviceStatus.abort.pending':'Preparing to abort ',
  'installer.step9.serviceStatus.abort.queued':'Waiting to abort ',
  'installer.step9.serviceStatus.abort.inProgress':'Aborting ',
  'installer.step9.serviceStatus.abort.completed':' aborted successfully',
  'installer.step9.serviceStatus.abort.failed':' failed to abort',
  'installer.step9.components.install.failed': 'Installation Failure',
  'installer.step9.service.start.failed': 'There were issues starting installed services. Please go to individual service pages to start them.',
  'installer.step9.service.start.header': 'Start Services',

  'installer.step10.header':'Summary',
  'installer.step10.body':'Here is the summary of the install process.',
  'installer.step10.staleServicesRestartRequired':' After closing this wizard, please restart all services ' +
  'that have the restart indicator <i class="glyphicon glyphicon-refresh"></i> next to the service name.',
  'installer.step10.hostsSummary':'The cluster consists of {0} hosts',
  'installer.step10.installedAndStarted':'Installed and started services successfully on {0} new ',
  'installer.step10.installed':'Installed services successfully on {0} new ',
  'installer.step10.warnings':' warnings',
  'installer.step10.clusterState.installing':'Installing ',
  'installer.step10.clusterState.starting':'Starting ',
  'installer.step10.taskStatus.failed':' failed on ',
  'installer.step10.taskStatus.aborted':' aborted on ',
  'installer.step10.taskStatus.timedOut':' timed out on ',
  'installer.step10.installStatus.failed':'Installing master services failed',
  'installer.step10.installStatus.installed':'Master services installed',
  'installer.step10.master.installedOn':'{0} installed on {1}',
  'installer.step10.startStatus.failed':'Starting services failed',
  'installer.step10.startStatus.skipped':'Starting services skipped',
  'installer.step10.startStatus.passed':'All tests passed',
  'installer.step10.startStatus.started':'All services started',
  'installer.step10.installTime.seconds':'Install and start completed in {0} seconds',
  'installer.step10.installTime.minutes':'Install and start completed in {0} minutes and {1} seconds',

  'addHost.step4.header':'Configurations',
  'addHost.step4.title':'Select the configuration groups to which the added hosts will belong to.',

  'form.create':'Create',
  'form.save':'Save',
  'form.cancel':'Cancel',
  'form.passwordRetype':'Retype Password',
  'form.saveSuccess':'Successfully saved.',
  'form.saveError':'Sorry, errors occurred.',
  'form.item.placeholders.typePassword':'Type password',

  'form.validator.invalidIp':'Please enter valid ip address',
  'form.validator.configKey':'Invalid Key. Only alphanumerics, hyphens, underscores, asterisks and periods are allowed.',
  'form.validator.configGroupName':'Invalid Group Name. Only alphanumerics, hyphens, spaces and underscores are allowed.',
  'form.validator.alertGroupName':'Invalid Alert Group Name. Only alphanumerics, hyphens, spaces and underscores are allowed.',
  'form.validator.alertNotificationName':'Invalid Alert Notification Name. Only alphanumerics, hyphens, spaces and underscores are allowed.',
  'form.validator.configKey.specific':'"{0}" is invalid Key. Only alphanumerics, hyphens, underscores, asterisks and periods are allowed.',

  'alerts.dropdown.dialog.title': 'Notifications',
  'alerts.dropdown.dialog.filters.critical': 'Critical ({0})',
  'alerts.dropdown.dialog.filters.warning': 'Warning ({0})',
  'alerts.dropdown.dialog.filters.all': 'All ({0})',

  'alerts.add.header': 'Create Alert',
  'alerts.add.step1.header': 'Choose Alert Type',
  'alerts.add.step1.header.description': 'Select the type of alert you want to create',
  'alerts.add.step2.header': 'Define Alert',
  'alerts.add.step3.header': 'Specify Threshold',
  'alerts.add.step3.selectedType': 'Selected Type',

  'alerts.add.wizard.step1.body.choose.tooltip': 'Click to select',
  'alerts.add.wizard.step1.body.port.description':'Check TCP connectivity to a remote endpoint',
  'alerts.add.wizard.step1.body.web.description':'Check for TCP connectivity and verify that a proper HTTP response code was returned',
  'alerts.add.wizard.step1.body.metric.description':'Define JMX/AMS endpoints that can be queried for values',
  'alerts.add.wizard.step1.body.script.description':'Defer all functionality to a Python script accessible to the Ambari agents from a specified relative or absolute path',
  'alerts.add.wizard.step1.body.aggregate.description':'Combine the results of another alert definition from different nodes',
  'alerts.add.wizard.step1.body.raw.description':'User can upload alert parameter using a JSON script',

  'alerts.fastAccess.popup.header': '{0} Critical or Warning Alerts',
  'alerts.fastAccess.popup.body.name': 'Alert Definition Name',
  'alerts.fastAccess.popup.body.showmore': 'Go to Alerts Definitions',
  'alerts.fastAccess.popup.body.noalerts': 'No critical or warning alerts to display',

  'alerts.actions.create': 'Create Alert',
  'alerts.actions.manageGroups': 'Manage Alert Groups',
  'alerts.actions.manageNotifications': 'Manage Notifications',
  'alerts.actions.manageNotifications.info': 'You can manage notification methods and recipients.',
  'alerts.actions.editRepeatTolerance.header': 'Edit Alert Check Count',
  'alerts.actions.editRepeatTolerance.title': 'Alert Check Counts',
  'alerts.actions.editRepeatTolerance.description': 'Set the number of alert checks to perform before dispatching a notification. ' +
    'If during an alert check a state change occurs, Ambari will attempt to check this number of times before dispatching a notification. ' +
    'Increase this number if your environment experiences transient issues resulting in false alerts.',
  'alerts.actions.editRepeatTolerance.label': 'Check Count:',
  'alerts.actions.editRepeatTolerance.error':'Input should be an integer between 1 and 99.',
  'alerts.actions.manageSettings': 'Manage Alert Settings',
  'alerts.actions.manageSettings.error':'Error during remote command: ',

  'alerts.groups.successPopup.header': 'Alert Groups processing results',
  'alerts.groups.successPopup.body.created': 'New Alert Groups',
  'alerts.groups.successPopup.body.updated': 'Updated Alert Groups',
  'alerts.groups.successPopup.body.deleted': 'Removed Alert Groups',

  'alerts.table.noAlerts': 'No Alerts to display',
  'alerts.table.header.lastTriggered': 'Last Status Changed',
  'alerts.table.header.lastChecked': 'Last Checked',
  'alerts.table.header.lastTrigger': 'Last Changed',
  'alerts.table.header.check.response': 'Response',
  'alerts.table.header.definitionName': 'Alert Definition Name',
  'alerts.table.header.notification': 'Notification',
  'alerts.table.header.repeatTolerance': 'Check Count',
  'alerts.table.header.default': '(default)',
  'alerts.table.header.helpUrl': 'Alert Context',
  'alerts.table.state': 'State',
  'alerts.table.state.enabled': 'Enabled',
  'alerts.table.state.disabled': 'Disabled',
  'alerts.table.state.enabled.tooltip': 'Click to disable this alert definition',
  'alerts.table.state.disabled.tooltip': 'Click to enable this alert definition',
  'alerts.table.state.enabled.confirm.msg': 'You are about to Disable this alert definition.',
  'alerts.table.state.disabled.confirm.msg': 'You are about to Enable this alert definition.',
  'alerts.table.state.enabled.confirm.btn': 'Confirm Disable',
  'alerts.table.state.disabled.confirm.btn': 'Confirm Enable',
  'alerts.filters.filteredAlertsInfo': '{0} of {1} definitions showing',
  'alerts.definition.name': 'Alert Definition Name',
  'alerts.saveChanges': 'You have unsaved changes',

  'alert.definition.name.invalid': 'Invalid input. Only alphanumerics, underscores, hyphens, percentage, brackets and spaces are allowed. Value should be less than 255 symbols.',
  'alerts.definition.details.enable': 'Enable',
  'alerts.definition.details.disable': 'Disable',
  'alerts.definition.details.enableDisable': 'Enable / Disable',
  'alerts.definition.details.groups': 'Groups',
  'alerts.definition.details.instances': 'Instances',
  'alerts.definition.details.serviceHost': 'Service / Host',
  'alerts.definition.details.24-hour': '24-Hour',
  'alerts.definition.details.notification': 'Notification',
  'alerts.definition.details.noAlerts': 'No alert instances to display',
  'alerts.definition.details.configs.thresholdsErrorMsg': 'Critical threshold should be larger than warning threshold',
  'alerts.definition.details.infoSection': 'Alert Info',

  'alerts.notifications.error.email': 'Must be a valid email address',
  'alerts.notifications.error.integer': 'Must be an integer',
  'alerts.notifications.error.host': 'Hosts must be a valid Fully Qualified Domain Name (FQDN)',

  'alerts.notifications.error.SMTPUsername': 'Username is required',
  'alerts.notifications.error.SMTPPassword': 'Password is required',
  'alerts.notifications.error.retypePassword': 'Password confirmation must match password',

  'alerts.notifications.addCustomPropertyPopup.header': 'Add Property',
  'alerts.notifications.addCustomPropertyPopup.error.propertyExists': 'Custom Property with current name already exists',
  'alerts.notifications.addCustomPropertyPopup.error.invalidPropertyName': 'Property name can only contain letters, numbers or . -_* characters',
  'alerts.notifications.regenerateKeytab.service.error' : 'Keytabs for {0} service could not be regenerated',
  'alerts.notifications.regenerateKeytab.host.error' : 'Keytabs for {0} host could not be regenerated',


  'wizard.progressPage.notice.completed':'Please proceed to the next step.',
  'wizard.progressPage.notice.failed':'You can click on the Retry button to retry failed tasks.',
  'wizard.singleRequest.progressPage.notice.failed': 'Please click on the Retry link to retry the failed request.',

  'admin.advanced.caution':'This section is for advanced user only.<br/>Proceed with caution.',
  'admin.advanced.button.uninstallIncludingData':'Uninstall cluster including all data.',
  'admin.advanced.button.uninstallKeepData':'Uninstall cluster but keep data.',

  'admin.advanced.popup.header':'Uninstall Cluster',

  /*'admin.advanced.popup.text':'Uninstall Cluster',*/

  'admin.audit.grid.date':"Date/Time",
  'admin.audit.grid.category':"Category",
  'admin.audit.grid.operationName':"Operation",
  'admin.audit.grid.performedBy':"Performed By",
  'admin.audit.grid.service':"Category",

  'admin.authentication.form.method.database':'Use Ambari Database to authenticate users',
  'admin.authentication.form.method.ldap':'Use LDAP/Active Directory to authenticate',
  'admin.authentication.form.primaryServer':'Primary Server',
  'admin.authentication.form.secondaryServer':'Secondary Server',
  'admin.authentication.form.useSsl':'Use SSL',
  'admin.authentication.form.bind.anonymously':"Bind Anonymously",
  'admin.authentication.form.bind.useCrenedtials':"Use Credentials To Bind",
  'admin.authentication.form.bindUserDN':'Bind User DN',
  'admin.authentication.form.searchBaseDN':'Search Base DN',
  'admin.authentication.form.usernameAttribute':'Username Attribute',

  'admin.authentication.form.userDN':'User DN',
  'admin.authentication.form.configurationTest':'Configuration Test',
  'admin.authentication.form.testConfiguration':'Test Configuration',

  'admin.authentication.form.test.success':'The configuration passes the test',
  'admin.authentication.form.test.fail':'The configuration fails the test',


  'admin.kerberos.credentials.store.hint.supported': 'When checked, Ambari will store the KDC Admin credentials so they are not required to be re-entered during future changes of services, hosts, and components.',
  'admin.kerberos.credentials.store.hint.not.supported': 'Ambari is not configured for storing credentials',
  'admin.kerberos.credentials.store.label': 'Save Admin Credentials',
  'admin.kerberos.credentials.store.menu.label': 'Manage KDC Credentials',
  'admin.kerberos.credentials.form.header.stored': 'Update or remove the stored KDC Credentials in the encrypted credential store.',
  'admin.kerberos.credentials.form.header.not.stored': 'Specify the KDC Admin Credentials to remember in the encrypted credential store.',
  'admin.kerberos.credentials.remove.confirmation.header': 'Remove KDC Credentials Confirmation',
  'admin.kerberos.credentials.remove.confirmation.body': 'You are about to remove the KDC Credentials from Ambari. Are you sure?',
  'admin.kerberos.wizard.configuration.note': 'This is the initial configuration created by Enable Kerberos wizard.',
  'admin.kerberos.wizard.header':'Enable Kerberos Wizard',
  'admin.kerberos.button.enable': 'Enable Kerberos',
  'admin.kerberos.button.disable': 'Disable Kerberos',
  'admin.kerberos.button.regenerateKeytabs': 'Regenerate Keytabs',
  'admin.kerberos.wizard.exit.warning.msg': 'Configuring Kerberos is in progress. Do you really want to exit the Enable Kerberos Wizard?',
  'admin.kerberos.wizard.exit.critical.msg': 'Configuring Kerberos is in progress. <strong>Before dismissing, you should complete the wizard.</strong> Do you really want to exit the Enable Kerberos Wizard?',
  'admin.kerberos.wizard.step1.header': 'Get Started',
  'admin.kerberos.wizard.step2.header': 'Configure Kerberos',
  'admin.kerberos.wizard.step3.header': 'Install and Test Kerberos Client',
  'admin.kerberos.wizard.step3.checkbox.ignoreAndProceed.label': 'Ignore errors and continue to next step',
  'admin.kerberos.wizard.step4.header': 'Configure Identities',
  'admin.kerberos.wizard.step5.header': 'Confirm Configuration',
  'admin.kerberos.wizard.step6.header': 'Stop Services',
  'admin.kerberos.wizard.step7.header': 'Kerberize Cluster',
  'admin.kerberos.wizard.step8.header': 'Start and Test Services',
  'admin.kerberos.wizard.step1.info.body': 'Welcome to the Ambari Security Wizard. Use this wizard to enable kerberos security in your cluster. </br>Let\'s get started.',
  'admin.kerberos.wizard.step1.alert.body': 'Note: This process requires services to be restarted and cluster downtime. As well, depending on the options you select, might require support from your Security administrators. Please plan accordingly.',
  'admin.kerberos.wizard.step1.body.text': 'What type of KDC do you plan on using?',
  'admin.kerberos.wizard.step1.option.kdc': 'Existing MIT KDC',
  'admin.kerberos.wizard.step1.option.kdc.condition.1': 'Ambari Server and cluster hosts have network access to both the KDC and KDC admin hosts.',
  'admin.kerberos.wizard.step1.option.kdc.condition.2': 'KDC administrative credentials are on-hand.',
  'admin.kerberos.wizard.step1.option.kdc.condition.3': 'The Java Cryptography Extensions (JCE) have been setup on the Ambari Server host and all hosts in the cluster.',
  'admin.kerberos.wizard.step1.option.kdc.condition.4': 'The Isilon administrator has setup all appropriate principals in OneFS',
  'admin.kerberos.wizard.step1.option.manual': 'Manage Kerberos principals and keytabs manually',
  'admin.kerberos.wizard.step1.option.manual.condition.1': 'Cluster hosts have network access to the KDC',
  'admin.kerberos.wizard.step1.option.manual.condition.2': 'Kerberos client utilities (such as kinit) have been installed on every cluster host',
  'admin.kerberos.wizard.step1.option.manual.condition.3': 'The Java Cryptography Extensions (JCE) have been setup on the Ambari Server host and all hosts in the cluster',
  'admin.kerberos.wizard.step1.option.manual.condition.4': 'The Service and Ambari Principals will be manually created in the KDC before completing this wizard',
  'admin.kerberos.wizard.step1.option.manual.condition.5': 'The keytabs for the Service and Ambari Principals will be manually created and distributed to cluster hosts before completing this wizard',
  'admin.kerberos.wizard.step1.option.ad': 'Existing Active Directory',
  'admin.kerberos.wizard.step1.option.ad.condition.1': 'Ambari Server and cluster hosts have network access to the Domain Controllers.',
  'admin.kerberos.wizard.step1.option.ad.condition.2': 'Active Directory secure LDAP (LDAPS) connectivity has been configured.',
  'admin.kerberos.wizard.step1.option.ad.condition.3': 'Active Directory User container for principals has been created and is on-hand (e.g. OU=Hadoop,OU=People,dc=apache,dc=org)',
  'admin.kerberos.wizard.step1.option.ad.condition.4': 'Active Directory administrative credentials with delegated control of “Create, delete, and manage user accounts” on the previously mentioned User container are on-hand.',
  'admin.kerberos.wizard.step1.option.ad.condition.5': 'The Java Cryptography Extensions (JCE) have been setup on the Ambari Server host and all hosts in the cluster.',
  'admin.kerberos.wizard.step1.option.ipa': 'Existing IPA',
  'admin.kerberos.wizard.step1.option.ipa.condition.1': 'All cluster hosts are joined to the IPA domain and hosts are registered in DNS',
  'admin.kerberos.wizard.step1.option.ipa.condition.2': 'A password policy is in place that sets no expiry for created principals',
  'admin.kerberos.wizard.step1.option.ipa.condition.3': 'If you do not plan on using Ambari to manage the krb5.conf, ensure the following is set in each krb5.conf file in your cluster: default_ccache_name = /tmp/krb5cc_%{uid}',
  'admin.kerberos.wizard.step1.option.ipa.condition.4': 'The Java Cryptography Extensions (JCE) have been setup on the Ambari Server host and all hosts in the cluster.',
  'admin.kerberos.wizard.step1.prerequisites.label': 'Following prerequisites needs to be checked to progress ahead in the wizard.',
  'admin.kerberos.wizard.step2.info.body': 'Please configure kerberos related properties.',
  'admin.kerberos.wizard.step3.task0.title': 'Install Kerberos Client',
  'admin.kerberos.wizard.step3.task1.title': 'Test Kerberos Client',
  'admin.kerberos.wizard.step3.notice.inProgress': 'Please wait while the Kerberos clients are being installed and tested.',
  'admin.kerberos.wizard.step3.notice.completed': 'Kerberos service has been installed and tested successfully.',
  'admin.kerberos.wizard.progressPage.notice.inProgress': 'Please wait while cluster is being kerberized',
  'admin.kerberos.wizard.step4.info.body': 'Configure principal name and keytab location for service users and hadoop service components.',
  'admin.kerberos.wizard.step5.info.body': 'Please review the configuration before continuing the setup process',
  'admin.kerberos.wizard.step5.moreInfoNonManual.body': 'Using the <b>Download CSV button</b>, you can download a csv file which contains a list of the principals and keytabs that will automatically be created by Ambari.',
  'admin.kerberos.wizard.step5.moreInfoManual.body': 'Important: Use the <b>Download CSV</b> button to obtain a list of the <b>required</b> principals and keytabs that are needed by Ambari to enable Kerberos in the cluster. <b>Do not proceed</b> until you have manually created and distributed the principals and keytabs to the cluster hosts.',
  'admin.kerberos.wizard.step5.kdc_type.label': 'KDC Type',
  'admin.kerberos.wizard.step5.kdc_hosts.label': 'KDC Hosts',
  'admin.kerberos.wizard.step5.realm.label': 'Realm Name',
  'admin.kerberos.wizard.step5.ldap_url.label': 'LDAP URL',
  'admin.kerberos.wizard.step5.container_dn.label': 'Container DN',
  'admin.kerberos.wizard.step5.executable_search_paths.label': 'Executable path',
  'admin.kerberos.wizard.step5.exitWizard': 'Exit Wizard',
  'admin.kerberos.wizard.step5.downloadCSV': 'Download CSV',
  'admin.kerberos.wizard.step5.group.label': 'Group user principals should be member of',
  'admin.kerberos.wizard.step6.task0.title' : 'Stop Services',
  'admin.kerberos.wizard.step6.task1.title' : 'Delete ATS',
  'admin.kerberos.wizard.step6.notice.inProgress': 'Please wait while services are being stopped.',
  'admin.kerberos.wizard.step6.notice.completed': 'Services have been successfully stopped.',
  'admin.kerberos.wizard.step7.notice.inProgress': 'Please wait while cluster is being kerberized.',
  'admin.kerberos.wizard.step7.notice.completed': 'Kerberos has successfully been enabled on the cluster.',
  'admin.kerberos.wizard.step8.notice.inProgress': 'Please wait while services are being started and tested.',
  'admin.kerberos.wizard.step8.notice.completed': 'Services have been successfully tested with kerberos environment.',
  'admin.kerberos.wizard.step8.notice.failed': 'Some services failed to start and execute tests successfully. Click Retry to attempt again or click Complete to dismiss the wizard and fix manually.',
  'admin.kerberos.wizard.step8.task0.title' : 'Start and Test Services',

  'admin.kerberos.regenerate_keytabs.popup.body': 'Regenerating keytabs for <strong>all</strong> hosts in the cluster is a disruptive operation, and requires all components to be restarted. Optionally, keytabs can be regenerated <strong>only</strong> for missing hosts and components, and this operation requires selectively restarting those affected hosts and services.',
  'admin.kerberos.regenerate_keytabs.checkbox.label': ' Only regenerate keytabs for missing hosts and components',
  'admin.kerberos.regenerate_keytabs.popup.restart.body': 'After keytab regenerate is complete, services relying on them <strong>must</strong> be restarted. This can be done automatically, or manually.',
  'admin.kerberos.regenerate_keytabs.checkbox.restart.label': 'Automatically restart components after keytab regeneration',
  'admin.kerberos.service.alert.yarn': 'YARN log and local dir will be deleted and ResourceManager state will be formatted as part of Enabling/Disabling Kerberos.',

  'admin.kerberos.disable.step1.task0.title': 'Start ZooKeeper',
  'admin.kerberos.disable.step1.task1.title': 'Stop Required Services',
  'admin.kerberos.disable.step1.task2.title': 'Unkerberize Cluster',
  'admin.kerberos.disable.step1.task3.title': 'Remove Kerberos',
  'admin.kerberos.disable.step1.task4.title': 'Start Services',

  'admin.kerberos.disable.unkerberize.header': 'Unkerberize cluster',
  'admin.kerberos.disable.unkerberize.message': 'You cannot quit wizard while cluster is being unkerberized',
  'admin.kerberos.disable.inProgress': 'Please wait while cluster is being unkerberized',
  'admin.kerberos.disable.notice.completed': 'Services have been successfully tested without kerberos environment.',
  'admin.kerberos.wizard.step1.notice.inProgress': 'Please wait while cluster is being unkerberized',

  'admin.manageJournalNode.label': 'Manage JournalNodes',
  'admin.manageJournalNode.warning': 'Manage JournalNodes Wizard requires all NameNodes be started and have Active/Standby state defined',
  'admin.manageJournalNode.wizard.header': 'Manage JournalNodes Wizard',
  'admin.manageJournalNode.wizard.step1.header': 'Assign JournalNodes',
  'admin.manageJournalNode.wizard.step2.header': 'Review',
  'admin.manageJournalNode.wizard.step3.header': 'Save Namespace',
  'admin.manageJournalNode.wizard.step4.header': 'Add/Remove JournalNodes',
  'admin.manageJournalNode.wizard.step5.header': 'Copy JournalNode directories',
  'admin.manageJournalNode.wizard.step6.header': 'Start JournalNodes',
  'admin.manageJournalNode.wizard.step7.header': 'Start All Services',

  'admin.manageJournalNode.wizard.step1.body': 'Add, or Remove JournalNodes',
  'admin.manageJournalNode.wizard.step3.confirm.hosts.body': '<b>Confirm your host selections.</b>',
  'admin.manageJournalNode.wizard.step3.confirm.config.body': '<p><b>Review Configuration Changes.</b></p>' +
  'As part of this process, configuration changes are required. Please review the changes below, and note that they are for <b>review only</b>.  Future steps in this wizard will update this configuration, and restart <b>all</b> services automatically.',

  'admin.manageJournalNode.wizard.step4.task0.title' : 'Stop Standby NameNode',
  'admin.manageJournalNode.wizard.step4.task1.title': 'Stop Services',
  'admin.manageJournalNode.wizard.step4.task2.title': 'Add JournalNodes',
  'admin.manageJournalNode.wizard.step4.task3.title': 'Delete JournalNodes',
  'admin.manageJournalNode.wizard.step4.task4.title': 'Reconfigure HDFS',
  'admin.manageJournalNode.wizard.step6.task0.title': 'Start JournalNodes',
  'admin.manageJournalNode.wizard.step7.task0.title': 'Start All Services',


  'admin.manageJournalNode.wizard.step5.bodyHeader': 'Manual Steps Required: Copy JournalNode directories',


  'admin.manageJournalNode.step4.save.configuration.note' : 'This configuration is created by Manage JournalNode Wizard',

  'admin.manageJournalNode.wizard.progressPage.notice.inProgress': 'Please wait while JournalNodes are being deployed',
  'admin.manageJournalNode.wizard.step4.notice.inProgress': 'Please wait while JournalNodes are being deployed',
  'admin.manageJournalNode.wizard.step6.notice.inProgress': 'Please wait while JournalNodes are started',
  'admin.manageJournalNode.wizard.step7.notice.inProgress': 'Please wait while services are started',
  'admin.manageJournalNode.wizard.step7.notice.completed':'Completed update to JournalNodes.',

  'admin.manageJournalNode.wizard.step3.error.multipleNameSpaces.nameNodes': 'Some NameNodes are in the process of being stopped. Please make sure that NameNodes are running to create checkpoints successfully.',
  'admin.manageJournalNode.wizard.step3.body.singleNameSpace.safeModeText': 'Put the NameNode in Safe Mode (read-only mode)',
  'admin.manageJournalNode.wizard.step3.body.multipleNameSpaces.safeModeText': 'Put the NameNodes in Safe Mode (read-only mode)',
  'admin.manageJournalNode.wizard.step3.body.singleNameSpace.safeModeCommand': 'sudo su {0} -l -c \'hdfs dfsadmin -safemode enter\'',
  'admin.manageJournalNode.wizard.step3.body.multipleNameSpaces.safeModeCommand': 'sudo su {0} -l -c \'hdfs dfsadmin -fs hdfs://{1} -safemode enter\'',
  'admin.manageJournalNode.wizard.step3.body.singleNameSpace.checkPointText': 'Once in Safe Mode, create a Checkpoint',
  'admin.manageJournalNode.wizard.step3.body.multipleNameSpaces.checkPointText': 'Once in Safe Mode, create Checkpoints',
  'admin.manageJournalNode.wizard.step3.body.singleNameSpace.checkPointCommand': 'sudo su {0} -l -c \'hdfs dfsadmin -saveNamespace\'',
  'admin.manageJournalNode.wizard.step3.body.multipleNameSpaces.checkPointCommand': 'sudo su {0} -l -c \'hdfs dfsadmin -fs hdfs://{1} -saveNamespace\'',
  'admin.manageJournalNode.wizard.step3.body.singleNameSpace.proceed': 'You will be able to proceed once Ambari detects that the NameNode is in Safe Mode and the Checkpoint has been created successfully.',
  'admin.manageJournalNode.wizard.step3.body.multipleNameSpaces.proceed': 'You will be able to proceed once Ambari detects that the NameNodes are in Safe Mode and the Checkpoints have been created successfully.',
  'admin.manageJournalNode.wizard.step3.body.singleNameSpace.recentCheckPoint': 'If the <b>Next</b> button is enabled before you run the <b>"Step 3: Save Namespace"</b> command, it means there is a recent Checkpoint already and you may proceed without running the <b>"Step 3: Save Namespace"</b> command.',
  'admin.manageJournalNode.wizard.step3.body.multipleNameSpaces.recentCheckPoint': 'If the <b>Next</b> button is enabled before you run the <b>"Step 3: Save Namespace"</b> commands, it means there are recent Checkpoints already and you may proceed without running the <b>"Step 3: Save Namespace"</b> commands.',
  'admin.manageJournalNode.wizard.step3.body':
  '<ol>' +
  '<li>Login to the NameNode host <b>{0}</b>.</li>' +
  '<li>{1}:' +
  '<div class="code-snippet">{2}</div></li>' +
  '<li>{3}:' +
  '<div class="code-snippet">{4}</div></li>' +
  '<li>{5}</li>'+
  '<div class="alert alert-warn">{6}</div>' +
  '</ol>',
  'admin.manageJournalNode.wizard.step3.checkPointsNotCreated': 'Checkpoints not created yet',
  'admin.manageJournalNode.wizard.step3.checkPointsCreated': 'Checkpoints created',

  'admin.manageJournalNode.wizard.step5.body':
  '<ol>' +
  '<li>Login to the JournalNode host <b>{0}</b>.</li>' +
  '<li>Create a tarball of the Journal directories: {1}.</li>' +
  '<li>Copy the tarball on the new JournalNodes and untar at the respective locations as in Step 2.</li>' +
  '</ol>',

  'admin.highAvailability':' High Availability',
  'admin.highAvailability.button.enable':'Enable NameNode HA',
  'admin.highAvailability.button.disable':'Disable NameNode HA',
  'admin.rm_highAvailability.button.enable':'Enable ResourceManager HA',
  'admin.rm_highAvailability.button.disable':'Disable ResourceManager HA',
  'admin.ra_highAvailability.button.enable':'Enable Ranger Admin HA',
  'admin.highAvailability.disabled':'NameNode HA is disabled',
  'admin.highAvailability.enabled':'NameNode HA is enabled',
  'admin.rm_highAvailability.disabled':'ResourceManager HA is disabled',
  'admin.rm_highAvailability.enabled':'ResourceManager HA is enabled',
  'admin.highAvailability.confirmRollbackHeader':'Confirm Rollback',
  'admin.highAvailability.confirmRollbackBody':'This will rollback all operations that were done in HA wizard',
  'admin.highAvailability.confirmManualRollbackBody':'You are in the process of enabling NameNode HA. If you exit now, you must follow manual instructions to revert back to the non-HA setup as documented in the Ambari User Guide\'s <i>Rolling Back NameNode HA</i> section.  Are you sure you want to exit the wizard?',
  'admin.highAvailability.error.hostsNum':'You must have at least 3 hosts in your cluster to enable NameNode HA.',
  'admin.highAvailability.error.namenodeStarted':'NameNode must be running before you enable NameNode HA.',
  'admin.highAvailability.error.maintenanceMode':'In order to enable NameNode HA, all services, and hosts with master components need to be out of Maintenance Mode.',
  'admin.highAvailability.error.zooKeeperNum':'You must have at least 3 ZooKeeper Servers in your cluster to enable NameNode HA.',
  'admin.rm_highAvailability.error.hostsNum':'You must have at least 3 hosts in your cluster to enable ResourceManager HA.',
  'admin.rm_highAvailability.error.zooKeeperNum':'You must have at least 3 ZooKeeper Servers in your cluster to enable ResourceManager HA.',
  'admin.rm_highAvailability.error.resourceManagerStarted':'ResourceManager must be running before you enable ResourceManager HA.',
  'admin.rm_highAvailability.closePopup':'Enable ResourceManager HA Wizard is in progress. You must allow the wizard to complete for Ambari to be in usable state. If you choose to quit, you must follow manual instructions to complete or revert enabling ResourceManager HA as documented in the Ambari User Guide. Are you sure you want to exit the wizard?',

  'admin.highAvailability.wizard.header':'Enable NameNode HA Wizard',
  'admin.highAvailability.wizard.progressPage.notice.inProgress':'Please wait while NameNode HA is being deployed.',
  'admin.highAvailability.wizard.progressPage.header':'Deploy',
  'admin.highAvailability.wizard.step1.header':'Get Started',
  'admin.highAvailability.wizard.step1.nameserviceid.tooltip.title':'Nameservice ID',
  'admin.highAvailability.wizard.step1.nameserviceid.tooltip.content':'This will be the ID for the NameNode HA cluster. For example, if you set Nameservice ID to <b>mycluster</b>, the logical URI for HDFS will be <b>hdfs://mycluster</b>.',
  'admin.highAvailability.wizard.step1.nameserviceid':'Nameservice ID',
  'admin.highAvailability.wizard.step1.nameserviceid.error':'Must consist of letters, numbers, and hyphens. Cannot begin or end with a hyphen.',
  'admin.highAvailability.wizard.step2.header':'Select Hosts',
  'admin.highAvailability.wizard.step3.header':'Review',
  'admin.highAvailability.wizard.step4.header':'Create Checkpoint',
  'admin.highAvailability.wizard.step4.error.nameNode':'NameNode is in the process of being stopped. Please make sure that NameNode is running to create checkpoint successfully.',
  'admin.highAvailability.wizard.step5.header':'Configure Components',
  'admin.highAvailability.wizard.step6.header':'Initialize JournalNodes',
  'admin.highAvailability.wizard.step7.header':'Start Components',
  'admin.highAvailability.wizard.step8.header':'Initialize Metadata',
  'admin.highAvailability.wizard.step9.header':'Finalize HA Setup',
  'admin.highAvailability.wizard.step4.bodyHeader':'Manual Steps Required: Create Checkpoint on NameNode',
  'admin.highAvailability.wizard.step6.bodyHeader':'Manual Steps Required: Initialize JournalNodes',
  'admin.highAvailability.wizard.step8.bodyHeader':'Manual Steps Required: Initialize NameNode HA Metadata',

  'admin.rollbackHighAvailability.wizard.step1.header':'Select Hosts page',
  'admin.rollbackHighAvailability.wizard.step2.header':'Create Checkpoint page',
  'admin.rollbackHighAvailability.wizard.step3.header':'Progress page',

  'admin.highAvailability.wizard.step5.notice.inProgress':'Please wait while the wizard configures the components.',
  'admin.highAvailability.wizard.step7.notice.inProgress':'Please wait while the wizard starts the components.',
  'admin.highAvailability.wizard.step9.notice.inProgress':'Please wait while the wizard finalizes the HA setup.',
  'admin.highAvailability.wizard.rollback.notice.inProgres':'Reverting Back to Non-HA Setup',

  'admin.highAvailability.wizard.step5.header.title':'Configure Components',
  'admin.highAvailability.wizard.step7.header.title':'Start Components',
  'admin.highAvailability.wizard.step9.header.title':'Finalize HA Setup',
  'admin.highAvailability.wizard.rollback.header.title':'Reverting Back to Non-HA Setup.',

  'admin.highAvailability.wizard.step5.task0.title':'Stop All Services',
  'admin.highAvailability.wizard.step5.task1.title':'Install Additional NameNode',
  'admin.highAvailability.wizard.step5.task2.title':'Install JournalNodes',
  'admin.highAvailability.wizard.step5.task3.title':'Reconfigure HDFS',
  'admin.highAvailability.wizard.step5.task4.title':'Start JournalNodes',
  'admin.highAvailability.wizard.step5.task5.title':'Disable Secondary NameNode',

  'admin.highAvailability.wizard.step7.task0.title':'Start ZooKeeper Servers',
  'admin.highAvailability.wizard.step7.task1.title':'Start Ambari Infra',
  'admin.highAvailability.wizard.step7.task2.title':'Start Mysql Server',
  'admin.highAvailability.wizard.step7.task3.title':'Start Ranger',
  'admin.highAvailability.wizard.step7.task4.title':'Start NameNode',

  'admin.highAvailability.wizard.step9.task0.title':'Start Additional NameNode',
  'admin.highAvailability.wizard.step9.task1.title':'Install Failover Controllers',
  'admin.highAvailability.wizard.step9.task2.title':'Start Failover Controllers',
  'admin.highAvailability.wizard.step9.task3.title':'Install PXF',
  'admin.highAvailability.wizard.step9.task4.title':'Reconfigure Ranger',
  'admin.highAvailability.wizard.step9.task5.title':'Reconfigure HBase',
  'admin.highAvailability.wizard.step9.task6.title':'Reconfigure AMS',
  'admin.highAvailability.wizard.step9.task7.title':'Reconfigure Accumulo',
  'admin.highAvailability.wizard.step9.task8.title':'Reconfigure HAWQ',
  'admin.highAvailability.wizard.step9.task9.title':'Delete Secondary NameNode',
  'admin.highAvailability.wizard.step9.task10.title':'Stop HDFS',
  'admin.highAvailability.wizard.step9.task11.title':'Start All Services',
  'admin.highAvailability.wizard.step9.notice.completed':'NameNode HA has been enabled successfully.',

  'admin.highAvailability.wizard.step3.curNameNode': '<b>Current NameNode:</b> ',
  'admin.highAvailability.wizard.step3.addNameNode': '<b>Additional NameNode:</b> ',
  'admin.highAvailability.wizard.step3.secNameNode': '<b>Secondary NameNode:</b> ',
  'admin.highAvailability.wizard.step3.journalNode': '<b>JournalNode:</b> ',
  'admin.highAvailability.wizard.step3.toBeInstalled': 'TO BE INSTALLED',
  'admin.highAvailability.wizard.step3.toBeDeleted': 'TO BE DELETED',
  'admin.highAvailability.wizard.step4.ckNotCreated':'Checkpoint not created yet',
  'admin.highAvailability.wizard.step4.ckCreated':'Checkpoint created',
  'admin.highAvailability.step4.save.configuration.note':'This configuration is created by Enable {0} HA wizard',
  'admin.highAvailability.wizard.step6.jsNoInit':'JournalNodes not initialized yet',
  'admin.highAvailability.wizard.step6.jsInit':'JournalNodes initialized',
  'admin.highAvailability.wizard.step6.jnStopped':'All JournalNodes should be started before initializing',
  'admin.highAvailability.wizard.step8.metaNoInit':'Metadata not initialized yet',
  'admin.highAvailability.wizard.step8.confirmPopup.body':'Please confirm that you have run the manual steps before continuing.',
  'admin.highAvailability.wizard.step9.hawq.confirmPopup.header':'Additional Steps Required for HAWQ',
  'admin.highAvailability.wizard.step9.hawq.confirmPopup.body':'You must refer to the HAWQ documentation under section ' +
     '"HAWQ Filespaces and High Availability Enabled HDFS" and perform the required manual steps to update the HAWQ filespace ' +
     'location. HAWQ will not use HDFS nameservice unless the steps have been completed successfully.',

  'admin.highAvailability.rollback.header':'Disable NameNode HA Wizard',
  'admin.highAvailability.rollback.task0.title':'Stop All Services',
  'admin.highAvailability.rollback.task1.title':'Restore HBase Configurations',
  'admin.highAvailability.rollback.task2.title':'Restore Accumulo Configurations',
  'admin.highAvailability.rollback.task3.title':'Restore HAWQ Configurations',
  'admin.highAvailability.rollback.task4.title':'Stop Failover Controllers',
  'admin.highAvailability.rollback.task5.title':'Delete Failover Controllers',
  'admin.highAvailability.rollback.task6.title':'Delete PXF',
  'admin.highAvailability.rollback.task7.title':'Stop Additional NameNode',
  'admin.highAvailability.rollback.task8.title':'Stop NameNode',
  'admin.highAvailability.rollback.task9.title':'Restore HDFS Configurations',
  'admin.highAvailability.rollback.task10.title':'Enable Secondary NameNode',
  'admin.highAvailability.rollback.task11.title':'Stop JournalNodes',
  'admin.highAvailability.rollback.task12.title':'Delete JournalNodes',
  'admin.highAvailability.rollback.task13.title':'Delete Additional NameNode',
  'admin.highAvailability.rollback.task14.title':'Start All Services',
  'admin.highAvailability.rollback.notice.inProgress':'Please wait while the wizard reverts back to the non-HA setup.',

  'admin.highAvailability.rollback.step2.body':
    '<ol>' +
      '<li>Login to the NameNode host <b>{1}</b>.</li>' +
      '<li>Put the NameNode in Safe Mode (read-only mode):' +
      '<div class="code-snippet">sudo su {0} -l -c \'hdfs dfsadmin -safemode enter\'</div></li>' +
      '<li>Once in Safe Mode, create a Checkpoint:' +
      '<div class="code-snippet">sudo su {0} -l -c \'hdfs dfsadmin -saveNamespace\'</div></li>' +
      '</ol>',

  'admin.highAvailability.wizard.step8.body':
    '<ol>' +
    '<li>Login to the NameNode host <b>{1}</b>.</li>' +
    '<li>Initialize the metadata for NameNode automatic failover by running:' +
    '<div class="code-snippet">sudo su {0} -l -c \'hdfs zkfc -formatZK\'</div></li>' +
    '<li>Login to the Additional NameNode host <b>{2}</b>.<br>' +
    '<div class="alert alert-warning"><strong>Important!</strong> Be sure to login to the Additional NameNode host.<br>This is a different host from the Steps 1 and 2 above.</div>' +
    '</li>' +
    '<li>Initialize the metadata for the Additional NameNode by running:' +
    '<div class="code-snippet">sudo su {0} -l -c \'hdfs namenode -bootstrapStandby\'</div></li>' +
    '</ol>',
  'admin.highAvailability.wizard.step8.proceed': 'Please proceed once you have completed the steps above.',
  'admin.highAvailability.wizard.step6.body':
    '<ol>' +
    '<li>Login to the NameNode host <b>{1}</b>.</li>' +
    '<li>Initialize the JournalNodes by running:' +
    '<div class="code-snippet">sudo su {0} -l -c \'hdfs namenode -initializeSharedEdits\'</div></li>' +
    '<li>You will be able to proceed once Ambari detects that the JournalNodes have been initialized successfully.</li>' +
    '</ol>',
  'admin.highAvailability.wizard.step4.body':
    '<ol>' +
    '<li>Login to the NameNode host <b>{1}</b>.</li>' +
    '<li>Put the NameNode in Safe Mode (read-only mode):' +
    '<div class="code-snippet">sudo su {0} -l -c \'hdfs dfsadmin -safemode enter\'</div></li>' +
    '<li>Once in Safe Mode, create a Checkpoint:' +
    '<div class="code-snippet">sudo su {0} -l -c \'hdfs dfsadmin -saveNamespace\'</div></li>' +
    '<li>You will be able to proceed once Ambari detects that the NameNode is in Safe Mode and the Checkpoint has been created successfully.</li>'+
    '<div class="alert alert-warning">If the <b>Next</b> button is enabled before you run the <b>"Step 4: Create a Checkpoint"</b> command, it means there is a recent Checkpoint already and you may proceed without running the <b>"Step 4: Create a Checkpoint"</b> command.</div>' +
    '</ol>',
  'admin.highAvailability.wizard.step3.confirm.host.body':'<b>Confirm your host selections.</b>',
  'admin.highAvailability.wizard.step3.confirm.config.body':'<div class="alert alert-info">' +
    '<p><b>Review Configuration Changes.</b></p>' +
    'The following lists the configuration changes that will be made by the Wizard to enable NameNode HA. This information is for <b> review only </b> and is not editable except for the  <b>dfs.journalnode.edits.dir</b> property' +
    '</div>',
  'admin.highAvailability.wizard.step2.body':'Select a host that will be running the additional NameNode.<br/> In addition,' +
    ' select the hosts to run JournalNodes, which store NameNode edit logs in a fault tolerant manner.',
  'admin.highAvailability.wizard.step1.body':'This wizard will walk you through enabling NameNode HA on your cluster.' +
    'Once enabled, you will be running a Standby NameNode in addition to your Active NameNode.' +
    'This allows for an Active-Standby NameNode configuration that automatically performs failover.' +
    'The process to enable HA involves a combination of <b>automated steps</b> (that will be handled by the wizard) and ' +
    '<b>manual steps</b> (that you must perform in sequence as instructed by the wizard).' +
    '<b>You should plan a cluster maintenance window and prepare for cluster downtime when enabling NameNode HA.</b>',
  'admin.highAvailability.wizard.step1.alert':'If you have HBase running, please exit this wizard and stop HBase first.',
  'admin.highAvailability.wizard.step1.hawq.alert':'<br/><br/>You will need to perform additional manual ' +
    'steps to update the HAWQ filespace location, once this wizard completes. Refer to the HAWQ documentation under section ' +
    '"HAWQ Filespaces and High Availability Enabled HDFS" for more information.',

  'admin.rm_highAvailability.wizard.header': 'Enable ResourceManager HA Wizard',
  'admin.rm_highAvailability.wizard.step1.header': 'Get Started',
  'admin.rm_highAvailability.wizard.step1.body':'This wizard will walk you through enabling ResourceManager HA on your cluster.<br/>' +
      'Once enabled, you will be running a Standby ResourceManager in addition to your Active ResourceManager.<br/>' +
      'This allows for an Active-Standby ResourceManager configuration that automatically performs failover.<br/><br/>' +
      '<b>You should plan a cluster maintenance window and prepare for cluster downtime when enabling ResourceManager HA.</b>',
  'admin.rm_highAvailability.wizard.step2.header': 'Select Host',
  'admin.rm_highAvailability.wizard.step2.body': 'Select a host that will be running the additional ResourceManager',
  'admin.rm_highAvailability.wizard.step3.header': 'Review',
  'admin.rm_highAvailability.wizard.step3.confirm.host.body':'<b>Confirm your host selections.</b>',
  'admin.rm_highAvailability.wizard.step3.confirm.config.body':'<div class="alert alert-info">' +
      '<p><b>Review Configuration Changes.</b></p>' +
      'The following lists the configuration changes that will be made by the Wizard to enable ResourceManager HA. This information is for <b> review only </b> and is not editable.' +
      '</div>',
  'admin.rm_highAvailability.wizard.step3.currentRM': 'Current ResourceManager',
  'admin.rm_highAvailability.wizard.step3.additionalRM': 'Additional ResourceManager',
  'admin.rm_highAvailability.wizard.step4.header': 'Configure Components',
  'admin.rm_highAvailability.wizard.step4.task0.title': 'Stop Required Services',
  'admin.rm_highAvailability.wizard.step4.task1.title': 'Install Additional ResourceManager',
  'admin.rm_highAvailability.wizard.step4.task2.title': 'Reconfigure YARN',
  'admin.rm_highAvailability.wizard.step4.task3.title': 'Reconfigure HAWQ',
  'admin.rm_highAvailability.wizard.step4.task4.title': 'Reconfigure HDFS',
  'admin.rm_highAvailability.wizard.step4.task5.title': 'Start All Services',
  'admin.rm_highAvailability.wizard.step4.notice.inProgress':'Please wait while ResourceManager HA is being deployed.',
  'admin.rm_highAvailability.wizard.step4.notice.completed':'ResourceManager HA has been enabled successfully.',

  'admin.ra_highAvailability.wizard.header': 'Enable Ranger Admin HA Wizard',
  'admin.ra_highAvailability.wizard.step1.header': 'Get Started',
  'admin.ra_highAvailability.wizard.step1.body': 'This wizard will walk you through enabling Ranger Admin HA on your cluster.<br/>' +
  'Once enabled, you will be running a Standby Ranger Admin in addition to your Active Ranger Admin.<br/>' +
  'This allows for an Active-Standby Ranger Admin configuration that automatically performs failover.<br/><br/>' +
  '<b>You should plan a cluster maintenance window and prepare for cluster downtime when enabling Ranger Admin HA.</b><br/><br/>' +
  'Please setup the load balancer and provide the URL to be used. Make sure that the load balancer is setup properly before proceeding.' +
  '<br/><br/><div class="alert">Be sure that Ranger Admin and load balancer are located on separate hosts.</div>',
  'admin.ra_highAvailability.wizard.step1.load_balancer_url': 'URL to load balancer',
  'admin.ra_highAvailability.wizard.step1.invalid_url': 'Must be valid URL',
  'admin.ra_highAvailability.wizard.step2.header': 'Select Hosts',
  'admin.ra_highAvailability.wizard.step2.body': 'Select a host or hosts that will be running the additional Ranger Admin components',
  'admin.ra_highAvailability.wizard.step2.warning': 'Be sure that load balancer located separately from Ranger Admin components.',
  'admin.ra_highAvailability.wizard.step3.header': 'Review',
  'admin.ra_highAvailability.wizard.step3.alert_message': '<b>Confirm your host selections.</b>',
  'admin.ra_highAvailability.wizard.step3.currentRA': 'Current Ranger Admin',
  'admin.ra_highAvailability.wizard.step3.additionalRA': 'Additional Ranger Admin',
  'admin.rm_highAvailability.wizard.step3.configs_changes': '<p><b>Review Configuration Changes.</b></p>' +
    'The following lists the configuration changes that will be made by the Wizard to enable Ranger Admin HA. ' +
    'This information is for <b> review only </b> and is not editable.',
  'admin.ra_highAvailability.wizard.step4.header': 'Install, Start and Test',
  'admin.ra_highAvailability.wizard.step4.task0.title': 'Stop All Services',
  'admin.ra_highAvailability.wizard.step4.task1.title': 'Install Additional Ranger Admin',
  'admin.ra_highAvailability.wizard.step4.task2.title': 'Reconfigure Services',
  'admin.ra_highAvailability.wizard.step4.task3.title': 'Start All Services',
  'admin.ra_highAvailability.wizard.step4.notice.inProgress': 'Please wait while Ranger Admin HA is being deployed.',
  'admin.ra_highAvailability.wizard.step4.notice.completed': 'Ranger Admin HA has been enabled successfully.',
  'admin.ra_highAvailability.closePopup':'Enable Ranger Admin HA Wizard is in progress. You must allow the wizard to complete for Ambari to be in usable state. ' +
  'If you choose to quit, you must follow manual instructions to complete or revert enabling Ranger Admin HA as documented in the Ambari User Guide. Are you sure you want to exit the wizard?',

  'admin.nameNodeFederation.button.enable':'Add New HDFS Namespace',
  'admin.nameNodeFederation.wizard.required.zookeepers': 'All ZooKeeper Servers should be up',
  'admin.nameNodeFederation.wizard.required.journalnodes': 'All JournalNodes should be up',
  'admin.nameNodeFederation.wizard.header': 'Add New HDFS Namespace',
  'admin.nameNodeFederation.closePopup': 'Are you sure you want to quit?',
  'admin.nameNodeFederation.closePopup2': 'Add New HDFS Namespace Wizard is in progress. You must allow the wizard to complete for Ambari to be in usable state. If you choose to quit, you must follow manual instructions to complete or revert Add New HDFS Namespace as documented in the Ambari User Guide. Are you sure you want to exit the wizard?',
  'admin.nameNodeFederation.wizard.step1.header': 'Get Started',
  'admin.nameNodeFederation.wizard.step1.body':'This wizard will walk you through the process of setting up a new Highly Available NameNode pair that will be used to create a new HDFS namespace, allowing you to use Ambari to manage multiple HDFS namespaces and take advantage of HDFS Federation.',
  'admin.nameNodeFederation.wizard.step1.alert':'You should plan a cluster maintenance window and prepare for cluster downtime when adding a new HDFS Namespace as this Wizard will restart all services.',
  'admin.nameNodeFederation.wizard.step1.nameserviceid':'New Nameservice ID',
  'admin.nameNodeFederation.wizard.step1.nameserviceid.existing':'Existing Nameservice ID',
  'admin.nameNodeFederation.wizard.step1.nameserviceid.error':'Must be unique and consist of letters, numbers, and hyphens. Cannot begin or end with a hyphen.',
  'admin.nameNodeFederation.wizard.step2.header': 'Select Hosts',
  'admin.nameNodeFederation.wizard.step2.body': 'Select hosts running the NameNodes for {0}',
  'admin.nameNodeFederation.wizard.step3.header': 'Review',
  'admin.nameNodeFederation.wizard.step3.confirm.config.body': '<div class="alert alert-info">' +
    '<p><b>Review Configuration Changes.</b></p>' +
    'The following lists the configuration changes that will be made by the Wizard to enable NameNode Federation. This information is for <b> review only </b> and is not editable except for the  <b>dfs.journalnode.edits.dir</b> properties' +
    '</div>',
  'admin.nameNodeFederation.wizard.step4.header': 'Configure Components',
  'admin.nameNodeFederation.wizard,step4.save.configuration.note':'This configuration is created by Enable NameNode Federation wizard',
  'admin.nameNodeFederation.wizard.step4.notice.inProgress':'Please wait while your new HDFS Namespace is being deployed.',
  'admin.nameNodeFederation.wizard.step4.notice.completed':'Add New HDFS Namespace Wizard has been completed successfully.',
  'admin.nameNodeFederation.wizard.step4.task0.title': 'Stop Required Services',
  'admin.nameNodeFederation.wizard.step4.task1.title': 'Reconfigure Services',
  'admin.nameNodeFederation.wizard.step4.task2.title': 'Install Additional NameNodes',
  'admin.nameNodeFederation.wizard.step4.task3.title': 'Install Additional ZKFCs',
  'admin.nameNodeFederation.wizard.step4.task4.title': 'Start JournalNodes',
  'admin.nameNodeFederation.wizard.step4.task5.title': 'Start Infra Solr',
  'admin.nameNodeFederation.wizard.step4.task6.title': 'Start Ranger Admin',
  'admin.nameNodeFederation.wizard.step4.task7.title': 'Start Ranger Usersync',
  'admin.nameNodeFederation.wizard.step4.task8.title': 'Start NameNodes',
  'admin.nameNodeFederation.wizard.step4.task9.title': 'Start ZKFCs',
  'admin.nameNodeFederation.wizard.step4.task10.title': 'Format NameNode',
  'admin.nameNodeFederation.wizard.step4.task11.title': 'Format ZKFC',
  'admin.nameNodeFederation.wizard.step4.task12.title': 'Start ZKFC',
  'admin.nameNodeFederation.wizard.step4.task13.title': 'Start NameNode',
  'admin.nameNodeFederation.wizard.step4.task14.title': 'Bootstrap NameNode',
  'admin.nameNodeFederation.wizard.step4.task15.title': 'Start ZKFC',
  'admin.nameNodeFederation.wizard.step4.task16.title': 'Start NameNode',
  'admin.nameNodeFederation.wizard.step4.task17.title': 'Restart Required Services',

  'admin.security.title':'Kerberos security has not been enabled',
  'admin.security.enabled': 'Kerberos security is enabled',
  'admin.security.disabled': 'Kerberos security is disabled',
  'admin.security.button.enable':'Enable Security',
  'admin.security.button.disable':'Disable Security',
  'admin.security.enable.popup.body': 'We will walk you through add security wizard',
  'admin.security.enable.popup.header': 'Add security',
  'admin.security.disable.popup.header': 'Remove security',
  'admin.security.disable.popup.body': 'You are about to disable Kerberos on the cluster. This will stop all the services in your cluster and remove the Kerberos configurations. <strong>Are you sure you wish to proceed with disabling Kerberos?</strong>',
  'admin.security.step1.header': 'Get Started',
  'admin.security.step2.header': 'Configure Services',
  'admin.security.step3.header': 'Create Principals and Keytabs',
  'admin.security.step4.header': 'Save and Apply Configuration',
  'admin.security.step1.body.header': 'Important: Before configuring Ambari to manage your Kerberos-enabled cluster, ' +
    'you must perform the following manual steps on your cluster. Be sure to record the location of the keytab files ' +
    'for each host and the principals for each Hadoop service. This information is required in order to use the wizard.',
  'admin.security.step1.body.instruction1': 'Install, configure and start your Kerberos KDC',
  'admin.security.step1.body.instruction2': 'Install and configure the Kerberos client on every host in the cluster',
  'admin.security.step1.body.instruction3': 'Create Kerberos principals for Hadoop services and hosts',
  'admin.security.step1.body.instruction4': 'Generate keytabs for each principal and place on the appropriate hosts',
  'admin.security.step1.body.instruction5': '<b>Application Timeline Server</b> component of YARN service will be <span class="text-danger"><b>deleted</b></span> as part of enabling security in this HDP stack version',
  'admin.security.step2.body.header': 'Configure Kerberos security properties',
  'admin.security.step3.notice': 'You need to create Kerberos principals and keytabs before proceeding.<br />'+
  'Download the CSV file and use it to create a script to generate the principals and keytabs on specified hosts. ' +
  'Once the principals and keytabs have been created, click on <i>Apply</i> to continue. If you need to make configuration changes, click <i>Back</i>.',
  'admin.security.step3.table.principal': 'Principal',
  'admin.security.step3.table.keytab': 'Keytab',
  'admin.security.step3.downloadCSV': 'Download CSV',
  'admin.security.step4.body.header': 'Applying kerberos security to the cluster',
  'admin.security.step4.body.success.header' : 'Kerberos-based security has been enabled on your cluster. Please wait while services are started in secure mode.',
  'admin.security.step4.body.failure.header' : 'Failed to enable Kerberos-based security on your cluster. Your cluster will keep running in non-secure mode.',
  'admin.security.step4.save.configuration.note':'This configuration is created by Enable/Disable security wizard',
  'admin.security.apply.configuration.error' : 'Failed to apply secure configurations to the cluster. Please navigate to "Configure Services" step and make sure all services are configured with appropriate values.',
  'admin.security.disable.body.header' : 'Disabling kerberos security on the cluster',
  'admin.security.disable.body.success.header': 'Kerberos-based security has been disabled on your cluster. Please wait while services are started in non-secure mode.',
  'admin.security.disable.body.failure.header': 'Failed to disable Kerberos-based security on your cluster. Your cluster will keep running in secure mode.',
  'admin.security.disable.onClose': 'You are in the process of disabling security on your cluster. ' +
    'Are you sure you want to quit?',
  'admin.removeSecurity.header': 'Disable Security',
  'admin.security.applying.config.header': 'Applying Configurations',
  'admin.security.applying.config.body':'You cannot quit wizard while configurations are being applied',
  'admin.security.status.error' : 'Error in retrieving cluster security status from Ambari server',
  'admin.users.ldapAuthUsed':'LDAP Authentication is being used to authenticate users',
  'admin.users.delete.yourself.message':'You cannot delete yourself',
  'admin.users.delete.yourself.header':'Deleting warning',

  'admin.users.delete.header':'Delete {0}',

  'admin.users.addButton':'Add Local User',
  'admin.users.editButton': 'Edit Local User',
  'admin.users.delete':'delete',
  'admin.users.edit':'edit',
  'admin.users.privileges':'Admin',
  'admin.users.type':'Type',
  'admin.users.action':'Action',
  'admin.users.passwordRetype':'Retype Password',
  'admin.users.username':'Username',
  'admin.users.createSuccess': 'User successfully created.',
  'admin.users.createError': 'Error occurred while user creating.',
  'admin.users.createError.passwordValidation': 'Passwords are different',
  'admin.users.createError.userNameExists': 'User with the same name is already exists',
  'admin.users.editError.requiredField': 'This is required',

  'admin.access.showJobs':'Enable Jobs tab for non-admin users',

  'admin.confirmUninstall':'Confirm Uninstall',
  'admin.cluster.stackVersion':'Cluster Stack Version',
  'admin.cluster.upgradeAvailable':'Upgrade available',
  'admin.cluster.upgradeUnavailable':'Upgrade unavailable',
  'admin.cluster.repositories.repositories':'Repositories',
  'admin.cluster.repositories.os':'OS',
  'admin.cluster.repositories.baseUrl':'Base URL',
  'admin.cluster.repositories.popup.header.success':'Repo Base URLs Saved',
  'admin.cluster.repositories.popup.header.fail':'Base URL Validation Failed',
  'admin.cluster.repositories.popup.body.success':'The Repo Base URL has been saved successfully.',
  'admin.cluster.repositories.popup.body.fail':'The Base URL failed validation and has not been saved.',
  'admin.cluster.repositories.invalidURLAttention': '<b>Attention:</b> Please make sure all repository URLs are valid before saving.',
  'admin.cluster.repositories.emptyURLattention':'<b>Attention:</b> Repository URLs are REQUIRED before you can save.',
  'admin.cluster.repositories.skipValidation.tooltip':'<b>Warning:</b> This is for advanced users only. Use this option if you want to skip validation for Repository Base URLs.',

  'admin.misc.header': 'Service Users and Groups',
  'admin.misc.nothingToShow': 'No user accounts to display',

  'admin.serviceAutoStart.title': "Service Auto Start",
  'admin.serviceAutoStart.header.text': "Ambari services can be configured to start automatically on system boot. Each service can be configured to start all components, masters and workers, or selectively.",
  'admin.serviceAutoStart.general.switcher': "Auto Start Settings",
  'admin.serviceAutoStart.tooltip.text': "{0} components enabled",
  'admin.serviceAutoStart.column.autoStart': "Auto Start",

  'admin.stackVersions.filter.notInstalled': "Not Installed ({0})",
  'admin.stackVersions.filter.all': "All ({0})",
  'admin.stackVersions.filter.upgradeReady': "Upgrade Ready ({0})",
  'admin.stackVersions.filter.installed': "Installed ({0})",
  'admin.stackVersions.filter.current': "Current ({0})",
  'admin.stackVersions.filter.upgrading': "Upgrade/Downgrade In Process ({0})",
  'admin.stackVersions.filter.upgraded': "Ready to Finalize ({0})",
  'admin.stackVersions.upgrade.start.fail.title':'Upgrade could not be started',
  'admin.stackVersions.upgrade.installPackage.fail.title':'Packages could not be installed',
  'admin.stackVersions.upgrade.installPackage.fail.timeout':'Request timed out.',
  'admin.stackVersions.upgrade.installPackage.fail.noAvailableServices':"Version {0} does not contain services that are installed.",

  'admin.stackVersions.upgrade.patch.revert.confirmation':'Are you sure you want to revert the following services:',
  'admin.stackVersions.editRepositories.info': 'Provide Base URLs for the Operating Systems you are configuring.',
  'admin.stackVersions.editRepositories.validation.warning': 'Some of the repositories failed validation. Make changes to the base url or skip validation if you are sure that urls are correct',
  'admin.stackVersions.version.install.confirm': 'You are about to install packages for version <strong>{0}</strong> on all hosts.',
  'admin.stackVersions.version.install.patch.confirm': 'You are about to install packages for version <strong>{0}</strong> on hosts which contain the following services:',
  'admin.stackVersions.version.linkTooltip': 'Click to Edit Repositories',
  'admin.stackVersions.version.hostsTooltip': 'Click to List Hosts',
  'admin.stackVersions.version.emptyHostsTooltip': 'No Hosts to List',
  'admin.stackVersions.version.notInstalled': "Not Installed",
  'admin.stackVersions.version.hostsInfoTooltip': "There are {0} hosts that do not need packages installed:<li>{1} Maintenance Mode</li><li>{2} Not Required</li>",
  'admin.stackVersions.manageVersions': "Manage Versions",
  'admin.stackVersions.manageVersions.popup.body': 'You are about to leave the <b>Cluster Management</b> interface' +
    ' and go to the <b>Ambari Administration</b> interface. You can return to cluster management by using the' +
    ' “Go to Dashboard” link in the Ambari Administration > Clusters section.',
  'admin.stackVersions.version.installNow': "Install Packages",
  'admin.stackVersions.version.reinstall': "Reinstall Packages",
  'admin.stackVersions.version.installError': "Installation Error!",
  'admin.stackVersions.version.performUpgrade': "Perform Upgrade",
  'admin.stackVersions.version.preUpgradeCheck': 'Pre-Upgrade Check',
  'admin.stackVersions.version.upgrade.pause': "Upgrade: Action Required",
  'admin.stackVersions.version.upgrade.notFinalized.warning': "The upgrade has not been finalized yet. After the cluster is verified to be functional, do not forget to finalize the upgrade as soon as possible (within a couple of days is highly recommended) as running the cluster in unfinalized state causes extra resource requirements on HDFS.",
  'admin.stackVersions.version.upgrade.running': "Upgrade: In Process",
  'admin.stackVersions.version.upgrade.running.nonWizard': "Upgrade: In Process | Initiated by {0}",
  'admin.stackVersions.version.upgrade.aborted': "Upgrade: Aborted",
  'admin.stackVersions.version.upgrade.suspended': "Upgrade: Paused",
  'admin.stackVersions.version.downgrade.pause': "Downgrade: Action Required",
  'admin.stackVersions.version.downgrade.running': "Downgrade: In Process",
  'admin.stackVersions.version.downgrade.running.nonWizard': "Downgrade: In Process | Initiated by {0}",
  'admin.stackVersions.version.downgrade.aborted': "Downgrade: Aborted",
  'admin.stackVersions.version.downgrade.suspended': "Downgrade: Paused",
  'admin.stackUpgrade.state.paused.fail.header': "Pause Upgrade failed",
  'admin.stackUpgrade.state.paused.fail.body': "Upgrade could not be paused. Try again later.",
  'admin.stackDowngrade.state.paused.fail.header': "Pause Downgrade failed",
  'admin.stackDowngrade.state.paused.fail.body': "Downgrade could not be paused. Try again later.",
  'admin.stackVersions.version.errors.outOfSync.title': 'Host component out of sync',
  'admin.stackVersions.version.errors.outOfSync.desc': 'One of more host components did not report the version that Ambari expected.' +
  ' Please re-install the failed host component, or remove it.',
  'admin.stackVersions.version.errors.outOfSync.reinstall.title': 'Confirm Re-Install',
  'admin.stackVersions.version.errors.outOfSync.remove.title': 'Confirm Remove',
  
  'admin.stackVersions.version.service.notUpgradable': "The version of this service included in this repository is already installed in the cluster.",
  'admin.stackVersions.version.service.notSupported': "This service is unsupported in the current version of the stack.",

  'admin.stackVersions.version.upgrade.upgradeOptions.header': "Upgrade Options",
  'admin.stackVersions.version.upgrade.upgradeOptions.bodyMsg.version': "You are about to perform an upgrade to <b>{0}</b>.",
  'admin.stackVersions.version.upgrade.upgradeOptions.bodyMsg.method': "Choose the upgrade method:",
  'admin.stackVersions.version.upgrade.upgradeOptions.bodyMsg.tolerance': "Select optional upgrade failure tolerance:",
  'admin.stackVersions.version.upgrade.upgradeOptions.tolerance.option1': "Skip all Slave Component failures",
  'admin.stackVersions.version.upgrade.upgradeOptions.tolerance.option2': "Skip all Service Check failures",
  'admin.stackVersions.version.upgrade.upgradeOptions.tolerance.tooltip': "These upgrade failure tolerance options are useful when performing an upgrade on a large cluster and you want to minimize user intervention.",
  'admin.stackVersions.version.upgrade.upgradeOptions.RU.title': "Rolling",
  'admin.stackVersions.version.upgrade.upgradeOptions.RU.description': "Services remain running while the upgrade is performed. Minimized disruption but slower upgrade.",
  'admin.stackVersions.version.upgrade.upgradeOptions.EU.title': "Express",
  'admin.stackVersions.version.upgrade.upgradeOptions.HOU.title': "Host Ordered",
  'admin.stackVersions.version.upgrade.upgradeOptions.EU.description': "Services are stopped while the upgrade is performed. Incurs downtime, but faster upgrade.",
  'admin.stackVersions.version.upgrade.upgradeOptions.errors_bypassed': "Bypassed errors,<br/>proceed at your own risk.",
  'admin.stackVersions.version.upgrade.upgradeOptions.preCheck.rerun':'Rerun Pre-Upgrade Checks',
  'admin.stackVersions.version.upgrade.upgradeOptions.preCheck.msg.title':'Checks:',
  'admin.stackVersions.version.upgrade.upgradeOptions.preCheck.msg.checking': 'Checking...',
  'admin.stackVersions.version.upgrade.upgradeOptions.preCheck.msg.failed.title': 'Check failed',
  'admin.stackVersions.version.upgrade.upgradeOptions.preCheck.msg.failed.link': 'Rerun',
  'admin.stackVersions.version.upgrade.upgradeOptions.preCheck.allPassed':'Passed',
  'admin.stackVersions.version.upgrade.upgradeOptions.preCheck.allPassed.msg':'All checks passed',
  'admin.stackVersions.version.upgrade.upgradeOptions.preCheck.failed.tooltip':'Option not available',
  'admin.stackVersions.version.upgrade.upgradeOptions.notAllowed':'Not allowed by the current version',
  'admin.stackVersions.version.upgrade.upgradeOptions.EU.confirm.msg': 'You are about to perform an <b>Express Upgrade</b> to <b>{0}</b>. This will incur cluster downtime. Are you sure you want to proceed?',
  'admin.stackVersions.version.upgrade.upgradeOptions.RU.confirm.msg': 'You are about to perform a <b>Rolling Upgrade</b> to <b>{0}</b>. Are you sure you want to proceed?',
  'admin.stackVersions.version.upgrade.upgradeOptions.error': 'Could not proceed with upgrade:',
  'admin.stackVersions.version.upgrade.upgradeOptions.loading': 'Checking for supported upgrade types...',

  'admin.stackVersions.version.upgrade.alertsWarning': 'Cluster alerts will still be visible and recorded in Ambari but notifications (such as Email and SNMP) will be suppressed during the upgrade.',

  'admin.stackVersions.version.preUpgrade.header' : 'Pre-Upgrade Check',
  'admin.stackVersions.version.preUpgrade.bodyMsg.version': 'The following checks have been run to test your ability to upgrade to <b>{0}</b>.',

  'admin.stackVersions.version.column.showDetails': "Show Details",
  'admin.stackVersions.version.column.showDetails.title': "Version Details",
  'admin.stackVersions.version.noCompatible.tooltip': 'Directly upgrading to this version is not supported.',

  'admin.stackVersions.hosts.popup.header.current': "Current",
  'admin.stackVersions.hosts.popup.header.installed': "Installed",
  'admin.stackVersions.hosts.popup.header.not_installed': "Not installed",
  'admin.stackVersions.hosts.popup.header': "Version Status: {0}",
  'admin.stackVersions.hosts.popup.title': "{0} Version is {1} on {2} hosts:",
  'admin.stackVersions.hosts.popup.current.title': "{0} is applied on {1} hosts:",
  'admin.stackVersions.hosts.popup.primary': "Go to Hosts",

  'admin.stackVersions.details.install.hosts.popup.title': "Install {0} version",
  'admin.stackVersions.upgradeHistory.upgrade': 'Upgrades',
  'admin.stackVersions.upgradeHistory.downgrade': 'Downgrades',
  'admin.stackVersions.upgradeHistory.show.details': 'Click to show more details on {0}',
  'admin.stackVersions.upgradeHistory.success': 'Sucessful {0}',
  'admin.stackVersions.upgradeHistory.aborted': 'Aborted {0}',
  'admin.stackVersions.upgradeHistory.summary': 'Summary',
  'admin.stackVersions.upgradeHistory.history': 'History',
  'admin.stackVersions.upgradeHistory.filter.all': 'All ({0})',
  'admin.stackVersions.upgradeHistory.filter.upgrade': 'Upgrade ({0})',
  'admin.stackVersions.upgradeHistory.filter.downgrade': 'Downgrade ({0})',
  'admin.stackVersions.upgradeHistory.filter.successful.upgrade': 'Successful Upgrade ({0})',
  'admin.stackVersions.upgradeHistory.filter.successful.downgrade': 'Successful Downgrade ({0})',
  'admin.stackVersions.upgradeHistory.filter.aborted.upgrade': 'Aborted Upgrade ({0})',
  'admin.stackVersions.upgradeHistory.filter.aborted.downgrade': 'Aborted Downgrade ({0})',
  'admin.stackVersions.upgradeHistory.filter.failed.upgrade': 'Failed Upgrade ({0})',
  'admin.stackVersions.upgradeHistory.filter.failed.downgrade': 'Failed Downgrade ({0})',
  'admin.stackVersions.upgradeHistory.no.history': 'No upgrade/downgrade history available',
  'admin.stackVersions.upgradeHistory.record.title.upgrade': '{0} {1} to {2}',
  'admin.stackVersions.upgradeHistory.record.title.downgrade': '{0} {1} from {2}',

  'admin.stackUpgrade.preCheck.warning.message': "{0} Warning {1}",
  'admin.stackUpgrade.preCheck.bypass.message': "{0} Error {1}",
  'admin.stackUpgrade.preCheck.fail.message': "{0} Required {1}",

  'admin.stackUpgrade.finalize.later': "Finalize Later",
  'admin.stackUpgrade.finalize.message.upgrade': "Your cluster version has been upgraded. " +
  "Click on <b>Finalize</b> when you are ready to finalize the upgrade and commit to the new version." +
  " You are strongly encouraged to run tests on your cluster to ensure it is fully operational before finalizing." +
  " <b>You cannot go back to the original version once the upgrade is finalized.</b>",
  'admin.stackUpgrade.finalize.message.downgrade': "Your cluster version has been downgraded. " +
    "Click on <b>Finalize</b> when you are ready to finalize the downgrade and commit to the new version." +
    " You are strongly encouraged to run tests on your cluster to ensure it is fully operational before finalizing." +
    " <b>You cannot go back to the original version once the downgrade is finalized.</b>",
  'admin.stackUpgrade.finalize.message.revertible': "The <b>{0}</b> upgrade to <b>{1}</b> is ready to be completed." +
  " After finalization, the patch can be reverted from the Stacks and Versions page if it is no longer required.",
  'admin.stackUpgrade.finalize.message.autoStart': "Please remember to re-enable Auto Start if you disabled it for upgrade.",
  'admin.stackUpgrade.finalize.message.skippedServiceChecks': "During the upgrade, checks for the following services failed and were skipped:",
  'admin.stackUpgrade.finalize.message.testServices': "You are strongly recommended to test these services before finalizing upgrade.",
  'admin.stackUpgrade.failedHosts.message': "Upgrade did not succeed on",
  'admin.stackUpgrade.failedHosts.showHosts': "{0} hosts",
  'admin.stackUpgrade.failedHosts.options': "Your options:",
  'admin.stackUpgrade.failedHosts.options.first': "<b>Pause Upgrade</b>, delete the unhealthy hosts and return to the Upgrade Wizard to Proceed.",
  'admin.stackUpgrade.failedHosts.options.second': "Perform a <b>Downgrade</b>, which will revert all hosts to the previous stack version.",
  'admin.stackUpgrade.failedHosts.options.third': "Ignore these failures and <b>Proceed</b> for now (reconcile the failures later).",
  'admin.stackUpgrade.failedHosts.isOutOfSync.options.first' : '<b>Pause Upgrade</b> and restart the component',
  'admin.stackUpgrade.failedHosts.isOutOfSync.options.second' : '<b>Restart</b> the Ambari Agent',
  'admin.stackUpgrade.failedHosts.header': "Failed Hosts",
  'admin.stackUpgrade.failedHosts.subHeader': "Upgrade failed on {0} hosts",
  'admin.stackUpgrade.failedHosts.details': "Open Details",
  'admin.stackUpgrade.doThisLater': "Do This Later",
  'admin.stackUpgrade.pauseUpgrade': "Pause Upgrade",
  'admin.stackUpgrade.pauseDowngrade': "Pause Downgrade",
  'admin.stackUpgrade.pauseUpgrade.warning': "You are about to Pause the {0}. You can return to continue the {0} and finalize at a later time but while the upgrade is paused, you <strong style='color:red;'>SHOULD NOT</strong> perform any cluster changes. For example:" +
  "<ul><li>DO NOT add / remove hosts on the cluster</li>" +
  "<li>DO NOT add / remove services on the cluster</li>" +
  "<li>DO NOT enable / disable Kerberos</li>" +
  "<li>DO NOT enable / disable HA</li>" +
  "<li>DO NOT make any drastic changes to service configurations</li></ul>" +
  "You <strong>MUST</strong> continue the {0} and finalize <strong>BEFORE</strong> performing <strong>ANY</strong> significant changes to the cluster.",
  'admin.stackUpgrade.downgrade.proceed': "Proceed with Downgrade",
  'admin.stackUpgrade.downgrade.body': "Are you sure you wish to abort the upgrade process and downgrade to <b>{0}</b>?",
  'admin.stackUpgrade.downgrade.retry.body': "Are you sure you wish to retry downgrade to <b>{0}</b>?",
  'admin.stackUpgrade.upgrade.confirm.body': "You are about to perform an upgrade to {0}.",
  'admin.stackUpgrade.upgrade.retry.confirm.body': "You are about to retry an upgrade to {0}.",
  'admin.stackUpgrade.title': "Stack and Versions",
  'admin.stackUpgrade.state.inProgress': "Upgrade in Progress",
  'admin.stackUpgrade.state.paused': "Upgrade Paused",
  'admin.stackUpgrade.state.aborted': "Upgrade Aborted",
  'admin.stackUpgrade.state.completed': "Upgrade Finished",
  'admin.stackUpgrade.state.inProgress.downgrade': "Downgrade in Progress",
  'admin.stackUpgrade.state.init': "Upgrade Initializing",
  'admin.stackUpgrade.state.init.downgrade': "Downgrade Initializing",
  'admin.stackUpgrade.state.paused.downgrade': "Downgrade Paused",
  'admin.stackUpgrade.state.aborted.downgrade': "Downgrade Aborted",
  'admin.stackUpgrade.state.completed.downgrade': "Downgrade Finished",
  'admin.stackUpgrade.dialog.upgrade.header': "{0} Upgrade to {1}",
  'admin.stackUpgrade.dialog.upgrade.patch.header': "{0} Patch Upgrade to {1}",
  'admin.stackUpgrade.dialog.upgrade.maint.header': "{0} Maint Upgrade to {1}",
  'admin.stackUpgrade.dialog.downgrade.header': "Downgrade from {0}",
  'admin.stackUpgrade.dialog.operationFailed': "This operation failed.",
  'admin.stackUpgrade.dialog.stop': "Stop Upgrade",
  'admin.stackUpgrade.dialog.continue': "Ignore and Proceed",
  'admin.stackUpgrade.dialog.cancel': "Cancel Upgrade",
  'admin.stackUpgrade.dialog.inProgress': "Now Running:",
  'admin.stackUpgrade.dialog.keepRunning': "Keep running Upgrade in background",
  'admin.stackUpgrade.dialog.failed': "Failed on:",
  'admin.stackUpgrade.dialog.manual.slaveComponentFailures.title': "Slave Component Failures",
  'admin.stackUpgrade.dialog.manual.serviceCheckFailures.title': "Service Check Failures",
  'admin.stackUpgrade.dialog.manual.serviceCheckFailures.msg1': "The following service checks failed but were skipped:",
  'admin.stackUpgrade.dialog.manual.serviceCheckFailures.msg2': "You have the option to Pause Upgrade and fix the above issue(s) before proceeding.",
  'admin.stackUpgrade.dialog.manual': "Manual steps required",
  'admin.stackUpgrade.dialog.manualDone': "I have performed the manual steps above.",
  'admin.stackUpgrade.dialog.closeProgress': "Upgrade is in progress. \n If you dismiss this window, Upgrade will keep running in background.",
  'admin.stackUpgrade.dialog.closePause': "Upgrade is paused. \n If you dismiss this window, you can resume Upgrade later.",
  'admin.stackUpgrade.dialog.aborted': "Upgrade is aborted. \n You can either downgrade or retry upgrade.",
  'admin.stackUpgrade.dialog.downgrade.aborted': "Downgrade is aborted. \n You can retry downgrade.",
  'admin.stackUpgrade.dialog.suspended': "Upgrade is Paused",
  'admin.stackUpgrade.dialog.suspended.downgrade': "Downgrade is Paused",
  'admin.stackUpgrade.dialog.resume': "Resume Upgrade",
  'admin.stackUpgrade.dialog.resume.downgrade': "Resume Downgrade",
  'admin.stackUpgrade.dialog.details.open': "show details",
  'admin.stackUpgrade.dialog.details.hide': "hide details",
  'admin.stackUpgrade.dialog.notActive': "Waiting to execute the next task...",
  'admin.stackUpgrade.dialog.prepareUpgrade.header': "Preparing the Upgrade...",
  'admin.stackUpgrade.dialog.skipped.failures':'There were automatically skipped failed steps.  Please resolve each failure before continuing with the upgrade.',
  'services.service.start':'Start',
  'services.service.stop':'Stop',
  'services.service.allComponents':'All Components',
  'services.service.metrics':'Metrics',
  'services.nothingToAdd':'Nothing to add',
  'services.service.summary.version':'Version',
  'services.service.summary.viewHost':'View Host',
  'services.service.summary.viewHosts':'View Hosts',
  'services.service.summary.clientOnlyService.ToolTip':'Client-only service',
  'services.service.summary.mapreduce2.client':'MapReduce2 Client',
  'services.service.summary.mapreduce2.clients':'MapReduce2 Clients',
  'services.service.summary.nodeManagersLive':'NodeManagers Live',
  'services.service.summary.TrackersLive':'Trackers Live',
  'services.service.summary.PhoenixServersLIVE':'Phoenix Query servers Live',
  'services.service.summary.GangliaMonitorsLIVE':'Ganglia Monitors Live',
  'services.service.summary.SupervisorsLIVE':'Supervisors Live',
  'services.service.summary.nameNode':'NameNode Web UI',
  'services.service.summary.nameNodeUptime':'NameNode Uptime',
  'services.service.summary.nameNodeHeap':'NameNode Heap',
  'services.service.summary.nameNode.active':'Active NameNode',
  'services.service.summary.nameNode.standby':'Standby NameNode',
  'services.service.summary.pendingUpgradeStatus':'Upgrade Status',
  'services.service.summary.pendingUpgradeStatus.notFinalized':'Upgrade not finalized',
  'services.service.summary.pendingUpgradeStatus.notPending':'No pending upgrade',
  'services.service.summary.safeModeStatus':'Safe Mode Status',
  'services.service.summary.safeModeStatus.inSafeMode':'In safe mode',
  'services.service.summary.safeModeStatus.notInSafeMode':'Not in safe mode',
  'services.service.summary.dataNodes':'DataNodes',
  'services.service.summary.diskCapacity':'HDFS Disk Capacity',
  'services.service.summary.blocks':'Blocks',
  'services.service.summary.blockErrors':'Block Errors',
  'services.service.summary.totalFiles':'Total Files + Dirs',
  'services.service.summary.jobTracker':'JobTracker',
  'services.service.summary.jobTrackerWebUI':'JobTracker Web UI',
  'services.service.summary.jobTrackerUptime':'JobTracker Uptime',
  'services.service.summary.trackersLiveTotal':'Trackers',
  'services.service.summary.trackersBlacklistGraylist':'Trackers',
  'services.service.summary.jobTrackerHeap':'JobTracker Heap',
  'services.service.summary.totalSlotsCapacity':'Total Slots Capacity',
  'services.service.summary.totalJobs':'Total Jobs',
  'services.service.summary.currentSlotUtiliMaps':'Map Slots',
  'services.service.summary.currentSlotUtiliReduces':'Reduce Slots',
  'services.service.summary.tasksMaps':'Tasks: Maps',
  'services.service.summary.tasksReduces':'Tasks: Reduces',
  'services.service.summary.hbaseMaster':'HBase Master Web UI',
  'services.service.summary.regionServerCount':'RegionServer Count',
  'services.service.summary.regionInTransition':'Region In Transition',
  'services.service.summary.masterStarted':'Master Started',
  'services.service.summary.masterActivated':'Master Activated',
  'services.service.summary.averageLoad':'Average Load',
  'services.service.summary.masterHeap':'Master Heap',
  'services.service.summary.moreStats':'more stats here',
  'services.service.summary.clientCount': '{0} Client Hosts',
  'services.service.summary.historyServer': 'History Server Web UI',
  'services.service.summary.hiveserver2.jdbc.url.text': ' JDBC URL',
  'services.service.summary.hiveserver2.endpoint.tooltip.text':'JDBC connection string for {0}',
  'services.service.summary.hiveserver2.endpoint.value':'jdbc:hive2://{0}/;serviceDiscoveryMode={1};zooKeeperNamespace={2}',
  'services.service.summary.inMaintenanceMode.tooltip': 'Service is in maintenance mode',
  'services.service.actions.downloadClientConfigs':'Download Client Configs',
  'services.service.actions.downloadClientConfigs.fail.noConfigFile':'No configuration files defined for the component',
  'services.service.actions.downloadClientConfigs.fail.popup.header':'{0} Configs',
  'services.service.actions.downloadClientConfigs.fail.popup.body.noErrorMessage':'Generation of {0} configurations file has failed. ',
  'services.service.actions.downloadClientConfigs.fail.popup.body.errorMessage':'Generation of {0} configurations file has failed with {1} error: <br /><pre><span class="text-error">{2}</span></pre>',
  'services.service.actions.downloadClientConfigs.fail.popup.body.question':'Do you want to try again?',
  'services.service.actions.deleteService':'Delete Service',
  'services.service.actions.run.rebalancer':'Run Rebalancer',
  'services.service.actions.run.rebalanceHdfsNodes':'Rebalance HDFS',
  'services.service.actions.run.rebalanceHdfsNodes.title':'HDFS Rebalance',
  'services.service.actions.run.rebalanceHdfsNodes.prompt':'Balancer threshold (percentage of disk capacity):',
  'services.service.actions.run.rebalanceHdfsNodes.promptTooltip':'Percentage of disk capacity. This overwrites the default threshold',
  'services.service.actions.run.rebalanceHdfsNodes.promptError':'Value should be number between 1 and 100',
  'services.service.actions.run.rebalanceHdfsNodes.context':'Rebalance HDFS',
  'services.service.actions.run.rebalanceHdfsNodes.error':'Error during remote command: ',
  'services.service.actions.run.yarnRefreshQueues.title':'Refresh Queues ResourceManager',
  'services.service.actions.run.yarnRefreshQueues.menu':'Refresh YARN Capacity Scheduler',
  'services.service.actions.run.yarnRefreshQueues.context':'Refresh YARN Capacity Scheduler',
  'services.service.actions.run.yarnRefreshQueues.error':'Error during remote command: ',
  'services.service.actions.run.executeCustomCommand.menu':'{0}',
  'services.service.actions.run.executeCustomCommand.context':'Execute {0}',
  'services.service.actions.run.executeCustomCommand.error':'Error during remote command: ',
  'services.service.actions.run.compaction':'Run Compaction',
  'services.service.actions.run.smoke':'Run Service Check',
  'services.service.actions.reassign.master':'Move {0}',
  'services.service.actions.reassign.master.hive':'Move HiveServer2, WebHCat Server, MySQL Server',
  'services.service.actions.manage_configuration_groups':'Manage Configuration Groups...',
  'services.service.actions.run.startLdapKnox.title':'Start Demo LDAP Knox Gateway',
  'services.service.actions.run.startLdapKnox.context':'Start Demo LDAP',
  'services.service.actions.run.stopLdapKnox.title':'Stop Demo LDAP Knox Gateway',
  'services.service.actions.run.stopLdapKnox.context':'Stop Demo LDAP',
  'services.service.actions.run.startStopLdapKnox.error': 'Error during remote command: ',
  'services.service.actions.run.updateHBaseReplication.label': 'Start/Update HBase Replication',
  'services.service.actions.run.updateHBaseReplication.context': 'Enable Cross Cluster HBase Replication',
  'services.service.actions.run.updateHBaseReplication.title': 'HBase Replication: Start/Update',
  'services.service.actions.run.updateHBaseReplication.promptError': 'ZKQuorum should be comma(,) separated ZK nodes. Port and Peer ID should be number',
  'services.service.actions.run.updateHBaseReplication.zkquorumText.prompt': 'Peer Cluster ZK Quorum: ',
  'services.service.actions.run.updateHBaseReplication.zkportText.prompt': 'Peer Cluster ZK Port: ',
  'services.service.actions.run.updateHBaseReplication.parentzkeyText.prompt': 'Parent ZKey for HBase: ',
  'services.service.actions.run.updateHBaseReplication.peerIdText.prompt': 'Peer Cluster ID: ',
  'services.service.actions.run.updateHBaseReplication.error':'Error while setting up HBase Cross Cluster Replication ',
  'services.service.actions.run.stopHBaseReplication.label': 'Stop HBase Replication',
  'services.service.actions.run.stopHBaseReplication.context': 'Disable Cross Cluster HBase Replication',
  'services.service.actions.run.stopHBaseReplication.title': 'HBase Replication: Stop',
  'services.service.actions.run.stopHBaseReplication.promptError': 'Peer ID should be number',
  'services.service.actions.run.stopHBaseReplication.error': 'Error while disabling HBase Cross Cluster Replication ',
  'services.service.actions.run.stopHBaseReplication.prompt': 'Peer Cluster ID to remove from Replication Peer list: ',

  // Hive Server Interactive custom command to restart LLAP
  'services.service.actions.run.restartLLAP':'Restart LLAP',
  'services.service.actions.run.immediateStopHawqService.context':'Stop HAWQ Service (Immediate Mode)',
  'services.service.actions.run.immediateStopHawqService.label':'Stop HAWQ Service (Immediate Mode)',
  'services.service.actions.run.immediateStopHawqSegment.label':'Stop (Immediate Mode)',
  'services.service.actions.run.immediateStopHawqSegment.context':'Stop HAWQ Segment (Immediate Mode)',
  'services.service.actions.run.resyncHawqStandby.context':'Re-Sync HAWQ Standby Master',
  'services.service.actions.run.resyncHawqStandby.label':'Re-Synchronize HAWQ Standby Master',
  'services.service.actions.run.clearHawqCache.label':'Clear HAWQ\'s HDFS Metadata Cache',
  'services.service.actions.run.runHawqCheck.label':'Run HAWQ Config Check',
  'services.service.actions.manage_configuration_groups.short':'Manage Config Groups',
  'services.service.actions.hsi.alertPopup.header':'Cannot enable Interactive Query',
  'services.service.actions.hsi.alertPopup.body':'You cannot enable Interactive Query now because Interactive Query is in the process of being disabled. This may take a few minutes. Try again later.',

  'services.service.delete.popup.header': 'Delete Service',
  'services.service.delete.popup.kerberos': 'The Kerberos Service <i>cannot be deleted</i> because Kerberos is ' +
  'currently enabled, and in use by the cluster. The Kerberos Service can only be removed by disabling Kerberos,' +
  ' which can be found by browsing to <b>Admin > Kerberos</b> and selecting <b>Disable Kerberos</b>.',
  'services.service.delete.popup.ranger': 'Prior to deleting <b>Ranger</b>, you must disable plugins.',
  'services.service.delete.configVersionNote': 'Update configs after {0} has been removed',
  'services.service.delete.configVersionNote.plural': 'Update configs after {0} have been removed',
  'services.service.delete.lastService.popup.body': 'The <b>{0}</b> service can\'t be deleted, at least one service must be installed.',
  'services.service.delete.popup.dependentServices': 'Prior to deleting <b>{0}</b>, you must delete the following dependent services:',
  'services.service.delete.popup.mustBeStopped': 'Prior to deleting <b>{0}</b>, you must stop the service and each slave and master component.',
  'services.service.delete.popup.mustBeStopped.dependent': ' Along with dependent service <b>{0}</b>.',
  'services.service.delete.popup.warning': 'The <b>{0} service will be removed from Ambari and all configurations' +
  ' and configuration history will be lost.</b>',
  'services.service.delete.popup.warning.dependent': '<b> Note: The dependent {0} service will be removed too.</b>',
  'services.service.confirmDelete.popup.header': 'Confirm Delete',
  'services.service.confirmDelete.popup.body': 'You must confirm delete of <b>{0}</b> by typing "{1}"' +
  ' in the confirmation box. <b>This operation is not reversible and all configuration history will be lost.</b>',
  'services.service.confirmDelete.popup.body.type': 'Type "{0}" to confirm',
  'services.service.confirmDelete.popup.body.dependent': 'You must confirm delete of <b>{0}</b> and <b>{1}</b> by typing "{2}"' +
  ' in the confirmation box. <b>This operation is not reversible and all configuration history will be lost.</b>',
  'services.service.delete.progressPopup.message': 'Deleting {0}...',
  'services.service.delete.service.success.confirmation': 'Service {0} was successfully deleted',
  'services.service.delete.service.success.confirmation.plural': 'Services {0} were successfully deleted',
  'services.service.delete.popup.warning.ranger_kms': '<b>Ranger KMS should not be deleted if encryption zones (EZ) and keys are being managed by the service. Otherwise data in the EZ will not be accessible.</b>',

  'services.service.summary.unknown':'unknown',
  'services.service.summary.notRunning':'Not Running',
  'services.service.summary.notAvailable':'n/a',
  'services.service.summary.diskInfoBar.used':'used',
  'services.service.summary.storm.freeslots': 'Free slots',
  'services.service.summary.storm.executors': 'Executors',
  'services.service.summary.storm.tasks': 'Tasks',
  'services.service.summary.storm.nimbus.uptime': 'Nimbus uptime',
  'services.service.summary.storm.topologies': 'Topologies',
  'services.service.summary.flume.startAgent': 'Start Agent',
  'services.service.summary.flume.stopAgent': 'Stop Agent',
  'services.service.summary.flume.stop.context': 'Stop Flume {0}',
  'services.service.summary.flume.start.context': 'Start Flume {0}',
  'services.service.summary.flume.noAgents': 'No Flume to display',

  'services.service.summary.ranger.plugin.title': 'Ranger {0} plugin',
  'services.service.summary.ranger.plugin.loadingStatus': 'Loading status...',

  'services.service.summary.alerts.noAlerts': '0',
  'services.service.summary.alerts.alertsExist': '{0} alerts',
  'services.service.summary.alerts.popup.header': 'Alerts for {0}',

  'services.service.info.metrics.ambariMetrics.master.averageLoad': 'Average load',
  'services.service.info.metrics.ambariMetrics.master.displayNames.averageLoad': 'Average load',
  'services.service.info.metrics.ambariMetrics.regionServer.storeFiles': 'Number of StoreFiles',
  'services.service.info.metrics.ambariMetrics.regionServer.displayNames.storeFilesCount': 'Number of StoreFiles',
  'services.service.info.metrics.ambariMetrics.regionServer.regions': 'Number of Regions',
  'services.service.info.metrics.ambariMetrics.regionServer.displayNames.regionsCount': 'Number of Regions',
  'services.service.info.metrics.ambariMetrics.regionServer.requests': 'Total Request Count',
  'services.service.info.metrics.ambariMetrics.regionServer.displayNames.requestCount': 'Total Request Count',
  'services.service.info.metrics.ambariMetrics.regionServer.blockCacheHitPercent': 'Block Cache Hit Percent',
  'services.service.info.metrics.ambariMetrics.regionServer.displayNames.blockCacheHitPercent': 'Block Cache Hit Percent',
  'services.service.info.metrics.ambariMetrics.regionServer.compactionQueueSize': 'Compaction Queue Size',
  'services.service.info.metrics.ambariMetrics.regionServer.displayNames.compactionQueueSize': 'Compaction Queue Size',

  'services.service.info.metrics.flume.channelFillPercent':'Channel Fill Percentage',
  'services.service.info.metrics.flume.channelSize':'Channel Size',
  'services.service.info.metrics.flume.sinkDrainSuccess':'Sink Event Drain Count',
  'services.service.info.metrics.flume.sourceAccepted':'Source Event Accepted Count',
  'services.service.info.metrics.flume.sinkConnectionFailed':'Sink Connection Failed Count',
  'services.service.info.metrics.flume.channelSizeMMA':'Channel Size Events',
  'services.service.info.metrics.flume.channelSizeSum':'Channel Size Event Sum',
  'services.service.info.metrics.flume.incoming.mma':'Incoming Event Rate',
  'services.service.info.metrics.flume.incoming.sum':'Incoming Event Sum',
  'services.service.info.metrics.flume.outgoing.mma':'Outgoing Event Rate',
  'services.service.info.metrics.flume.outgoing.sum':'Outgoing Event Sum',
  'services.service.info.metrics.flume.gc':'Garbage Collection Time',
  'services.service.info.metrics.flume.cpu.user':'CPU (User)',
  'services.service.info.metrics.flume.jvmThreadsRunnable':'JVM Runnable Threads',
  'services.service.info.metrics.flume.jvmHeapUsed':'JVM Heap Memory Used',
  'services.service.info.metrics.flume.channelType':'Channel size {0}',
  'services.service.info.metrics.flume.incoming_mma':'Incoming {0}',
  'services.service.info.metrics.flume.outgoing_mma':'Outgoing {0}',
  'services.service.info.metrics.flume.sourceName':'Source {0}',
  'services.service.info.metrics.flume.hostName':'Host: {0}',
  'services.service.info.metrics.flume.channelName':'Channel {0}',
  'services.service.info.metrics.flume.sinkName':'Sink {0}',

  'services.service.info.metrics.hbase.clusterRequests':'Cluster Requests',
  'services.service.info.metrics.hbase.clusterRequests.displayNames.requestCount':'Request Count',
  'services.service.info.metrics.hbase.hlogSplitSize':'HLog Split Size',
  'services.service.info.metrics.hbase.hlogSplitSize.displayNames.splitSize':'Split Size',
  'services.service.info.metrics.hbase.hlogSplitTime':'HLog Split Time',
  'services.service.info.metrics.hbase.hlogSplitTime.displayNames.splitTime':'Split Time',
  'services.service.info.metrics.hbase.regionServerQueueSize':'RegionServer Queue Size',
  'services.service.info.metrics.hbase.regionServerQueueSize.displayNames.compactionQueueSize':'Compaction Queue Size',
  'services.service.info.metrics.hbase.regionServerQueueSize.displayNames.flushQueueSize':'Flush Queue Size',
  'services.service.info.metrics.hbase.regionServerRegions':'RegionServer Regions',
  'services.service.info.metrics.hbase.regionServerRegions.displayNames.regions':'Regions',
  'services.service.info.metrics.hbase.regionServerRequests':'Cumulative Requests',
  'services.service.info.metrics.hbase.regionServerRequests.2':'RegionServer Requests',
  'services.service.info.metrics.hbase.regionServerRequests.displayNames.writeRequests':'Write Requests',
  'services.service.info.metrics.hbase.regionServerRequests.displayNames.readRequests':'Read Requests',

  'services.service.info.metrics.hdfs.blockStatus':'Block Status',
  'services.service.info.metrics.hdfs.blockStatus.displayNames.pendingReplicationBlocks':'Pending Replication Blocks',
  'services.service.info.metrics.hdfs.blockStatus.displayNames.underReplicatedBlocks':'Under Replicated Blocks',
  'services.service.info.metrics.hdfs.fileOperations':'File Operations',
  'services.service.info.metrics.hdfs.fileOperations.displayNames.fileInformationOperations':'File Information Operations',
  'services.service.info.metrics.hdfs.fileOperations.displayNames.deleteFileOperations':'Delete File Operations',
  'services.service.info.metrics.hdfs.fileOperations.displayNames.createFileOperations':'Create File Operations',
  'services.service.info.metrics.hdfs.gc':'Garbage Collection',
  'services.service.info.metrics.hdfs.gc.displayNames.gcTimeMillis':'Time',
  'services.service.info.metrics.hdfs.io':'HDFS I/O',
  'services.service.info.metrics.hdfs.io.displayNames.bytesWritten':'Bytes Written',
  'services.service.info.metrics.hdfs.io.displayNames.bytesRead':'Bytes Read',
  'services.service.info.metrics.hdfs.jvmHeap':'JVM Memory Status',
  'services.service.info.metrics.hdfs.jvmHeap.displayNames.memHeapCommittedM':'Heap Memory Committed',
  'services.service.info.metrics.hdfs.jvmHeap.displayNames.memNonHeapUsedM':'Non Heap Memory Used',
  'services.service.info.metrics.hdfs.jvmHeap.displayNames.memHeapUsedM':'Heap Memory Used',
  'services.service.info.metrics.hdfs.jvmHeap.displayNames.memNonHeapCommittedM':'Non Heap Memory Committed',
  'services.service.info.metrics.hdfs.jvmThreads':'JVM Thread Status',
  'services.service.info.metrics.hdfs.jvmThreads.displayNames.threadsBlocked':'Threads Blocked',
  'services.service.info.metrics.hdfs.jvmThreads.displayNames.threadsWaiting':'Threads Waiting',
  'services.service.info.metrics.hdfs.jvmThreads.displayNames.threadsTimedWaiting':'Threads Timed Waiting',
  'services.service.info.metrics.hdfs.jvmThreads.displayNames.threadsRunnable':'Threads Runnable',
  'services.service.info.metrics.hdfs.rpc':'RPC',
  'services.service.info.metrics.hdfs.rpc.displayNames.rpcQueueTimeAvgTime':'Queue Average Wait Time',
  'services.service.info.metrics.hdfs.spaceUtilization':'Total Space Utilization',
  'services.service.info.metrics.hdfs.spaceUtilization.displayNames.capacityRemainingGB':'Capacity Remaining',
  'services.service.info.metrics.hdfs.spaceUtilization.displayNames.capacityUsedGB':'Capacity Used',
  'services.service.info.metrics.hdfs.spaceUtilization.displayNames.capacityTotalGB':'Capacity Total',
  'services.service.info.metrics.hdfs.spaceUtilization.displayNames.capacityRemaining':'Capacity Remaining',
  'services.service.info.metrics.hdfs.spaceUtilization.displayNames.capacityUsed':'Capacity Used',
  'services.service.info.metrics.hdfs.spaceUtilization.displayNames.capacityTotal':'Capacity Total',
  'services.service.info.metrics.hdfs.spaceUtilization.displayNames.capacityNonDFSUsed':'Non DFS Capacity Used',

  'services.service.info.metrics.yarn.jvmHeap':'JVM Memory Status',
  'services.service.info.metrics.yarn.jvmHeap.displayNames.memHeapCommittedM':'Heap Memory Committed',
  'services.service.info.metrics.yarn.jvmHeap.displayNames.memNonHeapUsedM':'Non Heap Memory Used',
  'services.service.info.metrics.yarn.jvmHeap.displayNames.memHeapUsedM':'Heap Memory Used',
  'services.service.info.metrics.yarn.jvmHeap.displayNames.memNonHeapCommittedM':'Non Heap Memory Committed',
  'services.service.info.metrics.yarn.jvmThreads':'JVM Thread Status',
  'services.service.info.metrics.yarn.jvmThreads.displayNames.threadsBlocked':'Threads Blocked',
  'services.service.info.metrics.yarn.jvmThreads.displayNames.threadsWaiting':'Threads Waiting',
  'services.service.info.metrics.yarn.jvmThreads.displayNames.threadsTimedWaiting':'Threads Timed Waiting',
  'services.service.info.metrics.yarn.jvmThreads.displayNames.threadsRunnable':'Threads Runnable',
  'services.service.info.metrics.yarn.rpc':'RPC',
  'services.service.info.metrics.yarn.rpc.displayNames.RpcQueueTimeAvgTime':'Queue Average Wait Time',
  'services.service.info.metrics.yarn.gc': 'Garbage Collection',
  'services.service.info.metrics.yarn.gc.displayNames.gcTimeMillis':'Time',
  'services.service.info.metrics.yarn.allocated.memory': 'Cluster Memory',
  'services.service.info.metrics.yarn.allocated.memory.displayNames.allocated': 'Allocated',
  'services.service.info.metrics.yarn.allocated.memory.displayNames.available': 'Available',
  'services.service.info.metrics.yarn.allocated.memory.displayNames.pending': 'Pending',
  'services.service.info.metrics.yarn.allocated.container': 'Containers',
  'services.service.info.metrics.yarn.allocated.container.displayNames.allocated': 'Allocated',
  'services.service.info.metrics.yarn.allocated.container.displayNames.reserved': 'Reserved',
  'services.service.info.metrics.yarn.allocated.container.displayNames.pending': 'Pending',
  'services.service.info.metrics.yarn.nodemanager.statuses':'NodeManagers',
  'services.service.info.metrics.yarn.nodemanager.statuses.displayNames.active':'Active NodeManagers',
  'services.service.info.metrics.yarn.nodemanager.statuses.displayNames.decommissioned':'Decommissioned NodeManagers',
  'services.service.info.metrics.yarn.nodemanager.statuses.displayNames.lost':'Lost NodeManagers',
  'services.service.info.metrics.yarn.nodemanager.statuses.displayNames.rebooted':'Rebooted NodeManagers',
  'services.service.info.metrics.yarn.nodemanager.statuses.displayNames.unhealthy':'Unhealthy NodeManagers',
  'services.service.info.metrics.yarn.queueMemoryResource':'Queue Memory Used',
  'services.service.info.metrics.yarn.queueMemoryResource.displayNames.allocated':'Allocated ({0})',
  'services.service.info.metrics.yarn.queueMemoryResource.displayNames.available':'Available ({0})',
  'services.service.info.metrics.yarn.queueMemoryResource.displayName':'Queue: {0}',
  'services.service.info.metrics.yarn.apps.states.current.title': 'Current Applications',
  'services.service.info.metrics.yarn.apps.states.finished.title': 'Finished Applications',
  'services.service.info.metrics.yarn.apps.states.completed': 'Completed',
  'services.service.info.metrics.yarn.apps.states.failed': 'Failed',
  'services.service.info.metrics.yarn.apps.states.killed': 'Killed',
  'services.service.info.metrics.yarn.apps.states.pending': 'Pending',
  'services.service.info.metrics.yarn.apps.states.running': 'Running',
  'services.service.info.metrics.yarn.apps.states.submitted': 'Submitted',

  'services.service.info.menu.summary':'Summary',
  'services.service.info.menu.configs':'Configs',
  'services.service.info.menu.heatmaps':'Heatmaps',
  'services.service.info.menu.metrics':'Metrics',
  'services.service.info.summary.hostsRunningMonitor':'{0}/{1}',
  'services.service.info.summary.serversHostCount':'{0} more',

  'services.service.config.nothing.to.display': 'No properties to display.',
  'services.service.config.final':'Final',
  'services.service.config.password.additionalDescription': 'For security purposes, password changes will not be shown in configuration version comparisons',
  'services.service.config.secure.additionalDescription': 'This config can be changed from Kerberos page under Admin tab by privileged users.',
  'services.service.config.saved':'Save Configuration Changes',
  'services.service.config.notSaved':'Unable to Save Configuration Changes',
  'services.service.config.restartService.TooltipMessage':'<b>Restart Service</b><br>Stale configuration used by {0} components on {1} hosts:{2}',
  'services.service.config.restartService.needToRestart':'<strong>Restart Required:</strong> ',
  'services.service.config.restartService.needToRestartEnd':'should be restarted',
  'service.service.config.restartService.shouldBeRestarted':'{0} Requiring Restart',
  'services.service.config.saved.message':'Service configuration changes saved successfully.',
  'services.service.config.saving.message':'Configuration changes are being saved...',
  'services.service.config.msgServiceStop':'Could not save configuration changes.  Please stop the service first. You will be able to save configuration changes after all of its components are stopped.',
  'services.service.config.failCreateConfig' : 'Failure in creating service configuration',
  'services.service.config.failSaveConfig':'Failure in saving service configuration',
  'services.service.config.failSaveConfigHostOverrides':'Failure in saving service configuration overrides',
  'services.service.config.addPropertyWindow.error.required':'This is required',
  'services.service.config.addPropertyWindow.error.derivedKey':'This property is already defined',
  'services.service.config.addPropertyWindow.error.derivedKey.location':'This property is already defined in other configuration file(s) {0}',
  'services.service.config.addPropertyWindow.error.derivedKey.infile':'This property is already defined in this configuration file',
  'services.service.config.addPropertyWindow.error.derivedKey.specific':'Property "{0}" is already defined in this configuration file',
  'services.service.config.addPropertyWindow.error.format':'Key and value should be separated by "=" sign',
  'services.service.config.addPropertyWindow.error.lineNumber':'Line {0}: ',
  'services.service.config.addPropertyWindow.filterKeyLink' : 'Find property',
  'services.service.config.addPropertyWindow.properties' : 'Properties',
  'services.service.config.addPropertyWindow.propertiesHelper' : 'key=value (one per line)',
  'services.service.config.addPropertyWindow.propertiesPlaceholder' : 'Enter key=value (one per line)',
  'services.service.config.addPropertyWindow.bulkMode' : 'Bulk property add mode',
  'services.service.config.addPropertyWindow.singleMode' : 'Single property add mode',
  'services.service.config.stopService.runningHostComponents':'{0} components on {1} hosts are running',
  'services.service.config.stopService.unknownHostComponents':'{0} components on {1} hosts are in unknown state.  These components might actually be running and need restarting later to make the changes effective.',
  'services.service.config.confirmDirectoryChange':'You are about to make changes to service directories that are core to {0}. Before you proceed, be absolutely certain of the implications and that you have taken necessary manual steps, if any, for the changes. Are you sure you want to proceed?',
  'services.service.config.configOverride.head':'Config Override',
  'services.service.config.configOverride.body':'Cannot override a config that has not been saved yet.',
  'services.service.config.exitPopup.body':'You have unsaved changes. Save changes or discard?',
  'services.service.config.exitChangesPopup.body':'Going back to the previous step will result in losing all your current customizations. Are you sure?',
  'services.service.config.propertyFilterPopover.title':'Properties filter',
  'services.service.config.propertyFilterPopover.content':'Enter keywords to filter properties by property name, value, or description.',
  'services.service.config.hive.oozie.postgresql': 'Existing PostgreSQL Database',
  'services.service.config.database.connection.success': 'Connection OK',
  'services.service.config.database.connection.inProgress': 'Checking connectivity',
  'services.service.config.database.connection.failed': 'Connection Failed',
  'services.service.config.connection.logsPopup.header': '{0} Connection: {1}',
  'services.service.config.connection.exitPopup.msg': 'Test connection is in progress. It\'s recommended to wait until it wil be complete. Are you sure you want to exit Enable Kerberos Wizard?',
  'services.service.config.database.btn.idle': 'Test Connection',
  'services.service.config.kdc.btn.idle': 'Test KDC Connection',
  'services.service.config.database.btn.connecting': 'Connecting...',
  'services.service.config.database.msg.jdbcSetup': 'Be sure you have run:<br/>' +
    '<b>ambari-server setup --jdbc-db={0} --jdbc-driver=/path/to/{0}/{1}</b> ' +
    'on the Ambari Server host to make the JDBC driver available and to enable testing the database connection.',
  'services.service.config.configHistory.configGroup': 'Config Group',
  'services.service.config.configHistory.rightArrow.tooltip': 'Show earlier versions',
  'services.service.config.configHistory.leftArrow.tooltip': 'Show later versions',
  'services.service.config.configHistory.dismissIcon.tooltip': 'Dismiss',
  'services.service.config.configHistory.makeCurrent.message': 'Created from service config version {0}',
  'services.service.config.configHistory.comparing': 'Comparing Changes in',
  'services.service.config.setRecommendedValue': 'Set Recommended',
  'services.service.config.database.msg.jdbcSetup.detailed': 'To use {0} with {6}, you must <a rel="noopener noreferrer" href="{3}" target="_blank">' +
    'download the {4} from {0}</a>. Once downloaded to the Ambari Server host, run: <br/>' +
    '<b>ambari-server setup --jdbc-db={1} --jdbc-driver=/path/to/{1}/{2}</b>',

  'services.service.widgets.list-widget.nothingSelected': 'Nothing selected',

  'services.add.header':'Add Service Wizard',
  'services.add.warning': 'Add Service Wizard is in progress. Do you really want to exit the Add Service Wizard?',
  'services.add.warningStep6': 'Closing this dialog will continue to install the selected service(s) in the background, but the installed services need to be started manually. Are you sure you want to quit?',
  'services.reassign.header':'Move Master Wizard',
  'services.service.add':'Add Service',
  'services.service.startAll':'Start All',
  'services.service.stopAll':'Stop All',
  'services.service.startAllComponents': 'Start all components for {0}',
  'services.service.stopAllComponents': 'Stop all components for {0}',
  'services.service.restartAllRequired':'Restart All Required',
  'services.service.downloadAllClientConfigs':'Download All Client Configs',
  'services.service.startAll.confirmMsg' : 'You are about to start all services',
  'services.service.stopAll.confirmMsg' : 'You are about to stop all services',
  'services.service.refreshAll.confirmMsg': '<p>You are about to restart {0}</p>' +
    '<div class="alert alert-warning">This will trigger alerts as the service is restarted. To suppress alerts, turn on Maintenance Mode for services listed above prior to running Restart All Required</div>',
  'services.service.start.confirmMsg' : 'You are about to start {0}',
  'services.service.stop.confirmMsg' : 'You are about to stop {0}',
  'services.service.stop.confirmButton': 'Confirm Stop',
  'services.service.start.confirmButton' : 'Confirm Start',
  'services.service.stop.warningMsg.turnOnMM': 'This will generate alerts as the service is stopped. To suppress alerts, turn on Maintenance Mode for {0} prior to stopping.',
  'services.service.stopCertain.warningMsg.turnOnMM': 'This will generate alerts as components are stopped. To suppress alerts, turn on Maintenance Mode for {0} prior to stopping.',
  'services.service.stop.warningMsg.dependent.services': 'Stopping {0} may impair the functioning of its dependent service(s): {1}.',
  'services.service.restartAll.confirmButton': 'Confirm Restart All',
  'services.service.restartAll.confirmMsg': 'You are about to restart {0}',
  'services.service.restartAll.warningMsg.turnOnMM': 'This will trigger alerts as the service is restarted. To suppress alerts, turn on Maintenance Mode for {0} prior to running restart all',
  'services.service.restartCertain.warningMsg.turnOnMM': 'This will trigger alerts as components are restarted. To suppress alerts, turn on Maintenance Mode for {0} prior to running restart all',
  'services.service.componentsInNameSpace': 'components in {0} namespace',
  'services.service.stop.HDFS.warningMsg.checkPointNA': 'Could not determine the age of the last HDFS checkpoint. Please ensure that you have a recent checkpoint. Otherwise, the NameNode(s) can take a very long time to start up.',
  'services.service.stop.HDFS.warningMsg.checkPointTooOld.instructions.singleHost.login': '<br><ol><li>Login to the NameNode host <b>{0}</b>.</li>',
  'services.service.stop.HDFS.warningMsg.checkPointTooOld.instructions.multipleHosts.login': '<ol><li>Login to the NameNode hosts {0}.</li>',
  'services.service.stop.HDFS.warningMsg.checkPointTooOld.instructions':
    '<li>Put the NameNode in Safe Mode (read-only mode):' +
    '<div class="code-snippet">sudo su {0} -l -c \'hdfs dfsadmin -safemode enter\'</div></li>' +
    '<li>Once in Safe Mode, create a Checkpoint:' +
    '<div class="code-snippet">sudo su {0} -l -c \'hdfs dfsadmin -saveNamespace\'</div></li>' +
    '</ol>',
  'services.service.stop.HDFS.warningMsg.checkPointTooOld': 'The last HDFS checkpoint is older than {0} hours. ',
  'services.service.stop.HDFS.warningMsg.checkPointTooOld.makeSure': 'Make sure that you have taken a checkpoint before proceeding. Otherwise, the NameNode(s) can take a very long time to start up.',
  'services.service.stop.HDFS.warningMsg.nameSpaces.checkPointTooOld': 'The last HDFS checkpoint is older than {0} hours for the following namespaces:',
  'services.service.config_groups_popup.header':'Manage {0} Configuration Groups',
  'services.service.config_groups_popup.notice':'You can apply different sets of {{serviceName}} configurations to groups of hosts by managing {{serviceName}} Configuration Groups and their host membership.  Hosts belonging to a {{serviceName}} Configuration Group have the same set of configurations for {{serviceName}}. Each host belongs to one {{serviceName}} Configuration Group.',
  'services.service.config_groups_popup.rename':'Rename',
  'services.service.config_groups_popup.duplicate':'Duplicate',
  'services.service.config_groups_popup.group_name_lable':'Name',
  'services.service.config_groups_popup.group_desc_lable':'Description',
  'services.service.config_groups_popup.properties':'Properties',
  'services.service.config_groups_popup.addButton':'Create new Configuration Group',
  'services.service.config_groups_popup.removeButton':'Delete Configuration Group',
  'services.service.config_groups_popup.renameButton':'Rename Configuration Group',
  'services.service.config_groups_popup.addHost':'Add hosts to selected Configuration Group',
  'services.service.config_groups_popup.addHostDisabled':'There are no available hosts to add.',
  'services.service.config_groups_popup.removeHost':'Remove hosts from selected Configuration Group',
  'services.service.config_groups_popup.duplicateButton':'Duplicate Configuration Group',
  'services.service.config_groups.add_config_group_popup.header':'Create New Configuration Group',
  'services.service.config_groups.duplicate_config_group_popup.header':'Duplicate Configuration Group',
  'services.service.config_groups.rename_config_group_popup.header':'Rename Configuration Group',
  'services.service.config_groups.switchGroupTextFull':'Switch to \'{0}\' host config group',
  'services.service.config_groups.switchGroupTextShort':'Switch to \'{0}\'',
  'services.reassign.closePopup':'Move {0} wizard is in progress. You must allow the wizard to complete for Ambari to be in usable state. If you choose to quit, you must follow manual instructions to complete or revert move {0} wizard as documented in the Ambari User Guide. Are you sure you want to exit the wizard?',
  'services.reassign.error.fewHosts':'You must have at least 2 hosts in your cluster to run Move Wizard.',

  'services.reassign.step1.header':'Get Started',
  'services.reassign.step1.message1': 'This wizard will walk you through moving {0}.<br/>',
  'services.reassign.step1.message2': 'The process to reassign {0} involves a combination of <b>automated steps</b> (that will be handled by the wizard) and ' +
      '<b>manual steps</b> (that you must perform in sequence as instructed by the wizard).<br/><br/>',
  'services.reassign.step1.message3': '<br/><p class="restart-services-alert">Following services will be restarted as part of the wizard: <b>{0}</b>. You should plan a cluster maintenance window and prepare ' +
    'for cluster downtime when moving {1}.</p>',

  'services.reassign.step2.header':'Assign Master',
  'services.reassign.step2.currentHost':'Current:',
  'services.reassign.step2.body':'Assign {0} to new host.',
  'services.reassign.step2.body.namenodeHA':'Move {0} to new host. You can move only one master component at a time.',
  'services.reassign.step3.header':'Review',
  'services.reassign.step3.body':'<b>Confirm your host selections.</b>',
  'services.reassign.step3.targetHost':'Target Host:',
  'services.reassign.step3.sourceHost':'Source Host:',
  'services.reassign.step3.component':'Component name:',
  'services.reassign.step3.configs':'<div class="alert alert-info">' +
    '<p><b>Review Configuration Changes.</b></p>The Wizard will make the following configuration changes.</div>',
  'services.reassign.step4.header':'Configure Component',

  'services.reassign.step4.tasks.stopRequiredServices.title':'Stop Required Services',
  'services.reassign.step4.tasks.createHostComponents.title':'Create {0}',
  'services.reassign.step4.tasks.putHostComponentsInMaintenanceMode.title':'Disable {0}',
  'services.reassign.step4.tasks.reconfigure.title':'Reconfigure {0}',
  'services.reassign.step4.tasks.save.configuration.note':'This configuration is created by Move {0} wizard',
  'services.reassign.step4.tasks.installHostComponents.title':'Install {0}',
  'services.reassign.step4.tasks.startZooKeeperServers.title':'Start ZooKeeper Servers',
  'services.reassign.step4.tasks.startNameNode.title':'Start NameNode',
  'services.reassign.step4.tasks.stopHostComponentsInMaintenanceMode.title':'Stop {0}',
  'services.reassign.step4.tasks.deleteHostComponents.title':'Delete disabled {0}',
  'services.reassign.step4.tasks.startRequiredServices.title':'Start Required Services',
  'services.reassign.step4.tasks.cleanMySqlServer.title':'Clean MYSQL Server',
  'services.reassign.step4.tasks.testHiveMysqlConnection.title':'Test MYSQL Connection',
  'services.reassign.step4.tasks.configureMySqlServer.title':'Configure MYSQL Server',
  'services.reassign.step4.tasks.startMySqlServer.title':'Start MYSQL Server',
  'services.reassign.step4.tasks.restartMySqlServer.title':'Restart MYSQL Server',
  'services.reassign.step4.tasks.startServices.title':'Start Services',
  'services.reassign.step4.tasks.testDBConnection.title':'Test DB Connection',
  'services.reassign.step4.tasks.testDBConnection.tooltip':'Database Host: {0}\n' +
  'Database Type: {1}\n' +
  'Database Name: {2}\n' +
  'Username: {3}\n' +
  'Password: {4}\n' +
  'JDBC Driver Class: {5}\n' +
  'Database URL: {6}',
  'services.reassign.rollback.confirm':'Are you sure?',


  'services.reassign.step4.task0.title':'Stop Required Services',
  'services.reassign.step4.task1.title':'Create {0}',
  'services.reassign.step4.task2.title':'Disable {0}',
  'services.reassign.step4.task3.title':'Reconfigure {0}',
  'services.reassign.step4.save.configuration.note':'This configuration is created by Move {0} wizard',
  'services.reassign.step4.task4.title':'Install {0}',
  'services.reassign.step4.task5.title':'Start ZooKeeper Servers',
  'services.reassign.step4.task6.title':'Start NameNode',
  'services.reassign.step4.task7.title':'Delete disabled {0}',
  'services.reassign.step4.task8.title':'Start Required Services',
  'services.reassign.step4.tasks.startNewMySqlServer.title':'Start New MYSQL Server',
  'services.reassign.step4.status.success': 'Successfully moved <b>{0}</b> from <b>{1}</b> host to <b>{2}</b> host',
  'services.reassign.step4.status.success.withManualSteps': 'Proceed to the next step',
  'services.reassign.step4.status.failed': 'Failed to move <b>{0}</b> from <b>{1}</b> host to <b>{2}</b> host',
  'services.reassign.step4.status.info': 'Reassigning {0}. \nPlease wait for all tasks to be completed.',
  'services.reassign.step4.retry': 'You can click on the Retry or Abort button to retry failed task or abort changes',
  'services.reassign.step4.abortError': 'Error in aborting changes.',
  'services.reassign.step5.header': 'Manual commands',
  'services.reassign.step5.body.namenode':
      '<div class="alert alert-info">' +
      '<ol>' +
      '<li>Copy the contents of <b>{0}</b> on the source host <b>{1}</b> to <b>{0}</b> on the target host <b>{2}</b>.</li>' +
      '<li>Login to the target host <b>{2}</b> and change permissions for the NameNode dirs by running:' +
      '<div class="code-snippet">chown -R {3}:{5} {6}</div></li>' +
      '<li>Create marker directory by running:' +
      '<div class="code-snippet">mkdir -p /var/lib/hdfs/namenode/formatted</div></li>' +
      '</ol>' +
      '</div>',
  'services.reassign.step5.body.namenode_ha':
      '<div class="alert alert-info">' +
      '<ol>' +
      '<li>Login to the NameNode host <b>{4}</b>.</li>' +
      '<li>Reset automatic failover information in ZooKeeper by running:' +
      '<div class="code-snippet">sudo su {3} -l -c \'hdfs zkfc -formatZK\'</div></li>' +
      '</ol>' +
      '</div>' +
      '<div class="alert alert-info">' +
      '<ol start="3">' +
      '<li>Login to the newly installed NameNode host <b>{2}</b>.<br>' +
      '<div class="alert alert-warning"><strong>Important!</strong> Be sure to login to the newly installed NameNode host.<br>This is a different host from the Steps 1 and 2 above.</div>' +
      '</li>' +
      '<li>Initialize the metadata by running:' +
      "<div class='code-snippet'>sudo su {3} -l -c 'hdfs namenode -bootstrapStandby'</div></li>" +
      '</ol>' +
      '</div>',
  'services.reassign.step5.body.secondary_namenode':
      '<div class="alert alert-info">' +
      '<ol>' +
      '<li>Copy the contents of <b>{0}</b> on the source host <b>{1}</b> to <b>{0}</b> on the target host <b>{2}</b>.</li>' +
      '<li>Login to the target host <b>{2}</b> and change permissions for the SNameNode dirs by running:' +
      '<div class="code-snippet">chown -R {3}:{5} {6}</div></li>' +
      '</ol>' +
      '</div>',
  'services.reassign.step5.body.oozie_server':
    '<div class="alert alert-info">' +
    '<ol>' +
    '<li>On <b>{1}</b> copy the contents of' +
    '<div class="code-snippet"><b>/hadoop/oozie/data/oozie-db</b></div></li>' +
    '<li>To the target host <b>{2}</b></li>' +
    '<li>If the directory doesn\'t exists you can create by running' +
    '<div class="code-snippet">mkdir -p /hadoop/oozie/data/oozie-db</div></li>' +
    '<li>Update directory permissions by running' +
    '<div class="code-snippet">chown -R oozie:{5} /hadoop/oozie/data</div></li>' +
    '</ol>' +
    '</div>',
  'services.reassign.step5.body.mysql_server':
    '<div class="alert alert-info">' +
    '<ol>' +
    '<li>On <b>{1}</b> using a terminal you can export your Metastore DB (MYSQL) using:' +
    '<div class="code-snippet">mysqldump db_name > backup-file.sql</div></li>' +
    '<li>Copy the file to the target host <b>{2}</b> hosting the MySQL DB</li>' +
    '<li>Execute this SQL inside <b>mysql<b>' +
    '<div class="code-snippet">CREATE DATABASE db_name;</div></li>' +
    '<li>Import the database using' +
    '<div class="code-snippet">mysql db_name < backup-file.sql</div></li>' +
    '</ol>' +
    '</div>',
  'services.reassign.step5.body.app_timeline_server': '<div class="alert alert-info">' +
  '<ol>' +
  '<li>Copy <b>{7}/{8}</b> from the source host <b>{1}</b> to <b>{7}/{8}</b> on the target host <b>{2}</b>.</li>' +
  '<li>Login to the target host <b>{2}</b> and change permissions by running:' +
  '<div class="code-snippet">chown -R {3}:{5} {7}/{8}</div></li>' +
  '<div class="code-snippet">chmod -R 700 {7}/{8}</div></li>' +
  '</ol>' +
  '</div>',
  'services.reassign.step5.body.securityNotice': '<div class="alert alert-info"> <div class="alert alert-warning"> <strong>Note: </strong> Secure cluster' +
    ' requires generating necessary principals for reassigned component and creating keytab files with the principal on ' +
    'the target host. The keytab file should be accessible to the service user.</div> {0} </div>',
  'services.reassign.step5.body.securityConfigsList': 'Create keytab file <b>{0}</b> with principal <b>{1}</b> on <b>{2}</b> host.',
  'services.reassign.step5.body.proceedMsg': 'Please proceed once you have completed the steps above',
  'services.reassign.step5.confirmPopup.body': 'Please confirm that you have run the manual steps before continuing.',
  'services.reassign.step6.header': 'Start and Test services',
  'services.reassign.step6.tasks.putHostComponentsInMaintenanceMode.title':'Disable {0}',
  'services.reassign.step6.tasks.deleteHostComponents.title': 'Delete disabled {0}',
  'services.reassign.step6.tasks.startAllServices.title': 'Start All Services',
  'services.reassign.step6.tasks.installPxf.title': 'Install PXF on NameNode',
  'services.reassign.step6.tasks.stopMysqlService.title': 'Stop Mysql Server',
  'services.reassign.step6.tasks.stopHostComponentsInMaintenanceMode.title': 'Stop {0}',
  'services.reassign.step6.tasks.startDatanodes.title': 'Start DataNodes',
  'services.reassign.step6.status.success': 'Successfully moved <b>{0}</b> from <b>{1}</b> host to <b>{2}</b> host.',
  'services.reassign.step6.status.failed': 'Failed to move <b>{0}</b> from <b>{1}</b> host to <b>{2}</b> host.',
  'services.reassign.step6.status.info': 'Reassigning {0}. \nPlease wait for all tasks to be completed.',
  'services.reassign.step7.header': 'Rollback',
  'services.reassign.step7.info': 'Rollback in progress',
  'services.reassign.step7.failed': 'Rollback failed',
  'services.reassign.step7.success': 'Rollback successfully completed',

  /** services page constants **/

  'service.hbase.activeMaster': 'Active Master',

  'services.hive.client': 'Hive Client',
  'services.hive.clients': 'Hive Clients',

  'services.falcon.client': 'Falcon Client',
  'services.falcon.clients': 'Falcon Clients',

  'services.oozie.client': 'Oozie Client',
  'services.oozie.clients': 'Oozie Clients',
  'services.oozie.webUi': 'Oozie Web UI',

  'services.ganglia.webUi': 'Ganglia Web UI',
  'services.ganglia.monitors': 'Ganglia Monitors',

  'services.mapreduce2.webUi': 'History Server UI',

  'services.zookeeper.prefix': '{0} of',
  'services.zookeeper.title': '{0} ZooKeepers',
  'services.zookeeper.postfix': 'running',
  'services.zookeeper.clients': 'ZooKeeper Clients',
  'services.zookeeper.client': 'ZooKeeper Client',

  'services.mapreduce2.history.running': 'History server is running',
  'services.mapreduce2.history.stopped': 'History server is stopped',
  'services.mapreduce2.history.unknown': 'History server status is unknown',
  'services.mapreduce2.smokeTest.requirement': 'MapReduce2 smoke test requires YARN service be started',

  'services.tez.client': 'Tez client',
  'services.tez.clients': 'Tez clients',
  'services.pig.client': 'Pig client',
  'services.pig.clients': 'Pig clients',
  'services.glusterfs.client': 'GLUSTERFS client',
  'services.glusterfs.clients': 'GLUSTERFS clients',
  'services.sqoop.client': 'Sqoop client',
  'services.sqoop.clients': 'Sqoop clients',

  'services.hbase.master.error':'None of the HBase masters is active',

  'alerts.actions.manage_alert_groups_popup.header':'Manage Alert Groups',
  'alerts.actions.manage_alert_groups_popup.notice':'You can manage alert groups for each service in this dialog. View the list of alert groups and the alert definitions configured in them. ' +
    'You can also add/remove alert definitions, and pick notification for that alert group.',
  'alerts.actions.manage_alert_groups_popup.rename':'Rename',
  'alerts.actions.manage_alert_groups_popup.duplicate':'Duplicate',
  'alerts.actions.manage_alert_groups_popup.group_name_lable':'Name',
  'alerts.actions.manage_alert_groups_popup.group_desc_lable':'Description',
  'alerts.actions.manage_alert_groups_popup.notifications':'Notifications',
  'alerts.actions.manage_alert_groups_popup.addButton':'Create Alert Group',
  'alerts.actions.manage_alert_groups_popup.addGroup.exist': 'Alert Group with given name already exists',
  'alerts.actions.manage_alert_groups_popup.removeButton':'Delete Alert Group',
  'alerts.actions.manage_alert_groups_popup.removeButtonDisabled':'Cannot delete default alert group',
  'alerts.actions.manage_alert_groups_popup.renameButton':'Rename Alert Group',
  'alerts.actions.manage_alert_groups_popup.duplicateButton':'Duplicate Alert Group',
  'alerts.actions.manage_alert_groups_popup.addDefinition.noDefinitions':'No alert definitions to display',
  'alerts.actions.manage_alert_groups_popup.addDefinition':'Add alert definitions to selected Alert Group',
  'alerts.actions.manage_alert_groups_popup.addDefinitionDisabled':'There are no available alert definitions to add',
  'alerts.actions.manage_alert_groups_popup.addDefinitionToDefault': 'Cannot modify default alert group',
  'alerts.actions.manage_alert_groups_popup.removeDefinition':'Remove alert definitions from selected Alert Group',
  'alerts.actions.manage_alert_groups_popup.removeDefinitionDisabled':'Cannot modify default alert group',
  'alerts.actions.manage_alert_groups_popup.selectDefsDialog.title': 'Select Alert Group Definitions',
  'alerts.actions.manage_alert_groups_popup.selectDefsDialog.message': 'Select alert definitions to be added to this "{0}" Alert Group.',
  'alerts.actions.manage_alert_groups_popup.selectDefsDialog.filter.placeHolder': 'All',
  'alerts.actions.manage_alert_groups_popup.selectDefsDialog.selectedDefsLink': '{0} out of {1} alert definitions selected',
  'alerts.actions.manage_alert_groups_popup.selectDefsDialog.message.warning': 'At least one alert definition needs to be selected.',

  'alerts.actions.manage_alert_notifications_popup.header':'Manage Alert Notifications',
  'alerts.actions.manage_alert_notifications_popup.noAlertNotification':'No alert notifications defined',
  'alerts.actions.manage_alert_notifications_popup.addButton':'Create new Alert Notification',
  'alerts.actions.manage_alert_notifications_popup.addHeader':'Create Alert Notification',
  'alerts.actions.manage_alert_notifications_popup.removeButton':'Delete Alert Notification',
  'alerts.actions.manage_alert_notifications_popup.editButton':'Edit Alert Notification',
  'alerts.actions.manage_alert_notifications_popup.editHeader':'Edit Notification',
  'alerts.actions.manage_alert_notifications_popup.duplicateButton':'Duplicate Alert Notification',
  'alerts.actions.manage_alert_notifications_popup.disableButton':'Disable Alert Notification',
  'alerts.actions.manage_alert_notifications_popup.enableButton':'Enable Alert Notification',
  'alerts.actions.manage_alert_notifications_popup.method':'Method',
  'alerts.actions.manage_alert_notifications_popup.email':'Email To',
  'alerts.actions.manage_alert_notifications_popup.SMTPServer':'SMTP Server',
  'alerts.actions.manage_alert_notifications_popup.SMTPPort':'SMTP Port',
  'alerts.actions.manage_alert_notifications_popup.SMTPUseAuthentication':'Use authentication',
  'alerts.actions.manage_alert_notifications_popup.SMTPUsername':'Username',
  'alerts.actions.manage_alert_notifications_popup.SMTPPassword':'Password',
  'alerts.actions.manage_alert_notifications_popup.retypeSMTPPassword':'Password Confirmation',
  'alerts.actions.manage_alert_notifications_popup.SMTPSTARTTLS':'Start TLS',
  'alerts.actions.manage_alert_notifications_popup.emailFrom':'Email From',
  'alerts.actions.manage_alert_notifications_popup.version':'Version',
  'alerts.actions.manage_alert_notifications_popup.OIDs':'OID',
  'alerts.actions.manage_alert_notifications_popup.community':'Community',
  'alerts.actions.manage_alert_notifications_popup.host':'Hosts',
  'alerts.actions.manage_alert_notifications_popup.port':'Port',
  'alerts.actions.manage_alert_notifications_popup.global':'Global',
  'alerts.actions.manage_alert_notifications_popup.noDescription':'<i>No description</i>',
  'alerts.actions.manage_alert_notifications_popup.noGroup':'<i>None selected</i>',
  'alerts.actions.manage_alert_notifications_popup.severityFilter':'Severity',
  'alerts.actions.manage_alert_notifications_popup.clearAll':'Clear All',
  'alerts.actions.manage_alert_notifications_popup.selectAll':'Select All',
  'alerts.actions.manage_alert_notifications_popup.confirmDeleteHeader':'Confirm Delete',
  'alerts.actions.manage_alert_notifications_popup.confirmDeleteBody':'Are you sure you want to delete {0} notification?',
  'alerts.actions.manage_alert_notifications_popup.error.name.empty': 'Notification name is required',
  'alerts.actions.manage_alert_notifications_popup.error.name.existed': 'Notification name already exists',
  'alerts.actions.manage_alert_notifications_popup.scriptDispatchProperty':'Script Dispatch Property',
  'alerts.actions.manage_alert_notifications_popup.scriptFileName':'Script Filename',
  'alerts.actions.manage_alert_notifications_popup.error.scriptFileName.invalid': 'Invalid script filename',

  'hosts.host.add':'Add New Hosts',
  'hosts.table.noHosts':'No hosts to display',

  'hosts.filters.filteredHostsInfo': '{0} of {1} hosts showing',

  'hosts.filters.selectedHostInfo': 'host selected',
  'hosts.filters.selectedHostsInfo': 'hosts selected',

  'hosts.filters.clearSelection': 'clear selection',

  'hosts.filters.filterComponents': 'Filter by <strong>Component</strong>',

  'hosts.table.restartComponents.withNames':'Restart {0}',
  'hosts.table.restartComponents.withoutNames':'{0} components should be restarted',

  'hosts.table.componentsInPassiveState.withNames':'{0} in Maintenance Mode',
  'hosts.table.componentsInPassiveState.withoutNames':'{0} components in Maintenance Mode',

  'hosts.table.menu.l1.selectedHosts':'Selected Hosts',
  'hosts.table.menu.l1.filteredHosts':'Filtered Hosts',
  'hosts.table.menu.l1.allHosts':'All Hosts',
  'hosts.table.menu.l2.allComponents':'All Components',
  'hosts.table.menu.l2.restartAllComponents':'Restart All Components',
  'hosts.table.menu.l2.reinstallFailedComponents':'Reinstall Failed Components',
  'hosts.table.menu.l2.refreshConfigsClientComponents':'Refresh All Configs',

  'hosts.bulkOperation.confirmation.header':'Confirm Bulk Operation',
  'hosts.bulkOperation.confirmation.hosts':'Are you sure you want to <strong>{0}</strong> on the following {1} hosts?',
  'hosts.bulkOperation.confirmation.delete.hosts':'Are you sure you want to delete the following {0} hosts?',
  'hosts.bulkOperation.confirmation.hostComponents':'Are you sure you want to <strong>{0} {1}</strong> on the following {2} hosts?',
  'hosts.bulkOperation.passiveState.nothingToDo.body':'All hosts that you selected are already in Maintenance Mode.',
  'hosts.bulkOperation.warningInfo.body':'Components on these hosts are stopped so decommission will be skipped.',
  'hosts.bulkOperation.host_components.passiveState.nothingToDo.body':'All host components that you selected are already in Maintenance Mode',
  'hosts.bulkOperation.confirmation.add.component':'{0} will be added to the following hosts.',
  'hosts.bulkOperation.confirmation.add.component.skip':'{0} already installed.',
  'hosts.bulkOperation.confirmation.add.component.noHeartBeat.skip':'Host heartbeat lost',
  'hosts.bulkOperation.confirmation.add.component.nothingToDo.body': 'All the selected hosts have {0} installed already.',
  'hosts.bulkOperation.confirmation.cannot.add1': 'The following hosts will be skipped (expand for reason):',
  'hosts.bulkOperation.confirmation.cannot.add2': '{0} cannot be added to the following hosts (expand for reason):',
  'hosts.bulkOperation.deleteHosts.nonDeletableComponents': 'Deletion of the following components is not supported: {0}',
  'hosts.bulkOperation.deleteHosts.nonAddableMasterComponents': 'Host contains the following master components: {0}',
  'hosts.bulkOperation.deleteHosts.lastMasterComponents': 'Cluster does not contain any other instance of the following master components: {0}',
  'hosts.bulkOperation.deleteHosts.runningComponents': 'The following components are running and need to be stopped: {0}',
  'hosts.bulkOperation.deleteHosts.confirm.header':'Confirm Bulk Delete Hosts',
  'hosts.bulkOperation.deleteHosts.confirm.delete': 'The following hosts will be deleted:',
  'hosts.bulkOperation.deleteHosts.cannot.delete1':'The following hosts will be skipped (expand for reason):',
  'hosts.bulkOperation.deleteHosts.cannot.delete2':'Selected hosts cannot be deleted (expand for reason)',
  'hosts.bulkOperation.deleteHosts.confirmation.header':'Confirm Bulk Delete Hosts',
  'hosts.bulkOperation.deleteHosts.confirmation.body.msg1': '<b>Please note: </b>Once removed, Ambari will ignore future communications from these hosts. As part of the removal process, packages will not be removed, so please do not attempt to manually start the services on the host once they have been removed from Ambari. If you wish to re-add the hosts to the cluster, please completely clean the hosts before attempting to add them.',
  'hosts.bulkOperation.deleteHosts.confirmation.body.msg2': 'To ensure they are completely removed from Ambari database,',
  'hosts.bulkOperation.deleteHosts.confirmation.body.msg3': 'please make sure the Ambari Agent process is completely stopped on these hosts before proceeding.',
  'hosts.bulkOperation.deleteHosts.result.header':'Delete Hosts',
  'hosts.bulkOperation.deleteHosts.result.body': 'The following hosts were successfully deleted:',
  'hosts.bulkOperation.confirmation.delete.component.cannot1': 'The following hosts will be skipped (expand for reason):',
  'hosts.bulkOperation.confirmation.delete.component.cannot2': '{0} cannot be deleted from the selected hosts:',
  'hosts.bulkOperation.confirmation.delete.component': '{0} will be deleted from the following hosts',
  'hosts.bulkOperation.confirmation.delete.component.minimum.body': 'Cannot delete. At least {0} {1} required',
  'hosts.bulkOperation.confirmation.delete.component.nothingToDo.notStopped': '{0} not Stopped on all selected hosts',
  'hosts.bulkOperation.confirmation.delete.component.nothingToDo.notInstalled': '{0} not installed in any of the selected hosts',
  'hosts.bulkOperation.confirmation.delete.component.skip':'The following hosts will be skipped',
  'hosts.bulkOperation.delete.component.result.header':'Delete Components',
  'hosts.bulkOperation.confirmation.delete.component.notStopped': '{0} not Stopped',
  'hosts.bulkOperation.confirmation.delete.component.notInstalled': '{0} not Installed',
  'hosts.bulkOperation.delete.component.result.body': ' was successfully removed from the following hosts:',
  'hosts.bulkOperation.delete.component.dryRun.message':'{0} could not be deleted from the following hosts(expand for reason)',
  'hosts.bulkOperation.delete.component.failed.header': 'Delete Component failed',
  'hosts.bulkOperation.delete.component.failed.body': 'Delete {0} component from {1} host failed',

  'hosts.selectHostsDialog.title': 'Select Configuration Group Hosts',
  'hosts.selectHostsDialog.message': 'Select hosts that should belong to this {0} Configuration Group. All hosts belonging to this group will have the same set of configurations.',
  'hosts.selectHostsDialog.filter.placeHolder': 'Filter...',
  'hosts.selectHostsDialog.selectedHostsLink': '{0} out of {1} hosts selected',
  'hosts.selectHostsDialog.message.warning': 'At least one host needs to be selected.',

  'hosts.host.serviceNotAvailable': 'Service not available on this host',

  'hosts.host.menu.logs': 'Logs',

  'hosts.host.menu.stackVersions': 'Versions',
  'hosts.host.stackVersions.table.allVersions': 'All Versions',
  'hosts.host.stackVersions.table.allNames': 'All Names',
  'hosts.host.stackVersions.table.noVersions': 'No versions',
  'hosts.host.stackVersions.table.filteredInfo': '{0} of {1} versions showing',
  'hosts.host.stackVersions.status.init': 'Uninstalled',
  'hosts.host.stackVersions.status.installed': 'Installed',
  'hosts.host.stackVersions.status.install_failed': 'Install Failed',
  'hosts.host.stackVersions.status.installing': 'Installing',
  'hosts.host.stackVersions.status.current': 'Current',
  'hosts.host.stackVersions.status.out_of_sync': 'Out of Sync',
  'hosts.host.stackVersions.status.upgrading': 'Upgrading',
  'hosts.host.stackVersions.status.upgrade_failed': 'Upgrade Failed',
  'hosts.host.stackVersions.outOfSync.tooltip': 'This version is Out of Sync on this host. Out of Sync can occur ' +
    'the components on a host change after installing a version not in use. ' +
    'Click Install to have Ambari install the packages for this version to get this host in sync.',
  'hosts.host.stackVersions.install.confirmation': 'You are about to install version <b>{0}</b> on this host.',

  'hosts.host.metrics.dataUnavailable':'Data Unavailable',
  'hosts.host.metrics.cpu':'CPU Usage',
  'hosts.host.metrics.cpu.displayNames.cpu_wio':'CPU I/O Idle',
  'hosts.host.metrics.cpu.displayNames.cpu_idle':'CPU Idle',
  'hosts.host.metrics.cpu.displayNames.cpu_nice':'CPU Nice',
  'hosts.host.metrics.cpu.displayNames.cpu_aidle':'CPU Boot Idle',
  'hosts.host.metrics.cpu.displayNames.cpu_system':'CPU System',
  'hosts.host.metrics.cpu.displayNames.cpu_user':'CPU User',
  'hosts.host.metrics.disk':'Disk Usage',
  'hosts.host.metrics.disk.displayNames.disk_total':'Total',
  'hosts.host.metrics.disk.displayNames.disk_free':'Available',
  'hosts.host.metrics.load':'Load',
  'hosts.host.metrics.load.displayNames.load_fifteen':'15 Minute Load',
  'hosts.host.metrics.load.displayNames.load_one':'1 Minute Load',
  'hosts.host.metrics.load.displayNames.load_five':'5 Minute Load',
  'hosts.host.metrics.memory':'Memory Usage',
  'hosts.host.metrics.memory.displayNames.mem_shared':'Shared',
  'hosts.host.metrics.memory.displayNames.swap_free':'Swap',
  'hosts.host.metrics.memory.displayNames.mem_buffers':'Buffers',
  'hosts.host.metrics.memory.displayNames.mem_free':'Free',
  'hosts.host.metrics.memory.displayNames.mem_cached':'Cached',
  'hosts.host.metrics.network':'Network Usage',
  'hosts.host.metrics.network.displayNames.pkts_out':'Packets Out',
  'hosts.host.metrics.network.displayNames.bytes_in':'Bytes In',
  'hosts.host.metrics.network.displayNames.bytes_out':'Bytes Out',
  'hosts.host.metrics.network.displayNames.pkts_in':'Packets In',
  'hosts.host.metrics.processes':'Processes',
  'hosts.host.metrics.processes.displayNames.proc_total':'Total Processes',
  'hosts.host.metrics.processes.displayNames.proc_run':'Processes Run',

  'hosts.host.summary.header':'Summary',
  'hosts.host.summary.hostname':'Hostname',
  'hosts.host.summary.agentHeartbeat':'Heartbeat',
  'hosts.host.summary.agentHasJce':'JCE Unlimited',
  'hosts.host.summary.hostMetrics':'Host Metrics',
  'hosts.host.summary.hostLogMetrics':'Host Log Metrics',
  'hosts.host.summary.addComponent':'Add Component',
  'hosts.host.summary.currentVersion':'Current Version',

  'hosts.host.details.upgradeFailed':'Component upgrade failed',
  'hosts.host.details.hostActions':'Host Actions',
  'hosts.host.details.needToRestart':'Host needs {0} {1} restarted',
  'hosts.host.details.needToRestart.button':'Restart',
  'hosts.host.details.deleteHost':'Delete Host',
  'hosts.host.details.startAllComponents':'Start All Components',
  'hosts.host.details.stopAllComponents':'Stop All Components',
  'hosts.host.details.restartAllComponents':'Restart All Components',
  'hosts.host.details.deleteHosts':'Delete Hosts',
  'hosts.host.details.refreshConfigs':'Refresh configs',
  'hosts.host.details.for.postfix':'{0} for host',
  'hosts.host.details.setRackId':'Set Rack',
  'hosts.host.details.recoverHost': 'Recover Host',
  'host.host.details.installClients': 'Install clients',
  'host.host.details.reinstallClients': 'Reinstall clients',
  'host.host.details.checkHost': 'Check host',
  'host.host.details.downloadAllClients': 'All Clients On Host',

  'host.host.componentFilter.master':'Master Components',
  'host.host.componentFilter.slave':'Slave Components',
  'host.host.componentFilter.client':'Client Components',
  'hosts.host.deleteComponent.popup.msg1':'Are you sure you want to delete {0}?',
  'hosts.host.deleteComponent.popup.deleteJournalNodeMsg': 'You are about to open <i>Manage Journal Node Wizard</i>. Are you sure?',
  'hosts.host.deleteComponent.popup.warning':'<b>WARNING!</b> Delete the last <i>{0}</i> component in the cluster?</br>Deleting the last component in the cluster could result in permanent loss of service data.',
  'hosts.host.deleteComponent.popup.confirm':'Confirm Delete',
  'hosts.host.installComponent.popup.confirm':'Confirm Install',
  'hosts.host.installComponent.msg':'Are you sure you want to install {0}?',
  'hosts.host.addComponent.msg':'Are you sure you want to add {0}?',
  'hosts.host.delete.componentsRequireReconfigure':'Deleting host with {0} may reconfigure such properties:',
  'host.host.addComponent.popup.dependedComponents.body': '{0} requires {1} to be installed along with it on the same host. Please add them first and then try adding {0}',
  'host.host.addComponent.popup.dependedComponents.header': 'Component dependencies',
  'host.host.addComponent.popup.clients.dependedComponents.body': '{0} require {1} to be installed along with them on the same host. Please add them first',
  'hosts.host.zooKeeper.configs.save.note': 'This configuration is created by ambari while installing/deleting zookeeper component on a host',
  'hosts.host.addComponent.securityNote':'You are running your cluster in secure mode. You must set up the keytab for {0} on {1} before you proceed. Otherwise, the component will not be able to start properly.',
  'hosts.host.addComponent.popup.confirm':'Confirm Add',
  'hosts.host.manualKerberosWarning': '<strong>Because Kerberos has been manually installed on the cluster, you will have to create/distribute principals and keytabs when this operation is finished.</strong>',
  'hosts.host.deleteComponent.popup.deleteNimbus':'Deleting <i>Storm Nimbus</i> will reconfigure <b>nimbus.seeds</b>, <b>topology.min.replication.count</b>, <b>topology.max.replication.wait.time.sec</b> properties if they are defined.',
  'hosts.host.storm.configs.save.note': 'This configuration is created by ambari while installing/deleting storm component on a host',
  'hosts.host.datanode.decommission':'Decommission DataNode',
  'hosts.host.datanode.recommission':'Recommission DataNode',
  'hosts.host.nodemanager.decommission':'Decommission NodeManager',
  'hosts.host.nodemanager.recommission':'Recommission NodeManager',
  'hosts.host.tasktracker.decommission':'Decommission TaskTracker',
  'hosts.host.tasktracker.recommission':'Recommission TaskTracker',
  'hosts.host.tasktracker.restart':'Restart TaskTracker',
  'hosts.host.regionserver.decommission.batch1':'Decommission RegionServer - Turn drain mode on',
  'hosts.host.regionserver.decommission.batch2':'Decommission RegionServer - Stop RegionServer',
  'hosts.host.regionserver.decommission.batch3':'Decommission RegionServer - Turn drain mode off',
  'hosts.host.hbase_regionserver.recommission':'Recommission RegionServer',
  'hosts.host.hbase_regionserver.decommission':'Decommission RegionServer',
  'hosts.host.hbase_regionserver.decommission.warning':'Last RegionServer can\'t be decommissioned',
  'hosts.host.decommissioned':'Decommissioned',
  'hosts.host.decommissioning':'Decommissioning',
  'hosts.host.addComponent.JOURNALNODE': 'You are about to open <i>Manage Journal Node Wizard</i>. Are you sure?',
  'hosts.host.deleteComponent.popup.deleteHiveMetastore':'Deleting <i>Hive Metastore</i> will reconfigure such properties:<ul><li>hive.metastore.uris</li><li>templeton.hive.properties</li></ul>',
  'hosts.host.deleteComponent.popup.deleteWebHCatServer':'You are about to delete <i>WebHCat Server</i>. Are you sure?',
  'hosts.host.configs.save.note': 'This configuration is created by ambari while installing/deleting {0} component on a host',

  'hosts.component.passive.implied.host.mode.tooltip':'Cannot Turn Off Maintenance Mode because Host is in Maintenance Mode',
  'hosts.component.passive.implied.service.mode.tooltip':'Cannot Turn Off Maintenance Mode because {0} is in Maintenance Mode',
  'hosts.component.passive.mode':'Component is in Maintenance Mode',
  'hosts.component.passive.short.mode':'Maintenance Mode',
  'hosts.host.passive.mode':'Host is in Maintenance Mode',
  'hosts.host.alert.noAlerts':'No alerts',
  'hosts.host.alert.noAlerts.message':'There are no alerts for this host.',
  'hosts.host.healthStatus.heartBeatNotReceived':'The server has not received a heartbeat from this host for more than 3 minutes.',
  'hosts.host.healthStatus.mastersDown':"The following master components are down:\n",
  'hosts.host.healthStatus.slavesDown':"The following slave components are down:\n",
  'hosts.host.healthStatus.allUp':'All components are up',
  'hosts.host.healthStatusCategory.green': "Healthy",
  'hosts.host.healthStatusCategory.red': "Master Down",
  'hosts.host.healthStatusCategory.orange': "Slave Down",
  'hosts.host.healthStatusCategory.yellow': "Lost Heartbeat",
  'hosts.host.alerts.label': 'Alerts',
  'hosts.host.maintainance.allComponents.context': 'All Host Components',
  'hosts.host.maintainance.stopAllComponents.context': 'Stop All Host Components',
  'hosts.host.maintainance.startAllComponents.context': 'Start All Host Components',
  'hosts.host.maintainance.reinstallFailedComponents.context': 'Reinstall Failed Components',
  'hosts.host.maintainance.removeFailedComponents.context': 'Remove Failed Components',
  'hosts.host.recover.initAllComponents.context': 'Init All Host Components',
  'hosts.host.recover.installAllComponents.context': 'Install All Host Components',
  'hosts.host.recover.regenerateKeytabs.context': 'Regenerate keytabs',
  'hosts.host.alerts.st':'&nbsp;!&nbsp;',
  'hosts.decommission.popup.body':'Are you sure?',
  'hosts.decommission.popup.header':'Confirmation',
  'hosts.decommission.tooltip.warning':'Cannot {0} since {1} is not running',
  'hosts.delete.popup.body':'Are you sure you want to delete host <i>{0}</i>?',
  'hosts.delete.popup.body.msg1':'By removing this host, Ambari will ignore future communications from this host. Software packages will not be removed from the host. The components on the host should not be restarted. If you wish to readd this host to the cluster, be sure to clean the host.',
  'hosts.delete.popup.body.msg3':'If this host was hosting a Zookeeper Server, the Zookeeper Service should be restarted. Go to the <i>Services</i> page.',
  'hosts.delete.popup.body.msg4':'<b>WARNING!</b> Delete the last <i>{0}</i> component[s] in the cluster?</br>Deleting the last components in the cluster could result in permanent loss of service data.',
  'hosts.delete.popup.body.msg5':'<b>WARNING!</b> The agent is still heartbeating so the Host will still exist in the database.',
  'hosts.delete.popup.body.msg6':'To completely delete the Host, first stop ambari-agent on it.',
  'hosts.delete.popup.body.msg7':'<b>WARNING!</b> {0} should be decommissioned first to prevent data loss.',
  'hosts.delete.popup.body.msg.unknownComponents':'This host does not appear to be online and Ambari communication with the Agent has been lost.',
  'hosts.delete.popup.header':'Confirmation',
  'hosts.delete.popup.title':'Delete Host',
  'hosts.delete.popup.unknownComponents':'The following components have unknown status:',
  'hosts.recover.popup.title': 'Confirmation',
  'hosts.recover.popup.body': 'This action will completely re-install all components on this host. <strong>Are you sure you want to continue?<strong>',
  'hosts.recover.error.popup.title': 'Cannot Recover Host',
  'hosts.recover.error.popup.body': 'This host cannot be recovered unless every component is Stopped. Please stop all components and try again.',
  'hosts.cant.do.popup.title':'Unable to Delete Host',
  'hosts.cant.do.popup.masterList.body':'This host cannot be deleted since it has the following master components:',
  'hosts.cant.do.popup.masterList.body.end':'To delete this host, you must first move all the master components listed above.',
  'hosts.cant.do.popup.nonDeletableList.body':'Deletion of the following {0} components is not supported. ',
  'hosts.cant.do.popup.runningList.body':'This host cannot be deleted since the following components are running:',
  'hosts.cant.do.popup.runningList.body.end':'To delete this host, you must first stop all the running components listed above. ' +
    'If this host has a {0}, it should be decommissioned first to prevent data loss.',
  'hosts.cant.do.popup.lastMasterList.body':'This host cannot be deleted since the following master components do not have any other instances:',
  'hosts.cant.do.popup.lastMasterList.body.end':'To delete this host, you must first add all the components listed above to other hosts',
  'hosts.add.header':'Add Host Wizard',
  'hosts.add.exit.header':'Exit',
  'hosts.add.exit.body':'Do you really want to exit Add Host Wizard?',
  'hosts.assignRack':'Assign Rack',
  'hosts.checkHost.popup':'Are you sure you want to <b>Check host</b> for {0}?',
  'hosts.passiveMode.popup':'Are you sure you want to <b>Turn {0} Maintenance Mode</b> for {1}?',
  'hosts.passiveMode.popup.version.mismatch': '{0} has components from a stack which is not current. Before bringing this host out of maintenance mode, it is recommended that you upgrade its components to {1}',
  'hosts.passiveMode.popup.version.mismatch.multiple': 'Some hosts have components from a stack which is not current. Before bringing these hosts out of maintenance mode, it is recommended that you upgrade their components to {0}',
  'hosts.combo.search.placebolder': 'Filter by host and component attributes or search by keyword ...',
  'hosts.combo.search.invalidCategory': 'is not a valid category.',
  'charts.horizon.chart.showText':'show',
  'charts.horizon.chart.hideText':'hide',
  'charts.horizon.chart.attributes.cpu':'CPU',
  'charts.horizon.chart.attributes.memory':'Memory',
  'charts.horizon.chart.attributes.network':'Network',
  'charts.horizon.chart.attributes.io':'I/O',

  'charts.heatmap.selectMetric':'Select Metric',

  'charts.heatmap.category.host':'Host',
  'charts.heatmap.item.host.memory':'Memory Used',
  'charts.heatmap.item.host.disk':'Disk Space Used',
  'charts.heatmap.item.host.process':'Total Running Processes',
  'charts.heatmap.category.hdfs':'HDFS',
  'charts.heatmap.category.yarn': 'YARN',
  'charts.heatmap.category.hbase': 'HBase',
  'charts.heatmap.unknown': 'Unknown',
  'charts.heatmap.label.notApplicable' :'Not Applicable',
  'charts.heatmap.label.invalidData' :'Invalid data',
  'charts.heatmap.label.notAvailable': 'Data Not Available',
  'metric.notFound':'no items found',
  'metric.default':'combined',
  'metric.cpu':'cpu',
  'metric.memory':'disk used',
  'metric.network':'network',
  'metric.io':'io',
  'metric.more':'more',
  'metric.more.cpu':'CPU',
  'metric.more.disk':'Disk',
  'metric.more.load':'Load',
  'metric.more.memory':'Memory',
  'metric.more.network':'Network',
  'metric.more.process':'Process',

  'dashboard.clusterMetrics':'Cluster Metrics',

  'dashboard.clusterMetrics.cpu':'CPU Usage',
  'dashboard.clusterMetrics.cpu.displayNames.idle':'Idle',
  'dashboard.clusterMetrics.load':'Cluster Load',
  'dashboard.clusterMetrics.memory':'Memory Usage',
  'dashboard.clusterMetrics.network':'Network Usage',

  'dashboard.widgets.title': 'Metrics',
  'dashboard.heatmaps.title': 'Heatmaps',
  'dashboard.button.switch': 'Switch to classic dashboard',
  'dashboard.button.switchShort': 'Switch',
  'dashboard.button.reset': 'Reset all widgets to default ',
  'dashboard.widgets.actions.title': 'Metric Actions',
  'dashboard.widgets.create': 'Create Widget',
  'dashboard.widgets.actions.browse': 'Browse Widgets',
  'dashboard.widgets.layout.import': 'Import a layout',
  'dashboard.widgets.layout.save': 'Save a layout',
  'dashboard.widgets.addButton.tooltip': 'Add Widget',
  'dashboard.widgets.browser.header': 'Widget Browser',
  'dashboard.widgets.browser.menu.shared': 'Shared',
  'dashboard.widgets.browser.menu.mine': 'Mine',
  'dashboard.widgets.browser.noWidgets': 'No widgets to display',
  'dashboard.widgets.browser.footer.checkbox': 'Show only my widgets',
  'dashboard.widgets.browser.action.add': 'Add',
  'dashboard.widgets.browser.action.added': 'Added',
  'dashboard.widgets.browser.action.delete': 'Delete',
  'dashboard.widgets.browser.action.unshare': 'Unshare',
  'dashboard.widgets.browser.action.share': 'Share',
  'dashboard.widgets.browser.action.share.confirmation': 'You are about to make this a shared widget. All cluster operators will be able to modify or delete this widget. Are you sure you want to share this widget?',
  'dashboard.widgets.browser.shareIcon.tooltip': 'Shared',
  'dashboard.widgets.browser.action.delete.shared.bodyMsg': 'You are about to permanently delete the <b>{0}</b> widget. ' +
    'This widget is a shared widget and this operation will delete the widget from the shared widget library and remove the ' +
    'widget from all users.<br /> <br /> <b>Are you sure you wish to permanently delete this shared widget?</b>',
  'dashboard.widgets.browser.action.delete.mine.bodyMsg': 'You are about to permanently delete the <b>{0}</b> widget. ' +
    'This operation will delete the widget from your widget library.<br /><br /><b>Are you sure you wish to permanently ' +
    'delete this widget?</b>',
  'dashboard.widgets.browser.action.delete.btnMsg': 'Confirm Delete',

  'dashboard.widgets.NameNodeHeap': 'NameNode Heap',
  'dashboard.widgets.NameNodeCpu': 'NameNode CPU WIO',
  'dashboard.widgets.HDFSDiskUsage': 'HDFS Disk Usage',
  'dashboard.widgets.HDFSDiskUsage.DFSused': 'DFS used',
  'dashboard.widgets.HDFSDiskUsage.nonDFSused': 'non DFS used',
  'dashboard.widgets.HDFSDiskUsage.remaining': 'remaining',
  'dashboard.widgets.HDFSDiskUsage.info': '{0} ({1}%)',
  'dashboard.widgets.DataNodeUp': 'DataNodes Live',
  'dashboard.widgets.SuperVisorUp': 'Supervisors Live',
  'dashboard.widgets.FlumeAgentUp': 'Flume Live',
  'dashboard.widgets.NameNodeRpc': 'NameNode RPC',
  'dashboard.widgets.nothing': 'No Widget to Add',
  'dashboard.widgets.NameNodeUptime': 'NameNode Uptime',
  'dashboard.widgets.HDFSLinks': 'HDFS Links',
  'dashboard.widgets.HDFSLinks.activeNameNode': 'Active NameNode',
  'dashboard.widgets.HDFSLinks.standbyNameNode': 'Standby NameNode',
  'dashboard.widgets.HDFSLinks.standbyNameNodes': '2 Standby NameNodes',
  'dashboard.widgets.HBaseLinks': 'HBase Links',
  'dashboard.widgets.HBaseAverageLoad': 'HBase Ave Load',
  'dashboard.widgets.HBaseMasterHeap': 'HBase Master Heap',
  'dashboard.widgets.HBaseRegionsInTransition': 'Region In Transition',
  'dashboard.widgets.HBaseMasterUptime': 'HBase Master Uptime',
  'dashboard.widgets.ResourceManagerHeap': 'ResourceManager Heap',
  'dashboard.widgets.ResourceManagerUptime': 'ResourceManager Uptime',
  'dashboard.widgets.NodeManagersLive': 'NodeManagers Live',
  'dashboard.widgets.YARNMemory': 'YARN Memory',
  'dashboard.widgets.YARNLinks': 'YARN Links',
  'dashboard.widgets.YarnContainers': 'YARN Containers',
  'dashboard.widgets.error.invalid': 'Invalid! Enter a number between {0} - {1}',
  'dashboard.widgets.error.smaller': 'Threshold 1 should be smaller than threshold 2!',
  'dashboard.widgets.HawqSegmentUp': 'HAWQ Segments Live',
  'dashboard.widgets.PxfUp': 'PXF Agents Live',
  'dashboard.widgets.PXFAgents': 'PXF Agents',
  'dashboard.widgets.nameSpace': 'Namespace',

  'dashboard': {
    'widgets': {
      'popupHeader': 'Customize Widget',
      'hintInfo': {
        'common': 'Edit the percentage thresholds to change the color of current pie chart. <br />Enter two numbers between 0 to {0}',
        'hint1': 'Edit the percentage of thresholds to change the color of current widget. <br />Assume all components UP is 100, and all DOWN is 0. <br /> So enter two numbers between 0 to {0}',
        'hint2': 'Edit the thresholds to change the color of current widget.<br /><br />So enter two numbers larger than 0.',
        'hint3': 'Edit the thresholds to change the color of current widget.<br />The unit is milli-second. <br />So enter two numbers larger than 0. ',
        'hint4': 'Edit the threshold value representing the number of {0} that are down to change the color of the widget. <br />If the number of {0} that are down is greater than the threshold, the widget will show warning in Red. <br />Choose a number between 0 and {1}. '
      }
    }
  },

  'dashboard.services':'Services',
  'dashboard.services.hosts':'Hosts',
  'dashboard.services.uptime':'{0}',
  'dashboard.services.summary.slaves.live': 'Live',
  'dashboard.services.hdfs.summary':'{0} of {1} nodes live, {2}% capacity used',
  'dashboard.services.hdfs.summary.components': 'Components',
  'dashboard.services.hdfs.summary.service-metrics': 'Service Metrics',
  'dashboard.services.hdfs.nanmenode':'NameNode',
  'dashboard.services.hdfs.snanmenode':'Secondary NameNode',
  'dashboard.services.hdfs.journalnodes':'JournalNodes',
  'dashboard.services.hdfs.capacity':'HDFS Disk Usage',
  'dashboard.services.hdfs.capacity.dfsUsed':'Disk Usage (DFS Used)',
  'dashboard.services.hdfs.capacity.nonDfsUsed':'Disk Usage (Non DFS Used)',
  'dashboard.services.hdfs.capacity.remaining':'Disk Remaining',
  'dashboard.services.hdfs.capacityUsed':'{0} / {1}',
  'dashboard.services.hdfs.capacityUsedPercent':'{0}%',
  'dashboard.services.hdfs.totalFilesAndDirs':'Total Files + Directories',
  'dashboard.services.hdfs.datanodes':'DataNodes',
  'dashboard.services.hdfs.datanodecounts':'DataNodes Status',
  'dashboard.services.hdfs.nfsgateways':'NFSGateways',
  'dashboard.services.hdfs.version':'Version',
  'dashboard.services.hdfs.nameNodeWebUI':'NameNode Web UI',
  'dashboard.services.hdfs.nodes.live':'live',
  'dashboard.services.hdfs.nodes.dead':'dead',
  'dashboard.services.hdfs.nodes.decom':'decommissioning',
  'dashboard.services.hdfs.nodes.uptime':'NameNode Uptime',
  'dashboard.services.hdfs.nodes.heap':'NameNode Heap',
  'dashboard.services.hdfs.nodes.heapUsedPercent':'{0}%',
  'dashboard.services.hdfs.nodes.heapUsed':'{0} / {1}',

  'dashboard.services.hdfs.chart.label':'Capacity (Used/Total)',
  'dashboard.services.hdfs.blockErrors.total': 'total',
  'dashboard.services.hdfs.blockErrors.corrupt': 'corrupt replica',
  'dashboard.services.hdfs.blockErrors.replicated': 'under replicated',
  'dashboard.services.hdfs.blockErrors.missing': 'missing',
  'dashboard.services.hdfs.datanode.status.tooltip.live': 'This is the number of DataNodes that are live as reported from ' +
    'the NameNode. Even if a DataNode process is up, NameNode might see the status as dead ' +
    'if the DataNode is not communicating with the NameNode as expected. This can be due situations ' +
    'such as a network issue or a hanging DataNode process due to excessive garbage collection.',
  'dashboard.services.hdfs.datanode.status.tooltip.dead': 'This is the number of DataNodes that are dead as reported from ' +
  'the NameNode. Even if a DataNode process is up, NameNode might see the status as dead ' +
  'if the DataNode is not communicating with the NameNode as expected. This can be due situations ' +
  'such as a network issue or a hanging DataNode process due to excessive garbage collection.',
  'dashboard.services.hdfs.datanode.status.tooltip.decommission': 'This is the number of DataNodes that are currently ' +
  'Decommissioning as reported from the NameNode. If there are not enough other DataNodes ' +
  'in the cluster to create the configured number of block replicas based on the dfs.replication ' +
  'property (typically 3), a DataNode can get stuck in decommissioning state until ' +
  'more DataNodes become available to the NameNode.',

  'dashboard.services.yarn.summary':'{0} of {1} nodes live',
  'dashboard.services.yarn.resourceManager':'ResourceManager',
  'dashboard.services.yarn.nodeManagers':'NodeManagers',
  'dashboard.services.yarn.nodeManager':'NodeManager',
  'dashboard.services.yarn.nodes.heapUsed':'{0} / {1}',
  'dashboard.services.yarn.nodes.heapUsedPercent':'{0}%',
  'dashboard.services.yarn.clients':'YARN Clients',
  'dashboard.services.yarn.client':'YARN Client',
  'dashboard.services.yarn.resourceManager.uptime':'ResourceManager Uptime',
  'dashboard.services.yarn.resourceManager.active':'Active ResourceManager',
  'dashboard.services.yarn.resourceManager.standby':'Standby ResourceManager',
  'dashboard.services.resourceManager.nodes.heap':'ResourceManager Heap',
  'dashboard.services.yarn.nodeManagers.status': 'NodeManagers Status',
  'dashboard.services.yarn.nodeManagers.status.active': 'active',
  'dashboard.services.yarn.nodeManagers.status.lost': 'lost',
  'dashboard.services.yarn.nodeManagers.status.unhealthy': 'unhealthy',
  'dashboard.services.yarn.nodeManagers.status.rebooted': 'rebooted',
  'dashboard.services.yarn.nodeManagers.status.decommissioned': 'decommissioned',
  'dashboard.services.yarn.nodeManagers.status.tooltip.active': 'This is the number of NodeManagers that are active as reported from the ResourceManager',
  'dashboard.services.yarn.nodeManagers.status.tooltip.lost': 'This is the number of NodeManagers that are lost as reported from the ResourceManager. ' +
    'Even if a NodeManager process is up, the ResourceManager might see the status as lost if the NodeManager is not communicating with the ' +
    'ResourceManager as expected. This can be due to situations such as a network issue or a hanging NodeManager process due to excessive garbage collection.',
  'dashboard.services.yarn.nodeManagers.status.tooltip.unhealthy': 'This is the number of NodeManagers that are unhealthy as reported from the ResourceManager.',
  'dashboard.services.yarn.nodeManagers.status.tooltip.rebooted': 'This is the number of NodeManagers that are in the rebooted state as reported from the ResourceManager.',
  'dashboard.services.yarn.nodeManagers.status.tooltip.decommissioned': 'This is the number of NodeManagers that are decommissioned as reported from the ResourceManager.',
  'dashboard.services.yarn.containers': 'Containers',
  'dashboard.services.yarn.containers.allocated': 'allocated',
  'dashboard.services.yarn.containers.pending': 'pending',
  'dashboard.services.yarn.containers.reserved': 'reserved',
  'dashboard.services.yarn.apps': 'Applications',
  'dashboard.services.yarn.apps.submitted': 'submitted',
  'dashboard.services.yarn.apps.running': 'running',
  'dashboard.services.yarn.apps.pending': 'pending',
  'dashboard.services.yarn.apps.completed': 'completed',
  'dashboard.services.yarn.apps.killed': 'killed',
  'dashboard.services.yarn.apps.failed': 'failed',

  'dashboard.services.yarn.memory': 'Cluster Memory',
  'dashboard.services.yarn.memory.used': 'used',
  'dashboard.services.yarn.memory.reserved': 'reserved',
  'dashboard.services.yarn.memory.available': 'available',
  'dashboard.services.yarn.queues': 'Queues',
  'dashboard.services.yarn.queues.msg': '{0} Queues',
  'dashboard.services.hawq.hawqSegments':'HAWQ Segments',
  'dashboard.services.pxf.pxfHosts':'PXF',

  'dashboard.services.flume.summary.title':'Flume installed on {0} host{1} ({2} agent{3})',
  'dashboard.services.flume.summary.configure':'Configure Agents',
  'dashboard.services.flume.agentsLabel': 'Flume',
  'dashboard.services.flume.agentLabel': 'Flume Component',
  'dashboard.services.flume.channels': 'Channels',
  'dashboard.services.flume.sources': 'Sources',
  'dashboard.services.flume.sinks': 'Sinks',
  'dashboard.services.flume.agent': 'Agent',

  'dashboard.services.hbase.summary':'{0} region servers with {1} average load',
  'dashboard.services.hbase.masterServer':'HBase Master',
  'dashboard.services.hbase.masterServer.active':'Active HBase Master',
  'dashboard.services.hbase.masterServer.standby':'Standby HBase Master',
  'dashboard.services.hbase.noMasterServer':'No Active Master',
  'dashboard.services.hbase.masterServerHeap':'Master Heap',
  'dashboard.services.hbase.masterServerHeap.summary':'{0} / {1}',
  'dashboard.services.hbase.masterServerHeap.percent':'{0}%',
  'dashboard.services.hbase.masterServerUptime':'Master Server Uptime',
  'dashboard.services.hbase.averageLoad':'Average Load',
  'dashboard.services.hbase.averageLoadPerServer':'{0} regions per RegionServer',
  'dashboard.services.hbase.regionServers':'RegionServers',
  'dashboard.services.hbase.regionServersSummary':'{0} live / {1} total',
  'dashboard.services.hbase.phoenixServers':'Phoenix Query Servers',
  'dashboard.services.hbase.phoenixServersSummary':'{0} live / {1} total',
  'dashboard.services.hbase.chart.label':'Request Count',
  'dashboard.services.hbase.masterWebUI':'Master Web UI',
  'dashboard.services.hbase.regions.transition':'Regions In Transition',
  'dashboard.services.hbase.masterStarted':'Master Started',
  'dashboard.services.hbase.masterActivated':'Master Activated',

  'dashboard.services.ranger.rangerTagsyncs':'Ranger Tagsyncs',

  'dashboard.services.components.started':'started',
  'dashboard.services.components.stopped':'stopped',
  'dashboard.services.components.total':'in total',

  'dashboard.services.hive.clients':'Hive Clients',
  'dashboard.services.hive.client':'Hive Client',
  'dashboard.services.hive.metastore':'Hive Metastore',
  'dashboard.services.hive.server2':'HiveServer2',
  'dashboard.services.hive.server2interactive':'HiveServer2 Interactive',

  'dashboard.services.oozie.clients':'Oozie Clients',
  'dashboard.services.oozie.client':'Oozie Client',
  'dashboard.services.storm.supervisor': 'Supervisor',
  'dashboard.services.storm.supervisors': 'Supervisors',

  'dashboard.services.configs.popup.stopService.header':'Stop service',
  'dashboard.services.configs.popup.stopService.body' : 'Service needs to be stopped for reconfiguration',
  'dashboard.services.configs.popup.restartService.header' : 'Restart service',
  'dashboard.services.configs.popup.restartService.body' : 'Service needs to be restarted for reconfiguration',

  'dashboard.services.zookeeper.server' : 'ZooKeeper Server',

  'dashboard.configHistory.title': 'Config History',
  'dashboard.configHistory.table.version.title' : 'Service',
  'dashboard.configHistory.table.configGroup.title' : 'Config Group',
  'dashboard.configHistory.table.created.title' : 'Created',
  'dashboard.configHistory.table.configGroup.default' : 'default',
  'dashboard.configHistory.table.empty' : 'No history to display',
  'dashboard.configHistory.table.notes.default': 'Initial configurations for {0}',
  'dashboard.configHistory.table.notes.addService': 'Configuration updated while adding service',
  'dashboard.configHistory.table.notes.no': '',
  'dashboard.configHistory.table.version.versionText' : 'V{0}',
  'dashboard.configHistory.table.version.prefix' : 'V',
  'dashboard.configHistory.table.current.tooltip' : 'Current config for {0}:{1}',
  'dashboard.configHistory.table.restart.tooltip' : 'Restart required',
  'dashboard.configHistory.table.filteredHostsInfo': '{0} of {1} versions showing',
  'dashboard.configHistory.info-bar.authoredOn': 'authored on',
  'dashboard.configHistory.info-bar.changesToHandle': 'Changes to handle',
  'dashboard.configHistory.info-bar.showMore': 'Show more',
  'dashboard.configHistory.info-bar.save.popup.title': 'Save Configuration',
  'dashboard.configHistory.info-bar.makeCurrent.popup.title': 'Make Current Confirmation',
  'dashboard.configHistory.info-bar.save.popup.placeholder': 'What did you change?',
  'dashboard.configHistory.info-bar.save.popup.warningForPasswordChange': 'This configuration change includes a password change. The password change will be saved but for security purposes, password changes will not be shown in configuration version comparisons.',
  'dashboard.configHistory.info-bar.save.popup.notesForPasswordChange': 'Password change',
  'dashboard.configHistory.info-bar.revert.button': 'Make Current',
  'dashboard.configHistory.info-bar.revert.versionButton': 'Make {0} Current',
  'dashboard.configHistory.info-bar.view.button.disabled': 'You are currently viewing this version.',
  'dashboard.configHistory.info-bar.compare.button.disabled': 'You cannot compare against the same version.',
  'dashboard.configHistory.info-bar.revert.button.disabled': 'This is the current version.',
  'dashboard.configHistory.info-bar.compare.tooltip': 'Compare this version with current',

  'timeRange.presets.1hour':'1h',
  'timeRange.presets.12hour':'12h',
  'timeRange.presets.1day':'1d',
  'timeRange.presets.1week':'1wk',
  'timeRange.presets.1month':'1mo',
  'timeRange.presets.1year':'1yr',

  'tableView.filters.all': 'All',
  'tableView.filters.filtered': 'Filtered',
  'tableView.filters.clearFilters': 'Clear filters',
  'tableView.filters.itemsPerPage': 'Items per page:',
  'tableView.filters.paginationInfo': '{0} - {1} of {2}',
  'tableView.filters.clearAllFilters': 'clear filters',
  'tableView.filters.showAll': 'Show All',
  'tableView.filters.filteredConfigVersionInfo': '{0} of {1} versions showing',
  'tableView.filters.filteredAlertInstancesInfo': '{0} of {1} instances showing',
  'tableView.filters.filteredLogsInfo': '{0} of {1} logs showing',

  'rollingrestart.dialog.title': 'Restart {0}',
  'rollingrestart.dialog.primary': 'Trigger Rolling Restart',
  'rollingrestart.notsupported.hostComponent': 'Rolling restart not supported for {0} components',
  'rollingrestart.dialog.msg.restart': 'This will restart a specified number of {0} at a time.',
  'rollingrestart.dialog.msg.noRestartHosts': 'There are no {0} to do rolling restarts',
  'rollingrestart.dialog.msg.maintainance': 'Note: {0} {1} in Maintenance Mode will not be restarted',
  'rollingrestart.dialog.msg.componentsAtATime': '{0} at a time',
  'rollingrestart.dialog.msg.timegap.prefix': 'Wait ',
  'rollingrestart.dialog.msg.timegap.suffix': 'seconds between batches ',
  'rollingrestart.dialog.msg.toleration.prefix': 'Tolerate up to ',
  'rollingrestart.dialog.msg.toleration.suffix': 'restart failures',
  'rollingrestart.dialog.err.invalid.batchsize': 'Invalid restart batch size: {0}',
  'rollingrestart.dialog.err.invalid.waitTime': 'Invalid wait time between batches: {0}',
  'rollingrestart.dialog.err.invalid.toleratesize': 'Invalid failure toleration count: {0}',
  'rollingrestart.dialog.warn.datanode.batch.size': 'Restarting more than one DataNode at a time is not recommended. Doing so can lead to data unavailability and/or possible loss of data being actively written to HDFS.',
  'rollingrestart.dialog.msg.serviceNotInMM':'Note: This will trigger alerts. To suppress alerts, turn on Maintenance Mode for {0} prior to triggering a rolling restart',
  'rollingrestart.dialog.msg.staleConfigsOnly': 'Only restart {0} with stale configs',
  'rollingrestart.rest.context': 'Rolling Restart of {0}s - batch {1} of {2}',
  'rollingrestart.context.allOnSelectedHosts':'Restart all components on the selected hosts',
  'rollingrestart.context.configs.allOnSelectedHosts':'Refresh all configs on the selected hosts',
  'rollingrestart.context.allForSelectedService':'Restart all components for {0}',
  'rollingrestart.context.allWithStaleConfigsForSelectedService':'Restart all components with Stale Configs for {0}',
  'rollingrestart.context.ClientOnSelectedHost':'Restart {0} on {1}',
  'rollingrestart.context.allWithStaleConfigsOnSelectedHost':'Restart components with Stale Configs on {0}',
  'rollingrestart.context.allOnSelectedHost':'Restart all components on {0}',
  'rollingrestart.context.selectedComponentOnSelectedHost':'Restart {0}',
  'rollingrestart.context.default':'Restart components',

  'rolling.command.context': 'Rolling set {0} to state "{1}" - batch {2} of {3}',
  'rolling.nothingToDo.header': 'Nothing to do',
  'rolling.nothingToDo.body': '{0} on selected hosts are already in selected state or in Maintenance Mode.',

  'widget.type.gauge.description': 'A view to display metrics that can be expressed in percentage.',
  'widget.type.number.description': 'A view to display metrics that can be expressed as a single number with optional unit field.',
  'widget.type.graph.description': 'A view to display metrics that can be expressed in line graph or area graph over a time range.',
  'widget.type.template.description': 'A view to display metric value along with a templated text.',
  'widget.create.wizard.header': 'Create Widget',
  'widget.create.wizard.step1.header': 'Select Type',
  'widget.create.wizard.step1.body.text': 'What type of widget do you want to create?',
  'widget.create.wizard.step1.body.choose.tooltip': 'Click to select',
  'widget.create.wizard.step2.header': 'Metrics and Expression',
  'widget.create.wizard.step2.template.header': 'Template',
  'widget.create.wizard.step2.body.text':'Define the expression with any metrics and valid operators. </br>Use parentheses when necessary.',
  'widget.create.wizard.step2.body.template':'Define the template with any number of expressions and any string. An expression can be referenced from a template by enclosing its name with double curly braces.',
  'widget.create.wizard.step2.body.warning':'Note: Valid operators are +, -, *, /',
  'widget.create.wizard.step2.body.invalid.label': 'Invalid name. Only alphanumerics, underscores, hyphens, percentage and spaces are allowed.',
  'widget.create.wizard.step2.body.invalid.expression':'Expression is not complete or is invalid!',
  'widget.create.wizard.step2.body.invalid.expression2':'Invalid expression!',
  'widget.create.wizard.step2.body.invalid.msg2':'Only numbers or operators are allowed in this field.',
  'widget.create.wizard.step2.body.template.invalid.msg':'Invalid expression name existed. Should use name "Expression#" with double curly braces.',
  'widget.create.wizard.step2.addExpression': 'Add Expression',
  'widget.create.wizard.step2.addDataset': 'Add data set',
  'widget.create.wizard.step2.body.gauge.overflow.warning':'Overflowed! Gauge can only display number between 0 and 1.',
  'widget.create.wizard.step2.allComponents': 'All {0}',
  'widget.create.wizard.step2.activeComponents': 'Active {0}',
  'widget.create.wizard.step2.noMetricFound': 'No metric found',
  'widget.create.wizard.step3.widgetName': 'Name',
  'widget.create.wizard.step3.sharing': 'Sharing',
  'widget.create.wizard.step3.sharing.msg': 'Share this widget in the widget library',
  'widget.create.wizard.step3.header': 'Name and Description',
  'widget.create.wizard.step3.name.invalid.msg': 'Widget name is too long. Please enter a widget name less than 129 characters.',
  'widget.create.wizard.step3.name.invalidCharacter.msg': 'Invalid widget name. Only alphanumerics, underscores, hyphens, percentage and spaces are allowed.',
  'widget.create.wizard.step3.description.invalid.msg': 'Description is too long. Please enter a description less than 2049 characters.',
  'widget.create.wizard.step3.description.invalidCharacter.msg': 'Invalid input. Only alphanumerics, underscores, hyphens, percentage and spaces are allowed.',

  'widget.edit.wizard.header': 'Edit Widget',

  'widget.clone.body': 'Are you sure you want to clone current widget <b>{0}</b>?',
  'widget.edit.body': 'This is a shared widget and the edits are going to change this widget for all users. Would you prefer to Clone the widget instead?',
  'widget.edit.button.primary': 'Edit Shared',
  'widget.edit.button.secondary': 'Clone and Edit',

  'dashboard.widgets.wizard.step2.dataSeries': 'Data Series {0}',
  'dashboard.widgets.wizard.step2.addMetrics': 'Add Metrics and operators here...',
  'dashboard.widgets.wizard.step2.newMetric': '+ Add Metric',
  'dashboard.widgets.wizard.step2.newOperator': '+ Add Operator',
  'dashboard.widgets.wizard.step2.newNumber': '+ Add Number',
  'dashboard.widgets.wizard.step2.Component': 'Component',
  'dashboard.widgets.wizard.step2.Metric': 'Metric',
  'dashboard.widgets.wizard.step2.selectComponent': 'Select a Component',
  'dashboard.widgets.wizard.step2.selectMetric': 'Select a Metric',
  'dashboard.widgets.wizard.step2.addMetric': 'Add Metric',
  'dashboard.widgets.wizard.step2.aggregateFunction': 'Aggregator Function',
  'dashboard.widgets.wizard.step2.aggregateFunction.scanOps': 'Select Aggregation',
  'dashboard.widgets.wizard.step2.aggregateFunction.notFound': 'No aggregator function found',
  'dashboard.widgets.wizard.step2.aggregateTooltip': 'This mathematical function will be applied to compute single value for selected metric across all host components',
  'dashboard.widgets.wizard.step2.threshold.ok.tooltip': 'This is the threshold value at which the widget color changes from green (OK) to orange (Warning)',
  'dashboard.widgets.wizard.step2.threshold.warning.tooltip': 'This is the threshold value at which the widget color changes from orange (Warning) to red (Critical)',
  'dashboard.widgets.wizard.onClose.popup.body': 'You have unsaved changes. Your changes will not be saved if you exit the wizard at this step.',
  'dashboard.widgets.wizard.onClose.popup.discardAndExit': 'Discard and Exit',
  'dashboard.widgets.wizard.step2.nameSpaceDropDownItem': '{0} (Active)',

  'restart.service.all': 'Restart All',
  'restart.service.all.affected': 'Restart All Affected',
  'restart.service.rest.context': 'Restart {0}s',

  'menu.item.dashboard':'Dashboard',
  'menu.item.services':'Services',
  'menu.item.hosts':'Hosts',
  'menu.item.admin':'Cluster Admin',
  'menu.item.alerts': 'Alerts',
  'menu.item.views':'<i class="glyphicon glyphicon-th"></i>',
  'menu.item.views.noViews':'No Views',

  'jobs.nothingToShow': 'No jobs to display',
  'jobs.error.ats.down': 'Jobs data cannot be shown since YARN App Timeline Server is not running.',
  'jobs.error.400': 'Unable to load data.',
  'jobs.table.custom.date.am':'AM',
  'jobs.table.custom.date.pm':'PM',
  'jobs.table.custom.date.header':'Select Time Range',
  'jobs.table.job.fail':'Job failed to run',
  'jobs.customDateFilter.error.required':'This field is required',
  'jobs.customDateFilter.error.incorrect':'Date is incorrect',
  'jobs.customDateFilter.error.laterThanNow':'The specified time is in the future',
  'jobs.customDateFilter.error.date.order':'End Date must be after Start Date',
  'jobs.customDateFilter.startTime':'Start Time',
  'jobs.customDateFilter.endTime':'End Time',
  'jobs.customDateFilter.duration.15min':'15 minutes',
  'jobs.customDateFilter.duration.30min':'30 minutes',
  'jobs.customDateFilter.duration.1hr':'1 hour',
  'jobs.customDateFilter.duration.2hr':'2 hours',
  'jobs.customDateFilter.duration.4hr':'4 hours',
  'jobs.customDateFilter.duration.12hr':'12 hours',
  'jobs.customDateFilter.duration.24hr':'24 hours',
  'jobs.customDateFilter.duration.1w':'1 week',
  'jobs.customDateFilter.duration.1m':'1 month',
  'jobs.customDateFilter.duration.1yr':'1 year',

  'views.main.yourViews': 'Your Views',
  'views.main.noViews': 'No views',
  'views.main.instance.noDescription': 'No description',

  'number.validate.empty': 'cannot be empty',
  'number.validate.notValidNumber': 'not a valid number',
  'number.validate.lessThanMinimum': 'value less than {0}',
  'number.validate.moreThanMaximum': 'value greater than {0}',

  'common.combobox.placeholder': 'Filter...',
  'common.combobox.dropdown.overridden': 'Overridden properties',
  'common.combobox.dropdown.final': 'Final properties',
  'common.combobox.dropdown.changed': 'Changed properties',
  'common.combobox.dropdown.issues': 'Show property issues',
  'common.combobox.dropdown.warnings': 'Show property warnings',

  'quick.links.error.quicklinks.unavailable.label': 'Quick Links are not available',
  'quick.links.error.nohosts.label': 'Failed to obtain host information for {0}',
  'quick.links.error.oozie.label': 'Quick Links are not available. Make sure Oozie server is running.',
  'quick.links.publicHostName': '{0} ({1})',
  'quick.links.label.active': 'Active',
  'quick.links.label.standby': 'Standby',

  'contact.administrator': 'Contact System Administrator for more information!',

  'config.group.selection.dialog.title': '{0} Configuration Group',
  'config.group.selection.dialog.subtitle': 'Select or create a {0} Configuration Group where the configuration value will be overridden.',
  'config.group.selection.dialog.option.select': 'Select an existing {0} Configuration Group',
  'config.group.selection.dialog.option.select.msg': 'Overridden property will be changed for hosts belonging to the selected group.',
  'config.group.selection.dialog.option.create': 'Create a new {0} Configuration Group',
  'config.group.selection.dialog.option.create.msg': 'A new {0} Configuration Group will be created with the given name. Initially there will be no hosts in the group, with only the selected property overridden.',
  'config.group.selection.dialog.err.name.exists': 'Configuration Group with given name already exists',
  'config.group.selection.dialog.err.create': 'Error creating new Configuration Group [{0}]',
  'config.group.selection.dialog.no.groups': 'There are no existing {0} Configuration Groups.',
  'config.group.host.switch.dialog.title': 'Change Group',

  'config.group.save.confirmation.header': 'Save Configuration Group',
  'config.group.save.confirmation.msg': 'Click <em>Manage Hosts</em> to manage host membership to the configuration group',
  'config.group.save.confirmation.configGroup': 'Configuration Group',
  'config.group.save.confirmation.saved': 'has been successfully saved',
  'config.group.save.confirmation.manage.button': 'Manage Hosts',
  'config.group.description.default': 'New configuration group created on {0}',

  'config.infoMessage.wrong.value.for.widget': 'Configuration value cannot be converted into UI control value',
  'config.infoMessage.wrong.value.for.combobox.widget': '"{0}" is not available in the list of valid values',
  'config.warnMessage.outOfBoundaries.greater': 'Values greater than {0} are not recommended',
  'config.warnMessage.outOfBoundaries.less': 'Values smaller than {0} are not recommended',

  'errorMessage.config.required': 'This is required',
  'errorMessage.config.number.integer': 'Must contain digits only',
  'errorMessage.config.number.float': 'Must be a valid number',
  'errorMessage.config.mail': 'Must be a valid email address',
  'errorMessage.config.user': 'Value is not valid',
  'errorMessage.config.ldapUrl': 'Must be a valid LDAP url',
  'errorMessage.config.password': 'Passwords do not match',
  'errorMessage.config.password.length': 'Password should contain at least {0} symbols',
  'errorMessage.config.directory.heterogeneous': 'dir format is wrong, can be "[{storage type}]/{dir name}"',
  'errorMessage.config.directory.default': 'Must be a slash or drive at the start, and must not contain white spaces',
  'errorMessage.config.directory.allowed': 'Can\'t start with "home(s)"',
  'errorMessage.config.spaces.trailing': 'Cannot contain trailing whitespace',
  'errorMessage.config.spaces.trim': 'Cannot contain leading or trailing whitespace',

  'utils.ajax.errorMessage': 'Error message',
  'utils.ajax.defaultErrorPopupBody.message': 'received on {0} method for API: {1}',
  'utils.ajax.defaultErrorPopupBody.statusCode': '{0} status code',

  'wizard.inProgress': '{0} in Progress | Initiated by {1}',

  'alerts.instance.fullLogPopup.header': 'Instance Response',
  'admin.addHawqStandby.button.enable': 'Add HAWQ Standby Master',
  'admin.addHawqStandby.closePopup':'Add HAWQ Standby Master Wizard is in progress. You must allow the wizard to' +
      ' complete for Ambari to be in usable state. If you choose to quit, you must follow documented manual' +
  ' instructions to complete or reverting adding HAWQ Standby Master. Are you sure you want to exit the wizard?',
  'admin.addHawqStandby.wizard.header': 'Add HAWQ Standby Master Wizard',
  'admin.addHawqStandby.wizard.step1.header': 'Get Started',
  'admin.addHawqStandby.wizard.step1.body':'This wizard walks you through the process of adding the HAWQ Standby ' +
      'Master as a backup of the current HAWQ Master host. After you add the HAWQ Standby Master, it serves as a <i>warm standby</i> ' +
      'which may be activated in the event of the primary HAWQ Master host becoming non-operational.<br/><br/>' +
      '<b>This procedure restarts the HAWQ service. Perform this procedure during a scheduled cluster maintenance window.</b>',
  'admin.addHawqStandby.wizard.step2.header': 'Select Host',
  'admin.addHawqStandby.wizard.step2.body': 'Select a host that will be running the HAWQ Standby Master',
  'admin.addHawqStandby.wizard.step3.header': 'Review',
  'admin.addHawqStandby.wizard.step3.configs_changes': 'Review Configuration Changes.',
  'admin.addHawqStandby.wizard.step3.confirm.host.body':'<b>Confirm your host selections.</b>',
  'admin.addHawqStandby.wizard.step3.confirm.config.body':'<p class="alert alert-info">' +
      '<p><b>Review Configuration Changes.</b></p>' +
      'The following lists the configuration changes that will be made by the Wizard to add HAWQ Standby Master. ' +
      'This information is for <b> review only </b> and is not editable.</div>',
  'admin.addHawqStandby.wizard.step3.hawqMaster': 'Current HAWQ Master',
  'admin.addHawqStandby.wizard.step3.newHawqStandby': 'New HAWQ Standby Master',
  'admin.addHawqStandby.wizard.step3.confirm.dataDir.title': 'HAWQ Standby Master Directory Confirmation',
  'admin.addHawqStandby.wizard.step3.confirm.dataDir.body': 'Before you complete this procedure, ensure that you ' +
      'rename the directory <b>{0}</b> on the HAWQ Standby Master host <b>{1}</b> if it exists (for example, ' +
      'change it to {0}_old).<br/><br/><b>If {0} exists on the HAWQ Standby Master host, then the new HAWQ ' +
      'Standby Master may be started with stale data, leaving the cluster in an inconsistent state.</b><br/><br/>' +
      'Click Confirm to indicate that you have renamed any existing <b>{0}</b> directory on the HAWQ Standby Master host <b>{1}</b>.',
  'admin.addHawqStandby.step4.save.configuration.note': 'This configuration is created by Add HAWQ Standby wizard',
  'admin.addHawqStandby.wizard.step4.header': 'Configure Components',
  'admin.addHawqStandby.wizard.step4.task0.title': 'Stop HAWQ Service',
  'admin.addHawqStandby.wizard.step4.task1.title': 'Install HAWQ Standby Master',
  'admin.addHawqStandby.wizard.step4.task2.title': 'Reconfigure HAWQ',
  'admin.addHawqStandby.wizard.step4.task3.title': 'Start HAWQ Service',
  'admin.addHawqStandby.wizard.step4.notice.inProgress':'Please wait while HAWQ Standby Master is being deployed.',
  'admin.addHawqStandby.wizard.step4.notice.completed':'HAWQ Standby Master has been added successfully.',
  'admin.removeHawqStandby.button.enable': 'Remove HAWQ Standby',
  'admin.removeHawqStandby.wizard.header': 'Remove HAWQ Standby Wizard',
  'admin.removeHawqStandby.wizard.step1.header': 'Get Started',
  'admin.removeHawqStandby.wizard.step1.body':'This wizard walks you through the process of removing the HAWQ Standby Master ' +
      'in the event of HAWQ Standby Master host failure or maintenance. After you remove the HAWQ Standby Master, the existing HAWQ Master will run in standalone mode without a backup.' +
      '<br/><br/><b>This procedure stops and restarts the HAWQ service. Perform this procedure during a scheduled cluster ' +
      'maintenance window, only when HAWQ Master is functioning properly.</b>' +
      '<br/><br/>After you complete this wizard, the HAWQ cluster will no longer have a Standby Master. ' +
      'As a best practice, use the “Add HAWQ Standby Master” service action to configure a new HAWQ Standby Master for the cluster.',
  'admin.removeHawqStandby.wizard.step2.header': 'Review',
  'admin.removeHawqStandby.wizard.step2.hawqStandby': '<b>Current HAWQ Standby:</b>',
  'admin.removeHawqStandby.wizard.step2.confirm.config.body':'<div class="alert alert-info">' +
      '<p><b>Review Configuration Changes.</b></p>After removing the HAWQ Standby Master, the Wizard removes the ' +
      'hawq_standby_address_host property from hawq-site.xml. As a best practice, you should configure a new HAWQ Standby Master host after the Wizard completes.</div>',
  'admin.removeHawqStandby.wizard.step2.confirm.host.body':'<b>Review HAWQ Standby Master role changes.</b>',
  'admin.removeHawqStandby.wizard.step2.confirmPopup.body': 'Do you wish to continue with removing HAWQ Standby Master? Please confirm, before proceeding as you will not be able to rollback from Ambari.',
  'admin.removeHawqStandby.wizard.step3.header': 'Finalize Setup',
  'admin.removeHawqStandby.wizard.step3.task0.title': 'Remove HAWQ Standby',
  'admin.removeHawqStandby.wizard.step3.task1.title': 'Stop HAWQ Service',
  'admin.removeHawqStandby.wizard.step3.task2.title': 'Reconfigure HAWQ',
  'admin.removeHawqStandby.wizard.step3.task3.title': 'Delete Role: HAWQ Standby',
  'admin.removeHawqStandby.wizard.step3.task4.title': 'Start HAWQ Service',
  'admin.removeHawqStandby.closePopup':'Remove HAWQ Standby Wizard is in progress. You must allow the wizard to' +
      ' complete for Ambari to be in usable state. If you choose to quit, you must follow manual instructions to' +
      ' get back to a stable state. Are you sure you want to exit the wizard?',
  'admin.removeHawqStandby.wizard.step3.notice.inProgress':'Please wait while HAWQ Standby is being removed',
  'admin.removeHawqStandby.wizard.step3.notice.completed':'HAWQ Standby has been removed successfully.',
  'admin.removeHawqStandby.wizard.step3.removeHawqStandbyCommand.context': 'Execute HAWQ Standby remove command',
  'admin.removeHawqStandby.wizard.step3.save.configuration.note': 'This configuration was created by Remove HAWQ Standby wizard',
  'admin.activateHawqStandby.button.enable': 'Activate HAWQ Standby Master',
  'admin.activateHawqStandby.wizard.header': 'Activate HAWQ Standby Master Wizard',
  'admin.activateHawqStandby.wizard.step1.header': 'Get Started',
  'admin.activateHawqStandby.wizard.step1.body': 'This wizard walks you through the process of activating the HAWQ Standby Master ' +
      'in the event of HAWQ Master host failure. After you activate the HAWQ Standby Master, ' +
      'it is promoted as the new HAWQ Master, and the previous HAWQ Master configuration ' +
      'is removed from the cluster.<br/><br/><b>This procedure restarts the HAWQ service. ' +
      'Perform this procedure during a scheduled cluster maintenance window, unless the current ' +
      'HAWQ Master is not functioning.</b><br/><br/> After you complete this wizard, the HAWQ cluster ' +
      'will no longer have a Standby Master. As a best practice, use the “Add HAWQ Standby Master” ' +
      'service action to configure a new HAWQ Standby Master for the cluster.',
  'admin.activateHawqStandby.wizard.step2.header': 'Review',
  'admin.highAvailability.wizard.step2.toBeDeleted': 'TO BE DELETED',
  'admin.activateHawqStandby.wizard.step2.hawqMaster': '<b>Current HAWQ Master:</b>',
  'admin.activateHawqStandby.wizard.step2.hawqStandby': '<b>Current HAWQ Standby Master:</b>',
  'admin.activateHawqStandby.wizard.step2.toBeActivated': 'TO BE ACTIVATED AS NEW HAWQ MASTER',
  'admin.activateHawqStandby.step4.save.configuration.note': 'This configuration is created by Activate HAWQ Standby wizard',
  'admin.activateHawqStandby.wizard.step2.confirm.config.body': '<div class="alert alert-info">' +
      '<p><b>Review Configuration Changes.</b></p>The Wizard will make the following configuration changes. '+
      'This information is for review only, and cannot be edited.<br/><br/><b>After activating the HAWQ Standby ' +
      'Master, the wizard removes the hawq_standby_address_host property from hawq-site.xml.</b> ' +
      'As a best practice, you should configure a new HAWQ Standby Master host after the wizard completes.</div>',
  'admin.activateHawqStandby.wizard.step2.confirm.host.body':'<b>Review HAWQ Master & Standby Master role changes.</b>',
  'admin.activateHawqStandby.wizard.step2.confirmPopup.body': 'Do you wish to continue with activating HAWQ Standy Master? ' +
      'Please confirm, before proceeding as you will not be able to rollback from Ambari.',
  'admin.activateHawqStandby.wizard.step3.header': 'Finalize Setup',
  'admin.activateHawqStandby.wizard.step3.task0.title': 'Activate HAWQ Standby Master',
  'admin.activateHawqStandby.wizard.step3.task1.title': 'Stop HAWQ Service',
  'admin.activateHawqStandby.wizard.step3.task2.title': 'Reconfigure HAWQ',
  'admin.activateHawqStandby.wizard.step3.task3.title': 'Install Role: New HAWQ Master',
  'admin.activateHawqStandby.wizard.step3.task4.title': 'Delete Role: Previous HAWQ Master',
  'admin.activateHawqStandby.wizard.step3.task5.title': 'Delete Role: Previous HAWQ Standby',
  'admin.activateHawqStandby.wizard.step3.task6.title': 'Start HAWQ Service',
  'admin.activateHawqStandby.closePopup':'Activate HAWQ Standby Wizard is in progress. You must allow the wizard to' +
      ' complete for Ambari to be in usable state. If you choose to quit, you must follow manual instructions to' +
      ' get back to a stable state. Are you sure you want to exit the wizard?',
  'admin.activateHawqStandby.wizard.step3.notice.inProgress':'Please wait while HAWQ Standby Master is being activated',
  'admin.activateHawqStandby.wizard.step3.notice.completed':'HAWQ Standby Master has been activated successfully.',
  'admin.activateHawqStandby.wizard.step3.activateHawqStandbyCommand.context': "Execute HAWQ Standby Master activate command",
  'admin.serviceAutoStart.save.popup.title': 'Save Auto-Start Configuration',
  'admin.serviceAutoStart.save.popup.body': 'You are changing the auto-start configuration.' +
      'Click <b>Save</b> to commit the change or <b>Discard</b> to revert your changes',
  'admin.serviceAutoStart.save.popup.transition.title': 'Warning',
  'admin.serviceAutoStart.save.popup.transition.body': 'You have unsaved changes',

  'reset.ui.states': 'Reset UI State',
  'reset.ui.states.body': 'You should proceed only if the UI is misbehaving (such as incorrect navigation upon login, UI is stuck and won&apos;t load, etc.).  Are you sure you want to reset the UI state?',

  'app.logger.ajax': 'Ajax loading time: {0} [{1}]',
  'app.logger.wizard': 'wizard step {0} loading time'

};
