/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

public class SuballocatedByteVector {
    protected int m_blocksize;
    protected int m_numblocks = 32;
    protected byte[][] m_map;
    protected int m_firstFree = 0;
    protected byte[] m_map0;

    public SuballocatedByteVector() {
        this(2048);
    }

    public SuballocatedByteVector(int n) {
        this.m_blocksize = n;
        this.m_map0 = new byte[n];
        this.m_map = new byte[this.m_numblocks][];
        this.m_map[0] = this.m_map0;
    }

    public SuballocatedByteVector(int n, int n2) {
        this(n);
    }

    public int size() {
        return this.m_firstFree;
    }

    private void setSize(int n) {
        if (this.m_firstFree < n) {
            this.m_firstFree = n;
        }
    }

    public void addElement(byte by) {
        if (this.m_firstFree < this.m_blocksize) {
            this.m_map0[this.m_firstFree++] = by;
        } else {
            byte[] byArray;
            int n = this.m_firstFree / this.m_blocksize;
            int n2 = this.m_firstFree % this.m_blocksize;
            ++this.m_firstFree;
            if (n >= this.m_map.length) {
                int n3 = n + this.m_numblocks;
                byte[][] byArrayArray = new byte[n3][];
                System.arraycopy(this.m_map, 0, byArrayArray, 0, this.m_map.length);
                this.m_map = byArrayArray;
            }
            if (null == (byArray = this.m_map[n])) {
                this.m_map[n] = new byte[this.m_blocksize];
                byArray = this.m_map[n];
            }
            byArray[n2] = by;
        }
    }

    private void addElements(byte by, int n) {
        if (this.m_firstFree + n < this.m_blocksize) {
            for (int i = 0; i < n; ++i) {
                this.m_map0[this.m_firstFree++] = by;
            }
        } else {
            int n2 = this.m_firstFree / this.m_blocksize;
            int n3 = this.m_firstFree % this.m_blocksize;
            this.m_firstFree += n;
            while (n > 0) {
                byte[] byArray;
                if (n2 >= this.m_map.length) {
                    int n4 = n2 + this.m_numblocks;
                    byte[][] byArrayArray = new byte[n4][];
                    System.arraycopy(this.m_map, 0, byArrayArray, 0, this.m_map.length);
                    this.m_map = byArrayArray;
                }
                if (null == (byArray = this.m_map[n2])) {
                    this.m_map[n2] = new byte[this.m_blocksize];
                    byArray = this.m_map[n2];
                }
                int n5 = this.m_blocksize - n3 < n ? this.m_blocksize - n3 : n;
                n -= n5;
                while (n5-- > 0) {
                    byArray[n3++] = by;
                }
                ++n2;
                n3 = 0;
            }
        }
    }

    private void addElements(int n) {
        int n2 = this.m_firstFree + n;
        if (n2 > this.m_blocksize) {
            int n3 = this.m_firstFree % this.m_blocksize;
            int n4 = (this.m_firstFree + n) % this.m_blocksize;
            for (int i = n3 + 1; i <= n4; ++i) {
                this.m_map[i] = new byte[this.m_blocksize];
            }
        }
        this.m_firstFree = n2;
    }

    private void insertElementAt(byte by, int n) {
        if (n == this.m_firstFree) {
            this.addElement(by);
        } else if (n > this.m_firstFree) {
            byte[] byArray;
            int n2 = n / this.m_blocksize;
            if (n2 >= this.m_map.length) {
                int n3 = n2 + this.m_numblocks;
                byte[][] byArrayArray = new byte[n3][];
                System.arraycopy(this.m_map, 0, byArrayArray, 0, this.m_map.length);
                this.m_map = byArrayArray;
            }
            if (null == (byArray = this.m_map[n2])) {
                this.m_map[n2] = new byte[this.m_blocksize];
                byArray = this.m_map[n2];
            }
            int n4 = n % this.m_blocksize;
            byArray[n4] = by;
            this.m_firstFree = n4 + 1;
        } else {
            int n5 = this.m_firstFree + 1 / this.m_blocksize;
            ++this.m_firstFree;
            int n6 = n % this.m_blocksize;
            for (int i = n / this.m_blocksize; i <= n5; ++i) {
                byte by2;
                int n7 = this.m_blocksize - n6 - 1;
                byte[] byArray = this.m_map[i];
                if (null == byArray) {
                    by2 = 0;
                    this.m_map[i] = new byte[this.m_blocksize];
                    byArray = this.m_map[i];
                } else {
                    by2 = byArray[this.m_blocksize - 1];
                    System.arraycopy(byArray, n6, byArray, n6 + 1, n7);
                }
                byArray[n6] = by;
                by = by2;
                n6 = 0;
            }
        }
    }

    public void removeAllElements() {
        this.m_firstFree = 0;
    }

    private boolean removeElement(byte by) {
        int n = this.indexOf(by, 0);
        if (n < 0) {
            return false;
        }
        this.removeElementAt(n);
        return true;
    }

    private void removeElementAt(int n) {
        if (n < this.m_firstFree) {
            int n2 = this.m_firstFree / this.m_blocksize;
            int n3 = n % this.m_blocksize;
            for (int i = n / this.m_blocksize; i <= n2; ++i) {
                int n4 = this.m_blocksize - n3 - 1;
                byte[] byArray = this.m_map[i];
                if (null == byArray) {
                    this.m_map[i] = new byte[this.m_blocksize];
                    byArray = this.m_map[i];
                } else {
                    System.arraycopy(byArray, n3 + 1, byArray, n3, n4);
                }
                if (i < n2) {
                    byte[] byArray2 = this.m_map[i + 1];
                    if (byArray2 != null) {
                        byArray[this.m_blocksize - 1] = byArray2 != null ? byArray2[0] : (byte)0;
                    }
                } else {
                    byArray[this.m_blocksize - 1] = 0;
                }
                n3 = 0;
            }
        }
        --this.m_firstFree;
    }

    public void setElementAt(byte by, int n) {
        byte[] byArray;
        if (n < this.m_blocksize) {
            this.m_map0[n] = by;
            return;
        }
        int n2 = n / this.m_blocksize;
        int n3 = n % this.m_blocksize;
        if (n2 >= this.m_map.length) {
            int n4 = n2 + this.m_numblocks;
            byte[][] byArrayArray = new byte[n4][];
            System.arraycopy(this.m_map, 0, byArrayArray, 0, this.m_map.length);
            this.m_map = byArrayArray;
        }
        if (null == (byArray = this.m_map[n2])) {
            this.m_map[n2] = new byte[this.m_blocksize];
            byArray = this.m_map[n2];
        }
        byArray[n3] = by;
        if (n >= this.m_firstFree) {
            this.m_firstFree = n + 1;
        }
    }

    public byte elementAt(int n) {
        if (n < this.m_blocksize) {
            return this.m_map0[n];
        }
        return this.m_map[n / this.m_blocksize][n % this.m_blocksize];
    }

    private boolean contains(byte by) {
        return this.indexOf(by, 0) >= 0;
    }

    public int indexOf(byte by, int n) {
        int n2;
        byte[] byArray;
        if (n >= this.m_firstFree) {
            return -1;
        }
        int n3 = n % this.m_blocksize;
        int n4 = this.m_firstFree / this.m_blocksize;
        for (int i = n / this.m_blocksize; i < n4; ++i) {
            byArray = this.m_map[i];
            if (byArray != null) {
                for (n2 = n3; n2 < this.m_blocksize; ++n2) {
                    if (byArray[n2] != by) continue;
                    return n2 + i * this.m_blocksize;
                }
            }
            n3 = 0;
        }
        n2 = this.m_firstFree % this.m_blocksize;
        byArray = this.m_map[n4];
        for (int i = n3; i < n2; ++i) {
            if (byArray[i] != by) continue;
            return i + n4 * this.m_blocksize;
        }
        return -1;
    }

    public int indexOf(byte by) {
        return this.indexOf(by, 0);
    }

    private int lastIndexOf(byte by) {
        int n = this.m_firstFree % this.m_blocksize;
        for (int i = this.m_firstFree / this.m_blocksize; i >= 0; --i) {
            byte[] byArray = this.m_map[i];
            if (byArray != null) {
                for (int j = n; j >= 0; --j) {
                    if (byArray[j] != by) continue;
                    return j + i * this.m_blocksize;
                }
            }
            n = 0;
        }
        return -1;
    }
}

