/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.jaxp;

import com.ibm.xtq.common.utils.ErrorHandler;
import com.ibm.xtq.common.utils.SourceLocation;
import com.ibm.xtq.utils.SourceLocationImpl;
import com.ibm.xtq.xslt.jaxp.AbstractErrorHandler;
import com.ibm.xtq.xslt.jaxp.HandledRuntimeException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class ConfigurationErrorHandler
extends AbstractErrorHandler
implements ErrorHandler {
    public ConfigurationErrorHandler(ErrorListener errorListener) {
        super(errorListener);
    }

    @Override
    public void report(int n, String string, SourceLocation sourceLocation, Exception exception, boolean bl) {
        SourceLocationWrapper sourceLocationWrapper = null;
        if (sourceLocation instanceof SourceLocationImpl) {
            sourceLocationWrapper = new SourceLocationWrapper((SourceLocationImpl)sourceLocation);
        }
        TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(string, sourceLocationWrapper, exception);
        try {
            switch (n) {
                case 0: {
                    this.getErrorListener().warning(transformerConfigurationException);
                    break;
                }
                case 1: {
                    this.getErrorListener().error(transformerConfigurationException);
                    break;
                }
                case 2: {
                    this.getErrorListener().fatalError(transformerConfigurationException);
                    break;
                }
                default: {
                    transformerConfigurationException = new TransformerConfigurationException("Unrecognized error level: " + n, null, transformerConfigurationException);
                    this.getErrorListener().error(transformerConfigurationException);
                    break;
                }
            }
        }
        catch (TransformerException transformerException) {
            throw new HandledRuntimeException(transformerException);
        }
        if (bl) {
            String string2 = string;
            if (string2 == null && exception != null) {
                string2 = exception.getMessage();
            }
            throw new HandledRuntimeException(string2);
        }
    }

    private class SourceLocationWrapper
    implements SourceLocator {
        private SourceLocationImpl _location;

        public SourceLocationWrapper(SourceLocationImpl sourceLocationImpl) {
            this._location = sourceLocationImpl;
        }

        @Override
        public int getColumnNumber() {
            int n = this._location.getColumnNumber();
            return n > 0 ? n : -1;
        }

        @Override
        public int getLineNumber() {
            int n = this._location.getLineNumber();
            return n > 0 ? n : -1;
        }

        @Override
        public String getPublicId() {
            return this._location.getPublicId();
        }

        @Override
        public String getSystemId() {
            return this._location.getSystemId();
        }
    }
}

