/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.IImperativeInstruction;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.res.XylemMsg;
import com.ibm.xylem.types.JavaClassInformation;
import com.ibm.xylem.types.JavaObjectType;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.LinkedList;

public class ReadJavaFieldInstruction
extends UnaryPrimopInstruction
implements IImperativeInstruction {
    protected String m_fieldName;

    public ReadJavaFieldInstruction() {
    }

    public ReadJavaFieldInstruction(Instruction instruction, String string) {
        super(instruction);
        this.m_fieldName = string;
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string2 = codeGenerationTracker.generateConventionally(this.m_operand, dataFlowCodeGenerationHelper);
        String string3 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        dataFlowCodeGenerationHelper.appendAssignment(string3, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), string2 + "." + this.m_fieldName, codeGenerationTracker);
        return string3;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        codeGenerationTracker.generateConventionally(this.m_operand, bCELCodeGenerationHelper, null, instructionListBuilder);
        JavaObjectType javaObjectType = (JavaObjectType)codeGenerationTracker.resolveType(this.m_operand);
        Type type = codeGenerationTracker.resolveType(this);
        instructionListBuilder.appendGetField(javaObjectType.getClassName(), this.m_fieldName, type);
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        Object object = this.m_operand.evaluate(environment, function, iDebuggerInterceptor, false);
        try {
            Field field = object.getClass().getField(this.m_fieldName);
            Object object2 = field.get(object);
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, object2);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            throw new RuntimeException(securityException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            throw new RuntimeException(illegalArgumentException.getMessage());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
            throw new RuntimeException(noSuchFieldException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new RuntimeException(illegalAccessException.getMessage());
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return new ReadJavaFieldInstruction(this.m_operand.cloneWithoutTypeInformation(), this.m_fieldName);
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction) {
        return new ReadJavaFieldInstruction(instruction, this.m_fieldName);
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        Type type = this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        type = type.resolveType(typeEnvironment);
        if (type == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Could not infer the type of " + this.m_operand), this);
        }
        if (!(type instanceof JavaObjectType)) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", this.m_operand + " is not an object"), this);
        }
        JavaObjectType javaObjectType = (JavaObjectType)type;
        JavaClassInformation.Field field = javaObjectType.getInformation(typeEnvironment.getModule()).getField(this.m_fieldName);
        if (field == null) {
            throw new TypeCheckException(XylemMsg.createXylemMessage("ERR_SYSTEM", "Class " + javaObjectType + " does not contain field " + this.m_fieldName), this);
        }
        return this.setCachedType(field.getType());
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        Type type = this.m_operand.getType(typeEnvironment, bindingEnvironment);
        type = type.resolveType(typeEnvironment);
        JavaObjectType javaObjectType = (JavaObjectType)type;
        JavaClassInformation.Field field = javaObjectType.getInformation(typeEnvironment.getModule()).getField(this.m_fieldName);
        return field.getType();
    }

    @Override
    public String innerToString() {
        return "read-java-field! " + this.m_fieldName;
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeString(this.m_fieldName);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_fieldName = readObjectFileHelper.readString();
    }
}

