/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.PrettyPrinter;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.IStreamInADTOptimizationInstruction;
import com.ibm.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.LambdaType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.types.TagType;
import java.util.HashMap;
import java.util.LinkedList;

public class DebugInstruction
extends BinaryPrimopInstruction
implements IStreamInADTOptimizationInstruction,
IStreamOptimizationInstruction {
    private String m_category;
    private boolean m_printValue;
    private static HashMap s_settings = new HashMap();

    public static void enable(String string) {
        s_settings.put("DEBUG." + string, "true");
    }

    public static Instruction makeDebugInstruction(Instruction instruction, Instruction instruction2, String string, boolean bl) {
        if (s_settings.get("DEBUG." + string) != null) {
            return new DebugInstruction(instruction, instruction2, string, bl);
        }
        return instruction2;
    }

    private DebugInstruction(Instruction instruction, Instruction instruction2, String string, boolean bl) {
        super(instruction, instruction2);
        this.m_category = string;
        this.m_printValue = bl;
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction, Instruction instruction2) {
        return new DebugInstruction(this.getOperand1(), this.getOperand2(), this.m_category, this.m_printValue);
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        typeEnvironment.unify(CharType.s_charType.getStreamType(), this.getOperand1().typeCheck(typeEnvironment, bindingEnvironment, linkedList), this);
        return this.setCachedType(this.getOperand2().typeCheck(typeEnvironment, bindingEnvironment, linkedList));
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.getOperand2().getType(typeEnvironment, bindingEnvironment);
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        String string2 = codeGenerationTracker.generateConventionally(this.getOperand2(), dataFlowCodeGenerationHelper);
        this.generateDebug(dataFlowCodeGenerationHelper, codeGenerationTracker, string2, false);
        return string2;
    }

    public static void generateStringValue(Type type, String string, String string2, DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper) {
        if (type instanceof TagType) {
            dataFlowCodeGenerationHelper.append(string2 + ".append(\"(tag " + ((TagType)type).getTag() + " \");\n");
            DebugInstruction.generateStringValue(((TagType)type).getElementType(), string, string2, dataFlowCodeGenerationHelper);
            dataFlowCodeGenerationHelper.append(string2 + ".append(')');\n");
        } else if (type.equals(CharType.s_charType.getStreamType())) {
            dataFlowCodeGenerationHelper.append(string2 + ".append('\"');\n");
            dataFlowCodeGenerationHelper.append(string2 + ".append(new String(" + string + "));\n");
            dataFlowCodeGenerationHelper.append(string2 + ".append('\"');\n");
        } else if (type instanceof StreamType) {
            type = ((StreamType)type).getElementType();
            dataFlowCodeGenerationHelper.append(string2 + ".append(\"(stream " + LiteralInstruction.escape(type.getImplementationName(dataFlowCodeGenerationHelper)) + "\");\n");
            dataFlowCodeGenerationHelper.append("for (int i=0;i<" + string + ".length;i++) {\n");
            dataFlowCodeGenerationHelper.append(string2 + ".append(' ');\n");
            DebugInstruction.generateStringValue(type, string + "[i]", "sb", dataFlowCodeGenerationHelper);
            dataFlowCodeGenerationHelper.append("}\n");
            dataFlowCodeGenerationHelper.append(string2 + ".append(')');\n");
        } else if (type instanceof LambdaType) {
            LambdaType lambdaType = (LambdaType)type;
            dataFlowCodeGenerationHelper.append(string2 + ".append(\"(lambda@" + lambdaType.prettyPrint() + ")\");\n");
        } else {
            dataFlowCodeGenerationHelper.append(string2 + ".append(" + string + ");\n");
        }
    }

    public static void generateStreamStringValue(StreamType streamType, String string, String string2, DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string3) {
        String string4 = StreamType.generateGetStreamPart(string, streamType);
        String string5 = string + "_size";
        if (string3 == null) {
            string3 = "0";
        }
        if (streamType.equals(CharType.s_charType.getStreamType())) {
            dataFlowCodeGenerationHelper.append(string2 + ".append('\"');\n");
            dataFlowCodeGenerationHelper.append(string2 + ".append(new String(" + string4 + "," + string3 + ",(" + string5 + "-" + string3 + ")));\n");
            dataFlowCodeGenerationHelper.append(string2 + ".append('\"');\n");
        } else {
            Type type = streamType.getElementType();
            dataFlowCodeGenerationHelper.append(string2 + ".append(\"(stream " + LiteralInstruction.escape(type.getImplementationName(dataFlowCodeGenerationHelper)) + "\");\n");
            dataFlowCodeGenerationHelper.append("for (int i=0;i<" + string5 + ";i++) {\n");
            dataFlowCodeGenerationHelper.append(string2 + ".append(' ');\n");
            DebugInstruction.generateStringValue(type, string4 + "[i]", "sb", dataFlowCodeGenerationHelper);
            dataFlowCodeGenerationHelper.append("}\n");
            dataFlowCodeGenerationHelper.append(string2 + ".append(')');\n");
        }
    }

    private void generateDebug(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        if (s_settings.get("DEBUG." + this.m_category) != null) {
            String string2 = codeGenerationTracker.generateConventionally(this.getOperand1(), dataFlowCodeGenerationHelper);
            dataFlowCodeGenerationHelper.append("{ StringBuffer sb = new StringBuffer();\n");
            dataFlowCodeGenerationHelper.append("sb.append(\"" + this.m_category + ": \");\n");
            dataFlowCodeGenerationHelper.append("sb.append(new String(" + string2 + "));\n");
            dataFlowCodeGenerationHelper.append("sb.append(\" = '\");\n");
            if (this.m_printValue) {
                Type type = codeGenerationTracker.resolveType(this);
                if (bl) {
                    DebugInstruction.generateStreamStringValue((StreamType)type, string, "sb", dataFlowCodeGenerationHelper, null);
                } else {
                    DebugInstruction.generateStringValue(type, string, "sb", dataFlowCodeGenerationHelper);
                }
            }
            dataFlowCodeGenerationHelper.append("sb.append('\\'');\n");
            dataFlowCodeGenerationHelper.append("System.err.println(sb.toString()); }\n");
        }
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return new DebugInstruction(this.getOperand1(), this.getOperand2(), this.m_category, this.m_printValue);
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle codeGenerationOptimizationStyle, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (codeGenerationOptimizationStyle instanceof StreamOptimizationStyle) {
            return this.getOperand2().supportsCodeGenerationOptimization(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
        }
        return super.supportsCodeGenerationOptimizationInternal(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, Binding binding, CodeGenerationTracker codeGenerationTracker, boolean bl, boolean bl2) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string2 = ((IStreamInADTOptimizationInstruction)((Object)this.getOperand2())).generateCodeBasedOnDataFlow(dataFlowCodeGenerationHelper, string, binding, codeGenerationTracker.cloneBranch(), bl, bl2);
        this.generateDebug(dataFlowCodeGenerationHelper, codeGenerationTracker, string, true);
        return string2;
    }

    @Override
    public boolean canGenerateObjectless(TypeEnvironment typeEnvironment) {
        return ((IStreamInADTOptimizationInstruction)((Object)this.getOperand2())).canGenerateObjectless(typeEnvironment);
    }

    @Override
    public void generateCodeWithStreamOptimization(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, CodeGenerationTracker codeGenerationTracker, boolean bl) {
        ((IStreamOptimizationInstruction)((Object)this.getOperand2())).generateCodeWithStreamOptimization(dataFlowCodeGenerationHelper, string, codeGenerationTracker.cloneBranch(), bl);
        this.generateDebug(dataFlowCodeGenerationHelper, codeGenerationTracker, string, true);
    }

    @Override
    public String innerToString() {
        if (this.m_printValue) {
            return "debug-value";
        }
        return "debug";
    }

    @Override
    public void generateCodeWithStreamOptimization(BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionListBuilder instructionListBuilder, int[] nArray, CodeGenerationTracker codeGenerationTracker, InstructionHandle instructionHandle) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, int[] nArray, Binding binding, CodeGenerationTracker codeGenerationTracker, boolean bl, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n) {
        prettyPrinter.printFormOpen(this.innerToString(), n);
        prettyPrinter.printIdentifier(this.m_category, n + 1);
        this.m_operand1.toString(prettyPrinter, n + 1);
        this.m_operand2.toString(prettyPrinter, n + 1);
        prettyPrinter.printFormClose(n);
    }
}

