/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.File;
import java.io.FilenameFilter;
import java.security.cert.TrustAnchor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.stores.ResourceSecurityWrapperStore;
import org.globus.gsi.stores.ResourceStoreException;
import org.globus.gsi.stores.ResourceTrustAnchor;
import org.globus.util.GlobusResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceCACertStore
extends ResourceSecurityWrapperStore<ResourceTrustAnchor, TrustAnchor> {
    private static FilenameFilter filter = new TrustAnchorFilter();
    private Log logger = LogFactory.getLog((String)this.getClass().getCanonicalName());

    @Override
    public ResourceTrustAnchor create(GlobusResource globusResource) throws ResourceStoreException {
        return new ResourceTrustAnchor(false, globusResource);
    }

    @Override
    protected Log getLog() {
        return this.logger;
    }

    @Override
    public FilenameFilter getDefaultFilenameFilter() {
        return filter;
    }

    public static class TrustAnchorFilter
    implements FilenameFilter {
        public boolean accept(File dir, String file) {
            if (file == null) {
                throw new IllegalArgumentException();
            }
            int length = file.length();
            return length > 2 && file.charAt(length - 2) == '.' && file.charAt(length - 1) >= '0' && file.charAt(length - 1) <= '9';
        }
    }
}

