/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.security;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.airavata.security.AuthenticationException;
import org.apache.airavata.security.Authenticator;
import org.apache.airavata.security.UserStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticator
implements Authenticator {
    protected static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    protected static Logger log = LoggerFactory.getLogger(AbstractAuthenticator.class);
    public static int DEFAULT_AUTHENTICATOR_PRIORITY = 5;
    protected String authenticatorName;
    private int priority = DEFAULT_AUTHENTICATOR_PRIORITY;
    protected boolean enabled = true;
    protected UserStore userStore;

    public AbstractAuthenticator() {
    }

    public AbstractAuthenticator(String name) {
        this.authenticatorName = name;
    }

    @Override
    public void setUserStore(UserStore store) {
        this.userStore = store;
    }

    @Override
    public UserStore getUserStore() {
        return this.userStore;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean canProcess(Object credentials) {
        return false;
    }

    @Override
    public String getAuthenticatorName() {
        return this.authenticatorName;
    }

    public void setAuthenticatorName(String authenticatorName) {
        this.authenticatorName = authenticatorName;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean authenticate(Object credentials) throws AuthenticationException {
        boolean authenticated = this.doAuthentication(credentials);
        if (authenticated) {
            this.onSuccessfulAuthentication(credentials);
        } else {
            this.onFailedAuthentication(credentials);
        }
        return authenticated;
    }

    protected String getCurrentTime() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_TIME_FORMAT);
        return simpleDateFormat.format(cal.getTime());
    }

    protected abstract boolean doAuthentication(Object var1) throws AuthenticationException;

    public abstract void onSuccessfulAuthentication(Object var1);

    public abstract void onFailedAuthentication(Object var1);
}

