/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RestartAppServerRequestMarshaller
implements Marshaller<Request<RestartAppServerRequest>, RestartAppServerRequest> {
    public Request<RestartAppServerRequest> marshall(RestartAppServerRequest restartAppServerRequest) {
        if (restartAppServerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restartAppServerRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "RestartAppServer");
        request.addParameter("Version", "2010-12-01");
        if (restartAppServerRequest.getEnvironmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)restartAppServerRequest.getEnvironmentId()));
        }
        if (restartAppServerRequest.getEnvironmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)restartAppServerRequest.getEnvironmentName()));
        }
        return request;
    }
}

