/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.validators;

import eu.unicore.samly2.SAMLConstants;
import eu.unicore.samly2.exceptions.SAMLRequesterException;
import eu.unicore.samly2.exceptions.SAMLServerException;
import eu.unicore.samly2.exceptions.SAMLValidationException;
import eu.unicore.samly2.exceptions.SAMLVersionException;
import eu.unicore.samly2.trust.SamlTrustChecker;
import eu.unicore.samly2.validators.ReplayAttackChecker;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.xmlbeans.XmlObject;
import xmlbeans.org.oasis.saml2.protocol.RequestAbstractType;

public class AbstractRequestValidator {
    protected URI responderEndpointUri;
    protected SamlTrustChecker trustChecker;
    protected long requestValidity;
    protected ReplayAttackChecker replayChecker;

    public AbstractRequestValidator(String responderEndpointUri, SamlTrustChecker trustChecker, long requestValidity, ReplayAttackChecker replayChecker) {
        try {
            this.responderEndpointUri = new URI(responderEndpointUri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("responderURI '" + responderEndpointUri + "' is not a valid URI: " + e, e);
        }
        this.trustChecker = trustChecker;
        this.requestValidity = requestValidity;
        this.replayChecker = replayChecker;
    }

    public void validate(XmlObject wrappingDcoument, RequestAbstractType request) throws SAMLServerException {
        long maxTs;
        this.checkMandatoryElements(request);
        String destination = request.getDestination();
        if (destination != null) {
            URI destinationUri;
            try {
                destinationUri = new URI(destination);
            }
            catch (URISyntaxException e) {
                throw new SAMLRequesterException(SAMLConstants.SubStatus.STATUS2_REQUEST_DENIED, "Destination value " + destination + " is not a valid URI: " + e.toString());
            }
            if (!destinationUri.equals(this.responderEndpointUri)) {
                throw new SAMLRequesterException(SAMLConstants.SubStatus.STATUS2_REQUEST_DENIED, "Destination value " + destination + " is not matching the responder's URI: " + this.responderEndpointUri);
            }
        }
        if (request.getSignature() != null && !request.getSignature().isNil()) {
            try {
                this.trustChecker.checkTrust(wrappingDcoument, request);
            }
            catch (SAMLValidationException e) {
                throw new SAMLRequesterException(SAMLConstants.SubStatus.STATUS2_REQUEST_DENIED, e.getMessage(), e.getCause());
            }
        }
        if ((maxTs = request.getIssueInstant().getTimeInMillis() + this.requestValidity) < System.currentTimeMillis()) {
            throw new SAMLRequesterException(SAMLConstants.SubStatus.STATUS2_REQUEST_DENIED, "Request is too old. It was issued at " + request.getIssueInstant() + " and the validity timeframe is " + this.requestValidity + "ms");
        }
        try {
            this.replayChecker.checkAndStore(request.getID(), this.requestValidity);
        }
        catch (SAMLValidationException e) {
            throw new SAMLRequesterException(SAMLConstants.SubStatus.STATUS2_REQUEST_DENIED, e.getMessage());
        }
    }

    protected void checkMandatoryElements(RequestAbstractType request) throws SAMLServerException {
        if (request.getID() == null || request.getID().equals("")) {
            throw new SAMLRequesterException("Request must posses an ID");
        }
        if (request.getVersion() == null || !request.getVersion().equals("2.0")) {
            throw new SAMLVersionException("Request must posses 2.0 version");
        }
        if (request.getIssueInstant() == null) {
            throw new SAMLRequesterException("Request must posses an IssueInstant");
        }
    }
}

