/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.binding.scanner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.compass.core.config.binding.scanner.Filter;
import org.compass.core.config.binding.scanner.ScanItem;
import org.compass.core.config.binding.scanner.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileScanner
implements Scanner {
    private ArrayList<File> files = new ArrayList();
    private int index = 0;

    public FileScanner(String basePackge, File file, Filter filter) {
        try {
            this.create(this.files, file, new FileFilterWrapper(basePackge, filter));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void create(List<File> list, File dir, Filter filter) throws Exception {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.create(list, file, filter);
                continue;
            }
            if (filter != null && !filter.accepts(file.getAbsolutePath())) continue;
            list.add(file);
        }
    }

    @Override
    public ScanItem next() {
        if (this.index >= this.files.size()) {
            return null;
        }
        File fp = this.files.get(this.index++);
        try {
            return new ScanItem(new FileInputStream(fp), fp.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
    }

    private class FileFilterWrapper
    implements Filter {
        private String basePackage;
        private Filter delegate;

        private FileFilterWrapper(String basePackage, Filter delegate) {
            this.basePackage = basePackage;
            this.delegate = delegate;
        }

        public boolean accepts(String name) {
            int index = (name = name.replace('\\', '/')).lastIndexOf(this.basePackage);
            if (index == -1) {
                return false;
            }
            return this.delegate.accepts(name.substring(index + this.basePackage.length() + 1));
        }
    }
}

