/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateHsmConfigurationRequestMarshaller
implements Marshaller<Request<CreateHsmConfigurationRequest>, CreateHsmConfigurationRequest> {
    public Request<CreateHsmConfigurationRequest> marshall(CreateHsmConfigurationRequest createHsmConfigurationRequest) {
        if (createHsmConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createHsmConfigurationRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateHsmConfiguration");
        request.addParameter("Version", "2012-12-01");
        if (createHsmConfigurationRequest.getHsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringUtils.fromString((String)createHsmConfigurationRequest.getHsmConfigurationIdentifier()));
        }
        if (createHsmConfigurationRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createHsmConfigurationRequest.getDescription()));
        }
        if (createHsmConfigurationRequest.getHsmIpAddress() != null) {
            request.addParameter("HsmIpAddress", StringUtils.fromString((String)createHsmConfigurationRequest.getHsmIpAddress()));
        }
        if (createHsmConfigurationRequest.getHsmPartitionName() != null) {
            request.addParameter("HsmPartitionName", StringUtils.fromString((String)createHsmConfigurationRequest.getHsmPartitionName()));
        }
        if (createHsmConfigurationRequest.getHsmPartitionPassword() != null) {
            request.addParameter("HsmPartitionPassword", StringUtils.fromString((String)createHsmConfigurationRequest.getHsmPartitionPassword()));
        }
        if (createHsmConfigurationRequest.getHsmServerPublicCertificate() != null) {
            request.addParameter("HsmServerPublicCertificate", StringUtils.fromString((String)createHsmConfigurationRequest.getHsmServerPublicCertificate()));
        }
        return request;
    }
}

