/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.securevault;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.securevault.SecretCallbackHandlerServiceImpl;
import org.wso2.carbon.securevault.SecretManagerSecretCallbackHandler;
import org.wso2.securevault.secret.SecretCallbackHandler;
import org.wso2.securevault.secret.SecretCallbackHandlerFactory;
import org.wso2.securevault.secret.SecretManager;

public class SecretManagerInitializer {
    private SecretManager secretManager = SecretManager.getInstance();
    private static final Log log = LogFactory.getLog(SecretManagerInitializer.class);
    public static final String CARBON_HOME = "carbon.home";
    private String SECRET_CONF = "secret-conf.properties";
    private static String CONF_DIR = "conf";
    private static String REPOSITORY_DIR = "repository";
    private static final String SECURITY_DIR = "security";
    private static String GLOBAL_PREFIX = "carbon.";

    public SecretCallbackHandlerServiceImpl init() {
        SecretCallbackHandler passwordProvider;
        Properties properties = new Properties();
        if (this.secretManager.isInitialized()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SecretManager already has been initialized.");
            }
        } else {
            properties = this.loadProperties();
            this.secretManager.init(properties);
        }
        SecretCallbackHandlerServiceImpl serviceImpl = null;
        if (!this.secretManager.isInitialized() && (passwordProvider = SecretCallbackHandlerFactory.createSecretCallbackHandler((Properties)properties, (String)(GLOBAL_PREFIX + "passwordProvider"))) != null) {
            serviceImpl = new SecretCallbackHandlerServiceImpl();
            serviceImpl.setSecretCallbackHandler(passwordProvider);
        }
        if (serviceImpl == null) {
            serviceImpl = new SecretCallbackHandlerServiceImpl();
            serviceImpl.setSecretCallbackHandler((SecretCallbackHandler)new SecretManagerSecretCallbackHandler(this.secretManager));
        }
        return serviceImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties() {
        Properties properties = new Properties();
        String carbonHome = System.getProperty(CARBON_HOME);
        String filePath = carbonHome + File.separator + REPOSITORY_DIR + File.separator + CONF_DIR + File.separator + SECURITY_DIR + File.separator + this.SECRET_CONF;
        File dataSourceFile = new File(filePath);
        if (!dataSourceFile.exists()) {
            return properties;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(dataSourceFile);
            properties.load(in);
        }
        catch (IOException e) {
            String msg = "Error loading properties from a file at :" + filePath;
            log.warn((Object)msg, (Throwable)e);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ignored) {}
            }
        }
        return properties;
    }
}

