/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.dao;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.ResourceIDImpl;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.dao.RatingsDAO;
import org.wso2.carbon.registry.core.dao.ResourceDAO;
import org.wso2.carbon.registry.core.dataaccess.DAOManager;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dao.JDBCRatingsDAO;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDatabaseTransaction;
import org.wso2.carbon.registry.core.jdbc.dataobjects.RatingDO;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.utils.DBUtils;

public class JDBCRatingsVersionDAO
extends JDBCRatingsDAO
implements RatingsDAO {
    private static final Log log = LogFactory.getLog(JDBCRatingsVersionDAO.class);
    private ResourceDAO resourceDAO;

    public JDBCRatingsVersionDAO(DAOManager daoManager) {
        super(daoManager);
        this.resourceDAO = daoManager.getResourceDAO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRating(ResourceImpl resourceImpl, String userID, int rating) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        Statement ps1 = null;
        Statement ps2 = null;
        Statement ps3 = null;
        ResultSet result = null;
        try {
            String sql1 = "INSERT INTO REG_RATING (REG_RATING, REG_USER_ID, REG_RATED_TIME, REG_TENANT_ID) VALUES (?,?,?,?)";
            String sql2 = "SELECT MAX(REG_ID) FROM REG_RATING";
            String dbProductName = conn.getMetaData().getDatabaseProductName();
            boolean returnsGeneratedKeys = DBUtils.canReturnGeneratedKeys((String)dbProductName);
            ps1 = returnsGeneratedKeys ? conn.prepareStatement(sql1, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"REG_ID")}) : conn.prepareStatement(sql1);
            ps1.setInt(1, rating);
            ps1.setString(2, userID);
            long now = System.currentTimeMillis();
            ps1.setDate(3, new Date(now));
            ps1.setInt(4, CurrentSession.getTenantId());
            if (returnsGeneratedKeys) {
                ps1.executeUpdate();
                result = ps1.getGeneratedKeys();
            } else {
                Object object = ADD_RATING_LOCK;
                synchronized (object) {
                    ps1.executeUpdate();
                    ps2 = conn.prepareStatement(sql2);
                    result = ps2.executeQuery();
                }
            }
            if (result.next()) {
                int rateID = result.getInt(1);
                String sql3 = "INSERT INTO REG_RESOURCE_RATING (REG_RATING_ID, REG_VERSION, REG_TENANT_ID) VALUES(?,?,?)";
                ps3 = conn.prepareStatement(sql3);
                ps3.setInt(1, rateID);
                ps3.setLong(2, resourceImpl.getVersionNumber());
                ps3.setInt(3, CurrentSession.getTenantId());
                ps3.executeUpdate();
            }
        }
        catch (SQLException e) {
            String msg = "Failed to rate resource " + resourceImpl.getVersionNumber() + " with rating " + rating + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    try {
                        if (ps1 != null) {
                            ps1.close();
                        }
                    }
                    finally {
                        try {
                            if (ps2 != null) {
                                ps2.close();
                            }
                        }
                        finally {
                            if (ps3 != null) {
                                ps3.close();
                            }
                        }
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
    }

    @Override
    public void copyRatings(ResourceImpl fromResource, ResourceImpl toResource) throws RegistryException {
        RatingDO[] ratingDOs = this.getResourceRatingDO(fromResource);
        this.addRatings(toResource, ratingDOs);
    }

    @Override
    public int getRateID(ResourceImpl resourceImpl, String userID) throws RegistryException {
        RatingDO ratingDO = this.getRatingDO(resourceImpl, userID);
        return ratingDO.getRatingID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getAverageRating(ResourceImpl resourceImpl) throws RegistryException {
        int countRating;
        int sumRating;
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        PreparedStatement ps = null;
        ResultSet result1 = null;
        try {
            String sql = "SELECT SUM(R.REG_RATING) FROM REG_RATING R, REG_RESOURCE_RATING RR WHERE RR.REG_VERSION=? AND RR.REG_RATING_ID=R.REG_ID AND R.REG_TENANT_ID=? AND RR.REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setLong(1, resourceImpl.getVersionNumber());
            ps.setInt(2, CurrentSession.getTenantId());
            ps.setInt(3, CurrentSession.getTenantId());
            result1 = ps.executeQuery();
            sumRating = 0;
            if (result1.next()) {
                sumRating = result1.getInt(1);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get sum of all ratings on resource " + resourceImpl.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result1 != null) {
                        result1.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        ps = null;
        ResultSet result2 = null;
        try {
            String sql = "SELECT COUNT(R.REG_RATING) FROM REG_RATING R, REG_RESOURCE_RATING RR WHERE RR.REG_VERSION=? AND RR.REG_RATING_ID=R.REG_ID AND R.REG_TENANT_ID=? AND RR.REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setLong(1, resourceImpl.getVersionNumber());
            ps.setInt(2, CurrentSession.getTenantId());
            ps.setInt(3, CurrentSession.getTenantId());
            result2 = ps.executeQuery();
            countRating = 0;
            if (result2.next()) {
                countRating = result2.getInt(1);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get ratings count on resource " + resourceImpl.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result2 != null) {
                        result2.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        float averageRating = 0.0f;
        if (countRating > 0) {
            averageRating = (float)sumRating / (float)countRating;
        }
        return averageRating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RatingDO getRatingDO(ResourceImpl resourceImpl, String userID) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        PreparedStatement ps = null;
        ResultSet result = null;
        RatingDO ratingDO = new RatingDO();
        try {
            String sql = "SELECT R.REG_ID, R.REG_RATING, R.REG_RATED_TIME FROM REG_RATING R, REG_RESOURCE_RATING RR WHERE RR.REG_VERSION=? AND RR.REG_RATING_ID=R.REG_ID AND R.REG_USER_ID=? AND R.REG_TENANT_ID=? AND RR.REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setLong(1, resourceImpl.getVersionNumber());
            ps.setString(2, userID);
            ps.setInt(3, CurrentSession.getTenantId());
            ps.setInt(4, CurrentSession.getTenantId());
            result = ps.executeQuery();
            if (result.next()) {
                ratingDO.setRating(result.getInt("REG_RATING"));
                ratingDO.setRatedTime(new java.util.Date(result.getTimestamp("REG_RATED_TIME").getTime()));
                ratingDO.setRatedUserName(userID);
                ratingDO.setRatingID(result.getInt("REG_ID"));
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get rating on resource " + resourceImpl.getPath() + " done by user " + userID + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return ratingDO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RatingDO[] getResourceRatingDO(ResourceImpl resourceImpl) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        PreparedStatement ps = null;
        ResultSet result = null;
        ArrayList<RatingDO> ratingDOs = new ArrayList<RatingDO>();
        try {
            String sql = "SELECT R.REG_ID, R.REG_RATING, R.REG_USER_ID, R.REG_RATED_TIME FROM REG_RATING R, REG_RESOURCE_RATING RR WHERE RR.REG_VERSION=? AND RR.REG_RATING_ID=R.REG_ID AND R.REG_TENANT_ID=? AND RR.REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setLong(1, resourceImpl.getVersionNumber());
            ps.setInt(2, CurrentSession.getTenantId());
            ps.setInt(3, CurrentSession.getTenantId());
            result = ps.executeQuery();
            while (result.next()) {
                RatingDO ratingDO = new RatingDO();
                ratingDO.setRating(result.getInt("REG_RATING"));
                ratingDO.setRatedTime(new java.util.Date(result.getTimestamp("REG_RATED_TIME").getTime()));
                ratingDO.setRatedUserName(result.getString("REG_USER_ID"));
                ratingDO.setRatingID(result.getInt("REG_ID"));
                ratingDOs.add(ratingDO);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to get rating on resource " + resourceImpl.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        return ratingDOs.toArray(new RatingDO[ratingDOs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getRatedUserNames(ResourceImpl resourceImpl) throws RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        ArrayList<String> userIDList = new ArrayList<String>();
        PreparedStatement ps = null;
        ResultSet results = null;
        try {
            String sql = "SELECT R.REG_USER_ID FROM REG_RATING R, REG_RESOURCE_RATING RR WHERE RR.REG_VERSION=? AND RR.REG_RATING_ID=R.REG_ID AND R.REG_TENANT_ID=? AND RR.REG_TENANT_ID=?";
            ps = conn.prepareStatement(sql);
            ps.setLong(1, resourceImpl.getVersionNumber());
            ps.setInt(2, CurrentSession.getTenantId());
            ps.setInt(3, CurrentSession.getTenantId());
            results = ps.executeQuery();
            while (results.next()) {
                String ratedUserID = results.getString("REG_USER_ID");
                userIDList.add(ratedUserID);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to users who have rated the resource " + resourceImpl.getPath() + ". " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                String msg = "A SQLException error has occurred when trying to close result set or prepared statement";
                log.error((Object)msg, (Throwable)ex);
            }
        }
        String[] userIDs = new String[userIDList.size()];
        for (int i = 0; i < userIDs.length; ++i) {
            userIDs[i] = (String)userIDList.get(i);
        }
        return userIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RatingDO getRating(long ratingID) throws SQLException, RegistryException {
        JDBCDatabaseTransaction.ManagedRegistryConnection conn = JDBCDatabaseTransaction.getConnection();
        String sql = "SELECT RR.REG_VERSION, R.REG_USER_ID, R.REG_RATING, R.REG_RATED_TIME FROM REG_RATING R, REG_RESOURCE_RATING RR WHERE R.REG_ID =? AND R.REG_ID = RR.REG_RATING_ID AND R.REG_TENANT_ID=? AND RR.REG_TENANT_ID=?";
        PreparedStatement s = conn.prepareStatement(sql);
        try {
            s.setLong(1, ratingID);
            s.setInt(2, CurrentSession.getTenantId());
            s.setInt(3, CurrentSession.getTenantId());
            ResultSet results = s.executeQuery();
            try {
                if (results.next()) {
                    java.util.Date ratedTime = new java.util.Date(results.getTimestamp("REG_RATED_TIME").getTime());
                    RatingDO ratingDAO = new RatingDO();
                    ratingDAO.setRatedUserName(results.getString("REG_USER_ID"));
                    ratingDAO.setRatedTime(ratedTime);
                    ratingDAO.setRating(results.getInt("REG_RATING"));
                    String resourcePath = null;
                    long version = results.getLong("REG_VERSION");
                    if (version > 0L) {
                        resourcePath = this.resourceDAO.getPath(version);
                    }
                    if (resourcePath != null) {
                        ratingDAO.setResourcePath(resourcePath);
                    }
                    RatingDO ratingDO = ratingDAO;
                    return ratingDO;
                }
            }
            finally {
                if (results != null) {
                    results.close();
                }
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        return null;
    }

    @Override
    public ResourceImpl getResourceWithMinimumData(String path) throws RegistryException {
        return RegistryUtils.getResourceWithMinimumData(path, this.resourceDAO, true);
    }

    @Override
    public void moveRatings(ResourceIDImpl source, ResourceIDImpl target) throws RegistryException {
    }

    @Override
    public void moveRatingPaths(ResourceIDImpl source, ResourceIDImpl target) throws RegistryException {
    }
}

