/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.AppType;
import com.amazonaws.services.opsworks.model.DataSource;
import com.amazonaws.services.opsworks.model.EnvironmentVariable;
import com.amazonaws.services.opsworks.model.Source;
import com.amazonaws.services.opsworks.model.SslConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateAppRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String stackId;
    private String shortname;
    private String name;
    private String description;
    private ListWithAutoConstructFlag<DataSource> dataSources;
    private String type;
    private Source appSource;
    private ListWithAutoConstructFlag<String> domains;
    private Boolean enableSsl;
    private SslConfiguration sslConfiguration;
    private Map<String, String> attributes;
    private ListWithAutoConstructFlag<EnvironmentVariable> environment;

    public String getStackId() {
        return this.stackId;
    }

    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    public CreateAppRequest withStackId(String stackId) {
        this.stackId = stackId;
        return this;
    }

    public String getShortname() {
        return this.shortname;
    }

    public void setShortname(String shortname) {
        this.shortname = shortname;
    }

    public CreateAppRequest withShortname(String shortname) {
        this.shortname = shortname;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateAppRequest withName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateAppRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<DataSource> getDataSources() {
        if (this.dataSources == null) {
            this.dataSources = new ListWithAutoConstructFlag();
            this.dataSources.setAutoConstruct(true);
        }
        return this.dataSources;
    }

    public void setDataSources(Collection<DataSource> dataSources) {
        if (dataSources == null) {
            this.dataSources = null;
            return;
        }
        ListWithAutoConstructFlag dataSourcesCopy = new ListWithAutoConstructFlag(dataSources.size());
        dataSourcesCopy.addAll(dataSources);
        this.dataSources = dataSourcesCopy;
    }

    public CreateAppRequest withDataSources(DataSource ... dataSources) {
        if (this.getDataSources() == null) {
            this.setDataSources(new ArrayList<DataSource>(dataSources.length));
        }
        for (DataSource value : dataSources) {
            this.getDataSources().add(value);
        }
        return this;
    }

    public CreateAppRequest withDataSources(Collection<DataSource> dataSources) {
        if (dataSources == null) {
            this.dataSources = null;
        } else {
            ListWithAutoConstructFlag dataSourcesCopy = new ListWithAutoConstructFlag(dataSources.size());
            dataSourcesCopy.addAll(dataSources);
            this.dataSources = dataSourcesCopy;
        }
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public CreateAppRequest withType(String type) {
        this.type = type;
        return this;
    }

    public void setType(AppType type) {
        this.type = type.toString();
    }

    public CreateAppRequest withType(AppType type) {
        this.type = type.toString();
        return this;
    }

    public Source getAppSource() {
        return this.appSource;
    }

    public void setAppSource(Source appSource) {
        this.appSource = appSource;
    }

    public CreateAppRequest withAppSource(Source appSource) {
        this.appSource = appSource;
        return this;
    }

    public List<String> getDomains() {
        if (this.domains == null) {
            this.domains = new ListWithAutoConstructFlag();
            this.domains.setAutoConstruct(true);
        }
        return this.domains;
    }

    public void setDomains(Collection<String> domains) {
        if (domains == null) {
            this.domains = null;
            return;
        }
        ListWithAutoConstructFlag domainsCopy = new ListWithAutoConstructFlag(domains.size());
        domainsCopy.addAll(domains);
        this.domains = domainsCopy;
    }

    public CreateAppRequest withDomains(String ... domains) {
        if (this.getDomains() == null) {
            this.setDomains(new ArrayList<String>(domains.length));
        }
        for (String value : domains) {
            this.getDomains().add(value);
        }
        return this;
    }

    public CreateAppRequest withDomains(Collection<String> domains) {
        if (domains == null) {
            this.domains = null;
        } else {
            ListWithAutoConstructFlag domainsCopy = new ListWithAutoConstructFlag(domains.size());
            domainsCopy.addAll(domains);
            this.domains = domainsCopy;
        }
        return this;
    }

    public Boolean isEnableSsl() {
        return this.enableSsl;
    }

    public void setEnableSsl(Boolean enableSsl) {
        this.enableSsl = enableSsl;
    }

    public CreateAppRequest withEnableSsl(Boolean enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    public Boolean getEnableSsl() {
        return this.enableSsl;
    }

    public SslConfiguration getSslConfiguration() {
        return this.sslConfiguration;
    }

    public void setSslConfiguration(SslConfiguration sslConfiguration) {
        this.sslConfiguration = sslConfiguration;
    }

    public CreateAppRequest withSslConfiguration(SslConfiguration sslConfiguration) {
        this.sslConfiguration = sslConfiguration;
        return this;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public CreateAppRequest withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public CreateAppRequest addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public CreateAppRequest clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public List<EnvironmentVariable> getEnvironment() {
        if (this.environment == null) {
            this.environment = new ListWithAutoConstructFlag();
            this.environment.setAutoConstruct(true);
        }
        return this.environment;
    }

    public void setEnvironment(Collection<EnvironmentVariable> environment) {
        if (environment == null) {
            this.environment = null;
            return;
        }
        ListWithAutoConstructFlag environmentCopy = new ListWithAutoConstructFlag(environment.size());
        environmentCopy.addAll(environment);
        this.environment = environmentCopy;
    }

    public CreateAppRequest withEnvironment(EnvironmentVariable ... environment) {
        if (this.getEnvironment() == null) {
            this.setEnvironment(new ArrayList<EnvironmentVariable>(environment.length));
        }
        for (EnvironmentVariable value : environment) {
            this.getEnvironment().add(value);
        }
        return this;
    }

    public CreateAppRequest withEnvironment(Collection<EnvironmentVariable> environment) {
        if (environment == null) {
            this.environment = null;
        } else {
            ListWithAutoConstructFlag environmentCopy = new ListWithAutoConstructFlag(environment.size());
            environmentCopy.addAll(environment);
            this.environment = environmentCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackId() != null) {
            sb.append("StackId: " + this.getStackId() + ",");
        }
        if (this.getShortname() != null) {
            sb.append("Shortname: " + this.getShortname() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getDataSources() != null) {
            sb.append("DataSources: " + this.getDataSources() + ",");
        }
        if (this.getType() != null) {
            sb.append("Type: " + this.getType() + ",");
        }
        if (this.getAppSource() != null) {
            sb.append("AppSource: " + this.getAppSource() + ",");
        }
        if (this.getDomains() != null) {
            sb.append("Domains: " + this.getDomains() + ",");
        }
        if (this.isEnableSsl() != null) {
            sb.append("EnableSsl: " + this.isEnableSsl() + ",");
        }
        if (this.getSslConfiguration() != null) {
            sb.append("SslConfiguration: " + this.getSslConfiguration() + ",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: " + this.getAttributes() + ",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: " + this.getEnvironment());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackId() == null ? 0 : this.getStackId().hashCode());
        hashCode = 31 * hashCode + (this.getShortname() == null ? 0 : this.getShortname().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDataSources() == null ? 0 : this.getDataSources().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getAppSource() == null ? 0 : this.getAppSource().hashCode());
        hashCode = 31 * hashCode + (this.getDomains() == null ? 0 : this.getDomains().hashCode());
        hashCode = 31 * hashCode + (this.isEnableSsl() == null ? 0 : this.isEnableSsl().hashCode());
        hashCode = 31 * hashCode + (this.getSslConfiguration() == null ? 0 : this.getSslConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppRequest)) {
            return false;
        }
        CreateAppRequest other = (CreateAppRequest)obj;
        if (other.getStackId() == null ^ this.getStackId() == null) {
            return false;
        }
        if (other.getStackId() != null && !other.getStackId().equals(this.getStackId())) {
            return false;
        }
        if (other.getShortname() == null ^ this.getShortname() == null) {
            return false;
        }
        if (other.getShortname() != null && !other.getShortname().equals(this.getShortname())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDataSources() == null ^ this.getDataSources() == null) {
            return false;
        }
        if (other.getDataSources() != null && !other.getDataSources().equals(this.getDataSources())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getAppSource() == null ^ this.getAppSource() == null) {
            return false;
        }
        if (other.getAppSource() != null && !other.getAppSource().equals(this.getAppSource())) {
            return false;
        }
        if (other.getDomains() == null ^ this.getDomains() == null) {
            return false;
        }
        if (other.getDomains() != null && !other.getDomains().equals(this.getDomains())) {
            return false;
        }
        if (other.isEnableSsl() == null ^ this.isEnableSsl() == null) {
            return false;
        }
        if (other.isEnableSsl() != null && !other.isEnableSsl().equals(this.isEnableSsl())) {
            return false;
        }
        if (other.getSslConfiguration() == null ^ this.getSslConfiguration() == null) {
            return false;
        }
        if (other.getSslConfiguration() != null && !other.getSslConfiguration().equals(this.getSslConfiguration())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        return other.getEnvironment() == null || other.getEnvironment().equals(this.getEnvironment());
    }
}

