/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.KeyBasedClientRequest;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.map.operation.RemoveIfSameOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class MapRemoveIfSameRequest
extends KeyBasedClientRequest
implements Portable {
    protected String name;
    protected Data key;
    protected Data value;
    protected int threadId;

    public MapRemoveIfSameRequest() {
    }

    public MapRemoveIfSameRequest(String name, Data key, Data value, int threadId) {
        this.name = name;
        this.key = key;
        this.value = value;
        this.threadId = threadId;
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 10;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    protected Operation prepareOperation() {
        RemoveIfSameOperation op = new RemoveIfSameOperation(this.name, this.key, this.value);
        op.setThreadId(this.threadId);
        return op;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeInt("t", this.threadId);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.key.writeData(out);
        this.value.writeData(out);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.threadId = reader.readInt("t");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = new Data();
        this.key.readData(in);
        this.value = new Data();
        this.value.readData(in);
    }
}

