/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.support;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.store.jdbc.JdbcDirectorySettings;
import org.apache.lucene.store.jdbc.JdbcStoreException;
import org.apache.lucene.store.jdbc.datasource.DataSourceUtils;

public class JdbcTemplate {
    private static final Log log = LogFactory.getLog(JdbcTemplate.class);
    private DataSource dataSource;
    private JdbcDirectorySettings settings;

    public JdbcTemplate(DataSource dataSource, JdbcDirectorySettings settings) {
        this.dataSource = dataSource;
        this.settings = settings;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object executeSelect(String sql, ExecuteSelectCallback callback) throws JdbcStoreException {
        Object object;
        Connection con = DataSourceUtils.getConnection(this.dataSource);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement(sql);
            callback.fillPrepareStatement(ps);
            rs = ps.executeQuery();
            object = callback.execute(rs);
        }
        catch (JdbcStoreException e) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Failed to execute sql [" + sql + "]"), (Throwable)e);
                }
                throw e;
                catch (Exception e2) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Failed to execute sql [" + sql + "]"), (Throwable)e2);
                    }
                    throw new JdbcStoreException("Failed to execute sql [" + sql + "]", e2);
                }
            }
            catch (Throwable throwable) {
                DataSourceUtils.closeResultSet(rs);
                DataSourceUtils.closeStatement(ps);
                DataSourceUtils.releaseConnection(con);
                throw throwable;
            }
        }
        DataSourceUtils.closeResultSet(rs);
        DataSourceUtils.closeStatement(ps);
        DataSourceUtils.releaseConnection(con);
        return object;
    }

    public Object executeCallable(String sql, CallableStatementCallback callback) throws JdbcStoreException {
        Connection con = DataSourceUtils.getConnection(this.dataSource);
        CallableStatement cs = null;
        try {
            cs = con.prepareCall(sql);
            callback.fillCallableStatement(cs);
            cs.execute();
            Object object = callback.readCallableData(cs);
            return object;
        }
        catch (JdbcStoreException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Failed to execute sql [" + sql + "]"), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Failed to execute sql [" + sql + "]"), (Throwable)e);
            }
            throw new JdbcStoreException("Failed to execute sql [" + sql + "]", e);
        }
        finally {
            DataSourceUtils.closeStatement(cs);
            DataSourceUtils.releaseConnection(con);
        }
    }

    public void executeUpdate(String sql, PrepateStatementAwareCallback callback) throws JdbcStoreException {
        Connection con = DataSourceUtils.getConnection(this.dataSource);
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            callback.fillPrepareStatement(ps);
            ps.executeUpdate();
        }
        catch (JdbcStoreException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Failed to execute sql [" + sql + "]"), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Failed to execute sql [" + sql + "]"), (Throwable)e);
            }
            throw new JdbcStoreException("Failed to execute sql [" + sql + "]", e);
        }
        finally {
            DataSourceUtils.closeStatement(ps);
            DataSourceUtils.releaseConnection(con);
        }
    }

    public void executeUpdate(String sql) throws JdbcStoreException {
        Connection con = DataSourceUtils.getConnection(this.dataSource);
        Statement statement = null;
        try {
            statement = con.createStatement();
            statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Failed to execute sql [" + sql + "]"), (Throwable)e);
            }
            throw new JdbcStoreException("Failed to execute [" + sql + "]", e);
        }
        finally {
            DataSourceUtils.closeStatement(statement);
            DataSourceUtils.releaseConnection(con);
        }
    }

    public int[] executeBatch(String[] sqls) throws JdbcStoreException {
        Connection con = DataSourceUtils.getConnection(this.dataSource);
        Statement statement = null;
        try {
            statement = con.createStatement();
            for (String sql : sqls) {
                statement.addBatch(sql);
            }
            int[] nArray = statement.executeBatch();
            return nArray;
        }
        catch (SQLException sQLException) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Failed to execute sql [" + Arrays.toString(sqls) + "]"), (Throwable)sQLException);
            }
            throw new JdbcStoreException("Failed to execute [" + Arrays.toString(sqls) + "]", sQLException);
        }
        finally {
            DataSourceUtils.closeStatement(statement);
            DataSourceUtils.releaseConnection(con);
        }
    }

    public int[] executeBatch(String sql, PrepateStatementAwareCallback callback) throws JdbcStoreException {
        Connection con = DataSourceUtils.getConnection(this.dataSource);
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            callback.fillPrepareStatement(ps);
            int[] nArray = ps.executeBatch();
            return nArray;
        }
        catch (JdbcStoreException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Failed to execute sql [" + sql + "]"), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Failed to execute sql [" + sql + "]"), (Throwable)e);
            }
            throw new JdbcStoreException("Failed to execute sql [" + sql + "]", e);
        }
        finally {
            DataSourceUtils.closeStatement(ps);
            DataSourceUtils.releaseConnection(con);
        }
    }

    public static interface CallableStatementCallback {
        public void fillCallableStatement(CallableStatement var1) throws Exception;

        public Object readCallableData(CallableStatement var1) throws Exception;
    }

    public static interface ExecuteSelectCallback
    extends PrepateStatementAwareCallback {
        public Object execute(ResultSet var1) throws Exception;
    }

    public static interface PrepateStatementAwareCallback {
        public void fillPrepareStatement(PreparedStatement var1) throws Exception;
    }
}

