/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#ifndef status_models_TYPES_H
#define status_models_TYPES_H

#include <iosfwd>

#include <thrift/Thrift.h>
#include <thrift/TApplicationException.h>
#include <thrift/protocol/TProtocol.h>
#include <thrift/transport/TTransport.h>

#include <thrift/cxxfunctional.h>


namespace apache { namespace airavata { namespace model { namespace status {

struct ExperimentState {
  enum type {
    CREATED = 0,
    VALIDATED = 1,
    SCHEDULED = 2,
    LAUNCHED = 3,
    EXECUTING = 4,
    CANCELING = 5,
    CANCELED = 6,
    COMPLETED = 7,
    FAILED = 8
  };
};

extern const std::map<int, const char*> _ExperimentState_VALUES_TO_NAMES;

struct TaskState {
  enum type {
    CREATED = 0,
    EXECUTING = 1,
    COMPLETED = 2,
    FAILED = 3,
    CANCELED = 4
  };
};

extern const std::map<int, const char*> _TaskState_VALUES_TO_NAMES;

struct ProcessState {
  enum type {
    CREATED = 0,
    VALIDATED = 1,
    STARTED = 2,
    PRE_PROCESSING = 3,
    CONFIGURING_WORKSPACE = 4,
    INPUT_DATA_STAGING = 5,
    EXECUTING = 6,
    MONITORING = 7,
    OUTPUT_DATA_STAGING = 8,
    POST_PROCESSING = 9,
    COMPLETED = 10,
    FAILED = 11,
    CANCELLING = 12,
    CANCELED = 13
  };
};

extern const std::map<int, const char*> _ProcessState_VALUES_TO_NAMES;

struct JobState {
  enum type {
    SUBMITTED = 0,
    QUEUED = 1,
    ACTIVE = 2,
    COMPLETE = 3,
    CANCELED = 4,
    FAILED = 5,
    SUSPENDED = 6,
    UNKNOWN = 7
  };
};

extern const std::map<int, const char*> _JobState_VALUES_TO_NAMES;

class ExperimentStatus;

class ProcessStatus;

class TaskStatus;

class JobStatus;

class QueueStatusModel;

typedef struct _ExperimentStatus__isset {
  _ExperimentStatus__isset() : timeOfStateChange(false), reason(false) {}
  bool timeOfStateChange :1;
  bool reason :1;
} _ExperimentStatus__isset;

class ExperimentStatus {
 public:

  ExperimentStatus(const ExperimentStatus&);
  ExperimentStatus& operator=(const ExperimentStatus&);
  ExperimentStatus() : state((ExperimentState::type)0), timeOfStateChange(0), reason() {
  }

  virtual ~ExperimentStatus() throw();
  ExperimentState::type state;
  int64_t timeOfStateChange;
  std::string reason;

  _ExperimentStatus__isset __isset;

  void __set_state(const ExperimentState::type val);

  void __set_timeOfStateChange(const int64_t val);

  void __set_reason(const std::string& val);

  bool operator == (const ExperimentStatus & rhs) const
  {
    if (!(state == rhs.state))
      return false;
    if (__isset.timeOfStateChange != rhs.__isset.timeOfStateChange)
      return false;
    else if (__isset.timeOfStateChange && !(timeOfStateChange == rhs.timeOfStateChange))
      return false;
    if (__isset.reason != rhs.__isset.reason)
      return false;
    else if (__isset.reason && !(reason == rhs.reason))
      return false;
    return true;
  }
  bool operator != (const ExperimentStatus &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const ExperimentStatus & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(ExperimentStatus &a, ExperimentStatus &b);

inline std::ostream& operator<<(std::ostream& out, const ExperimentStatus& obj)
{
  obj.printTo(out);
  return out;
}

typedef struct _ProcessStatus__isset {
  _ProcessStatus__isset() : timeOfStateChange(false), reason(false) {}
  bool timeOfStateChange :1;
  bool reason :1;
} _ProcessStatus__isset;

class ProcessStatus {
 public:

  ProcessStatus(const ProcessStatus&);
  ProcessStatus& operator=(const ProcessStatus&);
  ProcessStatus() : state((ProcessState::type)0), timeOfStateChange(0), reason() {
  }

  virtual ~ProcessStatus() throw();
  ProcessState::type state;
  int64_t timeOfStateChange;
  std::string reason;

  _ProcessStatus__isset __isset;

  void __set_state(const ProcessState::type val);

  void __set_timeOfStateChange(const int64_t val);

  void __set_reason(const std::string& val);

  bool operator == (const ProcessStatus & rhs) const
  {
    if (!(state == rhs.state))
      return false;
    if (__isset.timeOfStateChange != rhs.__isset.timeOfStateChange)
      return false;
    else if (__isset.timeOfStateChange && !(timeOfStateChange == rhs.timeOfStateChange))
      return false;
    if (__isset.reason != rhs.__isset.reason)
      return false;
    else if (__isset.reason && !(reason == rhs.reason))
      return false;
    return true;
  }
  bool operator != (const ProcessStatus &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const ProcessStatus & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(ProcessStatus &a, ProcessStatus &b);

inline std::ostream& operator<<(std::ostream& out, const ProcessStatus& obj)
{
  obj.printTo(out);
  return out;
}

typedef struct _TaskStatus__isset {
  _TaskStatus__isset() : timeOfStateChange(false), reason(false) {}
  bool timeOfStateChange :1;
  bool reason :1;
} _TaskStatus__isset;

class TaskStatus {
 public:

  TaskStatus(const TaskStatus&);
  TaskStatus& operator=(const TaskStatus&);
  TaskStatus() : state((TaskState::type)0), timeOfStateChange(0), reason() {
  }

  virtual ~TaskStatus() throw();
  TaskState::type state;
  int64_t timeOfStateChange;
  std::string reason;

  _TaskStatus__isset __isset;

  void __set_state(const TaskState::type val);

  void __set_timeOfStateChange(const int64_t val);

  void __set_reason(const std::string& val);

  bool operator == (const TaskStatus & rhs) const
  {
    if (!(state == rhs.state))
      return false;
    if (__isset.timeOfStateChange != rhs.__isset.timeOfStateChange)
      return false;
    else if (__isset.timeOfStateChange && !(timeOfStateChange == rhs.timeOfStateChange))
      return false;
    if (__isset.reason != rhs.__isset.reason)
      return false;
    else if (__isset.reason && !(reason == rhs.reason))
      return false;
    return true;
  }
  bool operator != (const TaskStatus &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const TaskStatus & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(TaskStatus &a, TaskStatus &b);

inline std::ostream& operator<<(std::ostream& out, const TaskStatus& obj)
{
  obj.printTo(out);
  return out;
}

typedef struct _JobStatus__isset {
  _JobStatus__isset() : timeOfStateChange(false), reason(false) {}
  bool timeOfStateChange :1;
  bool reason :1;
} _JobStatus__isset;

class JobStatus {
 public:

  JobStatus(const JobStatus&);
  JobStatus& operator=(const JobStatus&);
  JobStatus() : jobState((JobState::type)0), timeOfStateChange(0), reason() {
  }

  virtual ~JobStatus() throw();
  JobState::type jobState;
  int64_t timeOfStateChange;
  std::string reason;

  _JobStatus__isset __isset;

  void __set_jobState(const JobState::type val);

  void __set_timeOfStateChange(const int64_t val);

  void __set_reason(const std::string& val);

  bool operator == (const JobStatus & rhs) const
  {
    if (!(jobState == rhs.jobState))
      return false;
    if (__isset.timeOfStateChange != rhs.__isset.timeOfStateChange)
      return false;
    else if (__isset.timeOfStateChange && !(timeOfStateChange == rhs.timeOfStateChange))
      return false;
    if (__isset.reason != rhs.__isset.reason)
      return false;
    else if (__isset.reason && !(reason == rhs.reason))
      return false;
    return true;
  }
  bool operator != (const JobStatus &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const JobStatus & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(JobStatus &a, JobStatus &b);

inline std::ostream& operator<<(std::ostream& out, const JobStatus& obj)
{
  obj.printTo(out);
  return out;
}


class QueueStatusModel {
 public:

  QueueStatusModel(const QueueStatusModel&);
  QueueStatusModel& operator=(const QueueStatusModel&);
  QueueStatusModel() : hostName(), queueName(), queueUp(0), runningJobs(0), queuedJobs(0), time(0) {
  }

  virtual ~QueueStatusModel() throw();
  std::string hostName;
  std::string queueName;
  bool queueUp;
  int32_t runningJobs;
  int32_t queuedJobs;
  int64_t time;

  void __set_hostName(const std::string& val);

  void __set_queueName(const std::string& val);

  void __set_queueUp(const bool val);

  void __set_runningJobs(const int32_t val);

  void __set_queuedJobs(const int32_t val);

  void __set_time(const int64_t val);

  bool operator == (const QueueStatusModel & rhs) const
  {
    if (!(hostName == rhs.hostName))
      return false;
    if (!(queueName == rhs.queueName))
      return false;
    if (!(queueUp == rhs.queueUp))
      return false;
    if (!(runningJobs == rhs.runningJobs))
      return false;
    if (!(queuedJobs == rhs.queuedJobs))
      return false;
    if (!(time == rhs.time))
      return false;
    return true;
  }
  bool operator != (const QueueStatusModel &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const QueueStatusModel & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

  virtual void printTo(std::ostream& out) const;
};

void swap(QueueStatusModel &a, QueueStatusModel &b);

inline std::ostream& operator<<(std::ostream& out, const QueueStatusModel& obj)
{
  obj.printTo(out);
  return out;
}

}}}} // namespace

#endif
