/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper;

import java.util.ArrayList;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.ConversionException;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreMessageWrapper;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.MessageEOFException;
import org.apache.activemq.artemis.reader.StreamMessageUtil;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;

public final class CoreStreamMessageWrapper
extends CoreMessageWrapper {
    public static final byte TYPE = 6;
    private int bodyLength = 0;
    private int len = 0;

    public CoreStreamMessageWrapper(ICoreMessage message) {
        super(message);
    }

    @Override
    public Section createAMQPSection(Map<Symbol, Object> maMap, Properties properties) throws ConversionException {
        maMap.put(AMQPMessageSupport.JMS_MSG_TYPE, (byte)4);
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            while (true) {
                list.add(this.readObject());
            }
        }
        catch (MessageEOFException messageEOFException) {
            return switch (this.getOrignalEncoding()) {
                case 3 -> new AmqpSequence(list);
                default -> new AmqpValue(list);
            };
        }
    }

    public boolean readBoolean() throws MessageEOFException, ConversionException {
        try {
            return StreamMessageUtil.streamReadBoolean((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new ConversionException(e.getMessage(), e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException();
        }
    }

    public byte readByte() throws MessageEOFException, ConversionException {
        try {
            return StreamMessageUtil.streamReadByte((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new ConversionException(e.getMessage(), e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException();
        }
    }

    public short readShort() throws MessageEOFException, ConversionException {
        try {
            return StreamMessageUtil.streamReadShort((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new ConversionException(e.getMessage(), e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException();
        }
    }

    public char readChar() throws MessageEOFException, ConversionException {
        try {
            return StreamMessageUtil.streamReadChar((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new ConversionException(e.getMessage(), e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException();
        }
    }

    public int readInt() throws MessageEOFException, ConversionException {
        try {
            return StreamMessageUtil.streamReadInteger((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new ConversionException(e.getMessage(), e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException();
        }
    }

    public long readLong() throws ConversionException, MessageEOFException {
        try {
            return StreamMessageUtil.streamReadLong((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new ConversionException(e.getMessage(), e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException();
        }
    }

    public float readFloat() throws ConversionException, MessageEOFException {
        try {
            return StreamMessageUtil.streamReadFloat((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new ConversionException(e.getMessage(), e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException();
        }
    }

    public double readDouble() throws ConversionException, MessageEOFException {
        try {
            return StreamMessageUtil.streamReadDouble((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new ConversionException(e.getMessage(), e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException();
        }
    }

    public String readString() throws ConversionException, MessageEOFException {
        try {
            return StreamMessageUtil.streamReadString((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new ConversionException(e.getMessage(), e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException();
        }
    }

    public int readBytes(byte[] value) throws ConversionException, MessageEOFException {
        try {
            Pair pairRead = StreamMessageUtil.streamReadBytes((ActiveMQBuffer)this.getReadBodyBuffer(), (int)this.len, (byte[])value);
            this.len = (Integer)pairRead.getA();
            return (Integer)pairRead.getB();
        }
        catch (IllegalStateException e) {
            throw new ConversionException(e.getMessage(), e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException();
        }
    }

    public Object readObject() throws ConversionException, MessageEOFException {
        if (this.getReadBodyBuffer().readerIndex() >= this.getReadBodyBuffer().writerIndex()) {
            throw new MessageEOFException();
        }
        try {
            return StreamMessageUtil.streamReadObject((ActiveMQBuffer)this.getReadBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new ConversionException(e.getMessage(), e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException();
        }
    }

    public void writeBoolean(boolean value) {
        this.getWriteBodyBuffer().writeByte((byte)2);
        this.getWriteBodyBuffer().writeBoolean(value);
    }

    public void writeByte(byte value) {
        this.getWriteBodyBuffer().writeByte((byte)3);
        this.getWriteBodyBuffer().writeByte(value);
    }

    public void writeShort(short value) {
        this.getWriteBodyBuffer().writeByte((byte)5);
        this.getWriteBodyBuffer().writeShort(value);
    }

    public void writeChar(char value) {
        this.getWriteBodyBuffer().writeByte((byte)11);
        this.getWriteBodyBuffer().writeShort((short)value);
    }

    public void writeInt(int value) {
        this.getWriteBodyBuffer().writeByte((byte)6);
        this.getWriteBodyBuffer().writeInt(value);
    }

    public void writeLong(long value) {
        this.getWriteBodyBuffer().writeByte((byte)7);
        this.getWriteBodyBuffer().writeLong(value);
    }

    public void writeFloat(float value) {
        this.getWriteBodyBuffer().writeByte((byte)8);
        this.getWriteBodyBuffer().writeInt(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) {
        this.getWriteBodyBuffer().writeByte((byte)9);
        this.getWriteBodyBuffer().writeLong(Double.doubleToLongBits(value));
    }

    public void writeString(String value) {
        this.getWriteBodyBuffer().writeByte((byte)10);
        this.getWriteBodyBuffer().writeNullableString(value);
    }

    public void writeBytes(byte[] value) {
        this.getWriteBodyBuffer().writeByte((byte)4);
        this.getWriteBodyBuffer().writeInt(value.length);
        this.getWriteBodyBuffer().writeBytes(value);
    }

    public void writeBytes(byte[] value, int offset, int length) {
        this.getWriteBodyBuffer().writeByte((byte)4);
        this.getWriteBodyBuffer().writeInt(length);
        this.getWriteBodyBuffer().writeBytes(value, offset, length);
    }

    public void writeObject(Object value) throws ConversionException {
        if (value instanceof String) {
            String string = (String)value;
            this.writeString(string);
        } else if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            this.writeBoolean(booleanValue);
        } else if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            this.writeByte(byteValue);
        } else if (value instanceof Short) {
            Short shortValue = (Short)value;
            this.writeShort(shortValue);
        } else if (value instanceof Integer) {
            Integer integer = (Integer)value;
            this.writeInt(integer);
        } else if (value instanceof Long) {
            Long longValue = (Long)value;
            this.writeLong(longValue);
        } else if (value instanceof Float) {
            Float floatValue = (Float)value;
            this.writeFloat(floatValue.floatValue());
        } else if (value instanceof Double) {
            Double doubleValue = (Double)value;
            this.writeDouble(doubleValue);
        } else if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            this.writeBytes(bytes);
        } else if (value instanceof Character) {
            Character character = (Character)value;
            this.writeChar(character.charValue());
        } else if (value == null) {
            this.writeString(null);
        } else {
            throw new ConversionException("Invalid object type: " + String.valueOf(value.getClass()));
        }
    }

    public void reset() {
        this.getWriteBodyBuffer().resetReaderIndex();
    }

    @Override
    public void clearBody() {
        super.clearBody();
        this.getWriteBodyBuffer().clear();
    }

    @Override
    public void decode() {
        super.decode();
    }

    @Override
    public void encode() {
        super.encode();
        this.bodyLength = this.message.getEndOfBodyPosition();
    }
}

