/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBindingPlugin;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManagementSupport;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgePolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiver;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiverConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQPBridgeFromPolicyManager
extends AMQPBridgePolicyManager
implements ActiveMQServerBindingPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected volatile AMQPBridgeReceiverConfiguration configuration;

    public AMQPBridgeFromPolicyManager(AMQPBridgeManager bridge, AMQPBridgeMetrics metrics, String policyName, AMQPBridgeType policyType) {
        super(bridge, metrics, policyName, policyType);
    }

    @Override
    protected void handleManagerInitialized() {
        this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)this);
        try {
            AMQPBridgeManagementSupport.registerBridgePolicyManager(this);
        }
        catch (Exception e) {
            logger.trace("Error while attempting to add receiver policy control to management", (Throwable)e);
        }
    }

    @Override
    protected void handleManagerStarted() {
        if (this.isActive()) {
            this.scanManagedResources();
        }
    }

    @Override
    protected void handleManagerStopped() {
        this.safeCleanupManagerResources(false);
    }

    @Override
    protected void handleManagerShutdown() {
        this.server.unRegisterBrokerPlugin((ActiveMQServerBasePlugin)this);
        try {
            AMQPBridgeManagementSupport.unregisterBridgePolicyManager(this);
        }
        catch (Exception e) {
            logger.trace("Error while attempting to remove receiver policy control from management", (Throwable)e);
        }
        this.safeCleanupManagerResources(false);
    }

    @Override
    protected void handleConnectionInterrupted() {
        this.safeCleanupManagerResources(true);
    }

    @Override
    protected void handleConnectionRestored(AMQPBridgeConfiguration configuration) {
        this.configuration = new AMQPBridgeReceiverConfiguration(configuration, this.getPolicy().getProperties());
        if (this.isActive()) {
            this.scanManagedResources();
        }
    }

    protected abstract void scanManagedResources();

    protected abstract void safeCleanupManagerResources(boolean var1);

    protected synchronized void tryCloseBridgeReceiver(AMQPBridgeReceiver bridgeReceiver) {
        if (bridgeReceiver != null) {
            try {
                if (!bridgeReceiver.isClosed()) {
                    bridgeReceiver.close();
                }
            }
            catch (Exception ignore) {
                logger.trace("Caught error on attempted close of existing bridge receiver", (Throwable)ignore);
            }
        }
    }
}

