/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoopImpl.mapreduce;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.hadoop.mapreduce.InputFormatBuilder;
import org.apache.accumulo.hadoopImpl.mapreduce.InputTableConfig;
import org.apache.accumulo.hadoopImpl.mapreduce.lib.InputConfigurator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;

public class InputFormatBuilderImpl<T>
implements InputFormatBuilder,
InputFormatBuilder.ClientParams<T>,
InputFormatBuilder.TableParams<T>,
InputFormatBuilder.InputFormatOptions<T> {
    private Class<?> callingClass;
    private Properties clientProps;
    private String clientPropsPath;
    private String currentTable;
    private Map<String, InputTableConfig> tableConfigMap = Collections.emptyMap();

    public InputFormatBuilderImpl(Class<?> callingClass) {
        this.callingClass = callingClass;
    }

    @Override
    public InputFormatBuilder.TableParams<T> clientProperties(Properties clientProperties) {
        this.clientProps = Objects.requireNonNull(clientProperties, "clientProperties must not be null");
        return this;
    }

    @Override
    public InputFormatBuilder.TableParams<T> clientPropertiesPath(String clientPropsPath) {
        this.clientPropsPath = Objects.requireNonNull(clientPropsPath, "clientPropsPath must not be null");
        return this;
    }

    @Override
    public InputFormatBuilder.InputFormatOptions<T> table(String tableName) {
        this.currentTable = Objects.requireNonNull(tableName, "Table name must not be null");
        if (this.tableConfigMap.isEmpty()) {
            this.tableConfigMap = new LinkedHashMap<String, InputTableConfig>();
        }
        this.tableConfigMap.put(this.currentTable, new InputTableConfig());
        return this;
    }

    @Override
    public InputFormatBuilder.InputFormatOptions<T> auths(Authorizations auths) {
        this.tableConfigMap.get(this.currentTable).setScanAuths(Objects.requireNonNull(auths, "Authorizations must not be null"));
        return this;
    }

    @Override
    public InputFormatBuilder.InputFormatOptions<T> classLoaderContext(String context) {
        this.tableConfigMap.get(this.currentTable).setContext(context);
        return this;
    }

    @Override
    public InputFormatBuilder.InputFormatOptions<T> ranges(Collection<Range> ranges) {
        List<Range> newRanges = List.copyOf(Objects.requireNonNull(ranges, "Collection of ranges is null"));
        if (newRanges.isEmpty()) {
            throw new IllegalArgumentException("Specified collection of ranges is empty.");
        }
        this.tableConfigMap.get(this.currentTable).setRanges(newRanges);
        return this;
    }

    @Override
    public InputFormatBuilder.InputFormatOptions<T> fetchColumns(Collection<IteratorSetting.Column> fetchColumns) {
        List<IteratorSetting.Column> newFetchColumns = List.copyOf(Objects.requireNonNull(fetchColumns, "Collection of fetch columns is null"));
        if (newFetchColumns.isEmpty()) {
            throw new IllegalArgumentException("Specified collection of fetch columns is empty.");
        }
        this.tableConfigMap.get(this.currentTable).fetchColumns(newFetchColumns);
        return this;
    }

    @Override
    public InputFormatBuilder.InputFormatOptions<T> addIterator(IteratorSetting cfg) {
        Objects.requireNonNull(cfg, "IteratorSetting must not be null.");
        this.tableConfigMap.get(this.currentTable).addIterator(cfg);
        return this;
    }

    @Override
    public InputFormatBuilder.InputFormatOptions<T> executionHints(Map<String, String> hints) {
        Map<String, String> newHints = Map.copyOf(Objects.requireNonNull(hints, "Map of execution hints must not be null."));
        if (newHints.isEmpty()) {
            throw new IllegalArgumentException("Specified map of execution hints is empty.");
        }
        this.tableConfigMap.get(this.currentTable).setExecutionHints(newHints);
        return this;
    }

    @Override
    public InputFormatBuilder.InputFormatOptions<T> samplerConfiguration(SamplerConfiguration samplerConfig) {
        this.tableConfigMap.get(this.currentTable).setSamplerConfiguration(samplerConfig);
        return this;
    }

    @Override
    public InputFormatBuilder.InputFormatOptions<T> autoAdjustRanges(boolean value) {
        this.tableConfigMap.get(this.currentTable).setAutoAdjustRanges(value);
        return this;
    }

    @Override
    public InputFormatBuilder.InputFormatOptions<T> scanIsolation(boolean value) {
        this.tableConfigMap.get(this.currentTable).setUseIsolatedScanners(value);
        return this;
    }

    @Override
    public InputFormatBuilder.InputFormatOptions<T> localIterators(boolean value) {
        this.tableConfigMap.get(this.currentTable).setUseLocalIterators(value);
        return this;
    }

    @Override
    public InputFormatBuilder.InputFormatOptions<T> offlineScan(boolean value) {
        this.tableConfigMap.get(this.currentTable).setOfflineScan(value);
        return this;
    }

    @Override
    public InputFormatBuilder.InputFormatOptions<T> batchScan(boolean value) {
        this.tableConfigMap.get(this.currentTable).setUseBatchScan(value);
        if (value) {
            this.tableConfigMap.get(this.currentTable).setAutoAdjustRanges(true);
        }
        return this;
    }

    @Override
    public InputFormatBuilder.InputFormatOptions<T> consistencyLevel(ScannerBase.ConsistencyLevel level) {
        this.tableConfigMap.get(this.currentTable).setConsistencyLevel(level);
        return this;
    }

    @Override
    public void store(T j) throws AccumuloException, AccumuloSecurityException {
        if (j instanceof Job) {
            this.store((Job)j);
        } else if (j instanceof JobConf) {
            this.store((JobConf)j);
        } else {
            throw new IllegalArgumentException("Unexpected type " + j.getClass().getName());
        }
    }

    @Override
    private void store(Job job) throws AccumuloException, AccumuloSecurityException {
        this._store(job.getConfiguration());
    }

    private void _store(Configuration conf) throws AccumuloException, AccumuloSecurityException {
        InputConfigurator.setClientProperties(this.callingClass, conf, this.clientProps, this.clientPropsPath);
        if (this.tableConfigMap.isEmpty()) {
            throw new IllegalArgumentException("At least one Table must be configured for job.");
        }
        if (this.tableConfigMap.size() == 1) {
            Map.Entry<String, InputTableConfig> entry = this.tableConfigMap.entrySet().iterator().next();
            InputConfigurator.setInputTableName(this.callingClass, conf, entry.getKey());
            InputTableConfig config = entry.getValue();
            if (!config.getScanAuths().isPresent()) {
                Properties props = InputConfigurator.getClientProperties(this.callingClass, conf);
                try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(props).build();){
                    String principal = ClientProperty.AUTH_PRINCIPAL.getValue(props);
                    config.setScanAuths(c.securityOperations().getUserAuthorizations(principal));
                }
            }
            InputConfigurator.setScanAuthorizations(this.callingClass, conf, config.getScanAuths().orElseThrow());
            if (config.getContext().isPresent()) {
                InputConfigurator.setClassLoaderContext(this.callingClass, conf, config.getContext().orElseThrow());
            }
            if (!config.getRanges().isEmpty()) {
                InputConfigurator.setRanges(this.callingClass, conf, config.getRanges());
            }
            if (!config.getIterators().isEmpty()) {
                InputConfigurator.writeIteratorsToConf(this.callingClass, conf, config.getIterators());
            }
            if (!config.getFetchedColumns().isEmpty()) {
                InputConfigurator.fetchColumns(this.callingClass, conf, config.getFetchedColumns());
            }
            if (config.getSamplerConfiguration() != null) {
                InputConfigurator.setSamplerConfiguration(this.callingClass, conf, config.getSamplerConfiguration());
            }
            if (!config.getExecutionHints().isEmpty()) {
                InputConfigurator.setExecutionHints(this.callingClass, conf, config.getExecutionHints());
            }
            InputConfigurator.setAutoAdjustRanges(this.callingClass, conf, config.shouldAutoAdjustRanges());
            InputConfigurator.setScanIsolation(this.callingClass, conf, config.shouldUseIsolatedScanners());
            InputConfigurator.setLocalIterators(this.callingClass, conf, config.shouldUseLocalIterators());
            InputConfigurator.setOfflineTableScan(this.callingClass, conf, config.isOfflineScan());
            InputConfigurator.setBatchScan(this.callingClass, conf, config.shouldBatchScan());
            if (config.getConsistencyLevel() != null) {
                InputConfigurator.setConsistencyLevel(this.callingClass, conf, config.getConsistencyLevel());
            }
        } else {
            InputConfigurator.setInputTableConfigs(this.callingClass, conf, this.tableConfigMap);
        }
        InputConfigurator.setJobStored(this.callingClass, conf);
    }

    @Override
    private void store(JobConf jobConf) throws AccumuloException, AccumuloSecurityException {
        this._store((Configuration)jobConf);
    }
}

