/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.fs;

import java.util.Objects;
import java.util.Optional;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;
import org.apache.accumulo.core.spi.fs.VolumeChooserEnvironment;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServiceEnvironmentImpl;
import org.apache.hadoop.io.Text;

public class VolumeChooserEnvironmentImpl
implements VolumeChooserEnvironment {
    private final VolumeChooserEnvironment.Scope scope;
    private final Optional<TableId> tableId;
    private final Text endRow;
    private final ServiceEnvironment senv;

    public VolumeChooserEnvironmentImpl(VolumeChooserEnvironment.Scope scope, ServerContext context) {
        this.scope = Objects.requireNonNull(scope);
        this.tableId = Optional.empty();
        this.endRow = null;
        this.senv = new ServiceEnvironmentImpl(context);
    }

    public VolumeChooserEnvironmentImpl(TableId tableId, Text endRow, ServerContext context) {
        this.scope = VolumeChooserEnvironment.Scope.TABLE;
        this.tableId = Optional.of(tableId);
        this.endRow = endRow;
        this.senv = new ServiceEnvironmentImpl(context);
    }

    public VolumeChooserEnvironmentImpl(VolumeChooserEnvironment.Scope scope, TableId tableId, Text endRow, ServerContext context) {
        this.scope = Objects.requireNonNull(scope);
        this.tableId = Optional.of(tableId);
        this.endRow = endRow;
        this.senv = new ServiceEnvironmentImpl(context);
    }

    public Text getEndRow() {
        if (this.scope != VolumeChooserEnvironment.Scope.TABLE && this.scope != VolumeChooserEnvironment.Scope.INIT) {
            throw new IllegalStateException("Can only request end row for tables, not for " + this.scope);
        }
        return this.endRow;
    }

    public Optional<TableId> getTable() {
        return this.tableId;
    }

    public VolumeChooserEnvironment.Scope getChooserScope() {
        return this.scope;
    }

    public ServiceEnvironment getServiceEnv() {
        return this.senv;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof VolumeChooserEnvironmentImpl)) {
            return false;
        }
        VolumeChooserEnvironmentImpl other = (VolumeChooserEnvironmentImpl)obj;
        return this.getChooserScope() == other.getChooserScope() && Objects.equals(this.tableId.orElseThrow(), other.getTable().orElseThrow());
    }

    public int hashCode() {
        return Objects.hashCode(this.scope) * 31 + Objects.hashCode(this.tableId);
    }
}

