/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.crypto;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.accumulo.core.crypto.CryptoEnvironmentImpl;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.spi.crypto.CryptoEnvironment;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.spi.crypto.FileDecrypter;
import org.apache.commons.io.IOUtils;

public class CryptoUtils {
    public static byte[] readParams(DataInputStream in) throws IOException {
        Objects.requireNonNull(in);
        int len = in.readInt();
        byte[] decryptionParams = new byte[len];
        IOUtils.readFully((InputStream)in, (byte[])decryptionParams);
        return decryptionParams;
    }

    public static FileDecrypter getFileDecrypter(CryptoService cs, CryptoEnvironment.Scope scope, TableId tableId, DataInputStream in) throws IOException {
        return cs.getFileDecrypter(CryptoUtils.getCryptoEnv(scope, tableId, in));
    }

    public static CryptoEnvironment getCryptoEnv(CryptoEnvironment.Scope scope, TableId tableId, DataInputStream in) throws IOException {
        byte[] decryptionParams = CryptoUtils.readParams(in);
        return new CryptoEnvironmentImpl(scope, tableId, decryptionParams);
    }

    public static void writeParams(byte[] decryptionParams, DataOutputStream out) throws IOException {
        Objects.requireNonNull(decryptionParams);
        Objects.requireNonNull(out);
        out.writeInt(decryptionParams.length);
        out.write(decryptionParams);
    }
}

