/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.logs;

import org.apache.accumulo.monitor.rest.logs.SingleLogEvent;

public class SanitizedLogEvent {
    public final long timestamp;
    public final String application;
    public final String logger;
    public final String level;
    public final String message;
    public final String stacktrace;
    public final int count;

    public SanitizedLogEvent(SingleLogEvent event, int count) {
        this.timestamp = event.timestamp;
        this.application = this.sanitize(event.application);
        this.logger = this.sanitize(event.logger);
        this.level = this.sanitize(event.level);
        String msg = this.sanitize(event.message);
        if (msg.length() > 300) {
            msg = msg.substring(0, 300).trim();
        }
        this.message = msg;
        this.stacktrace = this.sanitize(event.stacktrace);
        this.count = count;
    }

    private String sanitize(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            int type = Character.getType(c);
            boolean notPrintable = type == 0 || type == 13 || type == 6 || type == 18;
            text.append(notPrintable ? (char)'?' : (char)c);
        }
        return text.toString().trim().replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

