/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Objects;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;

final class KllHeapFloatsSketch
extends KllFloatsSketch {
    private final int k_;
    private final int m_;
    private long n_;
    private int minK_;
    private boolean isLevelZeroSorted_;
    private float minFloatItem_;
    private float maxFloatItem_;
    private float[] floatItems_;

    KllHeapFloatsSketch(int k, int m) {
        super(null, null);
        KllHelper.checkM(m);
        KllHelper.checkK(k, m);
        this.k_ = k;
        this.m_ = m;
        this.n_ = 0L;
        this.minK_ = k;
        this.isLevelZeroSorted_ = false;
        this.levelsArr = new int[]{k, k};
        this.minFloatItem_ = Float.NaN;
        this.maxFloatItem_ = Float.NaN;
        this.floatItems_ = new float[k];
    }

    static KllHeapFloatsSketch heapifyImpl(Memory srcMem) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        KllMemoryValidate memVal = new KllMemoryValidate(srcMem, KllSketch.SketchType.FLOATS_SKETCH);
        return new KllHeapFloatsSketch(srcMem, memVal);
    }

    private KllHeapFloatsSketch(Memory srcMem, KllMemoryValidate memValidate) {
        super(null, null);
        boolean serialVersionUpdatable;
        this.k_ = memValidate.k;
        this.m_ = memValidate.m;
        this.n_ = memValidate.n;
        this.minK_ = memValidate.minK;
        this.levelsArr = memValidate.levelsArr;
        this.isLevelZeroSorted_ = memValidate.level0Sorted;
        boolean bl = serialVersionUpdatable = KllPreambleUtil.getMemorySerVer(srcMem) == 3;
        if (memValidate.empty && !serialVersionUpdatable) {
            this.minFloatItem_ = Float.NaN;
            this.maxFloatItem_ = Float.NaN;
            this.floatItems_ = new float[this.k_];
        } else if (memValidate.singleItem && !serialVersionUpdatable) {
            float item;
            this.minFloatItem_ = this.maxFloatItem_ = (item = srcMem.getFloat(8L));
            this.floatItems_ = new float[this.k_];
            this.floatItems_[this.k_ - 1] = item;
        } else {
            int offsetBytes = 20;
            this.minFloatItem_ = srcMem.getFloat((long)(offsetBytes += serialVersionUpdatable ? this.levelsArr.length * 4 : (this.levelsArr.length - 1) * 4));
            this.maxFloatItem_ = srcMem.getFloat((long)(offsetBytes += 4));
            offsetBytes += 4;
            int capacityItems = this.levelsArr[this.getNumLevels()];
            int retainedItems = capacityItems - this.levelsArr[0];
            this.floatItems_ = new float[capacityItems];
            int shift = this.levelsArr[0];
            if (serialVersionUpdatable) {
                srcMem.getFloatArray((long)(offsetBytes += shift * 4), this.floatItems_, shift, retainedItems);
            } else {
                srcMem.getFloatArray((long)offsetBytes, this.floatItems_, shift, retainedItems);
            }
        }
    }

    @Override
    public int getK() {
        return this.k_;
    }

    @Override
    public long getN() {
        return this.n_;
    }

    @Override
    float[] getFloatItemsArray() {
        return this.floatItems_;
    }

    @Override
    float getFloatSingleItem() {
        if (this.n_ != 1L) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.NOT_SINGLE_ITEM);
            return Float.NaN;
        }
        return this.floatItems_[this.k_ - 1];
    }

    @Override
    int getM() {
        return this.m_;
    }

    @Override
    float getMaxFloatItem() {
        return this.maxFloatItem_;
    }

    @Override
    float getMinFloatItem() {
        return this.minFloatItem_;
    }

    @Override
    int getMinK() {
        return this.minK_;
    }

    @Override
    void incN() {
        ++this.n_;
    }

    @Override
    void incNumLevels() {
    }

    @Override
    boolean isLevelZeroSorted() {
        return this.isLevelZeroSorted_;
    }

    @Override
    void setFloatItemsArray(float[] floatItems) {
        this.floatItems_ = floatItems;
    }

    @Override
    void setFloatItemsArrayAt(int index, float item) {
        this.floatItems_[index] = item;
    }

    @Override
    void setLevelZeroSorted(boolean sorted) {
        this.isLevelZeroSorted_ = sorted;
    }

    @Override
    void setMaxFloatItem(float item) {
        this.maxFloatItem_ = item;
    }

    @Override
    void setMinFloatItem(float item) {
        this.minFloatItem_ = item;
    }

    @Override
    void setMinK(int minK) {
        this.minK_ = minK;
    }

    @Override
    void setN(long n) {
        this.n_ = n;
    }

    @Override
    void setNumLevels(int numLevels) {
    }
}

