/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.codec;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.StringJoiner;

public class EncodingOptions {
    public static final int EncodingVersion_1_0 = 1;
    private final int encodingVersion;
    private final boolean compress;

    EncodingOptions(int encodingVersion, boolean compress) {
        this.encodingVersion = encodingVersion;
        this.compress = compress;
    }

    public static EncodingOptions V1_0(boolean compress) {
        return new EncodingOptions(1, compress);
    }

    public static EncodingOptions fromDataStream(DataInputStream dis) throws IOException {
        return new EncodingOptions(dis.readInt(), dis.readBoolean());
    }

    public void encode(DataOutputStream dos) throws IOException {
        dos.writeInt(this.encodingVersion);
        dos.writeBoolean(this.compress);
    }

    public int getEncodingVersion() {
        return this.encodingVersion;
    }

    public boolean isCompressed() {
        return this.compress;
    }

    public String toString() {
        return new StringJoiner(", ", EncodingOptions.class.getSimpleName() + "[", "]").add("encodingVersion=" + this.encodingVersion).add("compress=" + this.compress).toString();
    }
}

