/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.summary;

import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.client.summary.Summarizer;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;

public class SummarizerFactory {
    private ClassLoader classloader;
    private String context;

    public SummarizerFactory() {
        this.classloader = SummarizerFactory.class.getClassLoader();
    }

    public SummarizerFactory(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public SummarizerFactory(AccumuloConfiguration tableConfig) {
        this.context = ClassLoaderUtil.tableContext(tableConfig);
    }

    private Summarizer newSummarizer(String classname) throws ReflectiveOperationException {
        if (this.classloader != null) {
            return this.classloader.loadClass(classname).asSubclass(Summarizer.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return ClassLoaderUtil.loadClass(this.context, classname, Summarizer.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public Summarizer getSummarizer(SummarizerConfiguration conf) {
        try {
            return this.newSummarizer(conf.getClassName());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

