/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.io.FileFormatPropertiesCOG;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixReader;
import org.apache.sysds.runtime.io.cog.COGByteReader;
import org.apache.sysds.runtime.io.cog.COGCompressionUtils;
import org.apache.sysds.runtime.io.cog.COGHeader;
import org.apache.sysds.runtime.io.cog.COGProperties;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderCOG
extends MatrixReader {
    protected final FileFormatPropertiesCOG _props;

    public ReaderCOG(FileFormatPropertiesCOG props) {
        this._props = props;
    }

    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        BufferedInputStream bis = new BufferedInputStream((InputStream)fs.open(path));
        return this.readCOG(bis, estnnz);
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        BufferedInputStream bis = new BufferedInputStream(is);
        return this.readCOG(bis, estnnz);
    }

    private MatrixBlock readCOG(BufferedInputStream bis, long estnnz) throws IOException {
        COGByteReader byteReader = new COGByteReader(bis);
        COGHeader cogHeader = COGHeader.readCOGHeader(byteReader);
        String isCompatible = COGHeader.isCompatible(cogHeader.getIFD());
        if (!isCompatible.equals("")) {
            throw new DMLRuntimeException("Incompatible COG file: " + isCompatible);
        }
        COGProperties cogP = new COGProperties(cogHeader.getIFD());
        int tileCols = cogP.getCols() / cogP.getTileWidth();
        int tileRows = cogP.getRows() / cogP.getTileLength();
        int calculatedAmountTiles = tileCols * tileRows;
        int actualAmountTiles = cogP.getTileOffsets().length;
        int currentTileCol = 0;
        int currentTileRow = 0;
        int currentBand = 0;
        boolean tilesFullySequential = cogP.tilesFullySequential();
        MatrixBlock outputMatrix = ReaderCOG.createOutputMatrixBlock(cogP.getRows(), cogP.getCols() * cogP.getBands(), cogP.getRows(), estnnz, true, false);
        for (int currenTileIdx = 0; currenTileIdx < actualAmountTiles; ++currenTileIdx) {
            double value;
            long bytesToRead = (long)cogP.getTileOffsets()[currenTileIdx] - byteReader.getTotalBytesRead() + (long)cogP.getBytesPerTile()[currenTileIdx];
            if (!tilesFullySequential) {
                byteReader.mark(bytesToRead);
            }
            byteReader.skipBytes((long)cogP.getTileOffsets()[currenTileIdx] - byteReader.getTotalBytesRead());
            byte[] currentTileData = byteReader.readBytes(cogP.getBytesPerTile()[currenTileIdx]);
            if (!tilesFullySequential) {
                byteReader.reset();
            }
            if (cogP.getCompression() == 8) {
                currentTileData = COGCompressionUtils.decompressDeflate(currentTileData);
            }
            int pixelsRead = 0;
            int bytesRead = 0;
            int currentRow = 0;
            if (cogP.getPlanarConfiguration() == 1) {
                while (currentRow < cogP.getTileLength() && pixelsRead < cogP.getTileWidth()) {
                    for (int bandIdx = 0; bandIdx < cogP.getBands(); ++bandIdx) {
                        value = 0.0;
                        int sampleLength = cogP.getBitsPerSample()[bandIdx] / 8;
                        switch (cogP.getSampleFormat()[bandIdx]) {
                            case UNSIGNED_INTEGER: 
                            case UNDEFINED: {
                                value = cogHeader.parseByteArray(currentTileData, sampleLength, bytesRead, false, false, false).doubleValue();
                                break;
                            }
                            case SIGNED_INTEGER: {
                                value = cogHeader.parseByteArray(currentTileData, sampleLength, bytesRead, false, true, false).doubleValue();
                                break;
                            }
                            case FLOATING_POINT: {
                                value = cogHeader.parseByteArray(currentTileData, sampleLength, bytesRead, true, false, false).doubleValue();
                            }
                        }
                        bytesRead += sampleLength;
                        outputMatrix.set(currentTileRow * cogP.getTileLength() + currentRow, currentTileCol * cogP.getTileWidth() * cogP.getBands() + pixelsRead * cogP.getBands() + bandIdx, value);
                    }
                    if (++pixelsRead < cogP.getTileWidth()) continue;
                    pixelsRead = 0;
                    ++currentRow;
                }
            } else if (cogP.getPlanarConfiguration() == 2 && calculatedAmountTiles * cogP.getBands() == cogP.getTileOffsets().length) {
                if (currenTileIdx - currentBand * calculatedAmountTiles >= calculatedAmountTiles) {
                    currentTileCol = 0;
                    currentTileRow = 0;
                    ++currentBand;
                }
                int sampleLength = cogP.getBitsPerSample()[currentBand] / 8;
                while (currentRow < cogP.getTileLength() && pixelsRead < cogP.getTileWidth()) {
                    value = 0.0;
                    switch (cogP.getSampleFormat()[currentBand]) {
                        case UNSIGNED_INTEGER: 
                        case UNDEFINED: {
                            value = cogHeader.parseByteArray(currentTileData, sampleLength, bytesRead, false, false, false).doubleValue();
                            break;
                        }
                        case SIGNED_INTEGER: {
                            value = cogHeader.parseByteArray(currentTileData, sampleLength, bytesRead, false, true, false).doubleValue();
                            break;
                        }
                        case FLOATING_POINT: {
                            value = cogHeader.parseByteArray(currentTileData, sampleLength, bytesRead, true, false, false).doubleValue();
                        }
                    }
                    bytesRead += sampleLength;
                    outputMatrix.set(currentTileRow * cogP.getTileLength() + currentRow, currentTileCol * cogP.getTileWidth() * cogP.getBands() + pixelsRead * cogP.getBands() + currentBand, value);
                    if (++pixelsRead < cogP.getTileWidth()) continue;
                    pixelsRead = 0;
                    ++currentRow;
                }
            } else {
                throw new DMLRuntimeException("Unsupported Planar Configuration: " + cogP.getPlanarConfiguration());
            }
            if (++currentTileCol < tileCols) continue;
            currentTileCol = 0;
            ++currentTileRow;
        }
        outputMatrix.examSparsity();
        return outputMatrix;
    }
}

