/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.codegen.cplan;

import org.apache.sysds.common.Types;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.codegen.SpoofCompiler;
import org.apache.sysds.hops.codegen.cplan.CNode;
import org.apache.sysds.runtime.codegen.CodegenUtils;
import org.apache.sysds.runtime.matrix.data.LibMatrixNative;
import org.apache.sysds.runtime.util.UtilFunctions;

public class CNodeData
extends CNode {
    protected final long _hopID;
    protected String _name;
    private boolean _strictEquals;

    public CNodeData(Hop hop) {
        this(hop, hop.getDim1(), hop.getDim2(), hop.getDataType());
    }

    public CNodeData(Hop hop, long rows, long cols, Types.DataType dt) {
        this._name = hop.getName();
        this._hopID = hop.getHopID();
        this._rows = rows;
        this._cols = cols;
        this._dataType = dt;
    }

    public CNodeData(CNodeData node, String newName) {
        this._name = newName;
        this._hopID = node.getHopID();
        this._rows = node.getNumRows();
        this._cols = node.getNumCols();
        this._dataType = node.getDataType();
    }

    @Override
    public String getVarname() {
        if ("NaN".equals(this._name)) {
            return "Double.NaN";
        }
        if ("Infinity".equals(this._name)) {
            return "Double.POSITIVE_INFINITY";
        }
        if ("-Infinity".equals(this._name)) {
            return "Double.NEGATIVE_INFINITY";
        }
        if ("true".equals(this._name) || "false".equals(this._name)) {
            return "true".equals(this._name) ? "1d" : "0d";
        }
        return this._name;
    }

    @Override
    public String getVarname(SpoofCompiler.GeneratorAPI api) {
        if (api == SpoofCompiler.GeneratorAPI.JAVA) {
            if ("NaN".equals(this._name)) {
                return "Double.NaN";
            }
            if ("Infinity".equals(this._name)) {
                return "Double.POSITIVE_INFINITY";
            }
            if ("-Infinity".equals(this._name)) {
                return "Double.NEGATIVE_INFINITY";
            }
            if ("true".equals(this._name) || "false".equals(this._name)) {
                return "true".equals(this._name) ? "1d" : "0d";
            }
            return this._name;
        }
        if (api == SpoofCompiler.GeneratorAPI.CUDA) {
            if ("NaN".equals(this._name)) {
                return LibMatrixNative.isSinglePrecision() ? "CUDART_NAN_F" : "CUDART_NAN";
            }
            if ("Infinity".equals(this._name)) {
                return LibMatrixNative.isSinglePrecision() ? "CUDART_INF_F" : "CUDART_INF";
            }
            if ("-Infinity".equals(this._name)) {
                return LibMatrixNative.isSinglePrecision() ? "-CUDART_INF_F" : "-CUDART_INF";
            }
            if ("true".equals(this._name) || "false".equals(this._name)) {
                return "true".equals(this._name) ? "1" : "0";
            }
            if (CodegenUtils.isNumeric(this._name)) {
                return LibMatrixNative.isSinglePrecision() ? this._name + ".0f" : this._name + ".0";
            }
            return this._name;
        }
        throw new RuntimeException("Unknown GeneratorAPI: " + SpoofCompiler.API);
    }

    public long getHopID() {
        return this._hopID;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setStrictEquals(boolean flag) {
        this._strictEquals = flag;
        this._hash = 0;
    }

    @Override
    public String codegen(boolean sparse, SpoofCompiler.GeneratorAPI api) {
        return "";
    }

    @Override
    public void setOutputDims() {
    }

    public String toString() {
        return "data(" + this._name + ", hopid=" + this._hopID + ")";
    }

    @Override
    public int hashCode() {
        if (this._hash == 0) {
            this._hash = UtilFunctions.intHashCode(super.hashCode(), this.isLiteral() || !this._strictEquals ? this._name.hashCode() : Long.hashCode(this._hopID));
        }
        return this._hash;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof CNodeData && super.equals(o) && this.isLiteral() == ((CNode)o).isLiteral() && (this.isLiteral() || !this._strictEquals ? this._name.equals(((CNodeData)o)._name) : this._hopID == ((CNodeData)o)._hopID);
    }

    @Override
    public boolean isSupported(SpoofCompiler.GeneratorAPI api) {
        return true;
    }
}

