/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.source.coordinator;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.connector.source.ReaderInfo;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.source.coordinator.SourceCoordinatorContext;
import org.apache.flink.runtime.source.event.ReaderRegistrationEvent;
import org.apache.flink.runtime.source.event.RequestSplitEvent;
import org.apache.flink.runtime.source.event.SourceEventWrapper;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TemporaryClassLoaderContext;
import org.apache.flink.util.function.ThrowingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class SourceCoordinator<SplitT extends SourceSplit, EnumChkT>
implements OperatorCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(SourceCoordinator.class);
    private final String operatorName;
    private final ExecutorService coordinatorExecutor;
    private final Source<?, SplitT, EnumChkT> source;
    private final SimpleVersionedSerializer<EnumChkT> enumCheckpointSerializer;
    private final SourceCoordinatorContext<SplitT> context;
    private SplitEnumerator<SplitT, EnumChkT> enumerator;
    private boolean started;

    public SourceCoordinator(String operatorName, ExecutorService coordinatorExecutor, Source<?, SplitT, EnumChkT> source, SourceCoordinatorContext<SplitT> context) {
        this.operatorName = operatorName;
        this.coordinatorExecutor = coordinatorExecutor;
        this.source = source;
        this.enumCheckpointSerializer = source.getEnumeratorCheckpointSerializer();
        this.context = context;
    }

    @Override
    public void start() throws Exception {
        LOG.info("Starting split enumerator for source {}.", (Object)this.operatorName);
        this.started = true;
        if (this.enumerator == null) {
            ClassLoader userCodeClassLoader = this.context.getCoordinatorContext().getUserCodeClassloader();
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of((ClassLoader)userCodeClassLoader);){
                this.enumerator = this.source.createEnumerator(this.context);
            }
            catch (Throwable t) {
                ExceptionUtils.rethrowIfFatalErrorOrOOM((Throwable)t);
                LOG.error("Failed to create Source Enumerator for source {}", (Object)this.operatorName, (Object)t);
                this.context.failJob(t);
                return;
            }
        }
        this.runInEventLoop((ThrowingRunnable<Throwable>)((ThrowingRunnable)() -> this.enumerator.start()), "starting the SplitEnumerator.", new Object[0]);
    }

    @Override
    public void close() throws Exception {
        LOG.info("Closing SourceCoordinator for source {}.", (Object)this.operatorName);
        try {
            if (this.started) {
                this.context.close();
                if (this.enumerator != null) {
                    this.enumerator.close();
                }
            }
        }
        finally {
            this.coordinatorExecutor.shutdownNow();
            this.coordinatorExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        LOG.info("Source coordinator for source {} closed.", (Object)this.operatorName);
    }

    @Override
    public void handleEventFromOperator(int subtask, OperatorEvent event) {
        this.runInEventLoop((ThrowingRunnable<Throwable>)((ThrowingRunnable)() -> {
            LOG.debug("Handling event from subtask {} of source {}: {}", new Object[]{subtask, this.operatorName, event});
            if (event instanceof RequestSplitEvent) {
                this.enumerator.handleSplitRequest(subtask, ((RequestSplitEvent)event).hostName());
            } else if (event instanceof SourceEventWrapper) {
                this.enumerator.handleSourceEvent(subtask, ((SourceEventWrapper)event).getSourceEvent());
            } else if (event instanceof ReaderRegistrationEvent) {
                this.handleReaderRegistrationEvent((ReaderRegistrationEvent)event);
            } else {
                throw new FlinkException("Unrecognized Operator Event: " + event);
            }
        }), "handling operator event %s from subtask %d", event, subtask);
    }

    @Override
    public void subtaskFailed(int subtaskId, @Nullable Throwable reason) {
        this.runInEventLoop((ThrowingRunnable<Throwable>)((ThrowingRunnable)() -> {
            LOG.info("Removing registered reader after failure for subtask {} of source {}.", (Object)subtaskId, (Object)this.operatorName);
            this.context.unregisterSourceReader(subtaskId);
            this.context.subtaskNotReady(subtaskId);
        }), "handling subtask %d failure", subtaskId);
    }

    @Override
    public void subtaskReset(int subtaskId, long checkpointId) {
        this.runInEventLoop((ThrowingRunnable<Throwable>)((ThrowingRunnable)() -> {
            LOG.info("Recovering subtask {} to checkpoint {} for source {} to checkpoint.", new Object[]{subtaskId, checkpointId, this.operatorName});
            List<SplitT> splitsToAddBack = this.context.getAndRemoveUncheckpointedAssignment(subtaskId, checkpointId);
            LOG.debug("Adding splits back to the split enumerator of source {}: {}", (Object)this.operatorName, splitsToAddBack);
            this.enumerator.addSplitsBack(splitsToAddBack, subtaskId);
        }), "handling subtask %d recovery to checkpoint %d", subtaskId, checkpointId);
    }

    @Override
    public void subtaskReady(int subtask, OperatorCoordinator.SubtaskGateway gateway) {
        assert (subtask == gateway.getSubtask());
        this.runInEventLoop((ThrowingRunnable<Throwable>)((ThrowingRunnable)() -> this.context.subtaskReady(gateway)), "making event gateway to subtask %d available", subtask);
    }

    @Override
    public void checkpointCoordinator(long checkpointId, CompletableFuture<byte[]> result) {
        this.runInEventLoop((ThrowingRunnable<Throwable>)((ThrowingRunnable)() -> {
            LOG.debug("Taking a state snapshot on operator {} for checkpoint {}", (Object)this.operatorName, (Object)checkpointId);
            try {
                this.context.onCheckpoint(checkpointId);
                result.complete(this.toBytes(checkpointId));
            }
            catch (Throwable e) {
                ExceptionUtils.rethrowIfFatalErrorOrOOM((Throwable)e);
                result.completeExceptionally(new CompletionException(String.format("Failed to checkpoint SplitEnumerator for source %s", this.operatorName), e));
            }
        }), "taking checkpoint %d", checkpointId);
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) {
        this.runInEventLoop((ThrowingRunnable<Throwable>)((ThrowingRunnable)() -> {
            LOG.info("Marking checkpoint {} as completed for source {}.", (Object)checkpointId, (Object)this.operatorName);
            this.context.onCheckpointComplete(checkpointId);
            this.enumerator.notifyCheckpointComplete(checkpointId);
        }), "notifying the enumerator of completion of checkpoint %d", checkpointId);
    }

    @Override
    public void notifyCheckpointAborted(long checkpointId) {
        this.runInEventLoop((ThrowingRunnable<Throwable>)((ThrowingRunnable)() -> {
            LOG.info("Marking checkpoint {} as aborted for source {}.", (Object)checkpointId, (Object)this.operatorName);
            this.enumerator.notifyCheckpointAborted(checkpointId);
        }), "calling notifyCheckpointAborted()", new Object[0]);
    }

    @Override
    public void resetToCheckpoint(long checkpointId, @Nullable byte[] checkpointData) throws Exception {
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"The coordinator can only be reset if it was not yet started");
        assert (this.enumerator == null);
        if (checkpointData == null) {
            return;
        }
        LOG.info("Restoring SplitEnumerator of source {} from checkpoint.", (Object)this.operatorName);
        ClassLoader userCodeClassLoader = this.context.getCoordinatorContext().getUserCodeClassloader();
        try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of((ClassLoader)userCodeClassLoader);){
            EnumChkT enumeratorCheckpoint = this.deserializeCheckpoint(checkpointData);
            this.enumerator = this.source.restoreEnumerator(this.context, enumeratorCheckpoint);
        }
    }

    private void runInEventLoop(ThrowingRunnable<Throwable> action, String actionName, Object ... actionNameFormatParameters) {
        this.ensureStarted();
        if (this.enumerator == null) {
            return;
        }
        this.coordinatorExecutor.execute(() -> {
            try {
                action.run();
            }
            catch (Throwable t) {
                ExceptionUtils.rethrowIfFatalErrorOrOOM((Throwable)t);
                String actionString = String.format(actionName, actionNameFormatParameters);
                LOG.error("Uncaught exception in the SplitEnumerator for Source {} while {}. Triggering job failover.", new Object[]{this.operatorName, actionString, t});
                this.context.failJob(t);
            }
        });
    }

    @VisibleForTesting
    SplitEnumerator<SplitT, EnumChkT> getEnumerator() {
        return this.enumerator;
    }

    @VisibleForTesting
    SourceCoordinatorContext<SplitT> getContext() {
        return this.context;
    }

    private byte[] toBytes(long checkpointId) throws Exception {
        return SourceCoordinator.writeCheckpointBytes(this.enumerator.snapshotState(checkpointId), this.enumCheckpointSerializer);
    }

    /*
     * Exception decompiling
     */
    static <EnumChkT> byte[] writeCheckpointBytes(EnumChkT enumeratorCheckpoint, SimpleVersionedSerializer<EnumChkT> enumeratorCheckpointSerializer) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private EnumChkT deserializeCheckpoint(byte[] bytes) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleReaderRegistrationEvent(ReaderRegistrationEvent event) {
        this.context.registerSourceReader(new ReaderInfo(event.subtaskId(), event.location()));
        this.enumerator.addReader(event.subtaskId());
    }

    private void ensureStarted() {
        if (!this.started) {
            throw new IllegalStateException("The coordinator has not started yet.");
        }
    }
}

