/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.oas.web;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.oas.mappers.ServiceModelToOpenApiMapper;
import springfox.documentation.oas.web.OpenApiTransformationContext;
import springfox.documentation.oas.web.WebFluxOpenApiTransformationFilter;
import springfox.documentation.service.Documentation;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.OnReactiveWebApplication;
import springfox.documentation.spring.web.json.Json;
import springfox.documentation.spring.web.json.JsonSerializer;

@ApiIgnore
@RestController
@RequestMapping(value={"${springfox.documentation.open-api.v3.path:/v3/api-docs}"})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@Conditional(value={OnReactiveWebApplication.class})
public class OpenApiControllerWebFlux {
    private final DocumentationCache documentationCache;
    private final ServiceModelToOpenApiMapper mapper;
    private final JsonSerializer jsonSerializer;
    private final PluginRegistry<WebFluxOpenApiTransformationFilter, DocumentationType> transformations;

    @Autowired
    public OpenApiControllerWebFlux(DocumentationCache documentationCache, ServiceModelToOpenApiMapper mapper, JsonSerializer jsonSerializer, @Qualifier(value="webFluxOpenApiTransformationFilterRegistry") PluginRegistry<WebFluxOpenApiTransformationFilter, DocumentationType> transformations) {
        this.documentationCache = documentationCache;
        this.mapper = mapper;
        this.jsonSerializer = jsonSerializer;
        this.transformations = transformations;
    }

    @GetMapping(produces={"application/json", "application/hal+json"})
    public ResponseEntity<Json> getDocumentation(@RequestParam(value="group", required=false) String swaggerGroup, ServerHttpRequest serverRequest) {
        String groupName = Optional.ofNullable(swaggerGroup).orElse("default");
        Documentation documentation = this.documentationCache.documentationByGroup(groupName);
        if (documentation == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        OpenAPI oas = this.mapper.mapDocumentation(documentation);
        OpenApiTransformationContext<ServerHttpRequest> context = new OpenApiTransformationContext<ServerHttpRequest>(oas, serverRequest);
        List filters = this.transformations.getPluginsFor((Object)DocumentationType.SWAGGER_2);
        for (WebFluxOpenApiTransformationFilter each : filters) {
            context = context.next(each.transform(context));
        }
        return new ResponseEntity((Object)this.jsonSerializer.toJson((Object)context.getSpecification()), HttpStatus.OK);
    }
}

