/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.common.util.CURLBuilder;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.InternalException;
import org.apache.streampark.console.core.enums.AccessTokenState;
import org.apache.streampark.console.core.service.CommonService;
import org.apache.streampark.console.system.entity.AccessToken;
import org.apache.streampark.console.system.service.AccessTokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"token"})
public class AccessTokenController {
    @Autowired
    private AccessTokenService accessTokenService;
    @Autowired
    private CommonService commonService;

    @PostMapping(value={"create"})
    @RequiresPermissions(value={"token:add"})
    public RestResponse createToken(@NotBlank(message="{required}") @NotBlank(message="{required}") Long userId, String expireTime, String description) throws InternalException {
        return this.accessTokenService.generateToken(userId, expireTime, description);
    }

    @PostMapping(value={"check"})
    public RestResponse checkToken() {
        Long userId = this.commonService.getUserId();
        RestResponse restResponse = RestResponse.success();
        if (userId != null) {
            AccessToken accessToken = this.accessTokenService.getByUserId(userId);
            if (accessToken == null) {
                restResponse.data(AccessTokenState.NULL.get());
            } else if (AccessToken.STATUS_DISABLE.equals(accessToken.getFinalStatus())) {
                restResponse.data(AccessTokenState.INVALID.get());
            } else {
                restResponse.data(AccessTokenState.OK.get());
            }
        } else {
            restResponse.data(AccessTokenState.INVALID.get());
        }
        return restResponse;
    }

    @PostMapping(value={"list"})
    @RequiresPermissions(value={"token:view"})
    public RestResponse tokenList(RestRequest restRequest, AccessToken accessToken) {
        IPage<AccessToken> accessTokens = this.accessTokenService.findAccessTokens(accessToken, restRequest);
        return RestResponse.success(accessTokens);
    }

    @PostMapping(value={"toggle"})
    @RequiresPermissions(value={"token:add"})
    public RestResponse toggleToken(@NotNull(message="{required}") @NotNull(message="{required}") Long tokenId) {
        return this.accessTokenService.toggleToken(tokenId);
    }

    @DeleteMapping(value={"delete"})
    @RequiresPermissions(value={"token:delete"})
    public RestResponse deleteToken(@NotBlank(message="{required}") @NotBlank(message="{required}") Long tokenId) {
        boolean res = this.accessTokenService.deleteToken(tokenId);
        return RestResponse.success(res);
    }

    @PostMapping(value={"curl"})
    public RestResponse copyRestApiCurl(@NotBlank(message="{required}") @NotBlank(message="{required}") String appId, @NotBlank(message="{required}") @NotBlank(message="{required}") String baseUrl, @NotBlank(message="{required}") @NotBlank(message="{required}") String path) {
        String resultCURL = null;
        CURLBuilder curlBuilder = new CURLBuilder(baseUrl + path);
        curlBuilder.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8").addHeader("Authorization", this.accessTokenService.getByUserId(this.commonService.getUserId()).getToken());
        if ("/flink/app/start".equalsIgnoreCase(path)) {
            resultCURL = curlBuilder.addFormData("allowNonRestored", "false").addFormData("savePoint", "").addFormData("savePointed", "false").addFormData("id", appId).build();
        } else if ("/flink/app/cancel".equalsIgnoreCase(path)) {
            resultCURL = curlBuilder.addFormData("id", appId).addFormData("savePointed", "false").addFormData("drain", "false").addFormData("savePoint", "").build();
        }
        return RestResponse.success(resultCURL);
    }
}

