/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.InternalException;
import org.apache.streampark.console.core.bean.ResponseResult;
import org.apache.streampark.console.core.entity.FlinkCluster;
import org.apache.streampark.console.core.service.FlinkClusterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"flink/cluster"})
public class FlinkClusterController {
    private static final Logger log = LoggerFactory.getLogger(FlinkClusterController.class);
    @Autowired
    private FlinkClusterService flinkClusterService;

    @PostMapping(value={"list"})
    public RestResponse list() {
        List flinkClusters = this.flinkClusterService.list();
        return RestResponse.success(flinkClusters);
    }

    @PostMapping(value={"remoteUrl"})
    public RestResponse remoteUrl(Long id) {
        FlinkCluster cluster = (FlinkCluster)this.flinkClusterService.getById(id);
        return RestResponse.success(cluster.getAddress());
    }

    @PostMapping(value={"check"})
    public RestResponse check(FlinkCluster cluster) {
        ResponseResult checkResult = this.flinkClusterService.check(cluster);
        return RestResponse.success(checkResult);
    }

    @PostMapping(value={"create"})
    @RequiresPermissions(value={"cluster:create"})
    public RestResponse create(FlinkCluster cluster) {
        Boolean success = this.flinkClusterService.create(cluster);
        return RestResponse.success(success);
    }

    @PostMapping(value={"update"})
    @RequiresPermissions(value={"cluster:update"})
    public RestResponse update(FlinkCluster cluster) {
        this.flinkClusterService.update(cluster);
        return RestResponse.success();
    }

    @PostMapping(value={"get"})
    public RestResponse get(Long id) throws InternalException {
        FlinkCluster cluster = (FlinkCluster)this.flinkClusterService.getById(id);
        return RestResponse.success(cluster);
    }

    @PostMapping(value={"start"})
    public RestResponse start(FlinkCluster cluster) {
        this.flinkClusterService.start(cluster);
        return RestResponse.success();
    }

    @PostMapping(value={"shutdown"})
    public RestResponse shutdown(FlinkCluster cluster) {
        this.flinkClusterService.shutdown(cluster);
        return RestResponse.success();
    }

    @PostMapping(value={"delete"})
    public RestResponse delete(FlinkCluster cluster) {
        this.flinkClusterService.delete(cluster);
        return RestResponse.success();
    }
}

