/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console;

import java.io.File;
import org.apache.streampark.common.util.SystemPropertyUtils;
import org.apache.streampark.console.base.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication
@EnableScheduling
public class StreamParkConsoleBootstrap {
    private static final Logger log = LoggerFactory.getLogger(StreamParkConsoleBootstrap.class);

    public static void main(String[] args) {
        SpringApplication application = new SpringApplication(new Class[]{StreamParkConsoleBootstrap.class});
        String pid = SystemPropertyUtils.get((String)"pid");
        if (pid != null) {
            application.addListeners(new ApplicationListener[]{new ApplicationPidFileWriter(pid)});
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                log.info("application shutdown now, pid: " + CommonUtils.getPid());
                File pidFile = new File(pid);
                pidFile.delete();
            }));
        }
        application.run(new String[0]);
    }
}

