/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.VolatileByteRef;
import scala.util.Try$;

public final class DateUtils$ {
    public static final DateUtils$ MODULE$;
    private final String fullFormat;
    private final String format_yyyyMMdd;
    private final String fullCompact;

    static {
        new DateUtils$();
    }

    public String fullFormat() {
        return this.fullFormat;
    }

    public String format_yyyyMMdd() {
        return this.format_yyyyMMdd;
    }

    public String fullCompact() {
        return this.fullCompact;
    }

    public Date parse(String date, String format, TimeZone timeZone) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(timeZone);
        return df.parse(date);
    }

    public String parse$default$2() {
        return this.fullFormat();
    }

    public TimeZone parse$default$3() {
        return TimeZone.getDefault();
    }

    public Date stringToDate(String date) {
        return this.parse(date, this.parse$default$2(), this.parse$default$3());
    }

    public Date milliSecond2Date(long time) {
        return new Date(time);
    }

    public Date second2Date(long time) {
        return this.milliSecond2Date(time * 1000L);
    }

    public String now(String dateFormat, TimeZone timeZone) {
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        df.setTimeZone(timeZone);
        return df.format(new Date());
    }

    public String now$default$1() {
        return this.format_yyyyMMdd();
    }

    public TimeZone now$default$2() {
        return TimeZone.getDefault();
    }

    public int minuteOfDay(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(timeZone);
        calendar.setTime(date);
        return calendar.get(11) * 60 + calendar.get(12);
    }

    public int minuteOf(Date date) {
        return (int)(date.getTime() / 1000L / 60L);
    }

    public Date minuteOfDay$default$1() {
        return new Date();
    }

    public TimeZone minuteOfDay$default$2() {
        return TimeZone.getDefault();
    }

    public Date minuteOf$default$1() {
        return new Date();
    }

    public int secondOf(Date date) {
        return (int)(date.getTime() / 1000L);
    }

    public Date secondOf$default$1() {
        return new Date();
    }

    public int secondOfDay(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(timeZone);
        calendar.setTime(date);
        return this.minuteOfDay(date, this.minuteOfDay$default$2()) * 60 + calendar.get(13);
    }

    public Date secondOfDay$default$1() {
        return new Date();
    }

    public TimeZone secondOfDay$default$2() {
        return TimeZone.getDefault();
    }

    public String format(Date date, String fmt, TimeZone timeZone) {
        String string;
        if (date == null) {
            string = null;
        } else {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(fmt);
            simpleDateFormat.setTimeZone(timeZone);
            string = simpleDateFormat.format(date);
        }
        return string;
    }

    public Date format$default$1() {
        return new Date();
    }

    public String format$default$2() {
        return this.fullFormat();
    }

    public TimeZone format$default$3() {
        return TimeZone.getDefault();
    }

    public long getTime(String time, String fmt, TimeZone timeZone) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(fmt);
        simpleDateFormat.setTimeZone(timeZone);
        return BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)new Serializable(time, simpleDateFormat){
            public static final long serialVersionUID = 0L;
            private final String time$1;
            private final SimpleDateFormat simpleDateFormat$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.simpleDateFormat$1.parse(this.time$1).getTime();
            }
            {
                this.time$1 = time$1;
                this.simpleDateFormat$1 = simpleDateFormat$1;
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$1) {
                return this.apply$mcZJ$sp(x$1);
            }

            public boolean apply$mcZJ$sp(long x$1) {
                return x$1 > 0L;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return System.currentTimeMillis();
            }
        }));
    }

    public String getTime$default$2() {
        return this.fullFormat();
    }

    public TimeZone getTime$default$3() {
        return TimeZone.getDefault();
    }

    public Date addAndSubtract(int i, Date date, TimeZone timeZone) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(timeZone);
        cal.setTime(date);
        cal.add(5, i);
        return cal.getTime();
    }

    public Date addAndSubtract$default$2() {
        return new Date();
    }

    public TimeZone addAndSubtract$default$3() {
        return TimeZone.getDefault();
    }

    public Date localToUTC(String localTime, String format) {
        Date value = new SimpleDateFormat(format).parse(localTime);
        return this.localToUTC(value);
    }

    public Date localToUTC(Date localTime) {
        long localTimeInMillis = localTime.getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(localTimeInMillis);
        int zoneOffset = calendar.get(15);
        int dstOffset = calendar.get(16);
        calendar.add(14, -(zoneOffset + dstOffset));
        return new Date(calendar.getTimeInMillis());
    }

    public String localToUTC$default$2() {
        return this.fullFormat();
    }

    public Date utcToLocal(Date utcDate) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.setTimeZone(TimeZone.getDefault());
        String localTime = sdf.format(BoxesRunTime.boxToLong((long)utcDate.getTime()));
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.parse(localTime);
    }

    public Date utcToLocal(String utcTime, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date utcDate = sdf.parse(utcTime);
        return this.utcToLocal(utcDate);
    }

    public String utcToLocal$default$2() {
        return this.fullFormat();
    }

    public String toDuration(long milliseconds) {
        LongRef hours$lzy = LongRef.zero();
        LongRef duration2$lzy = LongRef.zero();
        LongRef minutes$lzy = LongRef.zero();
        LongRef duration3$lzy = LongRef.zero();
        LongRef seconds$lzy = LongRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        Duration duration = Duration.ofMillis(milliseconds);
        long days = duration.toDays();
        long duration1 = milliseconds - TimeUnit.DAYS.toMillis(days);
        StringBuilder builder = new StringBuilder();
        Object object = days > 0L ? builder.append(new StringBuilder().append(days).append((Object)" days ").toString()) : BoxedUnit.UNIT;
        Object object2 = this.hours$1(duration1, hours$lzy, bitmap$0) > 0L || this.minutes$1(duration1, hours$lzy, duration2$lzy, minutes$lzy, bitmap$0) > 0L || this.seconds$1(duration1, hours$lzy, duration2$lzy, minutes$lzy, duration3$lzy, seconds$lzy, bitmap$0) > 0L ? builder.append(new StringBuilder().append(this.hours$1(duration1, hours$lzy, bitmap$0)).append((Object)" hours ").toString()) : BoxedUnit.UNIT;
        Object object3 = this.minutes$1(duration1, hours$lzy, duration2$lzy, minutes$lzy, bitmap$0) > 0L || this.seconds$1(duration1, hours$lzy, duration2$lzy, minutes$lzy, duration3$lzy, seconds$lzy, bitmap$0) > 0L ? builder.append(new StringBuilder().append(this.minutes$1(duration1, hours$lzy, duration2$lzy, minutes$lzy, bitmap$0)).append((Object)" minutes ").toString()) : BoxedUnit.UNIT;
        Object object4 = this.seconds$1(duration1, hours$lzy, duration2$lzy, minutes$lzy, duration3$lzy, seconds$lzy, bitmap$0) > 0L ? builder.append(new StringBuilder().append(this.seconds$1(duration1, hours$lzy, duration2$lzy, minutes$lzy, duration3$lzy, seconds$lzy, bitmap$0)).append((Object)" seconds ").toString()) : BoxedUnit.UNIT;
        return builder.toString();
    }

    public Tuple2<Object, TimeUnit> getTimeUnit(String time, Tuple2<Object, TimeUnit> tuple2) {
        String string;
        block4: {
            block10: {
                Tuple2 timeUnit;
                Tuple2 tuple22;
                block3: {
                    TimeUnit timeUnit2;
                    int num;
                    block6: {
                        String string2;
                        block9: {
                            block8: {
                                block7: {
                                    block5: {
                                        block2: {
                                            string = time;
                                            if (!"".equals(string)) break block2;
                                            tuple22 = null;
                                            break block3;
                                        }
                                        if (string == null) break block4;
                                        String string3 = string;
                                        num = new StringOps(Predef$.MODULE$.augmentString(string3.replaceAll("\\s+|[a-z|A-Z]+$", ""))).toInt();
                                        string2 = string3.replaceAll("^\\d+|\\s+", "");
                                        if (!"".equals(string2)) break block5;
                                        timeUnit2 = null;
                                        break block6;
                                    }
                                    if (!"s".equals(string2)) break block7;
                                    timeUnit2 = TimeUnit.SECONDS;
                                    break block6;
                                }
                                boolean bl = "m".equals(string2) ? true : "min".equals(string2);
                                if (!bl) break block8;
                                timeUnit2 = TimeUnit.MINUTES;
                                break block6;
                            }
                            if (!"h".equals(string2)) break block9;
                            timeUnit2 = TimeUnit.HOURS;
                            break block6;
                        }
                        boolean bl = "d".equals(string2) ? true : "day".equals(string2);
                        if (!bl) break block10;
                        timeUnit2 = TimeUnit.DAYS;
                    }
                    TimeUnit unit2 = timeUnit2;
                    tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)num), (Object)unit2);
                }
                Tuple2 tuple23 = timeUnit = tuple22;
                Tuple2 tuple24 = tuple23 == null ? tuple2 : (tuple23._2() == null ? new Tuple2((Object)BoxesRunTime.boxToInteger((int)(tuple23._1$mcI$sp() / 1000)), (Object)TimeUnit.SECONDS) : tuple23);
                return tuple24;
            }
            throw new IllegalArgumentException();
        }
        throw new MatchError((Object)string);
    }

    public Tuple2<Object, TimeUnit> getTimeUnit$default$2() {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)5), (Object)TimeUnit.SECONDS);
    }

    public String formatFullTime(LocalDateTime localDateTime) {
        return this.formatFullTime(localDateTime, this.fullFormat());
    }

    public String formatFullTime(LocalDateTime localDateTime, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return localDateTime.format(dateTimeFormatter);
    }

    private String getDateFormat(Date date, String dateFormatType) {
        SimpleDateFormat format = new SimpleDateFormat(dateFormatType);
        return format.format(date);
    }

    public String formatCSTTime(String date, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
        Date d = sdf.parse(date);
        return this.getDateFormat(d, format);
    }

    private final long hours$lzycompute$1(long duration1$1, LongRef hours$lzy$1, VolatileByteRef bitmap$0$1) {
        DateUtils$ dateUtils$ = this;
        synchronized (dateUtils$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                hours$lzy$1.elem = TimeUnit.MILLISECONDS.toHours(duration1$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return hours$lzy$1.elem;
        }
    }

    private final long hours$1(long duration1$1, LongRef hours$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.hours$lzycompute$1(duration1$1, hours$lzy$1, bitmap$0$1) : hours$lzy$1.elem;
    }

    private final long duration2$lzycompute$1(long duration1$1, LongRef hours$lzy$1, LongRef duration2$lzy$1, VolatileByteRef bitmap$0$1) {
        DateUtils$ dateUtils$ = this;
        synchronized (dateUtils$) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                duration2$lzy$1.elem = duration1$1 - TimeUnit.HOURS.toMillis(this.hours$1(duration1$1, hours$lzy$1, bitmap$0$1));
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return duration2$lzy$1.elem;
        }
    }

    private final long duration2$1(long duration1$1, LongRef hours$lzy$1, LongRef duration2$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.duration2$lzycompute$1(duration1$1, hours$lzy$1, duration2$lzy$1, bitmap$0$1) : duration2$lzy$1.elem;
    }

    private final long minutes$lzycompute$1(long duration1$1, LongRef hours$lzy$1, LongRef duration2$lzy$1, LongRef minutes$lzy$1, VolatileByteRef bitmap$0$1) {
        DateUtils$ dateUtils$ = this;
        synchronized (dateUtils$) {
            if ((byte)(bitmap$0$1.elem & 4) == 0) {
                minutes$lzy$1.elem = TimeUnit.MILLISECONDS.toMinutes(this.duration2$1(duration1$1, hours$lzy$1, duration2$lzy$1, bitmap$0$1));
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 4);
            }
            return minutes$lzy$1.elem;
        }
    }

    private final long minutes$1(long duration1$1, LongRef hours$lzy$1, LongRef duration2$lzy$1, LongRef minutes$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 4) == 0 ? this.minutes$lzycompute$1(duration1$1, hours$lzy$1, duration2$lzy$1, minutes$lzy$1, bitmap$0$1) : minutes$lzy$1.elem;
    }

    private final long duration3$lzycompute$1(long duration1$1, LongRef hours$lzy$1, LongRef duration2$lzy$1, LongRef minutes$lzy$1, LongRef duration3$lzy$1, VolatileByteRef bitmap$0$1) {
        DateUtils$ dateUtils$ = this;
        synchronized (dateUtils$) {
            if ((byte)(bitmap$0$1.elem & 8) == 0) {
                duration3$lzy$1.elem = this.duration2$1(duration1$1, hours$lzy$1, duration2$lzy$1, bitmap$0$1) - TimeUnit.MINUTES.toMillis(this.minutes$1(duration1$1, hours$lzy$1, duration2$lzy$1, minutes$lzy$1, bitmap$0$1));
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 8);
            }
            return duration3$lzy$1.elem;
        }
    }

    private final long duration3$1(long duration1$1, LongRef hours$lzy$1, LongRef duration2$lzy$1, LongRef minutes$lzy$1, LongRef duration3$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 8) == 0 ? this.duration3$lzycompute$1(duration1$1, hours$lzy$1, duration2$lzy$1, minutes$lzy$1, duration3$lzy$1, bitmap$0$1) : duration3$lzy$1.elem;
    }

    private final long seconds$lzycompute$1(long duration1$1, LongRef hours$lzy$1, LongRef duration2$lzy$1, LongRef minutes$lzy$1, LongRef duration3$lzy$1, LongRef seconds$lzy$1, VolatileByteRef bitmap$0$1) {
        DateUtils$ dateUtils$ = this;
        synchronized (dateUtils$) {
            if ((byte)(bitmap$0$1.elem & 0x10) == 0) {
                seconds$lzy$1.elem = TimeUnit.MILLISECONDS.toSeconds(this.duration3$1(duration1$1, hours$lzy$1, duration2$lzy$1, minutes$lzy$1, duration3$lzy$1, bitmap$0$1));
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 0x10);
            }
            return seconds$lzy$1.elem;
        }
    }

    private final long seconds$1(long duration1$1, LongRef hours$lzy$1, LongRef duration2$lzy$1, LongRef minutes$lzy$1, LongRef duration3$lzy$1, LongRef seconds$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 0x10) == 0 ? this.seconds$lzycompute$1(duration1$1, hours$lzy$1, duration2$lzy$1, minutes$lzy$1, duration3$lzy$1, seconds$lzy$1, bitmap$0$1) : seconds$lzy$1.elem;
    }

    private DateUtils$() {
        MODULE$ = this;
        this.fullFormat = "yyyy-MM-dd HH:mm:ss";
        this.format_yyyyMMdd = "yyyyMMdd";
        this.fullCompact = "yyyyMMddHHmmss";
    }
}

